/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.functions.FilterPartyRole;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="TradeBarrierDerterminationAgent")
@ImplementedBy(value=Default.class)
public interface TradeBarrierDerterminationAgent
extends Validator<Trade> {
    public static final String NAME = "TradeBarrierDerterminationAgent";
    public static final String DEFINITION = "if partyRole -> role contains PartyRoleEnum -> BarrierDeterminationAgent then FilterPartyRole(partyRole, PartyRoleEnum -> BarrierDeterminationAgent) count <= 1";

    public static class NoOp
    implements TradeBarrierDerterminationAgent {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradeBarrierDerterminationAgent {
        @Inject
        protected FilterPartyRole filterPartyRole;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradeBarrierDerterminationAgent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeBarrierDerterminationAgent.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradeBarrierDerterminationAgent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeBarrierDerterminationAgent.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                if (ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).mapC("getPartyRole", _trade -> _trade.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.BARRIER_DETERMINATION_AGENT))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)MapperC.of(this.filterPartyRole.evaluate(MapperS.of((Object)trade).mapC("getPartyRole", _trade -> _trade.getPartyRole()).getMulti(), PartyRoleEnum.BARRIER_DETERMINATION_AGENT)).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

