/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.common.functions;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.functions.FilterQuantityByCurrencyExists;
import cdm.base.math.functions.FilterQuantityByFinancialUnit;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=CashPriceQuantityNoOfUnitsTriangulationDefault.class)
public abstract class CashPriceQuantityNoOfUnitsTriangulation
implements RosettaFunction {
    @Inject
    protected FilterQuantityByCurrencyExists filterQuantityByCurrencyExists;
    @Inject
    protected FilterQuantityByFinancialUnit filterQuantityByFinancialUnit;

    public Boolean evaluate(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
        Boolean success = this.doEvaluate(quantity, price);
        return success;
    }

    protected abstract Boolean doEvaluate(List<? extends NonNegativeQuantitySchedule> var1, List<? extends PriceSchedule> var2);

    protected abstract MapperS<BigDecimal> notional(List<? extends NonNegativeQuantitySchedule> var1, List<? extends PriceSchedule> var2);

    protected abstract MapperS<BigDecimal> noOfUnits(List<? extends NonNegativeQuantitySchedule> var1, List<? extends PriceSchedule> var2);

    protected abstract MapperS<BigDecimal> cashPrice(List<? extends NonNegativeQuantitySchedule> var1, List<? extends PriceSchedule> var2);

    public static class CashPriceQuantityNoOfUnitsTriangulationDefault
    extends CashPriceQuantityNoOfUnitsTriangulation {
        @Override
        protected Boolean doEvaluate(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            if (quantity == null) {
                quantity = Collections.emptyList();
            }
            if (price == null) {
                price = Collections.emptyList();
            }
            Boolean success = null;
            return this.assignOutput(success, quantity, price);
        }

        protected Boolean assignOutput(Boolean success, List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            success = ExpressionOperators.exists(this.cashPrice(quantity, price)).and(ExpressionOperators.exists(this.noOfUnits(quantity, price))).and(ExpressionOperators.exists(this.notional(quantity, price))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.areEqual((Mapper)MapperMaths.multiply(this.cashPrice(quantity, price), this.noOfUnits(quantity, price)), this.notional(quantity, price), (CardinalityOperator)CardinalityOperator.All).get() : Boolean.valueOf(true);
            return success;
        }

        @Override
        protected MapperS<BigDecimal> notional(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            MapperC thenArg0 = MapperC.of(this.filterQuantityByCurrencyExists.evaluate(quantity)).mapItem(item -> item.map("getValue", quantitySchedule -> quantitySchedule.getValue()));
            MapperC thenArg1 = ExpressionOperators.distinct((Mapper)thenArg0);
            return MapperS.of((Object)((BigDecimal)thenArg1.get()));
        }

        @Override
        protected MapperS<BigDecimal> noOfUnits(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            MapperC thenArg = MapperC.of(this.filterQuantityByFinancialUnit.evaluate(quantity, FinancialUnitEnum.SHARE)).mapItem(item -> item.map("getValue", quantitySchedule -> quantitySchedule.getValue()));
            return MapperS.of((Object)((BigDecimal)thenArg.get()));
        }

        @Override
        protected MapperS<BigDecimal> cashPrice(List<? extends NonNegativeQuantitySchedule> quantity, List<? extends PriceSchedule> price) {
            MapperC thenArg0 = MapperC.of(price).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.ASSET_PRICE)), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getValue", priceSchedule -> priceSchedule.getValue()));
            return MapperS.of((Object)((BigDecimal)thenArg1.get()));
        }
    }
}

