/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.functions;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ExtractFixedLegDefault.class)
public abstract class ExtractFixedLeg
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public InterestRatePayout evaluate(List<? extends InterestRatePayout> interestRatePayouts) {
        InterestRatePayout fixedRatePayout;
        InterestRatePayout.InterestRatePayoutBuilder fixedRatePayoutBuilder = this.doEvaluate(interestRatePayouts);
        if (fixedRatePayoutBuilder == null) {
            fixedRatePayout = null;
        } else {
            fixedRatePayout = fixedRatePayoutBuilder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)fixedRatePayout);
        }
        return fixedRatePayout;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(List<? extends InterestRatePayout> var1);

    public static class ExtractFixedLegDefault
    extends ExtractFixedLeg {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(List<? extends InterestRatePayout> interestRatePayouts) {
            if (interestRatePayouts == null) {
                interestRatePayouts = Collections.emptyList();
            }
            InterestRatePayout.InterestRatePayoutBuilder fixedRatePayout = InterestRatePayout.builder();
            return this.assignOutput(fixedRatePayout, interestRatePayouts);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder fixedRatePayout, List<? extends InterestRatePayout> interestRatePayouts) {
            MapperC thenArg = MapperC.of(interestRatePayouts).filterItemNullSafe(item -> ExpressionOperators.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
            fixedRatePayout = (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((InterestRatePayout)thenArg.get())).get());
            return Optional.ofNullable(fixedRatePayout).map(o -> o.prune()).orElse(null);
        }
    }
}

