/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation;

import java.lang.reflect.Method;

public class BeanUtil {
    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        String rawPropertyName = BeanUtil.getSubstringIfPrefixMatches(methodName, "get");
        if (rawPropertyName == null) {
            rawPropertyName = BeanUtil.getSubstringIfPrefixMatches(methodName, "set");
        }
        if (rawPropertyName == null) {
            rawPropertyName = BeanUtil.getSubstringIfPrefixMatches(methodName, "is");
        }
        if (rawPropertyName == null) {
            rawPropertyName = BeanUtil.getSubstringIfPrefixMatches(methodName, "add");
        }
        return BeanUtil.toLowerCamelCase(rawPropertyName);
    }

    public static String toLowerCamelCase(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static String getSubstringIfPrefixMatches(String wholeString, String prefix) {
        return wholeString.startsWith(prefix) ? wholeString.substring(prefix.length()) : null;
    }
}

