/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.translation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MappingContext {
    private final List<Mapping> mappings;
    private final Map<Object, Object> mappingParams;
    private final SynonymToEnumMap synonymToEnumMap;
    private final ExecutorService executor;
    private final List<CompletableFuture<?>> invokedTasks = new ArrayList();
    private final List<String> mappingErrors = new ArrayList<String>();

    public MappingContext(Map<Class<?>, Map<String, Enum<?>>> synonymToEnumMap) {
        this(new ArrayList<Mapping>(), new ConcurrentHashMap<Object, Object>(), synonymToEnumMap);
    }

    @VisibleForTesting
    public MappingContext(List<Mapping> mappings, Map<Object, Object> mappingParams, Map<Class<?>, Map<String, Enum<?>>> synonymToEnumMap) {
        this(mappings, mappingParams, synonymToEnumMap, Executors.newFixedThreadPool(5, new ThreadFactoryBuilder().setNameFormat("mapper-%d").build()));
    }

    public MappingContext(List<Mapping> mappings, Map<Object, Object> mappingParams, Map<Class<?>, Map<String, Enum<?>>> synonymToEnumMap, ExecutorService executor) {
        this.mappings = mappings;
        this.mappingParams = mappingParams;
        this.synonymToEnumMap = new SynonymToEnumMap(synonymToEnumMap);
        this.executor = executor;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public Map<Object, Object> getMappingParams() {
        return this.mappingParams;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public List<CompletableFuture<?>> getInvokedTasks() {
        return this.invokedTasks;
    }

    public List<String> getMappingErrors() {
        return this.mappingErrors;
    }

    public SynonymToEnumMap getSynonymToEnumMap() {
        return this.synonymToEnumMap;
    }
}

