/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class UnicodeBom {
    private static final byte X_FE = -2;
    private static final byte X_EF = -17;
    private static final byte X_FF = -1;
    private static final byte X_BF = -65;
    private static final byte X_BB = -69;

    private UnicodeBom() {
    }

    public static String toString(byte[] input) {
        if (input.length >= 3 && input[0] == -17 && input[1] == -69 && input[2] == -65) {
            return new String(input, 3, input.length - 3, StandardCharsets.UTF_8);
        }
        if (input.length >= 2 && input[0] == -2 && input[1] == -1) {
            return new String(input, 2, input.length - 2, StandardCharsets.UTF_16BE);
        }
        if (input.length >= 2 && input[0] == -1 && input[1] == -2) {
            return new String(input, 2, input.length - 2, StandardCharsets.UTF_16LE);
        }
        return new String(input, StandardCharsets.UTF_8);
    }

    public static CharSource toCharSource(final ByteSource byteSource) {
        return new CharSource(){

            public ByteSource asByteSource(Charset charset) {
                return byteSource;
            }

            public Reader openStream() throws IOException {
                return UnicodeBom.toReader(byteSource.openStream());
            }

            public String toString() {
                return "UnicodeBom.toCharSource(" + byteSource.toString() + ")";
            }
        };
    }

    public static Reader toReader(InputStream inputStream) throws IOException {
        return new BomReader(inputStream);
    }

    private static final class BomReader
    extends Reader {
        private static final int MAX_BOM_SIZE = 4;
        private final InputStreamReader underlying;

        BomReader(InputStream inputStream) throws IOException {
            super(inputStream);
            Charset encoding;
            byte[] bom = new byte[4];
            PushbackInputStream pushbackStream = new PushbackInputStream(inputStream, 4);
            int bytesRead = ByteStreams.read((InputStream)pushbackStream, (byte[])bom, (int)0, (int)3);
            if (bytesRead >= 3 && bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                encoding = StandardCharsets.UTF_8;
                pushbackStream.unread(bom, 3, bytesRead - 3);
            } else if (bytesRead >= 2 && bom[0] == -2 && bom[1] == -1) {
                encoding = StandardCharsets.UTF_16BE;
                pushbackStream.unread(bom, 2, bytesRead - 2);
            } else if (bytesRead >= 2 && bom[0] == -1 && bom[1] == -2) {
                encoding = StandardCharsets.UTF_16LE;
                pushbackStream.unread(bom, 2, bytesRead - 2);
            } else {
                encoding = StandardCharsets.UTF_8;
                pushbackStream.unread(bom, 0, bytesRead);
            }
            this.underlying = new InputStreamReader((InputStream)pushbackStream, encoding);
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            return this.underlying.read(target);
        }

        @Override
        public int read() throws IOException {
            return this.underlying.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.underlying.read(cbuf);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.underlying.read(cbuf, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.underlying.skip(n);
        }

        @Override
        public boolean ready() throws IOException {
            return this.underlying.ready();
        }

        @Override
        public boolean markSupported() {
            return this.underlying.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.underlying.mark(readAheadLimit);
        }

        @Override
        public void reset() throws IOException {
            this.underlying.reset();
        }

        @Override
        public void close() throws IOException {
            this.underlying.close();
        }
    }
}

