/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.xcore.extractor;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;

public class ParserCaseExtractorFragment
extends AbstractXtextGeneratorFragment {
    private static final Logger LOGGER = Logger.getLogger(ParserCaseExtractorFragment.class);
    private final List<String> grammarFiles = new ArrayList<String>();
    public static final Pattern DFA_PATTERN = Pattern.compile("(class DFA\\d+ extends DFA \\{.*?)(public int specialStateTransition\\(int s, IntStream _input\\) throws NoViableAltException \\{.*?\\}\\s*NoViableAltException nvae =[^{}]*?\\})([^{]*?\\})", 40);
    public static final Pattern SPECIAL_STATE_TRANSITION_PATTERN = Pattern.compile("(public int specialStateTransition\\(int s, IntStream _input\\) throws NoViableAltException \\{.*\\}\\s*NoViableAltException nvae =[^{}]*\\})", 40);
    public static final Pattern TOO_MANY_CASES_PATTERN = Pattern.compile("^\\s*case\\s+50", 8);
    public static final Pattern CASE_PATTERN = Pattern.compile("(^\\s*case\\s+(\\d+)\\s*:(\\s*))([^;]*;(\\s*int\\s+index[^;]*;\\s*input\\.rewind\\(\\)\\s*;)?)\\s*s = -1;(\\s*if.*?\\}(\\s*else if.*?\\})*(\\s*else s.*?;)?(\\s*input\\.seek[^;]*;)?)\\s*(if\\s*\\(\\s*s\\s*>=0\\s*\\)\\s*return\\s*s;\\s*^\\s*break;$)", 40);
    public static final Pattern STATE_PATTERN = Pattern.compile(Pattern.quote("if (state.backtracking>0) {state.failed=true; return -1;}"));

    public void addGrammarFile(String fileName) {
        this.grammarFiles.add(fileName);
    }

    public void generate() {
        for (String fileName : this.grammarFiles) {
            File file = new File(fileName);
            String javaSource = null;
            try {
                javaSource = Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read();
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Error reading file " + fileName + ": " + ex.getMessage()));
            }
            if (javaSource == null) continue;
            String processed = this.process(javaSource, file);
            LOGGER.info((Object)("File " + this.readableFileName(file) + " processed: " + javaSource.length() + " --> " + processed.length() + " (" + 100 * processed.length() / javaSource.length() + "%)"));
            try {
                Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)processed);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Error writing processed file " + this.readableFileName(file) + ": " + e.getMessage()));
            }
        }
    }

    private String readableFileName(File f) {
        int firstSeg;
        int firstChar;
        String path = f.getPath();
        for (firstChar = 0; firstChar < path.length() && !Character.isLetterOrDigit(path.charAt(firstChar)); ++firstChar) {
        }
        if (firstChar == path.length()) {
            firstChar = 0;
        }
        if ((firstSeg = path.indexOf(File.separatorChar, firstChar)) > 0) {
            return path.substring(firstChar, firstSeg) + "/.../" + f.getName();
        }
        return f.getName();
    }

    private String process(String input, File file) {
        Matcher dfaMatcher = DFA_PATTERN.matcher(input);
        StringBuffer result = new StringBuffer();
        while (dfaMatcher.find()) {
            String specialStateTransition = dfaMatcher.group(2);
            String staticOrNot = "$1";
            if (!STATE_PATTERN.matcher(specialStateTransition).find()) {
                staticOrNot = "static $1";
            }
            String tmpSpecialStateTransition = this.extractSpecialStateMethods(specialStateTransition);
            String transformedDfa = staticOrNot + tmpSpecialStateTransition + "$3";
            dfaMatcher.appendReplacement(result, transformedDfa);
        }
        dfaMatcher.appendTail(result);
        return result.toString();
    }

    public String extractSpecialStateMethods(String specialStateTransition) {
        if (!TOO_MANY_CASES_PATTERN.matcher(specialStateTransition).find()) {
            return specialStateTransition.replace("\\", "\\\\").replace("$", "\\$");
        }
        Matcher caseMatcher = CASE_PATTERN.matcher(specialStateTransition);
        StringBuffer result = new StringBuffer();
        StringBuffer extractedMethods = new StringBuffer();
        while (caseMatcher.find()) {
            String replacedCaseBody = "$1s = specialStateTransition$2(input);$3$10";
            extractedMethods.append("\n        protected int specialStateTransition");
            extractedMethods.append(caseMatcher.group(2));
            extractedMethods.append("(IntStream input) {\n");
            extractedMethods.append("            int s = -1;\n            ");
            extractedMethods.append(caseMatcher.group(4).replaceAll("(^|\n)\\s+", "$1            "));
            extractedMethods.append("\n");
            extractedMethods.append(caseMatcher.group(6).replaceAll("(^|\n)\\s+", "$1            "));
            extractedMethods.append("\n            return s;\n");
            extractedMethods.append("        }");
            caseMatcher.appendReplacement(result, replacedCaseBody);
        }
        caseMatcher.appendTail(result);
        result.append(extractedMethods);
        result.append("\n");
        return result.toString().replace("\\", "\\\\").replace("$", "\\$");
    }
}

