/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.regnosys.rosetta.RosettaRuntimeModule;
import com.regnosys.rosetta.RosettaStandaloneSetupGenerated;
import com.regnosys.rosetta.config.file.RosettaConfigurationFileProvider;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;

public class RosettaStandaloneSetup
extends RosettaStandaloneSetupGenerated {
    private String configFile;

    public static void doSetup() {
        new RosettaStandaloneSetup().createInjectorAndDoEMFRegistration();
    }

    public RosettaStandaloneSetup setConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    @Override
    public Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{new RosettaRuntimeModule(), binder -> {
            if (this.configFile != null) {
                binder.bind(RosettaConfigurationFileProvider.class).toInstance((Object)RosettaConfigurationFileProvider.createFromFile(this.configFile));
            }
        }});
    }

    @Override
    public Injector createInjectorAndDoEMFRegistration() {
        EValidator.Registry.INSTANCE.clear();
        if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.rosetta-model.com/Rosetta")) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.rosetta-model.com/Rosetta", (Object)RosettaPackage.eINSTANCE);
        }
        if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.rosetta-model.com/RosettaSimple")) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.rosetta-model.com/RosettaSimple", (Object)SimplePackage.eINSTANCE);
        }
        if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.rosetta-model.com/RosettaExpression")) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.rosetta-model.com/RosettaExpression", (Object)ExpressionPackage.eINSTANCE);
        }
        return super.createInjectorAndDoEMFRegistration();
    }
}

