/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.util;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaTyped;
import com.regnosys.rosetta.rosetta.TypeCall;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.rosetta.simple.FunctionDispatch;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RShortcut;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class RosettaFunctionExtensions {
    @Inject
    private RosettaEcoreUtil ecoreUtil;
    @Inject
    private RosettaTypeProvider typeProvider;

    public boolean handleAsSpecFunction(Function function) {
        return function.getOperations().isEmpty() && !this.isDispatchingFunction(function) && !this.handleAsEnumFunction(function);
    }

    public boolean handleAsEnumFunction(Function function) {
        return function.getOperations().isEmpty() && !Iterables.isEmpty(this.getDispatchingFunctions(function));
    }

    public boolean isDispatchingFunction(Function function) {
        return function instanceof FunctionDispatch;
    }

    public Iterable<FunctionDispatch> getDispatchingFunctions(Function function) {
        return Iterables.filter((Iterable)EcoreUtil2.getSiblingsOfType((EObject)function, FunctionDispatch.class), f -> f.getName().equals(function.getName()));
    }

    public Function getMainFunction(Function function) {
        if (this.isDispatchingFunction(function)) {
            return (Function)Iterables.getFirst((Iterable)Iterables.filter((Iterable)EcoreUtil2.getSiblingsOfType((EObject)function, Function.class), f -> f.getName().equals(function.getName()) && f.getOperations().isEmpty()), null);
        }
        return null;
    }

    public Attribute getOutput(Function function) {
        Function mainFunction = this.getMainFunction(function);
        if (mainFunction == null) {
            mainFunction = function;
        }
        return mainFunction.getOutput();
    }

    public List<Attribute> getInputs(Function function) {
        Function mainFunction = this.getMainFunction(function);
        if (mainFunction == null) {
            mainFunction = function;
        }
        return mainFunction.getInputs();
    }

    public String inputsAsArgs(ShortcutDeclaration alias) {
        Function func = (Function)EcoreUtil2.getContainerOfType((EObject)alias, Function.class);
        return this.getInputs(func).stream().map(RosettaNamed::getName).collect(Collectors.joining(", "));
    }

    public boolean needsBuilder(Object ele) {
        if (ele instanceof Void) {
            return false;
        }
        if (ele instanceof RAttribute) {
            RAttribute attr = (RAttribute)ele;
            return this.needsBuilder(attr.getRMetaAnnotatedType().getRType());
        }
        if (ele instanceof RosettaTyped) {
            RosettaTyped typed = (RosettaTyped)ele;
            return this.needsBuilder(typed.getTypeCall().getType());
        }
        if (ele instanceof RosettaExpression) {
            RosettaExpression expr = (RosettaExpression)ele;
            return this.needsBuilder(this.typeProvider.getRMetaAnnotatedType(expr).getRType());
        }
        if (ele instanceof ShortcutDeclaration) {
            ShortcutDeclaration alias = (ShortcutDeclaration)ele;
            return this.needsBuilder(alias.getExpression());
        }
        if (ele instanceof RShortcut) {
            RShortcut alias = (RShortcut)ele;
            return this.needsBuilder(alias.getExpression());
        }
        if (ele instanceof Data || ele instanceof RDataType || ele instanceof RChoiceType) {
            return true;
        }
        if (ele instanceof TypeCall) {
            TypeCall tc = (TypeCall)ele;
            return this.needsBuilder(tc.getType());
        }
        return false;
    }

    public boolean isOutput(Attribute attr) {
        return attr.eContainingFeature() == SimplePackage.Literals.FUNCTION__OUTPUT;
    }

    public boolean isQualifierFunctionFor(Function function, Data type) {
        return this.isQualifierFunction(function) && this.getInputs(function).get(0).getTypeCall().getType().equals(type);
    }

    public boolean isQualifierFunction(Function function) {
        return !this.getQualifierAnnotations(function).isEmpty();
    }

    public boolean isQualifierFunction(RFunction function) {
        return !this.getQualifierAnnotations(function.getAnnotations()).isEmpty();
    }

    public List<AnnotationRef> getMetadataAnnotations(Annotated element) {
        return element.getAnnotations().stream().filter(it -> "metadata".equals(it.getAnnotation().getName())).toList();
    }

    public List<AnnotationRef> getQualifierAnnotations(Annotated element) {
        return this.getQualifierAnnotations((List<AnnotationRef>)element.getAnnotations());
    }

    public List<AnnotationRef> getQualifierAnnotations(List<AnnotationRef> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return List.of();
        }
        return annotations.stream().filter(it -> "qualification".equals(it.getAnnotation().getName())).toList();
    }

    public List<AnnotationRef> getTransformAnnotations(Annotated element) {
        if (element.getAnnotations() == null || element.getAnnotations().isEmpty()) {
            return List.of();
        }
        return element.getAnnotations().stream().filter(this.ecoreUtil::isResolved).filter(it -> "com.rosetta.model".equals(it.getAnnotation().getModel().getName())).filter(it -> Stream.of("ingest", "enrich", "projection").anyMatch(transformName -> transformName.equals(it.getAnnotation().getName()))).toList();
    }

    public List<AnnotationRef> getCreationAnnotations(Annotated element) {
        return element.getAnnotations().stream().filter(it -> "creation".equals(it.getAnnotation().getName())).toList();
    }
}

