/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.processor;

import cdm.base.math.UnitType;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.processor.PriceUnitTypeHelper;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;

public class DrrPriceUnitTypeHelper
extends PriceUnitTypeHelper {
    private final List<Mapping> mappings;

    public DrrPriceUnitTypeHelper(RosettaPath modelPath, MappingContext context) {
        super(modelPath, context);
        this.mappings = context.getMappings();
    }

    public boolean mapUnitType(Path synonymPath, PriceSchedule.PriceScheduleBuilder priceScheduleBuilder) {
        if (!Optional.ofNullable(priceScheduleBuilder.getPriceType()).isPresent()) {
            return false;
        }
        return this.updatePriceFromQuote(priceScheduleBuilder, synonymPath, "LastAvailableSpotPrice") || super.mapUnitType(synonymPath, priceScheduleBuilder);
    }

    protected boolean updatePriceFromQuote(PriceSchedule.PriceScheduleBuilder builder, Path valueSynonymPath, String measureType) {
        PriceTypeEnum priceType;
        if (valueSynonymPath.endsWith(new String[]{"quote", "value"}) && (priceType = builder.getPriceType()) == PriceTypeEnum.ASSET_PRICE) {
            Path quoteSynonymPath = DrrPriceUnitTypeHelper.getNonNullMappingEndsWith(this.mappings, "quote", "measureType").filter(m -> measureType.equals(m.getXmlValue())).map(Mapping::getXmlPath).map(Path::getParent).orElse(null);
            if (quoteSynonymPath == null) {
                return false;
            }
            Path currencySynonymPath = quoteSynonymPath.addElement("currency");
            Optional unitMapping = MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)currencySynonymPath);
            Optional<UnitType.UnitTypeBuilder> unit = unitMapping.map(arg_0 -> ((DrrPriceUnitTypeHelper)this).toCurrencyUnitType(arg_0));
            Path quoteUnitsPath = quoteSynonymPath.addElement("quoteUnits");
            Optional perUnitOfMapping = MappingProcessorUtils.getNonNullMapping(this.mappings, (Path)quoteUnitsPath);
            Optional<UnitType.UnitTypeBuilder> perUnitOf = perUnitOfMapping.map(arg_0 -> ((DrrPriceUnitTypeHelper)this).toCapacityUnitEnumType(arg_0));
            return unit.flatMap(u -> perUnitOf.map(p -> {
                this.updateBuilder(builder, (UnitType.UnitTypeBuilder)u, (UnitType.UnitTypeBuilder)p);
                DrrPriceUnitTypeHelper.updateEmptyMappings((Path)((Mapping)unitMapping.get()).getXmlPath(), this.mappings, (RosettaPath)this.unitCurrencyModelPath);
                DrrPriceUnitTypeHelper.updateEmptyMappings((Path)((Mapping)perUnitOfMapping.get()).getXmlPath(), this.mappings, (RosettaPath)this.perUnitOfCapacityModelPath);
                return true;
            })).orElse(false);
        }
        return false;
    }

    private static Optional<Mapping> getNonNullMappingEndsWith(List<Mapping> mappings, String ... endsWith) {
        return mappings.stream().filter(m -> m.getXmlPath().endsWith(endsWith)).filter(m -> m.getXmlValue() != null).findFirst();
    }
}

