/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.common.trade.functions;

import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PreEnrichDefault.class)
public abstract class PreEnrich
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public WorkflowStep evaluate(WorkflowStep workflowStep) {
        WorkflowStep enrichedWorkflowStep;
        WorkflowStep.WorkflowStepBuilder enrichedWorkflowStepBuilder = this.doEvaluate(workflowStep);
        if (enrichedWorkflowStepBuilder == null) {
            enrichedWorkflowStep = null;
        } else {
            enrichedWorkflowStep = enrichedWorkflowStepBuilder.build();
            this.objectValidator.validate(WorkflowStep.class, (RosettaModelObject)enrichedWorkflowStep);
        }
        return enrichedWorkflowStep;
    }

    protected abstract WorkflowStep.WorkflowStepBuilder doEvaluate(WorkflowStep var1);

    public static class PreEnrichDefault
    extends PreEnrich {
        @Override
        protected WorkflowStep.WorkflowStepBuilder doEvaluate(WorkflowStep workflowStep) {
            WorkflowStep.WorkflowStepBuilder enrichedWorkflowStep = WorkflowStep.builder();
            return this.assignOutput(enrichedWorkflowStep, workflowStep);
        }

        protected WorkflowStep.WorkflowStepBuilder assignOutput(WorkflowStep.WorkflowStepBuilder enrichedWorkflowStep, WorkflowStep workflowStep) {
            enrichedWorkflowStep = (WorkflowStep.WorkflowStepBuilder)this.toBuilder((RosettaModelObject)workflowStep);
            return Optional.ofNullable(enrichedWorkflowStep).map(o -> o.prune()).orElse(null);
        }
    }
}

