/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import iso20022.auth030.fca.TradeConfirmation1Choice;
import iso20022.auth030.fca.TradeConfirmation2;
import iso20022.auth030.fca.TradeConfirmationType1Code;
import iso20022.auth030.fca.TradeConfirmationType2Code;
import iso20022.auth030.fca.TradeNonConfirmation1;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetTradConfDefault.class)
public abstract class GetTradConf
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TradeConfirmation1Choice evaluate(FCAUKEMIRTransactionReport drrReport) {
        TradeConfirmation1Choice tradConf;
        TradeConfirmation1Choice.TradeConfirmation1ChoiceBuilder tradConfBuilder = this.doEvaluate(drrReport);
        if (tradConfBuilder == null) {
            tradConf = null;
        } else {
            tradConf = tradConfBuilder.build();
            this.objectValidator.validate(TradeConfirmation1Choice.class, (RosettaModelObject)tradConf);
        }
        return tradConf;
    }

    protected abstract TradeConfirmation1Choice.TradeConfirmation1ChoiceBuilder doEvaluate(FCAUKEMIRTransactionReport var1);

    public static class GetTradConfDefault
    extends GetTradConf {
        @Override
        protected TradeConfirmation1Choice.TradeConfirmation1ChoiceBuilder doEvaluate(FCAUKEMIRTransactionReport drrReport) {
            TradeConfirmation1Choice.TradeConfirmation1ChoiceBuilder tradConf = TradeConfirmation1Choice.builder();
            return this.assignOutput(tradConf, drrReport);
        }

        protected TradeConfirmation1Choice.TradeConfirmation1ChoiceBuilder assignOutput(TradeConfirmation1Choice.TradeConfirmation1ChoiceBuilder tradConf, FCAUKEMIRTransactionReport drrReport) {
            ZonedDateTime ifThenElseResult0 = null;
            if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)drrReport).map("getConfirmed", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getConfirmed()), (Mapper)MapperS.of((Object)"NCNF"), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = (ZonedDateTime)MapperS.of((Object)drrReport).map("getConfirmationTimestamp", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getConfirmationTimestamp()).get();
            }
            TradeConfirmationType1Code ifThenElseResult1 = null;
            if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)drrReport).map("getConfirmed", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getConfirmed()), (Mapper)MapperS.of((Object)"NCNF"), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = (TradeConfirmationType1Code)MapperS.of((Object)drrReport).map("getConfirmed", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getConfirmed()).checkedMap("to-enum", TradeConfirmationType1Code::fromDisplayName, IllegalArgumentException.class).get();
            }
            TradeConfirmationType2Code ifThenElseResult2 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)drrReport).map("getConfirmed", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getConfirmed()), (Mapper)MapperS.of((Object)"NCNF"), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult2 = (TradeConfirmationType2Code)MapperS.of((Object)drrReport).map("getConfirmed", fCAUKEMIRTransactionReport -> fCAUKEMIRTransactionReport.getConfirmed()).checkedMap("to-enum", TradeConfirmationType2Code::fromDisplayName, IllegalArgumentException.class).get();
            }
            tradConf = (TradeConfirmation1Choice.TradeConfirmation1ChoiceBuilder)this.toBuilder((RosettaModelObject)TradeConfirmation1Choice.builder().setConfd(TradeConfirmation2.builder().setTmStmp(ifThenElseResult0).setTp(ifThenElseResult1).build()).setNonConfd(TradeNonConfirmation1.builder().setTp(ifThenElseResult2).build()).build());
            return Optional.ofNullable(tradConf).map(o -> o.prune()).orElse(null);
        }
    }
}

