/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.margin.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.margin.ASICMarginReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ASICMarginReportTypeFormatValidator
implements Validator<ASICMarginReport> {
    private List<ComparisonResult> getComparisonResults(ASICMarginReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperators.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"uniqueTransactionIdentifierProprietary", (String)o.getUniqueTransactionIdentifierProprietary(), (int)0, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), ExpressionOperators.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperators.checkString((String)"initialMarginCollateralPortfolioCode", (String)o.getInitialMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkString((String)"collateralPortfolioCodeVM", (String)o.getCollateralPortfolioCodeVM(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperators.checkNumber((String)"initialMarginPostedByTheReportingEntityPreHaircut", (BigDecimal)o.getInitialMarginPostedByTheReportingEntityPreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"initialMarginPostedByTheReportingEntityPostHaircut", (BigDecimal)o.getInitialMarginPostedByTheReportingEntityPostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"initialMarginCollectedByTheReportingEntityPreHaircut", (BigDecimal)o.getInitialMarginCollectedByTheReportingEntityPreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"initialMarginCollectedByTheReportingEntityPostHaircut", (BigDecimal)o.getInitialMarginCollectedByTheReportingEntityPostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginPostedByTheReportingEntityPreHaircut", (BigDecimal)o.getVariationMarginPostedByTheReportingEntityPreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkNumber((String)"variationMarginCollectedByTheReportingEntityPreHaircut", (BigDecimal)o.getVariationMarginCollectedByTheReportingEntityPreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperators.checkString((String)"executionAgentOfCounterparty1", (String)o.getExecutionAgentOfCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICMarginReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"ASICMarginReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"ASICMarginReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"ASICMarginReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"ASICMarginReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

