/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.reports.CDEPriceCurrencyRule;
import javax.inject.Inject;

@ImplementedBy(value=PriceCurrencyRuleDefault.class)
public abstract class PriceCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected CDEPriceCurrencyRule cDEPriceCurrencyRule;
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class PriceCurrencyRuleDefault
    extends PriceCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_AssetClass_Commodity.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_AssetClass_Equity.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get())))))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isFixedFloatZeroCouponSwapKnownAmount.evaluate(this.productForEvent.evaluate((ReportableEvent)item.get()))))).get());
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                String string = this.cDEPriceCurrencyRule.evaluate((TransactionReportInstruction)item.get());
                return string == null ? MapperS.ofNull() : MapperS.of((Object)FieldWithMetaString.builder().setValue(string).build());
            });
            output = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

