/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.FinancialSectorEnum;
import drr.regulation.common.NonFinancialSector;
import drr.regulation.common.meta.CorporateSectorMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CorporateSector", builder=CorporateSectorBuilderImpl.class, version="5.53.0")
@RuneDataType(value="CorporateSector", model="drr", builder=CorporateSectorBuilderImpl.class, version="5.53.0")
public interface CorporateSector
extends RosettaModelObject {
    public static final CorporateSectorMeta metaData = new CorporateSectorMeta();

    public List<FinancialSectorEnum> getFinancialSector();

    public List<? extends NonFinancialSector> getNonFinancialSector();

    public CorporateSector build();

    public CorporateSectorBuilder toBuilder();

    public static CorporateSectorBuilder builder() {
        return new CorporateSectorBuilderImpl();
    }

    default public RosettaMetaData<? extends CorporateSector> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CorporateSector> getType() {
        return CorporateSector.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("financialSector"), FinancialSectorEnum.class, this.getFinancialSector(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonFinancialSector"), processor, NonFinancialSector.class, this.getNonFinancialSector(), new AttributeMeta[0]);
    }

    public static class CorporateSectorBuilderImpl
    implements CorporateSectorBuilder {
        protected List<FinancialSectorEnum> financialSector = new ArrayList<FinancialSectorEnum>();
        protected List<NonFinancialSector.NonFinancialSectorBuilder> nonFinancialSector = new ArrayList<NonFinancialSector.NonFinancialSectorBuilder>();

        @Override
        @RosettaAttribute(value="financialSector")
        @RuneAttribute(value="financialSector")
        public List<FinancialSectorEnum> getFinancialSector() {
            return this.financialSector;
        }

        @Override
        @RosettaAttribute(value="nonFinancialSector")
        @RuneAttribute(value="nonFinancialSector")
        public List<? extends NonFinancialSector.NonFinancialSectorBuilder> getNonFinancialSector() {
            return this.nonFinancialSector;
        }

        @Override
        public NonFinancialSector.NonFinancialSectorBuilder getOrCreateNonFinancialSector(int index) {
            if (this.nonFinancialSector == null) {
                this.nonFinancialSector = new ArrayList<NonFinancialSector.NonFinancialSectorBuilder>();
            }
            return (NonFinancialSector.NonFinancialSectorBuilder)this.getIndex(this.nonFinancialSector, index, () -> {
                NonFinancialSector.NonFinancialSectorBuilder newNonFinancialSector = NonFinancialSector.builder();
                return newNonFinancialSector;
            });
        }

        @Override
        @RosettaAttribute(value="financialSector")
        @RuneAttribute(value="financialSector")
        public CorporateSectorBuilder addFinancialSector(FinancialSectorEnum _financialSector) {
            if (_financialSector != null) {
                this.financialSector.add(_financialSector);
            }
            return this;
        }

        @Override
        public CorporateSectorBuilder addFinancialSector(FinancialSectorEnum _financialSector, int idx) {
            this.getIndex(this.financialSector, idx, () -> _financialSector);
            return this;
        }

        @Override
        public CorporateSectorBuilder addFinancialSector(List<FinancialSectorEnum> financialSectors) {
            if (financialSectors != null) {
                for (FinancialSectorEnum toAdd : financialSectors) {
                    this.financialSector.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="financialSector")
        public CorporateSectorBuilder setFinancialSector(List<FinancialSectorEnum> financialSectors) {
            this.financialSector = financialSectors == null ? new ArrayList<FinancialSectorEnum>() : (List)financialSectors.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="nonFinancialSector")
        @RuneAttribute(value="nonFinancialSector")
        public CorporateSectorBuilder addNonFinancialSector(NonFinancialSector _nonFinancialSector) {
            if (_nonFinancialSector != null) {
                this.nonFinancialSector.add(_nonFinancialSector.toBuilder());
            }
            return this;
        }

        @Override
        public CorporateSectorBuilder addNonFinancialSector(NonFinancialSector _nonFinancialSector, int idx) {
            this.getIndex(this.nonFinancialSector, idx, () -> _nonFinancialSector.toBuilder());
            return this;
        }

        @Override
        public CorporateSectorBuilder addNonFinancialSector(List<? extends NonFinancialSector> nonFinancialSectors) {
            if (nonFinancialSectors != null) {
                for (NonFinancialSector nonFinancialSector : nonFinancialSectors) {
                    this.nonFinancialSector.add(nonFinancialSector.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="nonFinancialSector")
        public CorporateSectorBuilder setNonFinancialSector(List<? extends NonFinancialSector> nonFinancialSectors) {
            this.nonFinancialSector = nonFinancialSectors == null ? new ArrayList<NonFinancialSector.NonFinancialSectorBuilder>() : (List)nonFinancialSectors.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CorporateSector build() {
            return new CorporateSectorImpl(this);
        }

        @Override
        public CorporateSectorBuilder toBuilder() {
            return this;
        }

        @Override
        public CorporateSectorBuilder prune() {
            this.nonFinancialSector = this.nonFinancialSector.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFinancialSector() != null && !this.getFinancialSector().isEmpty()) {
                return true;
            }
            return this.getNonFinancialSector() != null && this.getNonFinancialSector().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CorporateSectorBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CorporateSectorBuilder o = (CorporateSectorBuilder)other;
            merger.mergeRosetta(this.getNonFinancialSector(), o.getNonFinancialSector(), this::getOrCreateNonFinancialSector);
            merger.mergeBasic(this.getFinancialSector(), o.getFinancialSector(), this::addFinancialSector);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CorporateSector _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.financialSector, _that.getFinancialSector())) {
                return false;
            }
            return ListEquals.listEquals(this.nonFinancialSector, _that.getNonFinancialSector());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.financialSector != null ? this.financialSector.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.nonFinancialSector != null ? this.nonFinancialSector.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CorporateSectorBuilder {financialSector=" + String.valueOf(this.financialSector) + ", nonFinancialSector=" + String.valueOf(this.nonFinancialSector) + "}";
        }
    }

    public static interface CorporateSectorBuilder
    extends CorporateSector,
    RosettaModelObjectBuilder {
        public NonFinancialSector.NonFinancialSectorBuilder getOrCreateNonFinancialSector(int var1);

        public List<? extends NonFinancialSector.NonFinancialSectorBuilder> getNonFinancialSector();

        public CorporateSectorBuilder addFinancialSector(FinancialSectorEnum var1);

        public CorporateSectorBuilder addFinancialSector(FinancialSectorEnum var1, int var2);

        public CorporateSectorBuilder addFinancialSector(List<FinancialSectorEnum> var1);

        public CorporateSectorBuilder setFinancialSector(List<FinancialSectorEnum> var1);

        public CorporateSectorBuilder addNonFinancialSector(NonFinancialSector var1);

        public CorporateSectorBuilder addNonFinancialSector(NonFinancialSector var1, int var2);

        public CorporateSectorBuilder addNonFinancialSector(List<? extends NonFinancialSector> var1);

        public CorporateSectorBuilder setNonFinancialSector(List<? extends NonFinancialSector> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("financialSector"), FinancialSectorEnum.class, this.getFinancialSector(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonFinancialSector"), processor, NonFinancialSector.NonFinancialSectorBuilder.class, this.getNonFinancialSector(), new AttributeMeta[0]);
        }

        public CorporateSectorBuilder prune();
    }

    public static class CorporateSectorImpl
    implements CorporateSector {
        private final List<FinancialSectorEnum> financialSector;
        private final List<? extends NonFinancialSector> nonFinancialSector;

        protected CorporateSectorImpl(CorporateSectorBuilder builder) {
            this.financialSector = Optional.ofNullable(builder.getFinancialSector()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.nonFinancialSector = Optional.ofNullable(builder.getNonFinancialSector()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="financialSector")
        @RuneAttribute(value="financialSector")
        public List<FinancialSectorEnum> getFinancialSector() {
            return this.financialSector;
        }

        @Override
        @RosettaAttribute(value="nonFinancialSector")
        @RuneAttribute(value="nonFinancialSector")
        public List<? extends NonFinancialSector> getNonFinancialSector() {
            return this.nonFinancialSector;
        }

        @Override
        public CorporateSector build() {
            return this;
        }

        @Override
        public CorporateSectorBuilder toBuilder() {
            CorporateSectorBuilder builder = CorporateSector.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CorporateSectorBuilder builder) {
            Optional.ofNullable(this.getFinancialSector()).ifPresent(builder::setFinancialSector);
            Optional.ofNullable(this.getNonFinancialSector()).ifPresent(builder::setNonFinancialSector);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CorporateSector _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.financialSector, _that.getFinancialSector())) {
                return false;
            }
            return ListEquals.listEquals(this.nonFinancialSector, _that.getNonFinancialSector());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.financialSector != null ? this.financialSector.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.nonFinancialSector != null ? this.nonFinancialSector.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CorporateSector {financialSector=" + String.valueOf(this.financialSector) + ", nonFinancialSector=" + String.valueOf(this.nonFinancialSector) + "}";
        }
    }
}

