/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.observable.asset.PriceSchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.Cashflow;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.TradeLot;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.PayoutLeg;
import drr.regulation.common.meta.PayoutLegWithAuxiliaryMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PayoutLegWithAuxiliary", builder=PayoutLegWithAuxiliaryBuilderImpl.class, version="5.53.0")
@RuneDataType(value="PayoutLegWithAuxiliary", model="drr", builder=PayoutLegWithAuxiliaryBuilderImpl.class, version="5.53.0")
public interface PayoutLegWithAuxiliary
extends PayoutLeg {
    public static final PayoutLegWithAuxiliaryMeta metaData = new PayoutLegWithAuxiliaryMeta();

    public PayoutLeg getAuxiliaryLeg();

    public PriceSchedule getLastAvailableSpotPrice();

    public TradeLot getTradeLot();

    public Boolean getIsProductETD();

    @Override
    public PayoutLegWithAuxiliary build();

    @Override
    public PayoutLegWithAuxiliaryBuilder toBuilder();

    public static PayoutLegWithAuxiliaryBuilder builder() {
        return new PayoutLegWithAuxiliaryBuilderImpl();
    }

    default public RosettaMetaData<? extends PayoutLegWithAuxiliary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PayoutLegWithAuxiliary> getType() {
        return PayoutLegWithAuxiliary.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("creditDefaultPayout"), processor, CreditDefaultPayout.class, (RosettaModelObject)this.getCreditDefaultPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionPayout"), processor, OptionPayout.class, (RosettaModelObject)this.getOptionPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forwardPayout"), processor, ForwardPayout.class, (RosettaModelObject)this.getForwardPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("performancePayout"), processor, PerformancePayout.class, (RosettaModelObject)this.getPerformancePayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestRatePayout"), processor, InterestRatePayout.class, (RosettaModelObject)this.getInterestRatePayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashflow"), processor, Cashflow.class, (RosettaModelObject)this.getCashflow(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedPricePayout"), processor, FixedPricePayout.class, (RosettaModelObject)this.getFixedPricePayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityPayout"), processor, CommodityPayout.class, (RosettaModelObject)this.getCommodityPayout(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("auxiliaryLeg"), processor, PayoutLeg.class, this.getAuxiliaryLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lastAvailableSpotPrice"), processor, PriceSchedule.class, (RosettaModelObject)this.getLastAvailableSpotPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeLot"), processor, TradeLot.class, (RosettaModelObject)this.getTradeLot(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isProductETD"), Boolean.class, (Object)this.getIsProductETD(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PayoutLegWithAuxiliaryBuilderImpl
    extends PayoutLeg.PayoutLegBuilderImpl
    implements PayoutLegWithAuxiliaryBuilder {
        protected PayoutLeg.PayoutLegBuilder auxiliaryLeg;
        protected PriceSchedule.PriceScheduleBuilder lastAvailableSpotPrice;
        protected TradeLot.TradeLotBuilder tradeLot;
        protected Boolean isProductETD;

        @Override
        @RosettaAttribute(value="auxiliaryLeg")
        @RuneAttribute(value="auxiliaryLeg")
        public PayoutLeg.PayoutLegBuilder getAuxiliaryLeg() {
            return this.auxiliaryLeg;
        }

        @Override
        public PayoutLeg.PayoutLegBuilder getOrCreateAuxiliaryLeg() {
            PayoutLeg.PayoutLegBuilder result = this.auxiliaryLeg != null ? this.auxiliaryLeg : (this.auxiliaryLeg = PayoutLeg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lastAvailableSpotPrice")
        @RuneAttribute(value="lastAvailableSpotPrice")
        public PriceSchedule.PriceScheduleBuilder getLastAvailableSpotPrice() {
            return this.lastAvailableSpotPrice;
        }

        @Override
        public PriceSchedule.PriceScheduleBuilder getOrCreateLastAvailableSpotPrice() {
            PriceSchedule.PriceScheduleBuilder result = this.lastAvailableSpotPrice != null ? this.lastAvailableSpotPrice : (this.lastAvailableSpotPrice = PriceSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeLot")
        @RuneAttribute(value="tradeLot")
        public TradeLot.TradeLotBuilder getTradeLot() {
            return this.tradeLot;
        }

        @Override
        public TradeLot.TradeLotBuilder getOrCreateTradeLot() {
            TradeLot.TradeLotBuilder result = this.tradeLot != null ? this.tradeLot : (this.tradeLot = TradeLot.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="isProductETD")
        @RuneAttribute(value="isProductETD")
        public Boolean getIsProductETD() {
            return this.isProductETD;
        }

        @Override
        @RosettaAttribute(value="creditDefaultPayout")
        @RuneAttribute(value="creditDefaultPayout")
        public PayoutLegWithAuxiliaryBuilder setCreditDefaultPayout(CreditDefaultPayout _creditDefaultPayout) {
            this.creditDefaultPayout = _creditDefaultPayout == null ? null : _creditDefaultPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPayout")
        @RuneAttribute(value="optionPayout")
        public PayoutLegWithAuxiliaryBuilder setOptionPayout(OptionPayout _optionPayout) {
            this.optionPayout = _optionPayout == null ? null : _optionPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="forwardPayout")
        @RuneAttribute(value="forwardPayout")
        public PayoutLegWithAuxiliaryBuilder setForwardPayout(ForwardPayout _forwardPayout) {
            this.forwardPayout = _forwardPayout == null ? null : _forwardPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="performancePayout")
        @RuneAttribute(value="performancePayout")
        public PayoutLegWithAuxiliaryBuilder setPerformancePayout(PerformancePayout _performancePayout) {
            this.performancePayout = _performancePayout == null ? null : _performancePayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestRatePayout")
        @RuneAttribute(value="interestRatePayout")
        public PayoutLegWithAuxiliaryBuilder setInterestRatePayout(InterestRatePayout _interestRatePayout) {
            this.interestRatePayout = _interestRatePayout == null ? null : _interestRatePayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashflow")
        @RuneAttribute(value="cashflow")
        public PayoutLegWithAuxiliaryBuilder setCashflow(Cashflow _cashflow) {
            this.cashflow = _cashflow == null ? null : _cashflow.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedPricePayout")
        @RuneAttribute(value="fixedPricePayout")
        public PayoutLegWithAuxiliaryBuilder setFixedPricePayout(FixedPricePayout _fixedPricePayout) {
            this.fixedPricePayout = _fixedPricePayout == null ? null : _fixedPricePayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityPayout")
        @RuneAttribute(value="commodityPayout")
        public PayoutLegWithAuxiliaryBuilder setCommodityPayout(CommodityPayout _commodityPayout) {
            this.commodityPayout = _commodityPayout == null ? null : _commodityPayout.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="auxiliaryLeg")
        @RuneAttribute(value="auxiliaryLeg")
        public PayoutLegWithAuxiliaryBuilder setAuxiliaryLeg(PayoutLeg _auxiliaryLeg) {
            this.auxiliaryLeg = _auxiliaryLeg == null ? null : _auxiliaryLeg.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lastAvailableSpotPrice")
        @RuneAttribute(value="lastAvailableSpotPrice")
        public PayoutLegWithAuxiliaryBuilder setLastAvailableSpotPrice(PriceSchedule _lastAvailableSpotPrice) {
            this.lastAvailableSpotPrice = _lastAvailableSpotPrice == null ? null : _lastAvailableSpotPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeLot")
        @RuneAttribute(value="tradeLot")
        public PayoutLegWithAuxiliaryBuilder setTradeLot(TradeLot _tradeLot) {
            this.tradeLot = _tradeLot == null ? null : _tradeLot.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isProductETD")
        @RuneAttribute(value="isProductETD")
        public PayoutLegWithAuxiliaryBuilder setIsProductETD(Boolean _isProductETD) {
            this.isProductETD = _isProductETD == null ? null : _isProductETD;
            return this;
        }

        @Override
        public PayoutLegWithAuxiliary build() {
            return new PayoutLegWithAuxiliaryImpl(this);
        }

        @Override
        public PayoutLegWithAuxiliaryBuilder toBuilder() {
            return this;
        }

        @Override
        public PayoutLegWithAuxiliaryBuilder prune() {
            super.prune();
            if (this.auxiliaryLeg != null && !this.auxiliaryLeg.prune().hasData()) {
                this.auxiliaryLeg = null;
            }
            if (this.lastAvailableSpotPrice != null && !this.lastAvailableSpotPrice.prune().hasData()) {
                this.lastAvailableSpotPrice = null;
            }
            if (this.tradeLot != null && !this.tradeLot.prune().hasData()) {
                this.tradeLot = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAuxiliaryLeg() != null && this.getAuxiliaryLeg().hasData()) {
                return true;
            }
            if (this.getLastAvailableSpotPrice() != null && this.getLastAvailableSpotPrice().hasData()) {
                return true;
            }
            if (this.getTradeLot() != null && this.getTradeLot().hasData()) {
                return true;
            }
            return this.getIsProductETD() != null;
        }

        @Override
        public PayoutLegWithAuxiliaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PayoutLegWithAuxiliaryBuilder o = (PayoutLegWithAuxiliaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAuxiliaryLeg(), (RosettaModelObjectBuilder)o.getAuxiliaryLeg(), this::setAuxiliaryLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLastAvailableSpotPrice(), (RosettaModelObjectBuilder)o.getLastAvailableSpotPrice(), this::setLastAvailableSpotPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeLot(), (RosettaModelObjectBuilder)o.getTradeLot(), this::setTradeLot);
            merger.mergeBasic((Object)this.getIsProductETD(), (Object)o.getIsProductETD(), this::setIsProductETD, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PayoutLegWithAuxiliary _that = (PayoutLegWithAuxiliary)this.getType().cast(o);
            if (!Objects.equals(this.auxiliaryLeg, _that.getAuxiliaryLeg())) {
                return false;
            }
            if (!Objects.equals(this.lastAvailableSpotPrice, _that.getLastAvailableSpotPrice())) {
                return false;
            }
            if (!Objects.equals(this.tradeLot, _that.getTradeLot())) {
                return false;
            }
            return Objects.equals(this.isProductETD, _that.getIsProductETD());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.auxiliaryLeg != null ? this.auxiliaryLeg.hashCode() : 0);
            _result = 31 * _result + (this.lastAvailableSpotPrice != null ? this.lastAvailableSpotPrice.hashCode() : 0);
            _result = 31 * _result + (this.tradeLot != null ? this.tradeLot.hashCode() : 0);
            _result = 31 * _result + (this.isProductETD != null ? this.isProductETD.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PayoutLegWithAuxiliaryBuilder {auxiliaryLeg=" + String.valueOf(this.auxiliaryLeg) + ", lastAvailableSpotPrice=" + String.valueOf(this.lastAvailableSpotPrice) + ", tradeLot=" + String.valueOf(this.tradeLot) + ", isProductETD=" + this.isProductETD + "} " + super.toString();
        }
    }

    public static interface PayoutLegWithAuxiliaryBuilder
    extends PayoutLegWithAuxiliary,
    PayoutLeg.PayoutLegBuilder {
        public PayoutLeg.PayoutLegBuilder getOrCreateAuxiliaryLeg();

        @Override
        public PayoutLeg.PayoutLegBuilder getAuxiliaryLeg();

        public PriceSchedule.PriceScheduleBuilder getOrCreateLastAvailableSpotPrice();

        public PriceSchedule.PriceScheduleBuilder getLastAvailableSpotPrice();

        public TradeLot.TradeLotBuilder getOrCreateTradeLot();

        public TradeLot.TradeLotBuilder getTradeLot();

        @Override
        public PayoutLegWithAuxiliaryBuilder setCreditDefaultPayout(CreditDefaultPayout var1);

        @Override
        public PayoutLegWithAuxiliaryBuilder setOptionPayout(OptionPayout var1);

        @Override
        public PayoutLegWithAuxiliaryBuilder setForwardPayout(ForwardPayout var1);

        @Override
        public PayoutLegWithAuxiliaryBuilder setPerformancePayout(PerformancePayout var1);

        @Override
        public PayoutLegWithAuxiliaryBuilder setInterestRatePayout(InterestRatePayout var1);

        @Override
        public PayoutLegWithAuxiliaryBuilder setCashflow(Cashflow var1);

        @Override
        public PayoutLegWithAuxiliaryBuilder setFixedPricePayout(FixedPricePayout var1);

        @Override
        public PayoutLegWithAuxiliaryBuilder setCommodityPayout(CommodityPayout var1);

        public PayoutLegWithAuxiliaryBuilder setAuxiliaryLeg(PayoutLeg var1);

        public PayoutLegWithAuxiliaryBuilder setLastAvailableSpotPrice(PriceSchedule var1);

        public PayoutLegWithAuxiliaryBuilder setTradeLot(TradeLot var1);

        public PayoutLegWithAuxiliaryBuilder setIsProductETD(Boolean var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("creditDefaultPayout"), processor, CreditDefaultPayout.CreditDefaultPayoutBuilder.class, (RosettaModelObjectBuilder)this.getCreditDefaultPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionPayout"), processor, OptionPayout.OptionPayoutBuilder.class, (RosettaModelObjectBuilder)this.getOptionPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forwardPayout"), processor, ForwardPayout.ForwardPayoutBuilder.class, (RosettaModelObjectBuilder)this.getForwardPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("performancePayout"), processor, PerformancePayout.PerformancePayoutBuilder.class, (RosettaModelObjectBuilder)this.getPerformancePayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestRatePayout"), processor, InterestRatePayout.InterestRatePayoutBuilder.class, (RosettaModelObjectBuilder)this.getInterestRatePayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashflow"), processor, Cashflow.CashflowBuilder.class, (RosettaModelObjectBuilder)this.getCashflow(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedPricePayout"), processor, FixedPricePayout.FixedPricePayoutBuilder.class, (RosettaModelObjectBuilder)this.getFixedPricePayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityPayout"), processor, CommodityPayout.CommodityPayoutBuilder.class, (RosettaModelObjectBuilder)this.getCommodityPayout(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("auxiliaryLeg"), processor, PayoutLeg.PayoutLegBuilder.class, this.getAuxiliaryLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lastAvailableSpotPrice"), processor, PriceSchedule.PriceScheduleBuilder.class, (RosettaModelObjectBuilder)this.getLastAvailableSpotPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeLot"), processor, TradeLot.TradeLotBuilder.class, (RosettaModelObjectBuilder)this.getTradeLot(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isProductETD"), Boolean.class, (Object)this.getIsProductETD(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public PayoutLegWithAuxiliaryBuilder prune();
    }

    public static class PayoutLegWithAuxiliaryImpl
    extends PayoutLeg.PayoutLegImpl
    implements PayoutLegWithAuxiliary {
        private final PayoutLeg auxiliaryLeg;
        private final PriceSchedule lastAvailableSpotPrice;
        private final TradeLot tradeLot;
        private final Boolean isProductETD;

        protected PayoutLegWithAuxiliaryImpl(PayoutLegWithAuxiliaryBuilder builder) {
            super(builder);
            this.auxiliaryLeg = Optional.ofNullable(builder.getAuxiliaryLeg()).map(f -> f.build()).orElse(null);
            this.lastAvailableSpotPrice = Optional.ofNullable(builder.getLastAvailableSpotPrice()).map(f -> f.build()).orElse(null);
            this.tradeLot = Optional.ofNullable(builder.getTradeLot()).map(f -> f.build()).orElse(null);
            this.isProductETD = builder.getIsProductETD();
        }

        @Override
        @RosettaAttribute(value="auxiliaryLeg")
        @RuneAttribute(value="auxiliaryLeg")
        public PayoutLeg getAuxiliaryLeg() {
            return this.auxiliaryLeg;
        }

        @Override
        @RosettaAttribute(value="lastAvailableSpotPrice")
        @RuneAttribute(value="lastAvailableSpotPrice")
        public PriceSchedule getLastAvailableSpotPrice() {
            return this.lastAvailableSpotPrice;
        }

        @Override
        @RosettaAttribute(value="tradeLot")
        @RuneAttribute(value="tradeLot")
        public TradeLot getTradeLot() {
            return this.tradeLot;
        }

        @Override
        @RosettaAttribute(value="isProductETD")
        @RuneAttribute(value="isProductETD")
        public Boolean getIsProductETD() {
            return this.isProductETD;
        }

        @Override
        public PayoutLegWithAuxiliary build() {
            return this;
        }

        @Override
        public PayoutLegWithAuxiliaryBuilder toBuilder() {
            PayoutLegWithAuxiliaryBuilder builder = PayoutLegWithAuxiliary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PayoutLegWithAuxiliaryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAuxiliaryLeg()).ifPresent(builder::setAuxiliaryLeg);
            Optional.ofNullable(this.getLastAvailableSpotPrice()).ifPresent(builder::setLastAvailableSpotPrice);
            Optional.ofNullable(this.getTradeLot()).ifPresent(builder::setTradeLot);
            Optional.ofNullable(this.getIsProductETD()).ifPresent(builder::setIsProductETD);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PayoutLegWithAuxiliary _that = (PayoutLegWithAuxiliary)this.getType().cast(o);
            if (!Objects.equals(this.auxiliaryLeg, _that.getAuxiliaryLeg())) {
                return false;
            }
            if (!Objects.equals(this.lastAvailableSpotPrice, _that.getLastAvailableSpotPrice())) {
                return false;
            }
            if (!Objects.equals(this.tradeLot, _that.getTradeLot())) {
                return false;
            }
            return Objects.equals(this.isProductETD, _that.getIsProductETD());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.auxiliaryLeg != null ? this.auxiliaryLeg.hashCode() : 0);
            _result = 31 * _result + (this.lastAvailableSpotPrice != null ? this.lastAvailableSpotPrice.hashCode() : 0);
            _result = 31 * _result + (this.tradeLot != null ? this.tradeLot.hashCode() : 0);
            _result = 31 * _result + (this.isProductETD != null ? this.isProductETD.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PayoutLegWithAuxiliary {auxiliaryLeg=" + String.valueOf(this.auxiliaryLeg) + ", lastAvailableSpotPrice=" + String.valueOf(this.lastAvailableSpotPrice) + ", tradeLot=" + String.valueOf(this.tradeLot) + ", isProductETD=" + this.isProductETD + "} " + super.toString();
        }
    }
}

