/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.meta.PriceReportablePeriodMeta;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PriceReportablePeriod", builder=PriceReportablePeriodBuilderImpl.class, version="5.53.0")
@RuneDataType(value="PriceReportablePeriod", model="drr", builder=PriceReportablePeriodBuilderImpl.class, version="5.53.0")
public interface PriceReportablePeriod
extends RosettaModelObject {
    public static final PriceReportablePeriodMeta metaData = new PriceReportablePeriodMeta();

    public PriceAndNotation getPeriodValue();

    public Date getPeriodEffectiveDate();

    public Date getPeriodEndDate();

    public PriceReportablePeriod build();

    public PriceReportablePeriodBuilder toBuilder();

    public static PriceReportablePeriodBuilder builder() {
        return new PriceReportablePeriodBuilderImpl();
    }

    default public RosettaMetaData<? extends PriceReportablePeriod> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PriceReportablePeriod> getType() {
        return PriceReportablePeriod.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periodValue"), processor, PriceAndNotation.class, this.getPeriodValue(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("periodEffectiveDate"), Date.class, (Object)this.getPeriodEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("periodEndDate"), Date.class, (Object)this.getPeriodEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PriceReportablePeriodBuilderImpl
    implements PriceReportablePeriodBuilder {
        protected PriceAndNotation.PriceAndNotationBuilder periodValue;
        protected Date periodEffectiveDate;
        protected Date periodEndDate;

        @Override
        @RosettaAttribute(value="periodValue", isRequired=true)
        @RuneAttribute(value="periodValue", isRequired=true)
        public PriceAndNotation.PriceAndNotationBuilder getPeriodValue() {
            return this.periodValue;
        }

        @Override
        public PriceAndNotation.PriceAndNotationBuilder getOrCreatePeriodValue() {
            PriceAndNotation.PriceAndNotationBuilder result = this.periodValue != null ? this.periodValue : (this.periodValue = PriceAndNotation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodEffectiveDate", isRequired=true)
        @RuneAttribute(value="periodEffectiveDate", isRequired=true)
        public Date getPeriodEffectiveDate() {
            return this.periodEffectiveDate;
        }

        @Override
        @RosettaAttribute(value="periodEndDate")
        @RuneAttribute(value="periodEndDate")
        public Date getPeriodEndDate() {
            return this.periodEndDate;
        }

        @Override
        @RosettaAttribute(value="periodValue", isRequired=true)
        @RuneAttribute(value="periodValue", isRequired=true)
        public PriceReportablePeriodBuilder setPeriodValue(PriceAndNotation _periodValue) {
            this.periodValue = _periodValue == null ? null : _periodValue.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodEffectiveDate", isRequired=true)
        @RuneAttribute(value="periodEffectiveDate", isRequired=true)
        public PriceReportablePeriodBuilder setPeriodEffectiveDate(Date _periodEffectiveDate) {
            this.periodEffectiveDate = _periodEffectiveDate == null ? null : _periodEffectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="periodEndDate")
        @RuneAttribute(value="periodEndDate")
        public PriceReportablePeriodBuilder setPeriodEndDate(Date _periodEndDate) {
            this.periodEndDate = _periodEndDate == null ? null : _periodEndDate;
            return this;
        }

        @Override
        public PriceReportablePeriod build() {
            return new PriceReportablePeriodImpl(this);
        }

        @Override
        public PriceReportablePeriodBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceReportablePeriodBuilder prune() {
            if (this.periodValue != null && !this.periodValue.prune().hasData()) {
                this.periodValue = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPeriodValue() != null && this.getPeriodValue().hasData()) {
                return true;
            }
            if (this.getPeriodEffectiveDate() != null) {
                return true;
            }
            return this.getPeriodEndDate() != null;
        }

        public PriceReportablePeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PriceReportablePeriodBuilder o = (PriceReportablePeriodBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodValue(), (RosettaModelObjectBuilder)o.getPeriodValue(), this::setPeriodValue);
            merger.mergeBasic((Object)this.getPeriodEffectiveDate(), (Object)o.getPeriodEffectiveDate(), this::setPeriodEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPeriodEndDate(), (Object)o.getPeriodEndDate(), this::setPeriodEndDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceReportablePeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.periodValue, _that.getPeriodValue())) {
                return false;
            }
            if (!Objects.equals(this.periodEffectiveDate, _that.getPeriodEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.periodEndDate, _that.getPeriodEndDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periodValue != null ? this.periodValue.hashCode() : 0);
            _result = 31 * _result + (this.periodEffectiveDate != null ? this.periodEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.periodEndDate != null ? this.periodEndDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceReportablePeriodBuilder {periodValue=" + String.valueOf(this.periodValue) + ", periodEffectiveDate=" + String.valueOf(this.periodEffectiveDate) + ", periodEndDate=" + String.valueOf(this.periodEndDate) + "}";
        }
    }

    public static interface PriceReportablePeriodBuilder
    extends PriceReportablePeriod,
    RosettaModelObjectBuilder {
        public PriceAndNotation.PriceAndNotationBuilder getOrCreatePeriodValue();

        @Override
        public PriceAndNotation.PriceAndNotationBuilder getPeriodValue();

        public PriceReportablePeriodBuilder setPeriodValue(PriceAndNotation var1);

        public PriceReportablePeriodBuilder setPeriodEffectiveDate(Date var1);

        public PriceReportablePeriodBuilder setPeriodEndDate(Date var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periodValue"), processor, PriceAndNotation.PriceAndNotationBuilder.class, this.getPeriodValue(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("periodEffectiveDate"), Date.class, (Object)this.getPeriodEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("periodEndDate"), Date.class, (Object)this.getPeriodEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PriceReportablePeriodBuilder prune();
    }

    public static class PriceReportablePeriodImpl
    implements PriceReportablePeriod {
        private final PriceAndNotation periodValue;
        private final Date periodEffectiveDate;
        private final Date periodEndDate;

        protected PriceReportablePeriodImpl(PriceReportablePeriodBuilder builder) {
            this.periodValue = Optional.ofNullable(builder.getPeriodValue()).map(f -> f.build()).orElse(null);
            this.periodEffectiveDate = builder.getPeriodEffectiveDate();
            this.periodEndDate = builder.getPeriodEndDate();
        }

        @Override
        @RosettaAttribute(value="periodValue", isRequired=true)
        @RuneAttribute(value="periodValue", isRequired=true)
        public PriceAndNotation getPeriodValue() {
            return this.periodValue;
        }

        @Override
        @RosettaAttribute(value="periodEffectiveDate", isRequired=true)
        @RuneAttribute(value="periodEffectiveDate", isRequired=true)
        public Date getPeriodEffectiveDate() {
            return this.periodEffectiveDate;
        }

        @Override
        @RosettaAttribute(value="periodEndDate")
        @RuneAttribute(value="periodEndDate")
        public Date getPeriodEndDate() {
            return this.periodEndDate;
        }

        @Override
        public PriceReportablePeriod build() {
            return this;
        }

        @Override
        public PriceReportablePeriodBuilder toBuilder() {
            PriceReportablePeriodBuilder builder = PriceReportablePeriod.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceReportablePeriodBuilder builder) {
            Optional.ofNullable(this.getPeriodValue()).ifPresent(builder::setPeriodValue);
            Optional.ofNullable(this.getPeriodEffectiveDate()).ifPresent(builder::setPeriodEffectiveDate);
            Optional.ofNullable(this.getPeriodEndDate()).ifPresent(builder::setPeriodEndDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PriceReportablePeriod _that = this.getType().cast(o);
            if (!Objects.equals(this.periodValue, _that.getPeriodValue())) {
                return false;
            }
            if (!Objects.equals(this.periodEffectiveDate, _that.getPeriodEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.periodEndDate, _that.getPeriodEndDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periodValue != null ? this.periodValue.hashCode() : 0);
            _result = 31 * _result + (this.periodEffectiveDate != null ? this.periodEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.periodEndDate != null ? this.periodEndDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PriceReportablePeriod {periodValue=" + String.valueOf(this.periodValue) + ", periodEffectiveDate=" + String.valueOf(this.periodEffectiveDate) + ", periodEndDate=" + String.valueOf(this.periodEndDate) + "}";
        }
    }
}

