/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.CalculationPeriodToDaysCommodities;
import drr.regulation.common.functions.GetCommodityKey;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityCommodityLeg1Default.class)
public abstract class CommodityCommodityLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculationPeriodToDaysCommodities calculationPeriodToDaysCommodities;
    @Inject
    protected GetCommodityKey getCommodityKey;

    public CommodityPayout evaluate(List<? extends CommodityPayout> commodityPayouts) {
        CommodityPayout commodityLeg1;
        CommodityPayout.CommodityPayoutBuilder commodityLeg1Builder = this.doEvaluate(commodityPayouts);
        if (commodityLeg1Builder == null) {
            commodityLeg1 = null;
        } else {
            commodityLeg1 = commodityLeg1Builder.build();
            this.objectValidator.validate(CommodityPayout.class, (RosettaModelObject)commodityLeg1);
        }
        return commodityLeg1;
    }

    protected abstract CommodityPayout.CommodityPayoutBuilder doEvaluate(List<? extends CommodityPayout> var1);

    public static class CommodityCommodityLeg1Default
    extends CommodityCommodityLeg1 {
        @Override
        protected CommodityPayout.CommodityPayoutBuilder doEvaluate(List<? extends CommodityPayout> commodityPayouts) {
            if (commodityPayouts == null) {
                commodityPayouts = Collections.emptyList();
            }
            CommodityPayout.CommodityPayoutBuilder commodityLeg1 = CommodityPayout.builder();
            return this.assignOutput(commodityLeg1, commodityPayouts);
        }

        protected CommodityPayout.CommodityPayoutBuilder assignOutput(CommodityPayout.CommodityPayoutBuilder commodityLeg1, List<? extends CommodityPayout> commodityPayouts) {
            MapperC thenArg = MapperC.of(commodityPayouts).mapItem(item -> MapperS.of((Object)this.getCommodityKey.evaluate((CommodityPayout)item.get())));
            commodityLeg1 = (Boolean)ExpressionOperators.exists((Mapper)thenArg).asMapper().getOrDefault((Object)false) != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)MapperC.of(commodityPayouts).min(item -> MapperS.of((Object)this.getCommodityKey.evaluate((CommodityPayout)item.get()))).get()) : (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)MapperC.of(commodityPayouts).map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).map("getResolvedQuantity", resolvablePriceQuantity -> resolvablePriceQuantity.getResolvedQuantity()).map("getValue", quantity -> quantity.getValue())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)MapperC.of(commodityPayouts).min(item -> MapperS.of((Object)this.calculationPeriodToDaysCommodities.evaluate((CommodityPayout)item.get()))).get()) : (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)MapperC.of(commodityPayouts).max(item -> item.map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).get()));
            return Optional.ofNullable(commodityLeg1).map(o -> o.prune()).orElse(null);
        }
    }
}

