/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.rosetta.model.lib.records.Date;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.functions.Create_ContinuousQuantitySchedule;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Create_ContinuousQuantityScheduleImpl
extends Create_ContinuousQuantitySchedule {
    @Override
    protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(List<? extends QuantityReportablePeriod> reportablePeriods, Date endDate) {
        if (reportablePeriods == null || endDate == null) {
            return null;
        }
        LocalDate localEndDate = endDate.toLocalDate();
        List sortedPeriods = reportablePeriods.stream().sorted(Comparator.comparing(QuantityReportablePeriod::getPeriodEffectiveDate)).collect(Collectors.toList());
        return IntStream.range(0, sortedPeriods.size()).mapToObj(i -> {
            QuantityReportablePeriod QuantityReportablePeriod2 = (QuantityReportablePeriod)sortedPeriods.get(i);
            QuantityReportablePeriod.QuantityReportablePeriodBuilder reportablePeriodBuilder = (QuantityReportablePeriod.QuantityReportablePeriodBuilder)this.toBuilder(QuantityReportablePeriod2);
            LocalDate computedEndDate = i == sortedPeriods.size() - 1 ? localEndDate : ((QuantityReportablePeriod)sortedPeriods.get(i + 1)).getPeriodEffectiveDate().toLocalDate().minusDays(1L);
            if (QuantityReportablePeriod2.getPeriodEndDate() == null || QuantityReportablePeriod2.getPeriodEndDate().toLocalDate().isBefore(localEndDate)) {
                reportablePeriodBuilder.setPeriodEndDate(Date.of((LocalDate)computedEndDate));
            }
            return reportablePeriodBuilder;
        }).collect(Collectors.toList());
    }
}

