/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.DayOfWeekEnum;
import cdm.base.math.Quantity;
import cdm.product.asset.BankHolidayTreatmentEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.CommodityTimeUnitEnum;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.functions.GetDaysOfTheWeek;
import drr.regulation.common.functions.GetDeliveryCapacityAmount;
import drr.regulation.common.functions.GetDeliveryCapacityUnit;
import drr.regulation.common.functions.GetDurationCodeFromCommodityTimeUnit;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_DeliveryBlockDefault.class)
public abstract class Create_DeliveryBlock
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetDaysOfTheWeek getDaysOfTheWeek;
    @Inject
    protected GetDeliveryCapacityAmount getDeliveryCapacityAmount;
    @Inject
    protected GetDeliveryCapacityUnit getDeliveryCapacityUnit;
    @Inject
    protected GetDurationCodeFromCommodityTimeUnit getDurationCodeFromCommodityTimeUnit;

    public ReportableDelivery evaluate(LocalTime deliveryStartTime, LocalTime deliveryEndTime, Date deliveryStartDate, Date deliveryEndDate, BankHolidayTreatmentEnum bankHolidaysTreatment, CommodityTimeUnitEnum duration, List<DayOfWeekEnum> daysOfTheWeek, Quantity deliveryCapacity, BigDecimal priceTimeIntervalQuantity, String currencyOfThePriceTimeIntervalQuantity) {
        ReportableDelivery deliveryBlock;
        ReportableDelivery.ReportableDeliveryBuilder deliveryBlockBuilder = this.doEvaluate(deliveryStartTime, deliveryEndTime, deliveryStartDate, deliveryEndDate, bankHolidaysTreatment, duration, daysOfTheWeek, deliveryCapacity, priceTimeIntervalQuantity, currencyOfThePriceTimeIntervalQuantity);
        if (deliveryBlockBuilder == null) {
            deliveryBlock = null;
        } else {
            deliveryBlock = deliveryBlockBuilder.build();
            this.objectValidator.validate(ReportableDelivery.class, (RosettaModelObject)deliveryBlock);
        }
        return deliveryBlock;
    }

    protected abstract ReportableDelivery.ReportableDeliveryBuilder doEvaluate(LocalTime var1, LocalTime var2, Date var3, Date var4, BankHolidayTreatmentEnum var5, CommodityTimeUnitEnum var6, List<DayOfWeekEnum> var7, Quantity var8, BigDecimal var9, String var10);

    public static class Create_DeliveryBlockDefault
    extends Create_DeliveryBlock {
        @Override
        protected ReportableDelivery.ReportableDeliveryBuilder doEvaluate(LocalTime deliveryStartTime, LocalTime deliveryEndTime, Date deliveryStartDate, Date deliveryEndDate, BankHolidayTreatmentEnum bankHolidaysTreatment, CommodityTimeUnitEnum duration, List<DayOfWeekEnum> daysOfTheWeek, Quantity deliveryCapacity, BigDecimal priceTimeIntervalQuantity, String currencyOfThePriceTimeIntervalQuantity) {
            if (daysOfTheWeek == null) {
                daysOfTheWeek = Collections.emptyList();
            }
            ReportableDelivery.ReportableDeliveryBuilder deliveryBlock = ReportableDelivery.builder();
            return this.assignOutput(deliveryBlock, deliveryStartTime, deliveryEndTime, deliveryStartDate, deliveryEndDate, bankHolidaysTreatment, duration, daysOfTheWeek, deliveryCapacity, priceTimeIntervalQuantity, currencyOfThePriceTimeIntervalQuantity);
        }

        protected ReportableDelivery.ReportableDeliveryBuilder assignOutput(ReportableDelivery.ReportableDeliveryBuilder deliveryBlock, LocalTime deliveryStartTime, LocalTime deliveryEndTime, Date deliveryStartDate, Date deliveryEndDate, BankHolidayTreatmentEnum bankHolidaysTreatment, CommodityTimeUnitEnum duration, List<DayOfWeekEnum> daysOfTheWeek, Quantity deliveryCapacity, BigDecimal priceTimeIntervalQuantity, String currencyOfThePriceTimeIntervalQuantity) {
            deliveryBlock = (ReportableDelivery.ReportableDeliveryBuilder)this.toBuilder(ReportableDelivery.builder().setDeliveryStartTime(deliveryStartTime).setDeliveryEndTime(deliveryEndTime).setDeliveryStartDate(deliveryStartDate).setDeliveryEndDate(deliveryEndDate).setDuration(this.getDurationCodeFromCommodityTimeUnit.evaluate(duration)).setDaysOfTheWeek(this.getDaysOfTheWeek.evaluate(daysOfTheWeek, bankHolidaysTreatment)).setDeliveryCapacity(this.getDeliveryCapacityAmount.evaluate(deliveryCapacity)).setQuantityUnit(this.getDeliveryCapacityUnit.evaluate(deliveryCapacity)).setPriceTimeIntervalQuantity(priceTimeIntervalQuantity).setCurrencyOfThePriceTimeIntervalQuantity(currencyOfThePriceTimeIntervalQuantity).build());
            return Optional.ofNullable(deliveryBlock).map(o -> o.prune()).orElse(null);
        }
    }
}

