/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_PriceReportablePeriodDefault.class)
public abstract class Create_PriceReportablePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public PriceReportablePeriod evaluate(BigDecimal priceValue, Date periodEffectiveDate, Date periodEndDate, PriceNotationEnum priceNotation) {
        PriceReportablePeriod reportablePeriod;
        PriceReportablePeriod.PriceReportablePeriodBuilder reportablePeriodBuilder = this.doEvaluate(priceValue, periodEffectiveDate, periodEndDate, priceNotation);
        if (reportablePeriodBuilder == null) {
            reportablePeriod = null;
        } else {
            reportablePeriod = reportablePeriodBuilder.build();
            this.objectValidator.validate(PriceReportablePeriod.class, (RosettaModelObject)reportablePeriod);
        }
        return reportablePeriod;
    }

    protected abstract PriceReportablePeriod.PriceReportablePeriodBuilder doEvaluate(BigDecimal var1, Date var2, Date var3, PriceNotationEnum var4);

    public static class Create_PriceReportablePeriodDefault
    extends Create_PriceReportablePeriod {
        @Override
        protected PriceReportablePeriod.PriceReportablePeriodBuilder doEvaluate(BigDecimal priceValue, Date periodEffectiveDate, Date periodEndDate, PriceNotationEnum priceNotation) {
            PriceReportablePeriod.PriceReportablePeriodBuilder reportablePeriod = PriceReportablePeriod.builder();
            return this.assignOutput(reportablePeriod, priceValue, periodEffectiveDate, periodEndDate, priceNotation);
        }

        protected PriceReportablePeriod.PriceReportablePeriodBuilder assignOutput(PriceReportablePeriod.PriceReportablePeriodBuilder reportablePeriod, BigDecimal priceValue, Date periodEffectiveDate, Date periodEndDate, PriceNotationEnum priceNotation) {
            BigDecimal ifThenElseResult0 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)priceNotation)), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = priceValue;
            }
            reportablePeriod.getOrCreatePeriodValue().setPriceMonetary(ifThenElseResult0);
            BigDecimal ifThenElseResult1 = null;
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)priceNotation)), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.PERCENTAGE)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)priceNotation)), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = priceValue;
            }
            reportablePeriod.getOrCreatePeriodValue().setPricePercentage(ifThenElseResult1);
            reportablePeriod.getOrCreatePeriodValue().setPriceNotation(priceNotation);
            reportablePeriod.setPeriodEffectiveDate(periodEffectiveDate);
            reportablePeriod.setPeriodEndDate(periodEndDate);
            return Optional.ofNullable(reportablePeriod).map(o -> o.prune()).orElse(null);
        }
    }
}

