/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.math.Quantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.QuantityToDeliveryCapacity;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=GetDeliveryCapacityAmountDefault.class)
public abstract class GetDeliveryCapacityAmount
implements RosettaFunction {
    @Inject
    protected QuantityToDeliveryCapacity quantityToDeliveryCapacity;

    public BigDecimal evaluate(Quantity deliveryCapacity) {
        BigDecimal amount = this.doEvaluate(deliveryCapacity);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(Quantity var1);

    public static class GetDeliveryCapacityAmountDefault
    extends GetDeliveryCapacityAmount {
        @Override
        protected BigDecimal doEvaluate(Quantity deliveryCapacity) {
            BigDecimal amount = null;
            return this.assignOutput(amount, deliveryCapacity);
        }

        protected BigDecimal assignOutput(BigDecimal amount, Quantity deliveryCapacity) {
            amount = (BigDecimal)MapperS.of((Object)this.quantityToDeliveryCapacity.evaluate(deliveryCapacity)).map("getAmount", _deliveryCapacity -> _deliveryCapacity.getAmount()).get();
            return amount;
        }
    }
}

