/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.event.position.CounterpartyPosition;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ProductForPositionDefault.class)
public abstract class ProductForPosition
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Product evaluate(CounterpartyPosition position) {
        Product product;
        Product.ProductBuilder productBuilder = this.doEvaluate(position);
        if (productBuilder == null) {
            product = null;
        } else {
            product = productBuilder.build();
            this.objectValidator.validate(Product.class, (RosettaModelObject)product);
        }
        return product;
    }

    protected abstract Product.ProductBuilder doEvaluate(CounterpartyPosition var1);

    public static class ProductForPositionDefault
    extends ProductForPosition {
        @Override
        protected Product.ProductBuilder doEvaluate(CounterpartyPosition position) {
            Product.ProductBuilder product = Product.builder();
            return this.assignOutput(product, position);
        }

        protected Product.ProductBuilder assignOutput(Product.ProductBuilder product, CounterpartyPosition position) {
            product = (Product.ProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)position).map("getPositionBase", counterpartyPosition -> counterpartyPosition.getPositionBase()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            return Optional.ofNullable(product).map(o -> o.prune()).orElse(null);
        }
    }
}

