/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.event.common.Trade;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ProductForTradeDefault.class)
public abstract class ProductForTrade
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Product evaluate(Trade trade) {
        Product product;
        Product.ProductBuilder productBuilder = this.doEvaluate(trade);
        if (productBuilder == null) {
            product = null;
        } else {
            product = productBuilder.build();
            this.objectValidator.validate(Product.class, (RosettaModelObject)product);
        }
        return product;
    }

    protected abstract Product.ProductBuilder doEvaluate(Trade var1);

    public static class ProductForTradeDefault
    extends ProductForTrade {
        @Override
        protected Product.ProductBuilder doEvaluate(Trade trade) {
            Product.ProductBuilder product = Product.builder();
            return this.assignOutput(product, trade);
        }

        protected Product.ProductBuilder assignOutput(Product.ProductBuilder product, Trade trade) {
            product = (Product.ProductBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get());
            return Optional.ofNullable(product).map(o -> o.prune()).orElse(null);
        }
    }
}

