/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.functions.FormatToLongFraction20DecimalNumber;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=DeliveryCapacityRuleDefault.class)
public abstract class DeliveryCapacityRule
implements ReportFunction<ReportableDelivery, BigDecimal> {
    @Inject
    protected FormatToLongFraction20DecimalNumber formatToLongFraction20DecimalNumber;

    public BigDecimal evaluate(ReportableDelivery input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(ReportableDelivery var1);

    public static class DeliveryCapacityRuleDefault
    extends DeliveryCapacityRule {
        @Override
        protected BigDecimal doEvaluate(ReportableDelivery input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, ReportableDelivery input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> item.map("getDeliveryCapacity", reportableDelivery -> reportableDelivery.getDeliveryCapacity()));
            output = (BigDecimal)MapperS.of((Object)this.formatToLongFraction20DecimalNumber.evaluate((BigDecimal)thenArg.get())).get();
            return output;
        }
    }
}

