/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.jfsa.rewrite.margin.meta.CollateralReportMeta;
import iso20022.auth108.esma.CollateralisationType3Code__1;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CollateralReport", builder=CollateralReportBuilderImpl.class, version="5.53.0")
@RuneDataType(value="CollateralReport", model="drr", builder=CollateralReportBuilderImpl.class, version="5.53.0")
public interface CollateralReport
extends RosettaModelObject {
    public static final CollateralReportMeta metaData = new CollateralReportMeta();

    public Boolean getCollateralPortfolioIndicator();

    public String getUti();

    public CollateralisationType3Code__1 getCollateralisationCategory();

    public String getInitialMarginCollateralPortfolioCode();

    public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut();

    public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut();

    public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted();

    public BigDecimal getInitialMarginCollectedByReportingCounterpartyPreHaircut();

    public BigDecimal getInitialMarginCollectedByReportingCounterpartyPostHaircut();

    public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected();

    public String getVariationMarginCollateralPortfolioCode();

    public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut();

    public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPostHaircut();

    public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted();

    public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut();

    public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPostHaircut();

    public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected();

    public BigDecimal getExcessCollateralPostedByTheReportingCounterparty();

    public String getCurrencyOfTheExcessCollateralPosted();

    public BigDecimal getExcessCollateralCollectedByTheReportingCounterparty();

    public String getCurrencyOfTheExcessCollateralCollected();

    public ZonedDateTime getEventTimestamp();

    public MarginActionEnum getActionType();

    public String getTechnicalRecordId();

    public CollateralReport build();

    public CollateralReportBuilder toBuilder();

    public static CollateralReportBuilder builder() {
        return new CollateralReportBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralReport> getType() {
        return CollateralReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyofInitialMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyofInitialMarginPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByReportingCounterpartyPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByReportingCounterpartyPostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyofInitialMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyofInitialMarginCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralPostedByTheReportingCounterparty"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheReportingCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralCollectedByTheReportingCounterparty"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheReportingCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CollateralReportBuilderImpl
    implements CollateralReportBuilder {
        protected Boolean collateralPortfolioIndicator;
        protected String uti;
        protected CollateralisationType3Code__1 collateralisationCategory;
        protected String initialMarginCollateralPortfolioCode;
        protected BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut;
        protected BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut;
        protected ISOCurrencyCodeEnum currencyofInitialMarginPosted;
        protected BigDecimal initialMarginCollectedByReportingCounterpartyPreHaircut;
        protected BigDecimal initialMarginCollectedByReportingCounterpartyPostHaircut;
        protected ISOCurrencyCodeEnum currencyofInitialMarginCollected;
        protected String variationMarginCollateralPortfolioCode;
        protected BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut;
        protected BigDecimal variationMarginPostedByTheReportingCounterpartyPostHaircut;
        protected ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
        protected BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut;
        protected BigDecimal variationMarginCollectedByTheReportingCounterpartyPostHaircut;
        protected ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
        protected BigDecimal excessCollateralPostedByTheReportingCounterparty;
        protected String currencyOfTheExcessCollateralPosted;
        protected BigDecimal excessCollateralCollectedByTheReportingCounterparty;
        protected String currencyOfTheExcessCollateralCollected;
        protected ZonedDateTime eventTimestamp;
        protected MarginActionEnum actionType;
        protected String technicalRecordId;

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public String getUti() {
            return this.uti;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CollateralisationType3Code__1 getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut() {
            return this.initialMarginPostedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut() {
            return this.initialMarginPostedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginPosted")
        @RuneAttribute(value="currencyofInitialMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted() {
            return this.currencyofInitialMarginPosted;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginCollectedByReportingCounterpartyPreHaircut")
        public BigDecimal getInitialMarginCollectedByReportingCounterpartyPreHaircut() {
            return this.initialMarginCollectedByReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginCollectedByReportingCounterpartyPostHaircut")
        public BigDecimal getInitialMarginCollectedByReportingCounterpartyPostHaircut() {
            return this.initialMarginCollectedByReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginCollected")
        @RuneAttribute(value="currencyofInitialMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected() {
            return this.currencyofInitialMarginCollected;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut() {
            return this.variationMarginPostedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPostHaircut() {
            return this.variationMarginPostedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginPosted")
        @RuneAttribute(value="currencyOfVariationMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
            return this.currencyOfVariationMarginPosted;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() {
            return this.variationMarginCollectedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPostHaircut() {
            return this.variationMarginCollectedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginCollected")
        @RuneAttribute(value="currencyOfVariationMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
            return this.currencyOfVariationMarginCollected;
        }

        @Override
        @RosettaAttribute(value="excessCollateralPostedByTheReportingCounterparty")
        @RuneAttribute(value="excessCollateralPostedByTheReportingCounterparty")
        public BigDecimal getExcessCollateralPostedByTheReportingCounterparty() {
            return this.excessCollateralPostedByTheReportingCounterparty;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralPosted")
        @RuneAttribute(value="currencyOfTheExcessCollateralPosted")
        public String getCurrencyOfTheExcessCollateralPosted() {
            return this.currencyOfTheExcessCollateralPosted;
        }

        @Override
        @RosettaAttribute(value="excessCollateralCollectedByTheReportingCounterparty")
        @RuneAttribute(value="excessCollateralCollectedByTheReportingCounterparty")
        public BigDecimal getExcessCollateralCollectedByTheReportingCounterparty() {
            return this.excessCollateralCollectedByTheReportingCounterparty;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralCollected")
        @RuneAttribute(value="currencyOfTheExcessCollateralCollected")
        public String getCurrencyOfTheExcessCollateralCollected() {
            return this.currencyOfTheExcessCollateralCollected;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public CollateralReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public CollateralReportBuilder setUti(String _uti) {
            this.uti = _uti == null ? null : _uti;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CollateralReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public CollateralReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        public CollateralReportBuilder setInitialMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal _initialMarginPostedByTheReportingCounterpartyPreHaircut) {
            this.initialMarginPostedByTheReportingCounterpartyPreHaircut = _initialMarginPostedByTheReportingCounterpartyPreHaircut == null ? null : _initialMarginPostedByTheReportingCounterpartyPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        public CollateralReportBuilder setInitialMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal _initialMarginPostedByTheReportingCounterpartyPostHaircut) {
            this.initialMarginPostedByTheReportingCounterpartyPostHaircut = _initialMarginPostedByTheReportingCounterpartyPostHaircut == null ? null : _initialMarginPostedByTheReportingCounterpartyPostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginPosted")
        @RuneAttribute(value="currencyofInitialMarginPosted")
        public CollateralReportBuilder setCurrencyofInitialMarginPosted(ISOCurrencyCodeEnum _currencyofInitialMarginPosted) {
            this.currencyofInitialMarginPosted = _currencyofInitialMarginPosted == null ? null : _currencyofInitialMarginPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginCollectedByReportingCounterpartyPreHaircut")
        public CollateralReportBuilder setInitialMarginCollectedByReportingCounterpartyPreHaircut(BigDecimal _initialMarginCollectedByReportingCounterpartyPreHaircut) {
            this.initialMarginCollectedByReportingCounterpartyPreHaircut = _initialMarginCollectedByReportingCounterpartyPreHaircut == null ? null : _initialMarginCollectedByReportingCounterpartyPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginCollectedByReportingCounterpartyPostHaircut")
        public CollateralReportBuilder setInitialMarginCollectedByReportingCounterpartyPostHaircut(BigDecimal _initialMarginCollectedByReportingCounterpartyPostHaircut) {
            this.initialMarginCollectedByReportingCounterpartyPostHaircut = _initialMarginCollectedByReportingCounterpartyPostHaircut == null ? null : _initialMarginCollectedByReportingCounterpartyPostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginCollected")
        @RuneAttribute(value="currencyofInitialMarginCollected")
        public CollateralReportBuilder setCurrencyofInitialMarginCollected(ISOCurrencyCodeEnum _currencyofInitialMarginCollected) {
            this.currencyofInitialMarginCollected = _currencyofInitialMarginCollected == null ? null : _currencyofInitialMarginCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public CollateralReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        public CollateralReportBuilder setVariationMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal _variationMarginPostedByTheReportingCounterpartyPreHaircut) {
            this.variationMarginPostedByTheReportingCounterpartyPreHaircut = _variationMarginPostedByTheReportingCounterpartyPreHaircut == null ? null : _variationMarginPostedByTheReportingCounterpartyPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingCounterpartyPostHaircut")
        public CollateralReportBuilder setVariationMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal _variationMarginPostedByTheReportingCounterpartyPostHaircut) {
            this.variationMarginPostedByTheReportingCounterpartyPostHaircut = _variationMarginPostedByTheReportingCounterpartyPostHaircut == null ? null : _variationMarginPostedByTheReportingCounterpartyPostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginPosted")
        @RuneAttribute(value="currencyOfVariationMarginPosted")
        public CollateralReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum _currencyOfVariationMarginPosted) {
            this.currencyOfVariationMarginPosted = _currencyOfVariationMarginPosted == null ? null : _currencyOfVariationMarginPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        public CollateralReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal _variationMarginCollectedByTheReportingCounterpartyPreHaircut) {
            this.variationMarginCollectedByTheReportingCounterpartyPreHaircut = _variationMarginCollectedByTheReportingCounterpartyPreHaircut == null ? null : _variationMarginCollectedByTheReportingCounterpartyPreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingCounterpartyPostHaircut")
        public CollateralReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal _variationMarginCollectedByTheReportingCounterpartyPostHaircut) {
            this.variationMarginCollectedByTheReportingCounterpartyPostHaircut = _variationMarginCollectedByTheReportingCounterpartyPostHaircut == null ? null : _variationMarginCollectedByTheReportingCounterpartyPostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginCollected")
        @RuneAttribute(value="currencyOfVariationMarginCollected")
        public CollateralReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum _currencyOfVariationMarginCollected) {
            this.currencyOfVariationMarginCollected = _currencyOfVariationMarginCollected == null ? null : _currencyOfVariationMarginCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralPostedByTheReportingCounterparty")
        @RuneAttribute(value="excessCollateralPostedByTheReportingCounterparty")
        public CollateralReportBuilder setExcessCollateralPostedByTheReportingCounterparty(BigDecimal _excessCollateralPostedByTheReportingCounterparty) {
            this.excessCollateralPostedByTheReportingCounterparty = _excessCollateralPostedByTheReportingCounterparty == null ? null : _excessCollateralPostedByTheReportingCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralPosted")
        @RuneAttribute(value="currencyOfTheExcessCollateralPosted")
        public CollateralReportBuilder setCurrencyOfTheExcessCollateralPosted(String _currencyOfTheExcessCollateralPosted) {
            this.currencyOfTheExcessCollateralPosted = _currencyOfTheExcessCollateralPosted == null ? null : _currencyOfTheExcessCollateralPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralCollectedByTheReportingCounterparty")
        @RuneAttribute(value="excessCollateralCollectedByTheReportingCounterparty")
        public CollateralReportBuilder setExcessCollateralCollectedByTheReportingCounterparty(BigDecimal _excessCollateralCollectedByTheReportingCounterparty) {
            this.excessCollateralCollectedByTheReportingCounterparty = _excessCollateralCollectedByTheReportingCounterparty == null ? null : _excessCollateralCollectedByTheReportingCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralCollected")
        @RuneAttribute(value="currencyOfTheExcessCollateralCollected")
        public CollateralReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
            this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public CollateralReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public CollateralReportBuilder setActionType(MarginActionEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public CollateralReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        public CollateralReport build() {
            return new CollateralReportImpl(this);
        }

        @Override
        public CollateralReportBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralReportBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getCollateralPortfolioIndicator() != null) {
                return true;
            }
            if (this.getUti() != null) {
                return true;
            }
            if (this.getCollateralisationCategory() != null) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut() != null) {
                return true;
            }
            if (this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut() != null) {
                return true;
            }
            if (this.getCurrencyofInitialMarginPosted() != null) {
                return true;
            }
            if (this.getInitialMarginCollectedByReportingCounterpartyPreHaircut() != null) {
                return true;
            }
            if (this.getInitialMarginCollectedByReportingCounterpartyPostHaircut() != null) {
                return true;
            }
            if (this.getCurrencyofInitialMarginCollected() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut() != null) {
                return true;
            }
            if (this.getVariationMarginPostedByTheReportingCounterpartyPostHaircut() != null) {
                return true;
            }
            if (this.getCurrencyOfVariationMarginPosted() != null) {
                return true;
            }
            if (this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() != null) {
                return true;
            }
            if (this.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut() != null) {
                return true;
            }
            if (this.getCurrencyOfVariationMarginCollected() != null) {
                return true;
            }
            if (this.getExcessCollateralPostedByTheReportingCounterparty() != null) {
                return true;
            }
            if (this.getCurrencyOfTheExcessCollateralPosted() != null) {
                return true;
            }
            if (this.getExcessCollateralCollectedByTheReportingCounterparty() != null) {
                return true;
            }
            if (this.getCurrencyOfTheExcessCollateralCollected() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            return this.getTechnicalRecordId() != null;
        }

        public CollateralReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralReportBuilder o = (CollateralReportBuilder)other;
            merger.mergeBasic((Object)this.getCollateralPortfolioIndicator(), (Object)o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUti(), (Object)o.getUti(), this::setUti, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralisationCategory(), (Object)o.getCollateralisationCategory(), this::setCollateralisationCategory, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), (Object)o.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), this::setInitialMarginPostedByTheReportingCounterpartyPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), (Object)o.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), this::setInitialMarginPostedByTheReportingCounterpartyPostHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyofInitialMarginPosted(), (Object)o.getCurrencyofInitialMarginPosted(), this::setCurrencyofInitialMarginPosted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollectedByReportingCounterpartyPreHaircut(), (Object)o.getInitialMarginCollectedByReportingCounterpartyPreHaircut(), this::setInitialMarginCollectedByReportingCounterpartyPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollectedByReportingCounterpartyPostHaircut(), (Object)o.getInitialMarginCollectedByReportingCounterpartyPostHaircut(), this::setInitialMarginCollectedByReportingCounterpartyPostHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyofInitialMarginCollected(), (Object)o.getCurrencyofInitialMarginCollected(), this::setCurrencyofInitialMarginCollected, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), (Object)o.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), this::setVariationMarginPostedByTheReportingCounterpartyPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), (Object)o.getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), this::setVariationMarginPostedByTheReportingCounterpartyPostHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfVariationMarginPosted(), (Object)o.getCurrencyOfVariationMarginPosted(), this::setCurrencyOfVariationMarginPosted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), (Object)o.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), this::setVariationMarginCollectedByTheReportingCounterpartyPreHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), (Object)o.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), this::setVariationMarginCollectedByTheReportingCounterpartyPostHaircut, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfVariationMarginCollected(), (Object)o.getCurrencyOfVariationMarginCollected(), this::setCurrencyOfVariationMarginCollected, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExcessCollateralPostedByTheReportingCounterparty(), (Object)o.getExcessCollateralPostedByTheReportingCounterparty(), this::setExcessCollateralPostedByTheReportingCounterparty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfTheExcessCollateralPosted(), (Object)o.getCurrencyOfTheExcessCollateralPosted(), this::setCurrencyOfTheExcessCollateralPosted, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExcessCollateralCollectedByTheReportingCounterparty(), (Object)o.getExcessCollateralCollectedByTheReportingCounterparty(), this::setExcessCollateralCollectedByTheReportingCounterparty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrencyOfTheExcessCollateralCollected(), (Object)o.getCurrencyOfTheExcessCollateralCollected(), this::setCurrencyOfTheExcessCollateralCollected, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralReport _that = this.getType().cast(o);
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.uti, _that.getUti())) {
                return false;
            }
            if (!Objects.equals(this.collateralisationCategory, _that.getCollateralisationCategory())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyofInitialMarginPosted, _that.getCurrencyofInitialMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByReportingCounterpartyPreHaircut, _that.getInitialMarginCollectedByReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByReportingCounterpartyPostHaircut, _that.getInitialMarginCollectedByReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyofInitialMarginCollected, _that.getCurrencyofInitialMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginPostedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginPostedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.excessCollateralPostedByTheReportingCounterparty, _that.getExcessCollateralPostedByTheReportingCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfTheExcessCollateralPosted, _that.getCurrencyOfTheExcessCollateralPosted())) {
                return false;
            }
            if (!Objects.equals(this.excessCollateralCollectedByTheReportingCounterparty, _that.getExcessCollateralCollectedByTheReportingCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfTheExcessCollateralCollected, _that.getCurrencyOfTheExcessCollateralCollected())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            return Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.uti != null ? this.uti.hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? this.collateralisationCategory.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingCounterpartyPreHaircut != null ? this.initialMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingCounterpartyPostHaircut != null ? this.initialMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyofInitialMarginPosted != null ? this.currencyofInitialMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByReportingCounterpartyPreHaircut != null ? this.initialMarginCollectedByReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByReportingCounterpartyPostHaircut != null ? this.initialMarginCollectedByReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyofInitialMarginCollected != null ? this.currencyofInitialMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginPostedByTheReportingCounterpartyPreHaircut != null ? this.variationMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginPostedByTheReportingCounterpartyPostHaircut != null ? this.variationMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginPosted != null ? this.currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollectedByTheReportingCounterpartyPreHaircut != null ? this.variationMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollectedByTheReportingCounterpartyPostHaircut != null ? this.variationMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginCollected != null ? this.currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.excessCollateralPostedByTheReportingCounterparty != null ? this.excessCollateralPostedByTheReportingCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfTheExcessCollateralPosted != null ? this.currencyOfTheExcessCollateralPosted.hashCode() : 0);
            _result = 31 * _result + (this.excessCollateralCollectedByTheReportingCounterparty != null ? this.excessCollateralCollectedByTheReportingCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfTheExcessCollateralCollected != null ? this.currencyOfTheExcessCollateralCollected.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralReportBuilder {collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", uti=" + this.uti + ", collateralisationCategory=" + String.valueOf(this.collateralisationCategory) + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", initialMarginPostedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingCounterpartyPreHaircut) + ", initialMarginPostedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingCounterpartyPostHaircut) + ", currencyofInitialMarginPosted=" + String.valueOf(this.currencyofInitialMarginPosted) + ", initialMarginCollectedByReportingCounterpartyPreHaircut=" + String.valueOf(this.initialMarginCollectedByReportingCounterpartyPreHaircut) + ", initialMarginCollectedByReportingCounterpartyPostHaircut=" + String.valueOf(this.initialMarginCollectedByReportingCounterpartyPostHaircut) + ", currencyofInitialMarginCollected=" + String.valueOf(this.currencyofInitialMarginCollected) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", variationMarginPostedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.variationMarginPostedByTheReportingCounterpartyPreHaircut) + ", variationMarginPostedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.variationMarginPostedByTheReportingCounterpartyPostHaircut) + ", currencyOfVariationMarginPosted=" + String.valueOf(this.currencyOfVariationMarginPosted) + ", variationMarginCollectedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.variationMarginCollectedByTheReportingCounterpartyPreHaircut) + ", variationMarginCollectedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.variationMarginCollectedByTheReportingCounterpartyPostHaircut) + ", currencyOfVariationMarginCollected=" + String.valueOf(this.currencyOfVariationMarginCollected) + ", excessCollateralPostedByTheReportingCounterparty=" + String.valueOf(this.excessCollateralPostedByTheReportingCounterparty) + ", currencyOfTheExcessCollateralPosted=" + this.currencyOfTheExcessCollateralPosted + ", excessCollateralCollectedByTheReportingCounterparty=" + String.valueOf(this.excessCollateralCollectedByTheReportingCounterparty) + ", currencyOfTheExcessCollateralCollected=" + this.currencyOfTheExcessCollateralCollected + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", actionType=" + String.valueOf((Object)this.actionType) + ", technicalRecordId=" + this.technicalRecordId + "}";
        }
    }

    public static interface CollateralReportBuilder
    extends CollateralReport,
    RosettaModelObjectBuilder {
        public CollateralReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        public CollateralReportBuilder setUti(String var1);

        public CollateralReportBuilder setCollateralisationCategory(CollateralisationType3Code__1 var1);

        public CollateralReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        public CollateralReportBuilder setInitialMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal var1);

        public CollateralReportBuilder setInitialMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal var1);

        public CollateralReportBuilder setCurrencyofInitialMarginPosted(ISOCurrencyCodeEnum var1);

        public CollateralReportBuilder setInitialMarginCollectedByReportingCounterpartyPreHaircut(BigDecimal var1);

        public CollateralReportBuilder setInitialMarginCollectedByReportingCounterpartyPostHaircut(BigDecimal var1);

        public CollateralReportBuilder setCurrencyofInitialMarginCollected(ISOCurrencyCodeEnum var1);

        public CollateralReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        public CollateralReportBuilder setVariationMarginPostedByTheReportingCounterpartyPreHaircut(BigDecimal var1);

        public CollateralReportBuilder setVariationMarginPostedByTheReportingCounterpartyPostHaircut(BigDecimal var1);

        public CollateralReportBuilder setCurrencyOfVariationMarginPosted(ISOCurrencyCodeEnum var1);

        public CollateralReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(BigDecimal var1);

        public CollateralReportBuilder setVariationMarginCollectedByTheReportingCounterpartyPostHaircut(BigDecimal var1);

        public CollateralReportBuilder setCurrencyOfVariationMarginCollected(ISOCurrencyCodeEnum var1);

        public CollateralReportBuilder setExcessCollateralPostedByTheReportingCounterparty(BigDecimal var1);

        public CollateralReportBuilder setCurrencyOfTheExcessCollateralPosted(String var1);

        public CollateralReportBuilder setExcessCollateralCollectedByTheReportingCounterparty(BigDecimal var1);

        public CollateralReportBuilder setCurrencyOfTheExcessCollateralCollected(String var1);

        public CollateralReportBuilder setEventTimestamp(ZonedDateTime var1);

        public CollateralReportBuilder setActionType(MarginActionEnum var1);

        public CollateralReportBuilder setTechnicalRecordId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code__1.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyofInitialMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyofInitialMarginPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByReportingCounterpartyPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByReportingCounterpartyPostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyofInitialMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyofInitialMarginCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheReportingCounterpartyPostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfVariationMarginPosted"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheReportingCounterpartyPostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfVariationMarginCollected"), ISOCurrencyCodeEnum.class, (Object)this.getCurrencyOfVariationMarginCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralPostedByTheReportingCounterparty"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheReportingCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralCollectedByTheReportingCounterparty"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheReportingCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CollateralReportBuilder prune();
    }

    public static class CollateralReportImpl
    implements CollateralReport {
        private final Boolean collateralPortfolioIndicator;
        private final String uti;
        private final CollateralisationType3Code__1 collateralisationCategory;
        private final String initialMarginCollateralPortfolioCode;
        private final BigDecimal initialMarginPostedByTheReportingCounterpartyPreHaircut;
        private final BigDecimal initialMarginPostedByTheReportingCounterpartyPostHaircut;
        private final ISOCurrencyCodeEnum currencyofInitialMarginPosted;
        private final BigDecimal initialMarginCollectedByReportingCounterpartyPreHaircut;
        private final BigDecimal initialMarginCollectedByReportingCounterpartyPostHaircut;
        private final ISOCurrencyCodeEnum currencyofInitialMarginCollected;
        private final String variationMarginCollateralPortfolioCode;
        private final BigDecimal variationMarginPostedByTheReportingCounterpartyPreHaircut;
        private final BigDecimal variationMarginPostedByTheReportingCounterpartyPostHaircut;
        private final ISOCurrencyCodeEnum currencyOfVariationMarginPosted;
        private final BigDecimal variationMarginCollectedByTheReportingCounterpartyPreHaircut;
        private final BigDecimal variationMarginCollectedByTheReportingCounterpartyPostHaircut;
        private final ISOCurrencyCodeEnum currencyOfVariationMarginCollected;
        private final BigDecimal excessCollateralPostedByTheReportingCounterparty;
        private final String currencyOfTheExcessCollateralPosted;
        private final BigDecimal excessCollateralCollectedByTheReportingCounterparty;
        private final String currencyOfTheExcessCollateralCollected;
        private final ZonedDateTime eventTimestamp;
        private final MarginActionEnum actionType;
        private final String technicalRecordId;

        protected CollateralReportImpl(CollateralReportBuilder builder) {
            this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
            this.uti = builder.getUti();
            this.collateralisationCategory = builder.getCollateralisationCategory();
            this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
            this.initialMarginPostedByTheReportingCounterpartyPreHaircut = builder.getInitialMarginPostedByTheReportingCounterpartyPreHaircut();
            this.initialMarginPostedByTheReportingCounterpartyPostHaircut = builder.getInitialMarginPostedByTheReportingCounterpartyPostHaircut();
            this.currencyofInitialMarginPosted = builder.getCurrencyofInitialMarginPosted();
            this.initialMarginCollectedByReportingCounterpartyPreHaircut = builder.getInitialMarginCollectedByReportingCounterpartyPreHaircut();
            this.initialMarginCollectedByReportingCounterpartyPostHaircut = builder.getInitialMarginCollectedByReportingCounterpartyPostHaircut();
            this.currencyofInitialMarginCollected = builder.getCurrencyofInitialMarginCollected();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.variationMarginPostedByTheReportingCounterpartyPreHaircut = builder.getVariationMarginPostedByTheReportingCounterpartyPreHaircut();
            this.variationMarginPostedByTheReportingCounterpartyPostHaircut = builder.getVariationMarginPostedByTheReportingCounterpartyPostHaircut();
            this.currencyOfVariationMarginPosted = builder.getCurrencyOfVariationMarginPosted();
            this.variationMarginCollectedByTheReportingCounterpartyPreHaircut = builder.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut();
            this.variationMarginCollectedByTheReportingCounterpartyPostHaircut = builder.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut();
            this.currencyOfVariationMarginCollected = builder.getCurrencyOfVariationMarginCollected();
            this.excessCollateralPostedByTheReportingCounterparty = builder.getExcessCollateralPostedByTheReportingCounterparty();
            this.currencyOfTheExcessCollateralPosted = builder.getCurrencyOfTheExcessCollateralPosted();
            this.excessCollateralCollectedByTheReportingCounterparty = builder.getExcessCollateralCollectedByTheReportingCounterparty();
            this.currencyOfTheExcessCollateralCollected = builder.getCurrencyOfTheExcessCollateralCollected();
            this.eventTimestamp = builder.getEventTimestamp();
            this.actionType = builder.getActionType();
            this.technicalRecordId = builder.getTechnicalRecordId();
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public String getUti() {
            return this.uti;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CollateralisationType3Code__1 getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPreHaircut() {
            return this.initialMarginPostedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getInitialMarginPostedByTheReportingCounterpartyPostHaircut() {
            return this.initialMarginPostedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginPosted")
        @RuneAttribute(value="currencyofInitialMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyofInitialMarginPosted() {
            return this.currencyofInitialMarginPosted;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByReportingCounterpartyPreHaircut")
        @RuneAttribute(value="initialMarginCollectedByReportingCounterpartyPreHaircut")
        public BigDecimal getInitialMarginCollectedByReportingCounterpartyPreHaircut() {
            return this.initialMarginCollectedByReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByReportingCounterpartyPostHaircut")
        @RuneAttribute(value="initialMarginCollectedByReportingCounterpartyPostHaircut")
        public BigDecimal getInitialMarginCollectedByReportingCounterpartyPostHaircut() {
            return this.initialMarginCollectedByReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyofInitialMarginCollected")
        @RuneAttribute(value="currencyofInitialMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyofInitialMarginCollected() {
            return this.currencyofInitialMarginCollected;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPreHaircut() {
            return this.variationMarginPostedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="variationMarginPostedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getVariationMarginPostedByTheReportingCounterpartyPostHaircut() {
            return this.variationMarginPostedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginPosted")
        @RuneAttribute(value="currencyOfVariationMarginPosted")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginPosted() {
            return this.currencyOfVariationMarginPosted;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingCounterpartyPreHaircut")
        public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPreHaircut() {
            return this.variationMarginCollectedByTheReportingCounterpartyPreHaircut;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheReportingCounterpartyPostHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheReportingCounterpartyPostHaircut")
        public BigDecimal getVariationMarginCollectedByTheReportingCounterpartyPostHaircut() {
            return this.variationMarginCollectedByTheReportingCounterpartyPostHaircut;
        }

        @Override
        @RosettaAttribute(value="currencyOfVariationMarginCollected")
        @RuneAttribute(value="currencyOfVariationMarginCollected")
        public ISOCurrencyCodeEnum getCurrencyOfVariationMarginCollected() {
            return this.currencyOfVariationMarginCollected;
        }

        @Override
        @RosettaAttribute(value="excessCollateralPostedByTheReportingCounterparty")
        @RuneAttribute(value="excessCollateralPostedByTheReportingCounterparty")
        public BigDecimal getExcessCollateralPostedByTheReportingCounterparty() {
            return this.excessCollateralPostedByTheReportingCounterparty;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralPosted")
        @RuneAttribute(value="currencyOfTheExcessCollateralPosted")
        public String getCurrencyOfTheExcessCollateralPosted() {
            return this.currencyOfTheExcessCollateralPosted;
        }

        @Override
        @RosettaAttribute(value="excessCollateralCollectedByTheReportingCounterparty")
        @RuneAttribute(value="excessCollateralCollectedByTheReportingCounterparty")
        public BigDecimal getExcessCollateralCollectedByTheReportingCounterparty() {
            return this.excessCollateralCollectedByTheReportingCounterparty;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralCollected")
        @RuneAttribute(value="currencyOfTheExcessCollateralCollected")
        public String getCurrencyOfTheExcessCollateralCollected() {
            return this.currencyOfTheExcessCollateralCollected;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        public CollateralReport build() {
            return this;
        }

        @Override
        public CollateralReportBuilder toBuilder() {
            CollateralReportBuilder builder = CollateralReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralReportBuilder builder) {
            Optional.ofNullable(this.getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
            Optional.ofNullable(this.getUti()).ifPresent(builder::setUti);
            Optional.ofNullable(this.getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategory);
            Optional.ofNullable(this.getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getInitialMarginPostedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterpartyPreHaircut);
            Optional.ofNullable(this.getInitialMarginPostedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setInitialMarginPostedByTheReportingCounterpartyPostHaircut);
            Optional.ofNullable(this.getCurrencyofInitialMarginPosted()).ifPresent(builder::setCurrencyofInitialMarginPosted);
            Optional.ofNullable(this.getInitialMarginCollectedByReportingCounterpartyPreHaircut()).ifPresent(builder::setInitialMarginCollectedByReportingCounterpartyPreHaircut);
            Optional.ofNullable(this.getInitialMarginCollectedByReportingCounterpartyPostHaircut()).ifPresent(builder::setInitialMarginCollectedByReportingCounterpartyPostHaircut);
            Optional.ofNullable(this.getCurrencyofInitialMarginCollected()).ifPresent(builder::setCurrencyofInitialMarginCollected);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getVariationMarginPostedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingCounterpartyPreHaircut);
            Optional.ofNullable(this.getVariationMarginPostedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setVariationMarginPostedByTheReportingCounterpartyPostHaircut);
            Optional.ofNullable(this.getCurrencyOfVariationMarginPosted()).ifPresent(builder::setCurrencyOfVariationMarginPosted);
            Optional.ofNullable(this.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingCounterpartyPreHaircut);
            Optional.ofNullable(this.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut()).ifPresent(builder::setVariationMarginCollectedByTheReportingCounterpartyPostHaircut);
            Optional.ofNullable(this.getCurrencyOfVariationMarginCollected()).ifPresent(builder::setCurrencyOfVariationMarginCollected);
            Optional.ofNullable(this.getExcessCollateralPostedByTheReportingCounterparty()).ifPresent(builder::setExcessCollateralPostedByTheReportingCounterparty);
            Optional.ofNullable(this.getCurrencyOfTheExcessCollateralPosted()).ifPresent(builder::setCurrencyOfTheExcessCollateralPosted);
            Optional.ofNullable(this.getExcessCollateralCollectedByTheReportingCounterparty()).ifPresent(builder::setExcessCollateralCollectedByTheReportingCounterparty);
            Optional.ofNullable(this.getCurrencyOfTheExcessCollateralCollected()).ifPresent(builder::setCurrencyOfTheExcessCollateralCollected);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestamp);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralReport _that = this.getType().cast(o);
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.uti, _that.getUti())) {
                return false;
            }
            if (!Objects.equals(this.collateralisationCategory, _that.getCollateralisationCategory())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingCounterpartyPreHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginPostedByTheReportingCounterpartyPostHaircut, _that.getInitialMarginPostedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyofInitialMarginPosted, _that.getCurrencyofInitialMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByReportingCounterpartyPreHaircut, _that.getInitialMarginCollectedByReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollectedByReportingCounterpartyPostHaircut, _that.getInitialMarginCollectedByReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyofInitialMarginCollected, _that.getCurrencyofInitialMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginPostedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginPostedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginPostedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginPosted, _that.getCurrencyOfVariationMarginPosted())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollectedByTheReportingCounterpartyPreHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPreHaircut())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollectedByTheReportingCounterpartyPostHaircut, _that.getVariationMarginCollectedByTheReportingCounterpartyPostHaircut())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfVariationMarginCollected, _that.getCurrencyOfVariationMarginCollected())) {
                return false;
            }
            if (!Objects.equals(this.excessCollateralPostedByTheReportingCounterparty, _that.getExcessCollateralPostedByTheReportingCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfTheExcessCollateralPosted, _that.getCurrencyOfTheExcessCollateralPosted())) {
                return false;
            }
            if (!Objects.equals(this.excessCollateralCollectedByTheReportingCounterparty, _that.getExcessCollateralCollectedByTheReportingCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.currencyOfTheExcessCollateralCollected, _that.getCurrencyOfTheExcessCollateralCollected())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            return Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.uti != null ? this.uti.hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? this.collateralisationCategory.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingCounterpartyPreHaircut != null ? this.initialMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginPostedByTheReportingCounterpartyPostHaircut != null ? this.initialMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyofInitialMarginPosted != null ? this.currencyofInitialMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByReportingCounterpartyPreHaircut != null ? this.initialMarginCollectedByReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollectedByReportingCounterpartyPostHaircut != null ? this.initialMarginCollectedByReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyofInitialMarginCollected != null ? this.currencyofInitialMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginPostedByTheReportingCounterpartyPreHaircut != null ? this.variationMarginPostedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginPostedByTheReportingCounterpartyPostHaircut != null ? this.variationMarginPostedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginPosted != null ? this.currencyOfVariationMarginPosted.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollectedByTheReportingCounterpartyPreHaircut != null ? this.variationMarginCollectedByTheReportingCounterpartyPreHaircut.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollectedByTheReportingCounterpartyPostHaircut != null ? this.variationMarginCollectedByTheReportingCounterpartyPostHaircut.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfVariationMarginCollected != null ? this.currencyOfVariationMarginCollected.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.excessCollateralPostedByTheReportingCounterparty != null ? this.excessCollateralPostedByTheReportingCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfTheExcessCollateralPosted != null ? this.currencyOfTheExcessCollateralPosted.hashCode() : 0);
            _result = 31 * _result + (this.excessCollateralCollectedByTheReportingCounterparty != null ? this.excessCollateralCollectedByTheReportingCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.currencyOfTheExcessCollateralCollected != null ? this.currencyOfTheExcessCollateralCollected.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralReport {collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", uti=" + this.uti + ", collateralisationCategory=" + String.valueOf(this.collateralisationCategory) + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", initialMarginPostedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingCounterpartyPreHaircut) + ", initialMarginPostedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.initialMarginPostedByTheReportingCounterpartyPostHaircut) + ", currencyofInitialMarginPosted=" + String.valueOf(this.currencyofInitialMarginPosted) + ", initialMarginCollectedByReportingCounterpartyPreHaircut=" + String.valueOf(this.initialMarginCollectedByReportingCounterpartyPreHaircut) + ", initialMarginCollectedByReportingCounterpartyPostHaircut=" + String.valueOf(this.initialMarginCollectedByReportingCounterpartyPostHaircut) + ", currencyofInitialMarginCollected=" + String.valueOf(this.currencyofInitialMarginCollected) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", variationMarginPostedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.variationMarginPostedByTheReportingCounterpartyPreHaircut) + ", variationMarginPostedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.variationMarginPostedByTheReportingCounterpartyPostHaircut) + ", currencyOfVariationMarginPosted=" + String.valueOf(this.currencyOfVariationMarginPosted) + ", variationMarginCollectedByTheReportingCounterpartyPreHaircut=" + String.valueOf(this.variationMarginCollectedByTheReportingCounterpartyPreHaircut) + ", variationMarginCollectedByTheReportingCounterpartyPostHaircut=" + String.valueOf(this.variationMarginCollectedByTheReportingCounterpartyPostHaircut) + ", currencyOfVariationMarginCollected=" + String.valueOf(this.currencyOfVariationMarginCollected) + ", excessCollateralPostedByTheReportingCounterparty=" + String.valueOf(this.excessCollateralPostedByTheReportingCounterparty) + ", currencyOfTheExcessCollateralPosted=" + this.currencyOfTheExcessCollateralPosted + ", excessCollateralCollectedByTheReportingCounterparty=" + String.valueOf(this.excessCollateralCollectedByTheReportingCounterparty) + ", currencyOfTheExcessCollateralCollected=" + this.currencyOfTheExcessCollateralCollected + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", actionType=" + String.valueOf((Object)this.actionType) + ", technicalRecordId=" + this.technicalRecordId + "}";
        }
    }
}

