/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetReportableStrikePricePeriod;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.jfsa.rewrite.trade.StrikePriceScheduleReport;
import drr.regulation.jfsa.rewrite.trade.reports.EffectiveDateStrikePriceRule;
import drr.regulation.jfsa.rewrite.trade.reports.EndDateStrikePriceRule;
import drr.regulation.jfsa.rewrite.trade.reports.StrikePriceInEffectOnAssociatedEffectiveDateDecimalRule;
import drr.regulation.jfsa.rewrite.trade.reports.StrikePriceInEffectOnAssociatedEffectiveDateMonetaryRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceScheduleRuleDefault.class)
public abstract class StrikePriceScheduleRule
implements ReportFunction<TransactionReportInstruction, List<? extends StrikePriceScheduleReport>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EffectiveDateStrikePriceRule effectiveDateStrikePriceRule;
    @Inject
    protected EndDateStrikePriceRule endDateStrikePriceRule;
    @Inject
    protected GetReportableStrikePricePeriod getReportableStrikePricePeriod;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected StrikePriceInEffectOnAssociatedEffectiveDateDecimalRule strikePriceInEffectOnAssociatedEffectiveDateDecimalRule;
    @Inject
    protected StrikePriceInEffectOnAssociatedEffectiveDateMonetaryRule strikePriceInEffectOnAssociatedEffectiveDateMonetaryRule;

    public List<? extends StrikePriceScheduleReport> evaluate(TransactionReportInstruction input) {
        List output;
        List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(StrikePriceScheduleReport::build).collect(Collectors.toList());
            this.objectValidator.validate(StrikePriceScheduleReport.class, output);
        }
        return output;
    }

    protected abstract List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class StrikePriceScheduleRuleDefault
    extends StrikePriceScheduleRule {
        @Override
        protected List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> output = new ArrayList<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> assignOutput(List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            MapperC thenArg1 = thenArg0.mapSingleToList(item -> MapperC.of(this.getReportableStrikePricePeriod.evaluate((ReportableEvent)item.get())));
            MapperC thenArg2 = thenArg1.mapItem(item -> MapperS.of((Object)StrikePriceScheduleReport.builder().setEffectiveDateStrikePrice(this.effectiveDateStrikePriceRule.evaluate((PriceReportablePeriod)item.get())).setEndDateStrikePrice(this.endDateStrikePriceRule.evaluate((PriceReportablePeriod)item.get())).setStrikePriceInEffectOnAssociatedEffectiveDateMonetary(this.strikePriceInEffectOnAssociatedEffectiveDateMonetaryRule.evaluate((PriceReportablePeriod)item.get())).setStrikePriceInEffectOnAssociatedEffectiveDateDecimal(this.strikePriceInEffectOnAssociatedEffectiveDateDecimalRule.evaluate((PriceReportablePeriod)item.get())).setStrikePriceNotationInEffectOnAssociatedEffectiveDate(null).build()));
            output = this.toBuilder(thenArg2.sort(item -> item.map("getEffectiveDateStrikePrice", strikePriceScheduleReport -> strikePriceScheduleReport.getEffectiveDateStrikePrice())).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

