/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.reports;

import cdm.event.common.Trade;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsEquityOption;
import drr.regulation.common.functions.IsPutOption;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.functions.CDEPutQuantity;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=CDEPutCurrencyRuleDefault.class)
public abstract class CDEPutCurrencyRule
implements ReportFunction<TransactionReportInstruction, List<String>> {
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected CDEPutQuantity cDEPutQuantity;
    @Inject
    protected FixedPriceLeg1 fixedPriceLeg1;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected IsEquityOption isEquityOption;
    @Inject
    protected IsPutOption isPutOption;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
    @Inject
    protected TradeForEvent tradeForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<String> evaluate(TransactionReportInstruction input) {
        List<String> output = this.doEvaluate(input);
        return output;
    }

    protected abstract List<String> doEvaluate(TransactionReportInstruction var1);

    public static class CDEPutCurrencyRuleDefault
    extends CDEPutCurrencyRule {
        @Override
        protected List<String> doEvaluate(TransactionReportInstruction input) {
            ArrayList<String> output = new ArrayList<String>();
            return this.assignOutput(output, input);
        }

        protected List<String> assignOutput(List<String> output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> {
                Boolean _boolean = this.isActionTypeTERM.evaluate((ReportableEvent)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)this.beforeTradeForEvent.evaluate((ReportableEvent)item.get()));
                }
                return MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)item.get()));
            });
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())));
            output = thenArg1.mapSingleToList(item -> {
                Boolean boolean0 = this.isPutOption.evaluate((Product)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    Boolean boolean1 = this.qualify_Commodity_Option.evaluate((EconomicTerms)item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
                    if (boolean1 != null && boolean1.booleanValue()) {
                        return item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                    }
                    Boolean boolean2 = this.qualify_Commodity_Swaption.evaluate((EconomicTerms)item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get());
                    if (boolean2 != null && boolean2.booleanValue()) {
                        return MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.fixedPriceLeg1.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getFixedPrice", fixedPricePayout -> fixedPricePayout.getFixedPrice()).map("getPrice", fixedPrice -> fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())});
                    }
                    if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquityOption.evaluate((Product)item.get()))).and(ExpressionOperators.exists((Mapper)item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                    }
                    if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquityOption.evaluate((Product)item.get()))).and(ExpressionOperators.exists((Mapper)item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getPriceQuantity", optionPayout -> optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getFinancialUnit", unitType -> unitType.getFinancialUnit()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getStrike", optionExercise -> optionExercise.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                    }
                    return MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.cDEPutQuantity.evaluate((Product)item.get())).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())});
                }
                return MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.cDEPutQuantity.evaluate((Product)item.get())).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())});
            }).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti();
            return output;
        }
    }
}

