package drr.projection.iso20022.asic.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.asic.rewrite.trade.ASICCustomBasket;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.Basket;
import drr.regulation.asic.rewrite.trade.BasketConstituentsReport;
import iso20022.auth030.asic.BasketConstituents3__1;
import iso20022.auth030.asic.ContractType15__1;
import iso20022.auth030.asic.CurrencyExchange23__1;
import iso20022.auth030.asic.CustomBasket4__1;
import iso20022.auth030.asic.FinancialInstrumentContractType2Code;
import iso20022.auth030.asic.GenericIdentification184;
import iso20022.auth030.asic.InstrumentIdentification6Choice__1;
import iso20022.auth030.asic.ProductType4Code__1;
import iso20022.auth030.asic.SecurityIdentification41Choice__1;
import iso20022.auth030.asic.SecurityIdentification46__1;
import iso20022.auth030.asic.UniqueProductIdentifier2Choice__1;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_ContractType15__1.Create_ContractType15__1Default.class)
public abstract class Create_ContractType15__1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param drrReport 
	* @return ctrctData 
	*/
	public ContractType15__1 evaluate(ASICTransactionReport drrReport) {
		ContractType15__1.ContractType15__1Builder ctrctDataBuilder = doEvaluate(drrReport);
		
		final ContractType15__1 ctrctData;
		if (ctrctDataBuilder == null) {
			ctrctData = null;
		} else {
			ctrctData = ctrctDataBuilder.build();
			objectValidator.validate(ContractType15__1.class, ctrctData);
		}
		
		return ctrctData;
	}

	protected abstract ContractType15__1.ContractType15__1Builder doEvaluate(ASICTransactionReport drrReport);

	public static class Create_ContractType15__1Default extends Create_ContractType15__1 {
		@Override
		protected ContractType15__1.ContractType15__1Builder doEvaluate(ASICTransactionReport drrReport) {
			ContractType15__1.ContractType15__1Builder ctrctData = ContractType15__1.builder();
			return assignOutput(ctrctData, drrReport);
		}
		
		protected ContractType15__1.ContractType15__1Builder assignOutput(ContractType15__1.ContractType15__1Builder ctrctData, ASICTransactionReport drrReport) {
			String ifThenElseResult0 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", aSICTransactionReport -> aSICTransactionReport.getUnderlyingIdentificationType()), MapperS.of("I"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult0 = MapperS.of(drrReport).<String>map("getUnderlyingIdentification", aSICTransactionReport -> aSICTransactionReport.getUnderlyingIdentification()).get();
			}
			CustomBasket4__1 ifThenElseResult3 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", aSICTransactionReport -> aSICTransactionReport.getUnderlyingIdentificationType()), MapperS.of("B"), CardinalityOperator.All).getOrDefault(false)) {
				String ifThenElseResult1 = null;
				if (exists(MapperS.of(drrReport).<ASICCustomBasket>map("getCustomBasketCode", aSICTransactionReport -> aSICTransactionReport.getCustomBasketCode()).<String>map("getBasketStructurerID", aSICCustomBasket -> aSICCustomBasket.getBasketStructurerID())).getOrDefault(false)) {
					ifThenElseResult1 = MapperS.of(drrReport).<ASICCustomBasket>map("getCustomBasketCode", aSICTransactionReport -> aSICTransactionReport.getCustomBasketCode()).<String>map("getBasketStructurerID", aSICCustomBasket -> aSICCustomBasket.getBasketStructurerID()).get();
				}
				String ifThenElseResult2 = null;
				if (exists(MapperS.of(drrReport).<ASICCustomBasket>map("getCustomBasketCode", aSICTransactionReport -> aSICTransactionReport.getCustomBasketCode()).<String>map("getCustomBasketID", aSICCustomBasket -> aSICCustomBasket.getCustomBasketID())).getOrDefault(false)) {
					ifThenElseResult2 = MapperS.of(drrReport).<ASICCustomBasket>map("getCustomBasketCode", aSICTransactionReport -> aSICTransactionReport.getCustomBasketCode()).<String>map("getCustomBasketID", aSICCustomBasket -> aSICCustomBasket.getCustomBasketID()).get();
				}
				ifThenElseResult3 = CustomBasket4__1.builder()
					.setStrr(ifThenElseResult1)
					.setId(ifThenElseResult2)
					.setCnsttnts(MapperS.of(drrReport).<Basket>map("getBasket", aSICTransactionReport -> aSICTransactionReport.getBasket()).<BasketConstituentsReport>mapC("getBasketConstituents", basket -> basket.getBasketConstituents())
						.mapItem(item -> {
							String _ifThenElseResult0 = null;
							if (areEqual(item.<ProductIdTypeEnum>map("getSource", basketConstituentsReport -> basketConstituentsReport.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All).getOrDefault(false)) {
								_ifThenElseResult0 = item.<String>map("getIdentifier", basketConstituentsReport -> basketConstituentsReport.getIdentifier()).get();
							}
							GenericIdentification184 _ifThenElseResult1 = null;
							if (notEqual(item.<ProductIdTypeEnum>map("getSource", basketConstituentsReport -> basketConstituentsReport.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.Any).getOrDefault(false)) {
								_ifThenElseResult1 = GenericIdentification184.builder()
									.setId(item.<String>map("getIdentifier", basketConstituentsReport -> basketConstituentsReport.getIdentifier()).get())
									.setSrc(item.<ProductIdTypeEnum>map("getSource", basketConstituentsReport -> basketConstituentsReport.getSource()).map("to-string", ProductIdTypeEnum::toDisplayString).get())
									.build();
							}
							return MapperS.of(BasketConstituents3__1.builder()
								.setInstrmId(InstrumentIdentification6Choice__1.builder()
									.setIsin(_ifThenElseResult0)
									.setOthrId(_ifThenElseResult1)
									.build())
								.build());
						}).getMulti())
					.build();
			}
			GenericIdentification184 ifThenElseResult4 = null;
			if (areEqual(MapperS.of(drrReport).<String>map("getUnderlyingIdentificationType", aSICTransactionReport -> aSICTransactionReport.getUnderlyingIdentificationType()), MapperS.of("O"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult4 = GenericIdentification184.builder()
					.setId(MapperS.of(drrReport).<String>map("getUnderlyingIdOther", aSICTransactionReport -> aSICTransactionReport.getUnderlyingIdOther()).get())
					.setSrc(MapperS.of(drrReport).<ProductIdTypeEnum>map("getUnderlyingIdOtherSource", aSICTransactionReport -> aSICTransactionReport.getUnderlyingIdOtherSource()).map("to-string", ProductIdTypeEnum::toDisplayString).get())
					.build();
			}
			final CurrencyExchange23__1 ifThenElseResult5;
			if (areEqual(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getSettlementCurrencyLeg2", aSICTransactionReport -> aSICTransactionReport.getSettlementCurrencyLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString), MapperS.of("Not Modelled"), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult5 = null;
			} else {
				ifThenElseResult5 = CurrencyExchange23__1.builder()
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getSettlementCurrencyLeg2", aSICTransactionReport -> aSICTransactionReport.getSettlementCurrencyLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build();
			}
			ctrctData = toBuilder(ContractType15__1.builder()
				.setCtrctTp(MapperS.of(drrReport).<String>map("getContractType", aSICTransactionReport -> aSICTransactionReport.getContractType()).checkedMap("to-enum", FinancialInstrumentContractType2Code::fromDisplayName, IllegalArgumentException.class).get())
				.setAsstClss(MapperS.of(drrReport).<String>map("getAssetClass", aSICTransactionReport -> aSICTransactionReport.getAssetClass()).checkedMap("to-enum", ProductType4Code__1::fromDisplayName, IllegalArgumentException.class).get())
				.setPdctId(SecurityIdentification46__1.builder()
					.setUnqPdctIdr(UniqueProductIdentifier2Choice__1.builder()
						.setId(MapperS.of(drrReport).<String>map("getUniqueProductIdentifier", aSICTransactionReport -> aSICTransactionReport.getUniqueProductIdentifier()).get())
						.build())
					.build())
				.setUndrlygInstrm(SecurityIdentification41Choice__1.builder()
					.setIsin(ifThenElseResult0)
					.setBskt(ifThenElseResult3)
					.setOthr(ifThenElseResult4)
					.build())
				.setSttlmCcy(CurrencyExchange23__1.builder()
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getSettlementCurrencyLeg1", aSICTransactionReport -> aSICTransactionReport.getSettlementCurrencyLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setSttlmCcyScndLeg(ifThenElseResult5)
				.build());
			
			return Optional.ofNullable(ctrctData)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
