package drr.projection.iso20022.asic.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.asic.FixedRate10__1;
import iso20022.auth030.asic.FloatingRate13__1;
import iso20022.auth030.asic.FloatingRate13__2;
import iso20022.auth030.asic.InterestComputationMethod4Code;
import iso20022.auth030.asic.InterestRate33Choice__1;
import iso20022.auth030.asic.InterestRate33Choice__2;
import iso20022.auth030.asic.InterestRateLegs14__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetIntrstRate.GetIntrstRateDefault.class)
public abstract class GetIntrstRate implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_FixedRate create_FixedRate;
	@Inject protected Create_FloatingRate create_FloatingRate;
	@Inject protected Create_FloatingRate2 create_FloatingRate2;

	/**
	* @param drrReport 
	* @return intrstRate 
	*/
	public InterestRateLegs14__1 evaluate(ASICTransactionReport drrReport) {
		InterestRateLegs14__1.InterestRateLegs14__1Builder intrstRateBuilder = doEvaluate(drrReport);
		
		final InterestRateLegs14__1 intrstRate;
		if (intrstRateBuilder == null) {
			intrstRate = null;
		} else {
			intrstRate = intrstRateBuilder.build();
			objectValidator.validate(InterestRateLegs14__1.class, intrstRate);
		}
		
		return intrstRate;
	}

	protected abstract InterestRateLegs14__1.InterestRateLegs14__1Builder doEvaluate(ASICTransactionReport drrReport);

	public static class GetIntrstRateDefault extends GetIntrstRate {
		@Override
		protected InterestRateLegs14__1.InterestRateLegs14__1Builder doEvaluate(ASICTransactionReport drrReport) {
			InterestRateLegs14__1.InterestRateLegs14__1Builder intrstRate = InterestRateLegs14__1.builder();
			return assignOutput(intrstRate, drrReport);
		}
		
		protected InterestRateLegs14__1.InterestRateLegs14__1Builder assignOutput(InterestRateLegs14__1.InterestRateLegs14__1Builder intrstRate, ASICTransactionReport drrReport) {
			FixedRate10__1 ifThenElseResult0 = null;
			if (exists(MapperS.of(drrReport).<BigDecimal>map("getFixedRateLeg1", aSICTransactionReport -> aSICTransactionReport.getFixedRateLeg1())).getOrDefault(false)) {
				ifThenElseResult0 = create_FixedRate.evaluate(MapperS.of(drrReport).<BigDecimal>map("getFixedRateLeg1", aSICTransactionReport -> aSICTransactionReport.getFixedRateLeg1()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getDayCountConventionLeg1", aSICTransactionReport -> aSICTransactionReport.getDayCountConventionLeg1()).get(), MapperS.of(drrReport).<String>map("getPaymentFrequencyPeriodLeg1", aSICTransactionReport -> aSICTransactionReport.getPaymentFrequencyPeriodLeg1()).get(), MapperS.of(drrReport).<Integer>map("getPaymentFrequencyPeriodMultiplierLeg1", aSICTransactionReport -> aSICTransactionReport.getPaymentFrequencyPeriodMultiplierLeg1()).get());
			}
			FloatingRate13__1 ifThenElseResult1 = null;
			if (areEqual(exists(MapperS.of(drrReport).<BigDecimal>map("getFixedRateLeg1", aSICTransactionReport -> aSICTransactionReport.getFixedRateLeg1())), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = create_FloatingRate.evaluate(MapperS.of(drrReport).<SpreadLeg1>map("getSpreadLeg1", aSICTransactionReport -> aSICTransactionReport.getSpreadLeg1()).<BigDecimal>map("getSpreadLeg1Monetary", spreadLeg1 -> spreadLeg1.getSpreadLeg1Monetary()).get(), MapperS.of(drrReport).<SpreadLeg1>map("getSpreadLeg1", aSICTransactionReport -> aSICTransactionReport.getSpreadLeg1()).<BigDecimal>map("getSpreadLeg1Decimal", spreadLeg1 -> spreadLeg1.getSpreadLeg1Decimal()).get(), MapperS.of(drrReport).<SpreadLeg1>map("getSpreadLeg1", aSICTransactionReport -> aSICTransactionReport.getSpreadLeg1()).<BigDecimal>map("getSpreadLeg1Basis", spreadLeg1 -> spreadLeg1.getSpreadLeg1Basis()).get(), MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg1", aSICTransactionReport -> aSICTransactionReport.getSpreadCurrencyLeg1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get(), MapperS.of(drrReport).<SpreadLeg1>map("getSpreadLeg1", aSICTransactionReport -> aSICTransactionReport.getSpreadLeg1()).<PriceNotationEnum>map("getSpreadLeg1Notation", spreadLeg1 -> spreadLeg1.getSpreadLeg1Notation()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getDayCountConventionLeg1", aSICTransactionReport -> aSICTransactionReport.getDayCountConventionLeg1()).get(), MapperS.of(drrReport).<String>map("getPaymentFrequencyPeriodLeg1", aSICTransactionReport -> aSICTransactionReport.getPaymentFrequencyPeriodLeg1()).get(), MapperS.of(drrReport).<Integer>map("getPaymentFrequencyPeriodMultiplierLeg1", aSICTransactionReport -> aSICTransactionReport.getPaymentFrequencyPeriodMultiplierLeg1()).get());
			}
			FixedRate10__1 ifThenElseResult2 = null;
			if (exists(MapperS.of(drrReport).<BigDecimal>map("getFixedRateLeg2", aSICTransactionReport -> aSICTransactionReport.getFixedRateLeg2())).getOrDefault(false)) {
				ifThenElseResult2 = create_FixedRate.evaluate(MapperS.of(drrReport).<BigDecimal>map("getFixedRateLeg2", aSICTransactionReport -> aSICTransactionReport.getFixedRateLeg2()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getDayCountConventionLeg2", aSICTransactionReport -> aSICTransactionReport.getDayCountConventionLeg2()).get(), MapperS.of(drrReport).<String>map("getPaymentFrequencyPeriodLeg2", aSICTransactionReport -> aSICTransactionReport.getPaymentFrequencyPeriodLeg2()).get(), MapperS.of(drrReport).<Integer>map("getPaymentFrequencyPeriodMultiplierLeg2", aSICTransactionReport -> aSICTransactionReport.getPaymentFrequencyPeriodMultiplierLeg2()).get());
			}
			FloatingRate13__2 ifThenElseResult3 = null;
			if (areEqual(exists(MapperS.of(drrReport).<BigDecimal>map("getFixedRateLeg2", aSICTransactionReport -> aSICTransactionReport.getFixedRateLeg2())), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult3 = create_FloatingRate2.evaluate(MapperS.of(drrReport).<String>map("getIndicatorOfTheFloatingRateLeg2", aSICTransactionReport -> aSICTransactionReport.getIndicatorOfTheFloatingRateLeg2()).get(), MapperS.of(drrReport).<String>map("getFloatingRateReferencePeriodOfLeg2TimePeriod", aSICTransactionReport -> aSICTransactionReport.getFloatingRateReferencePeriodOfLeg2TimePeriod()).get(), MapperS.of(drrReport).<Integer>map("getFloatingRateReferencePeriodOfLeg2Multiplier", aSICTransactionReport -> aSICTransactionReport.getFloatingRateReferencePeriodOfLeg2Multiplier()).get(), MapperS.of(drrReport).<SpreadLeg2>map("getSpreadLeg2", aSICTransactionReport -> aSICTransactionReport.getSpreadLeg2()).<BigDecimal>map("getSpreadLeg2Monetary", spreadLeg2 -> spreadLeg2.getSpreadLeg2Monetary()).get(), MapperS.of(drrReport).<SpreadLeg2>map("getSpreadLeg2", aSICTransactionReport -> aSICTransactionReport.getSpreadLeg2()).<BigDecimal>map("getSpreadLeg2Decimal", spreadLeg2 -> spreadLeg2.getSpreadLeg2Decimal()).get(), MapperS.of(drrReport).<SpreadLeg2>map("getSpreadLeg2", aSICTransactionReport -> aSICTransactionReport.getSpreadLeg2()).<BigDecimal>map("getSpreadLeg2Basis", spreadLeg2 -> spreadLeg2.getSpreadLeg2Basis()).get(), MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg2", aSICTransactionReport -> aSICTransactionReport.getSpreadCurrencyLeg2()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get(), MapperS.of(drrReport).<SpreadLeg2>map("getSpreadLeg2", aSICTransactionReport -> aSICTransactionReport.getSpreadLeg2()).<PriceNotationEnum>map("getSpreadLeg2Notation", spreadLeg2 -> spreadLeg2.getSpreadLeg2Notation()).get(), MapperS.of(drrReport).<InterestComputationMethod4Code>map("getDayCountConventionLeg2", aSICTransactionReport -> aSICTransactionReport.getDayCountConventionLeg2()).get(), MapperS.of(drrReport).<String>map("getPaymentFrequencyPeriodLeg2", aSICTransactionReport -> aSICTransactionReport.getPaymentFrequencyPeriodLeg2()).get(), MapperS.of(drrReport).<Integer>map("getPaymentFrequencyPeriodMultiplierLeg2", aSICTransactionReport -> aSICTransactionReport.getPaymentFrequencyPeriodMultiplierLeg2()).get());
			}
			intrstRate = toBuilder(InterestRateLegs14__1.builder()
				.setFrstLeg(InterestRate33Choice__1.builder()
					.setFxd(ifThenElseResult0)
					.setFltg(ifThenElseResult1)
					.build())
				.setScndLeg(InterestRate33Choice__2.builder()
					.setFxd(ifThenElseResult2)
					.setFltg(ifThenElseResult3)
					.build())
				.build());
			
			return Optional.ofNullable(intrstRate)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
