package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.regulation.jfsa.rewrite.trade.NotionalQuantityScheduleLeg1Report;
import drr.regulation.jfsa.rewrite.trade.NotionalQuantityScheduleLeg2Report;
import iso20022.auth030.jfsa.NotionalQuantity9__1;
import iso20022.auth030.jfsa.NotionalQuantityLegs5__1;
import iso20022.auth030.jfsa.QuantityOrTerm1Choice__1;
import iso20022.auth030.jfsa.Schedule10__1;
import iso20022.auth030.jfsa.UnitOfMeasure8Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(GetNtnlQty.GetNtnlQtyDefault.class)
public abstract class GetNtnlQty implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param drrReport 
	* @return ntnlQty 
	*/
	public NotionalQuantityLegs5__1 evaluate(JFSATransactionReport drrReport) {
		NotionalQuantityLegs5__1.NotionalQuantityLegs5__1Builder ntnlQtyBuilder = doEvaluate(drrReport);
		
		final NotionalQuantityLegs5__1 ntnlQty;
		if (ntnlQtyBuilder == null) {
			ntnlQty = null;
		} else {
			ntnlQty = ntnlQtyBuilder.build();
			objectValidator.validate(NotionalQuantityLegs5__1.class, ntnlQty);
		}
		
		return ntnlQty;
	}

	protected abstract NotionalQuantityLegs5__1.NotionalQuantityLegs5__1Builder doEvaluate(JFSATransactionReport drrReport);

	public static class GetNtnlQtyDefault extends GetNtnlQty {
		@Override
		protected NotionalQuantityLegs5__1.NotionalQuantityLegs5__1Builder doEvaluate(JFSATransactionReport drrReport) {
			NotionalQuantityLegs5__1.NotionalQuantityLegs5__1Builder ntnlQty = NotionalQuantityLegs5__1.builder();
			return assignOutput(ntnlQty, drrReport);
		}
		
		protected NotionalQuantityLegs5__1.NotionalQuantityLegs5__1Builder assignOutput(NotionalQuantityLegs5__1.NotionalQuantityLegs5__1Builder ntnlQty, JFSATransactionReport drrReport) {
			ntnlQty = toBuilder(NotionalQuantityLegs5__1.builder()
				.setFrstLeg(NotionalQuantity9__1.builder()
					.setTtlQty(MapperS.of(drrReport).<BigDecimal>map("getTotalNotionalQuantityLeg1", jFSATransactionReport -> jFSATransactionReport.getTotalNotionalQuantityLeg1()).get())
					.setUnitOfMeasr(UnitOfMeasure8Choice__1.builder()
						.setCd(MapperS.of(drrReport).<String>map("getQuantityUnitOfMeasureLeg1", jFSATransactionReport -> jFSATransactionReport.getQuantityUnitOfMeasureLeg1()).get())
						.build())
					.setDtls(QuantityOrTerm1Choice__1.builder()
						.setSchdlPrd(MapperS.of(drrReport).<NotionalQuantityScheduleLeg1Report>mapC("getNotionalQuantityScheduleLeg1", jFSATransactionReport -> jFSATransactionReport.getNotionalQuantityScheduleLeg1())
							.mapItem(item -> MapperS.of(Schedule10__1.builder()
								.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getEffectiveDate()).get())
								.setUadjstdEndDt(item.<Date>map("getEndDate", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getEndDate()).get())
								.setQty(item.<BigDecimal>map("getValue", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getValue()).get())
								.build())).getMulti())
						.build())
					.build())
				.setScndLeg(NotionalQuantity9__1.builder()
					.setTtlQty(MapperS.of(drrReport).<BigDecimal>map("getTotalNotionalQuantityLeg2", jFSATransactionReport -> jFSATransactionReport.getTotalNotionalQuantityLeg2()).get())
					.setUnitOfMeasr(UnitOfMeasure8Choice__1.builder()
						.setCd(MapperS.of(drrReport).<String>map("getQuantityUnitOfMeasureLeg2", jFSATransactionReport -> jFSATransactionReport.getQuantityUnitOfMeasureLeg2()).get())
						.build())
					.setDtls(QuantityOrTerm1Choice__1.builder()
						.setSchdlPrd(MapperS.of(drrReport).<NotionalQuantityScheduleLeg2Report>mapC("getNotionalQuantityScheduleLeg2", jFSATransactionReport -> jFSATransactionReport.getNotionalQuantityScheduleLeg2())
							.mapItem(item -> MapperS.of(Schedule10__1.builder()
								.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", notionalQuantityScheduleLeg2Report -> notionalQuantityScheduleLeg2Report.getEffectiveDate()).get())
								.setUadjstdEndDt(item.<Date>map("getEndDate", notionalQuantityScheduleLeg2Report -> notionalQuantityScheduleLeg2Report.getEndDate()).get())
								.setQty(item.<BigDecimal>map("getValue", notionalQuantityScheduleLeg2Report -> notionalQuantityScheduleLeg2Report.getValue()).get())
								.build())).getMulti())
						.build())
					.build())
				.build());
			
			return Optional.ofNullable(ntnlQty)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
