package drr.projection.iso20022.mas.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import iso20022.auth030.mas.Counterparty45__1;
import iso20022.auth030.mas.Counterparty46__1;
import iso20022.auth030.mas.Direction2;
import iso20022.auth030.mas.Direction4Choice;
import iso20022.auth030.mas.OptionParty1Code;
import iso20022.auth030.mas.OptionParty3Code;
import iso20022.auth030.mas.TradeCounterpartyReport20__1;
import iso20022.auth030.mas.TradingCapacity7Code;
import java.util.ArrayList;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_TradeCounterpartyReport20__1.Create_TradeCounterpartyReport20__1Default.class)
public abstract class Create_TradeCounterpartyReport20__1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_PartyIdentification248Choice__1 create_PartyIdentification248Choice__1;
	@Inject protected Create_PartyIdentification248Choice__2 create_PartyIdentification248Choice__2;
	@Inject protected GetExctnAgt getExctnAgt;
	@Inject protected GetNttyRspnsblForRpt getNttyRspnsblForRpt;
	@Inject protected GetSubmitgAgt getSubmitgAgt;

	/**
	* @param drrReport 
	* @return ctrPty 
	*/
	public TradeCounterpartyReport20__1 evaluate(MASTransactionReport drrReport) {
		TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder ctrPtyBuilder = doEvaluate(drrReport);
		
		final TradeCounterpartyReport20__1 ctrPty;
		if (ctrPtyBuilder == null) {
			ctrPty = null;
		} else {
			ctrPty = ctrPtyBuilder.build();
			objectValidator.validate(TradeCounterpartyReport20__1.class, ctrPty);
		}
		
		return ctrPty;
	}

	protected abstract TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder doEvaluate(MASTransactionReport drrReport);

	public static class Create_TradeCounterpartyReport20__1Default extends Create_TradeCounterpartyReport20__1 {
		@Override
		protected TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder doEvaluate(MASTransactionReport drrReport) {
			TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder ctrPty = TradeCounterpartyReport20__1.builder();
			return assignOutput(ctrPty, drrReport);
		}
		
		protected TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder assignOutput(TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder ctrPty, MASTransactionReport drrReport) {
			ctrPty = toBuilder(TradeCounterpartyReport20__1.builder()
				.setRptgCtrPty(Counterparty45__1.builder()
					.setId(create_PartyIdentification248Choice__1.evaluate(MapperS.of(drrReport).<String>map("getCounterparty1", mASTransactionReport -> mASTransactionReport.getCounterparty1()).get()))
					.setTradgCpcty(MapperS.of(drrReport).<TradingCapacity7Code>map("getTradingCapacityOfSpecifiedPerson", mASTransactionReport -> mASTransactionReport.getTradingCapacityOfSpecifiedPerson()).get())
					.setDrctnOrSd(Direction4Choice.builder()
						.setCtrPtySd(MapperS.of(drrReport).<String>map("getDirection", mASTransactionReport -> mASTransactionReport.getDirection()).checkedMap("to-enum", OptionParty1Code::fromDisplayName, IllegalArgumentException.class).get())
						.setDrctn(Direction2.builder()
							.setDrctnOfTheFrstLeg(MapperS.of(drrReport).<String>map("getDirectionOfLeg1", mASTransactionReport -> mASTransactionReport.getDirectionOfLeg1()).checkedMap("to-enum", OptionParty3Code::fromDisplayName, IllegalArgumentException.class).get())
							.setDrctnOfTheScndLeg(MapperS.of(drrReport).<String>map("getDirectionOfLeg2", mASTransactionReport -> mASTransactionReport.getDirectionOfLeg2()).checkedMap("to-enum", OptionParty3Code::fromDisplayName, IllegalArgumentException.class).get())
							.build())
						.build())
					.setTradrLctn(MapperS.of(drrReport).<String>map("getTraderLocation", mASTransactionReport -> mASTransactionReport.getTraderLocation()).get())
					.setBookgLctn(MapperS.of(drrReport).<String>map("getBookingLocation", mASTransactionReport -> mASTransactionReport.getBookingLocation()).get())
					.build())
				.setOthrCtrPty(Counterparty46__1.builder()
					.setIdTp(create_PartyIdentification248Choice__2.evaluate(drrReport))
					.build())
				.setSubmitgAgt(getSubmitgAgt.evaluate(drrReport))
				.setClrMmb(create_PartyIdentification248Choice__1.evaluate(MapperS.of(drrReport).<String>map("getClearingMember", mASTransactionReport -> mASTransactionReport.getClearingMember()).get()))
				.setNttyRspnsblForRpt(getNttyRspnsblForRpt.evaluate(drrReport))
				.setExctnAgt(new ArrayList(getExctnAgt.evaluate(drrReport)))
				.build());
			
			return Optional.ofNullable(ctrPty)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
