package drr.projection.iso20022.mas.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.util.functions.StringLength;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.StrikePriceAndNotation;
import drr.regulation.mas.rewrite.trade.StrikePriceScheduleReport;
import drr.standards.iso.PriceNotationEnum;
import iso20022.auth030.mas.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.mas.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.mas.AmountAndDirection106__1;
import iso20022.auth030.mas.ExerciseDate1Choice__1;
import iso20022.auth030.mas.OptionOrSwaption11__1;
import iso20022.auth030.mas.OptionStyle6Code;
import iso20022.auth030.mas.OptionType2Code;
import iso20022.auth030.mas.Schedule4__1;
import iso20022.auth030.mas.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetOptn.GetOptnDefault.class)
public abstract class GetOptn implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;
	@Inject protected StringLength stringLength;
	@Inject protected SubString subString;

	/**
	* @param drrReport 
	* @return optn 
	*/
	public OptionOrSwaption11__1 evaluate(MASTransactionReport drrReport) {
		OptionOrSwaption11__1.OptionOrSwaption11__1Builder optnBuilder = doEvaluate(drrReport);
		
		final OptionOrSwaption11__1 optn;
		if (optnBuilder == null) {
			optn = null;
		} else {
			optn = optnBuilder.build();
			objectValidator.validate(OptionOrSwaption11__1.class, optn);
		}
		
		return optn;
	}

	protected abstract OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(MASTransactionReport drrReport);

	public static class GetOptnDefault extends GetOptn {
		@Override
		protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(MASTransactionReport drrReport) {
			OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn = OptionOrSwaption11__1.builder();
			return assignOutput(optn, drrReport);
		}
		
		protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder assignOutput(OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn, MASTransactionReport drrReport) {
			final String ifThenElseResult;
			if (exists(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getOptionPremiumCurrency", mASTransactionReport -> mASTransactionReport.getOptionPremiumCurrency())).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getOptionPremiumCurrency", mASTransactionReport -> mASTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get();
			} else if (areEqual(MapperS.of(drrReport).<BigDecimal>map("getOptionPremiumAmount", mASTransactionReport -> mASTransactionReport.getOptionPremiumAmount()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getSettlementCurrency1", mASTransactionReport -> mASTransactionReport.getSettlementCurrency1()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get();
			} else {
				ifThenElseResult = null;
			}
			optn = toBuilder(OptionOrSwaption11__1.builder()
				.setTp(MapperS.of(drrReport).<String>map("getOptionType", mASTransactionReport -> mASTransactionReport.getOptionType()).checkedMap("to-enum", OptionType2Code::fromDisplayName, IllegalArgumentException.class).get())
				.setExrcStyle(MapperS.of(drrReport).<String>map("getOptionStyle", mASTransactionReport -> mASTransactionReport.getOptionStyle()).checkedMap("to-enum", OptionStyle6Code::fromDisplayName, IllegalArgumentException.class).get())
				.setExrcDt(ExerciseDate1Choice__1.builder()
					.setFrstExrcDt(MapperS.of(drrReport).<Date>map("getFirstExerciseDate", mASTransactionReport -> mASTransactionReport.getFirstExerciseDate()).get())
					.build())
				.setStrkPric(MapperS.of(drrReport).<StrikePriceAndNotation>map("getStrikePrice", mASTransactionReport -> mASTransactionReport.getStrikePrice())
					.mapSingleToItem(item -> {
						AmountAndDirection106__1 ifThenElseResult2 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							String ifThenElseResult0 = null;
							if (areEqual(MapperS.of(drrReport).<String>map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), MapperS.of("OPTN"), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<String>map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), MapperS.of("SWPT"), CardinalityOperator.All)).and(areEqual(areEqual(MapperS.of(drrReport).<String>map("getAssetClass", mASTransactionReport -> mASTransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.All), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
								if (greaterThan(MapperS.of(stringLength.evaluate(item.<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get())), MapperS.of(3), CardinalityOperator.All).getOrDefault(false)) {
									ifThenElseResult0 = subString.evaluate(item.<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get(), 5, 3);
								} else {
									ifThenElseResult0 = item.<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).get();
								}
							}
							Boolean ifThenElseResult1 = null;
							if (lessThan(item.<BigDecimal>map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult1 = false;
							}
							ifThenElseResult2 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
									.setValue(abs.evaluate(item.<BigDecimal>map("getStrikePriceMonetary", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceMonetary()).get()))
									.setCcy(ifThenElseResult0)
									.build())
								.setSgn(ifThenElseResult1)
								.build();
						}
						BigDecimal ifThenElseResult3 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult3 = item.<BigDecimal>map("getStrikePriceDecimal", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceDecimal()).get();
						}
						return MapperS.of(SecuritiesTransactionPrice17Choice__1.builder()
							.setMntryVal(ifThenElseResult2)
							.setDcml(ifThenElseResult3)
							.build());
					}).get())
				.setStrkPricSchdl(MapperS.of(drrReport).<StrikePriceScheduleReport>mapC("getStrikePriceSchedule", mASTransactionReport -> mASTransactionReport.getStrikePriceSchedule())
					.mapItem(item -> {
						AmountAndDirection106__1 ifThenElseResult2 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							String ifThenElseResult0 = null;
							if (areEqual(MapperS.of(drrReport).<String>map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), MapperS.of("OPTN"), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<String>map("getContractType", mASTransactionReport -> mASTransactionReport.getContractType()), MapperS.of("SWPT"), CardinalityOperator.All)).and(areEqual(areEqual(MapperS.of(drrReport).<String>map("getAssetClass", mASTransactionReport -> mASTransactionReport.getAssetClass()), MapperS.of("CURR"), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<String>map("getAssetClass", mASTransactionReport -> mASTransactionReport.getAssetClass()), MapperS.of("INTR"), CardinalityOperator.All)), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
								ifThenElseResult0 = MapperS.of(drrReport).<StrikePriceAndNotation>map("getStrikePrice", mASTransactionReport -> mASTransactionReport.getStrikePrice()).<String>map("getStrikePriceCurrency", strikePriceAndNotation -> strikePriceAndNotation.getStrikePriceCurrency()).map("to-string", Object::toString).get();
							}
							Boolean ifThenElseResult1 = null;
							if (lessThan(item.<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult1 = false;
							}
							ifThenElseResult2 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
									.setValue(abs.evaluate(item.<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateMonetary", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateMonetary()).get()))
									.setCcy(ifThenElseResult0)
									.build())
								.setSgn(ifThenElseResult1)
								.build();
						}
						BigDecimal ifThenElseResult3 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotationInEffectOnAssociatedEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceNotationInEffectOnAssociatedEffectiveDate()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult3 = item.<BigDecimal>map("getStrikePriceInEffectOnAssociatedEffectiveDateDecimal", strikePriceScheduleReport -> strikePriceScheduleReport.getStrikePriceInEffectOnAssociatedEffectiveDateDecimal()).get();
						}
						return MapperS.of(Schedule4__1.builder()
							.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", strikePriceScheduleReport -> strikePriceScheduleReport.getEffectiveDate()).get())
							.setUadjstdEndDt(item.<Date>map("getEndDate", strikePriceScheduleReport -> strikePriceScheduleReport.getEndDate()).get())
							.setPric(SecuritiesTransactionPrice17Choice__1.builder()
								.setMntryVal(ifThenElseResult2)
								.setDcml(ifThenElseResult3)
								.build())
							.build());
					}).getMulti())
				.setCallAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(drrReport).<BigDecimal>map("getCallAmount", mASTransactionReport -> mASTransactionReport.getCallAmount()).get())
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getCallCurrency", mASTransactionReport -> mASTransactionReport.getCallCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setPutAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(drrReport).<BigDecimal>map("getPutAmount", mASTransactionReport -> mASTransactionReport.getPutAmount()).get())
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPutCurrency", mASTransactionReport -> mASTransactionReport.getPutCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(drrReport).<BigDecimal>map("getOptionPremiumAmount", mASTransactionReport -> mASTransactionReport.getOptionPremiumAmount()).get())
					.setCcy(ifThenElseResult)
					.build())
				.build());
			
			return Optional.ofNullable(optn)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
