package drr.regulation.asic.rewrite.margin.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.common.ReportingSide;
import drr.standards.iosco.cde.functions.CDEInitialMarginPostedByReportingCounterpartyPostHaircut;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(InitialMarginPostedByTheReportingEntityPostHaircutRule.InitialMarginPostedByTheReportingEntityPostHaircutRuleDefault.class)
public abstract class InitialMarginPostedByTheReportingEntityPostHaircutRule implements ReportFunction<CollateralReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEInitialMarginPostedByReportingCounterpartyPostHaircut cDEInitialMarginPostedByReportingCounterpartyPostHaircut;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(CollateralReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(CollateralReportInstruction input);

	public static class InitialMarginPostedByTheReportingEntityPostHaircutRuleDefault extends InitialMarginPostedByTheReportingEntityPostHaircutRule {
		@Override
		protected BigDecimal doEvaluate(CollateralReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, CollateralReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					final ReferenceWithMetaParty referenceWithMetaParty = item.<ReportingSide>map("getReportingSide", collateralReportInstruction -> collateralReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
					return MapperS.of(cDEInitialMarginPostedByReportingCounterpartyPostHaircut.evaluate(item.get(), (referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue())));
				}).get();
			
			return output;
		}
	}
}
