package drr.regulation.asic.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.asic.rewrite.trade.meta.ASICTransactionReportMeta;
import iso20022.auth030.asic.InterestComputationMethod4Code;
import iso20022.auth030.asic.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="ASICTransactionReport", builder=ASICTransactionReport.ASICTransactionReportBuilderImpl.class, version="5.53.0")
@RuneDataType(value="ASICTransactionReport", model="drr", builder=ASICTransactionReport.ASICTransactionReportBuilderImpl.class, version="5.53.0")
public interface ASICTransactionReport extends RosettaModelObject {

	ASICTransactionReportMeta metaData = new ASICTransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	String getUniqueTransactionIdentifier();
	String getUtiProprietaryID();
	String getSecondaryTransactionIdentifier();
	String getUniqueProductIdentifier();
	String getAssetClass();
	String getContractType();
	String getReportingEntity();
	String getCounterparty1();
	String getCounterparty2();
	String getCounterparty2Name();
	Boolean getCounterparty2IdentifierTypeIndicator();
	ISOCountryCodeEnum getCountryOfTheCounterParty2();
	String getBeneficiary1();
	Boolean getBeneficiary1IdentifierTypeIndicator();
	String getBroker();
	String getExecutionAgentOfCounterparty1();
	String getDirection();
	String getDirection2OfLeg1();
	String getDirection2OfLeg2();
	Date getEffectiveDate();
	Date getExpirationDate();
	ZonedDateTime getExecutionTimestamp();
	ZonedDateTime getEventTimestamp();
	ZonedDateTime getClearingTimestamp();
	String getCleared();
	String getCentralCounterparty();
	String getClearingMember();
	String getPlatformIdentifier();
	BigDecimal getNotionalLeg1();
	BigDecimal getNotionalLeg2();
	BigDecimal getTotalNotionalQuantityLeg1();
	BigDecimal getTotalNotionalQuantityLeg2();
	BigDecimal getNotionalQuantityLeg1();
	BigDecimal getNotionalQuantityLeg2();
	BigDecimal getCallAmount();
	BigDecimal getPutAmount();
	ISOCurrencyCodeEnum getNotionalCurrencyLeg1();
	ISOCurrencyCodeEnum getNotionalCurrencyLeg2();
	String getQuantityUnitOfMeasureLeg1();
	String getQuantityUnitOfMeasureLeg2();
	ISOCurrencyCodeEnum getCallCurrency();
	ISOCurrencyCodeEnum getPutCurrency();
	List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1();
	List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2();
	PriceAndNotation getPrice();
	String getPriceUnitOfMeasure();
	BigDecimal getFixedRateLeg1();
	BigDecimal getFixedRateLeg2();
	String getSpreadNotationLeg1();
	SpreadLeg1 getSpreadLeg1();
	String getSpreadNotationLeg2();
	SpreadLeg2 getSpreadLeg2();
	ISOCurrencyCodeEnum getSpreadCurrencyLeg1();
	ISOCurrencyCodeEnum getSpreadCurrencyLeg2();
	StrikePriceAndNotation getStrikePrice();
	BarrierAndNotation getBarrier();
	BigDecimal getOptionPremiumAmount();
	ISOCurrencyCodeEnum getOptionPremiumCurrency();
	Date getOptionPremiumPaymentDate();
	BigDecimal getExchangeRate();
	String getExchangeRateBasis();
	InterestComputationMethod4Code getDayCountConventionLeg1();
	InterestComputationMethod4Code getDayCountConventionLeg2();
	String getPaymentFrequencyPeriodLeg1();
	String getPaymentFrequencyPeriodLeg2();
	Integer getPaymentFrequencyPeriodMultiplierLeg1();
	Integer getPaymentFrequencyPeriodMultiplierLeg2();
	ISOCurrencyCodeEnum getSettlementCurrencyLeg1();
	ISOCurrencyCodeEnum getSettlementCurrencyLeg2();
	List<? extends OtherPaymentReport> getOtherPayment();
	ASICCustomBasket getCustomBasketCode();
	Basket getBasket();
	String getUnderlyingIdentification();
	String getUnderlyingIdentificationType();
	String getUnderlyingIdOther();
	ProductIdTypeEnum getUnderlyingIdOtherSource();
	Date getMaturityDateOfTheUnderlying();
	String getIndicatorOfTheFloatingRateLeg2();
	String getFloatingRateReferencePeriodOfLeg2TimePeriod();
	Integer getFloatingRateReferencePeriodOfLeg2Multiplier();
	BigDecimal getCdSIndexAttachmentPoint();
	BigDecimal getCdSIndexDetachmentPoint();
	BigDecimal getIndexFactor();
	String getPackageIdentifier();
	PackageTransactionPrice getPackageTransactionPrice();
	PackageTransactionSpread getPackageTransactionSpread();
	String getPriorUTI();
	String getPriorUtiProprietary();
	String getEventIdentifier();
	String getActionType();
	String getEventType();
	ZonedDateTime getReportingTimestamp();
	String getReportSubmittingEntityID();
	String getNewDerivativeTradeRepository();
	ZonedDateTime getValuationTimestamp();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ValuationType1Code getValuationMethod();
	BigDecimal getDelta();
	Date getNextFloatingReferenceResetDateLeg1();
	Date getNextFloatingReferenceResetDateLeg2();
	String getSmallScaleBuySideEntityIndicator();
	String getTechnicalRecordId();
	Boolean getCollateralPortfolioIndicator();
	String getCollateralPortfolioCodeInitialMargin();
	String getCollateralPortfolioCodeVariationMargin();
	String getExecutionAgentOfCounterparty2DTCC();
	ASICNonReportable getNonReportable();

	/*********************** Build Methods  ***********************/
	ASICTransactionReport build();
	
	ASICTransactionReport.ASICTransactionReportBuilder toBuilder();
	
	static ASICTransactionReport.ASICTransactionReportBuilder builder() {
		return new ASICTransactionReport.ASICTransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ASICTransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ASICTransactionReport> getType() {
		return ASICTransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("utiProprietaryID"), String.class, getUtiProprietaryID(), this);
		processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, getSecondaryTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
		processor.processBasic(path.newSubPath("reportingEntity"), String.class, getReportingEntity(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, getCounterparty2IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
		processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
		processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("broker"), String.class, getBroker(), this);
		processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, getExecutionAgentOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("direction"), String.class, getDirection(), this);
		processor.processBasic(path.newSubPath("direction2OfLeg1"), String.class, getDirection2OfLeg1(), this);
		processor.processBasic(path.newSubPath("direction2OfLeg2"), String.class, getDirection2OfLeg2(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, getNotionalLeg1(), this);
		processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, getNotionalLeg2(), this);
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
		processor.processBasic(path.newSubPath("notionalQuantityLeg1"), BigDecimal.class, getNotionalQuantityLeg1(), this);
		processor.processBasic(path.newSubPath("notionalQuantityLeg2"), BigDecimal.class, getNotionalQuantityLeg2(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("notionalCurrencyLeg1"), ISOCurrencyCodeEnum.class, getNotionalCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("notionalCurrencyLeg2"), ISOCurrencyCodeEnum.class, getNotionalCurrencyLeg2(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.class, getNotionalAmountScheduleLeg1());
		processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.class, getNotionalAmountScheduleLeg2());
		processRosetta(path.newSubPath("price"), processor, PriceAndNotation.class, getPrice());
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, getFixedRateLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, getFixedRateLeg2(), this);
		processor.processBasic(path.newSubPath("spreadNotationLeg1"), String.class, getSpreadNotationLeg1(), this);
		processRosetta(path.newSubPath("spreadLeg1"), processor, SpreadLeg1.class, getSpreadLeg1());
		processor.processBasic(path.newSubPath("spreadNotationLeg2"), String.class, getSpreadNotationLeg2(), this);
		processRosetta(path.newSubPath("spreadLeg2"), processor, SpreadLeg2.class, getSpreadLeg2());
		processor.processBasic(path.newSubPath("spreadCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSpreadCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("spreadCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSpreadCurrencyLeg2(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.class, getStrikePrice());
		processRosetta(path.newSubPath("barrier"), processor, BarrierAndNotation.class, getBarrier());
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("dayCountConventionLeg1"), InterestComputationMethod4Code.class, getDayCountConventionLeg1(), this);
		processor.processBasic(path.newSubPath("dayCountConventionLeg2"), InterestComputationMethod4Code.class, getDayCountConventionLeg2(), this);
		processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg1"), String.class, getPaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg2"), String.class, getPaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg1"), Integer.class, getPaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg2"), Integer.class, getPaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg2(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.class, getOtherPayment());
		processRosetta(path.newSubPath("customBasketCode"), processor, ASICCustomBasket.class, getCustomBasketCode());
		processRosetta(path.newSubPath("basket"), processor, Basket.class, getBasket());
		processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
		processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
		processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
		processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, getUnderlyingIdOtherSource(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateLeg2"), String.class, getIndicatorOfTheFloatingRateLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg2TimePeriod(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg2Multiplier(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.class, getPackageTransactionPrice());
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUtiProprietary"), String.class, getPriorUtiProprietary(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("newDerivativeTradeRepository"), String.class, getNewDerivativeTradeRepository(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, getNextFloatingReferenceResetDateLeg1(), this);
		processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, getNextFloatingReferenceResetDateLeg2(), this);
		processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, getSmallScaleBuySideEntityIndicator(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioCodeInitialMargin"), String.class, getCollateralPortfolioCodeInitialMargin(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioCodeVariationMargin"), String.class, getCollateralPortfolioCodeVariationMargin(), this);
		processor.processBasic(path.newSubPath("executionAgentOfCounterparty2DTCC"), String.class, getExecutionAgentOfCounterparty2DTCC(), this);
		processRosetta(path.newSubPath("nonReportable"), processor, ASICNonReportable.class, getNonReportable());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ASICTransactionReportBuilder extends ASICTransactionReport, RosettaModelObjectBuilder {
		NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1();
		NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2();
		PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice();
		@Override
		PriceAndNotation.PriceAndNotationBuilder getPrice();
		SpreadLeg1.SpreadLeg1Builder getOrCreateSpreadLeg1();
		@Override
		SpreadLeg1.SpreadLeg1Builder getSpreadLeg1();
		SpreadLeg2.SpreadLeg2Builder getOrCreateSpreadLeg2();
		@Override
		SpreadLeg2.SpreadLeg2Builder getSpreadLeg2();
		StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice();
		@Override
		StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice();
		BarrierAndNotation.BarrierAndNotationBuilder getOrCreateBarrier();
		@Override
		BarrierAndNotation.BarrierAndNotationBuilder getBarrier();
		OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index);
		@Override
		List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment();
		ASICCustomBasket.ASICCustomBasketBuilder getOrCreateCustomBasketCode();
		@Override
		ASICCustomBasket.ASICCustomBasketBuilder getCustomBasketCode();
		Basket.BasketBuilder getOrCreateBasket();
		@Override
		Basket.BasketBuilder getBasket();
		PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice();
		@Override
		PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice();
		PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread();
		@Override
		PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread();
		ASICNonReportable.ASICNonReportableBuilder getOrCreateNonReportable();
		@Override
		ASICNonReportable.ASICNonReportableBuilder getNonReportable();
		ASICTransactionReport.ASICTransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		ASICTransactionReport.ASICTransactionReportBuilder setUtiProprietaryID(String utiProprietaryID);
		ASICTransactionReport.ASICTransactionReportBuilder setSecondaryTransactionIdentifier(String secondaryTransactionIdentifier);
		ASICTransactionReport.ASICTransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		ASICTransactionReport.ASICTransactionReportBuilder setAssetClass(String assetClass);
		ASICTransactionReport.ASICTransactionReportBuilder setContractType(String contractType);
		ASICTransactionReport.ASICTransactionReportBuilder setReportingEntity(String reportingEntity);
		ASICTransactionReport.ASICTransactionReportBuilder setCounterparty1(String counterparty1);
		ASICTransactionReport.ASICTransactionReportBuilder setCounterparty2(String counterparty2);
		ASICTransactionReport.ASICTransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		ASICTransactionReport.ASICTransactionReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean counterparty2IdentifierTypeIndicator);
		ASICTransactionReport.ASICTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum countryOfTheCounterParty2);
		ASICTransactionReport.ASICTransactionReportBuilder setBeneficiary1(String beneficiary1);
		ASICTransactionReport.ASICTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean beneficiary1IdentifierTypeIndicator);
		ASICTransactionReport.ASICTransactionReportBuilder setBroker(String broker);
		ASICTransactionReport.ASICTransactionReportBuilder setExecutionAgentOfCounterparty1(String executionAgentOfCounterparty1);
		ASICTransactionReport.ASICTransactionReportBuilder setDirection(String direction);
		ASICTransactionReport.ASICTransactionReportBuilder setDirection2OfLeg1(String direction2OfLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setDirection2OfLeg2(String direction2OfLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setEffectiveDate(Date effectiveDate);
		ASICTransactionReport.ASICTransactionReportBuilder setExpirationDate(Date expirationDate);
		ASICTransactionReport.ASICTransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		ASICTransactionReport.ASICTransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		ASICTransactionReport.ASICTransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		ASICTransactionReport.ASICTransactionReportBuilder setCleared(String cleared);
		ASICTransactionReport.ASICTransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		ASICTransactionReport.ASICTransactionReportBuilder setClearingMember(String clearingMember);
		ASICTransactionReport.ASICTransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		ASICTransactionReport.ASICTransactionReportBuilder setNotionalLeg1(BigDecimal notionalLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setNotionalLeg2(BigDecimal notionalLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal totalNotionalQuantityLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal totalNotionalQuantityLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setNotionalQuantityLeg1(BigDecimal notionalQuantityLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setNotionalQuantityLeg2(BigDecimal notionalQuantityLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setCallAmount(BigDecimal callAmount);
		ASICTransactionReport.ASICTransactionReportBuilder setPutAmount(BigDecimal putAmount);
		ASICTransactionReport.ASICTransactionReportBuilder setNotionalCurrencyLeg1(ISOCurrencyCodeEnum notionalCurrencyLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setNotionalCurrencyLeg2(ISOCurrencyCodeEnum notionalCurrencyLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		ASICTransactionReport.ASICTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1, int idx);
		ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2, int idx);
		ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setPrice(PriceAndNotation price);
		ASICTransactionReport.ASICTransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		ASICTransactionReport.ASICTransactionReportBuilder setFixedRateLeg1(BigDecimal fixedRateLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setFixedRateLeg2(BigDecimal fixedRateLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setSpreadNotationLeg1(String spreadNotationLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setSpreadLeg1(SpreadLeg1 spreadLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setSpreadNotationLeg2(String spreadNotationLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setSpreadLeg2(SpreadLeg2 spreadLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setSpreadCurrencyLeg1(ISOCurrencyCodeEnum spreadCurrencyLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setSpreadCurrencyLeg2(ISOCurrencyCodeEnum spreadCurrencyLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setStrikePrice(StrikePriceAndNotation strikePrice);
		ASICTransactionReport.ASICTransactionReportBuilder setBarrier(BarrierAndNotation barrier);
		ASICTransactionReport.ASICTransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		ASICTransactionReport.ASICTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		ASICTransactionReport.ASICTransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		ASICTransactionReport.ASICTransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		ASICTransactionReport.ASICTransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		ASICTransactionReport.ASICTransactionReportBuilder setDayCountConventionLeg1(InterestComputationMethod4Code dayCountConventionLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setDayCountConventionLeg2(InterestComputationMethod4Code dayCountConventionLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setPaymentFrequencyPeriodLeg1(String paymentFrequencyPeriodLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setPaymentFrequencyPeriodLeg2(String paymentFrequencyPeriodLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setPaymentFrequencyPeriodMultiplierLeg1(Integer paymentFrequencyPeriodMultiplierLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setPaymentFrequencyPeriodMultiplierLeg2(Integer paymentFrequencyPeriodMultiplierLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum settlementCurrencyLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum settlementCurrencyLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment);
		ASICTransactionReport.ASICTransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment, int idx);
		ASICTransactionReport.ASICTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		ASICTransactionReport.ASICTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		ASICTransactionReport.ASICTransactionReportBuilder setCustomBasketCode(ASICCustomBasket customBasketCode);
		ASICTransactionReport.ASICTransactionReportBuilder setBasket(Basket basket);
		ASICTransactionReport.ASICTransactionReportBuilder setUnderlyingIdentification(String underlyingIdentification);
		ASICTransactionReport.ASICTransactionReportBuilder setUnderlyingIdentificationType(String underlyingIdentificationType);
		ASICTransactionReport.ASICTransactionReportBuilder setUnderlyingIdOther(String underlyingIdOther);
		ASICTransactionReport.ASICTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum underlyingIdOtherSource);
		ASICTransactionReport.ASICTransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		ASICTransactionReport.ASICTransactionReportBuilder setIndicatorOfTheFloatingRateLeg2(String indicatorOfTheFloatingRateLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String floatingRateReferencePeriodOfLeg2TimePeriod);
		ASICTransactionReport.ASICTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer floatingRateReferencePeriodOfLeg2Multiplier);
		ASICTransactionReport.ASICTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		ASICTransactionReport.ASICTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		ASICTransactionReport.ASICTransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		ASICTransactionReport.ASICTransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		ASICTransactionReport.ASICTransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice packageTransactionPrice);
		ASICTransactionReport.ASICTransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread packageTransactionSpread);
		ASICTransactionReport.ASICTransactionReportBuilder setPriorUTI(String priorUTI);
		ASICTransactionReport.ASICTransactionReportBuilder setPriorUtiProprietary(String priorUtiProprietary);
		ASICTransactionReport.ASICTransactionReportBuilder setEventIdentifier(String eventIdentifier);
		ASICTransactionReport.ASICTransactionReportBuilder setActionType(String actionType);
		ASICTransactionReport.ASICTransactionReportBuilder setEventType(String eventType);
		ASICTransactionReport.ASICTransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		ASICTransactionReport.ASICTransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		ASICTransactionReport.ASICTransactionReportBuilder setNewDerivativeTradeRepository(String newDerivativeTradeRepository);
		ASICTransactionReport.ASICTransactionReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		ASICTransactionReport.ASICTransactionReportBuilder setValuationAmount(BigDecimal valuationAmount);
		ASICTransactionReport.ASICTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		ASICTransactionReport.ASICTransactionReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		ASICTransactionReport.ASICTransactionReportBuilder setDelta(BigDecimal delta);
		ASICTransactionReport.ASICTransactionReportBuilder setNextFloatingReferenceResetDateLeg1(Date nextFloatingReferenceResetDateLeg1);
		ASICTransactionReport.ASICTransactionReportBuilder setNextFloatingReferenceResetDateLeg2(Date nextFloatingReferenceResetDateLeg2);
		ASICTransactionReport.ASICTransactionReportBuilder setSmallScaleBuySideEntityIndicator(String smallScaleBuySideEntityIndicator);
		ASICTransactionReport.ASICTransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		ASICTransactionReport.ASICTransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		ASICTransactionReport.ASICTransactionReportBuilder setCollateralPortfolioCodeInitialMargin(String collateralPortfolioCodeInitialMargin);
		ASICTransactionReport.ASICTransactionReportBuilder setCollateralPortfolioCodeVariationMargin(String collateralPortfolioCodeVariationMargin);
		ASICTransactionReport.ASICTransactionReportBuilder setExecutionAgentOfCounterparty2DTCC(String executionAgentOfCounterparty2DTCC);
		ASICTransactionReport.ASICTransactionReportBuilder setNonReportable(ASICNonReportable nonReportable);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("utiProprietaryID"), String.class, getUtiProprietaryID(), this);
			processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, getSecondaryTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
			processor.processBasic(path.newSubPath("reportingEntity"), String.class, getReportingEntity(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, getCounterparty2IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
			processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
			processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("broker"), String.class, getBroker(), this);
			processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, getExecutionAgentOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("direction"), String.class, getDirection(), this);
			processor.processBasic(path.newSubPath("direction2OfLeg1"), String.class, getDirection2OfLeg1(), this);
			processor.processBasic(path.newSubPath("direction2OfLeg2"), String.class, getDirection2OfLeg2(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, getNotionalLeg1(), this);
			processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, getNotionalLeg2(), this);
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
			processor.processBasic(path.newSubPath("notionalQuantityLeg1"), BigDecimal.class, getNotionalQuantityLeg1(), this);
			processor.processBasic(path.newSubPath("notionalQuantityLeg2"), BigDecimal.class, getNotionalQuantityLeg2(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("notionalCurrencyLeg1"), ISOCurrencyCodeEnum.class, getNotionalCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("notionalCurrencyLeg2"), ISOCurrencyCodeEnum.class, getNotionalCurrencyLeg2(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder.class, getNotionalAmountScheduleLeg1());
			processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder.class, getNotionalAmountScheduleLeg2());
			processRosetta(path.newSubPath("price"), processor, PriceAndNotation.PriceAndNotationBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, getFixedRateLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, getFixedRateLeg2(), this);
			processor.processBasic(path.newSubPath("spreadNotationLeg1"), String.class, getSpreadNotationLeg1(), this);
			processRosetta(path.newSubPath("spreadLeg1"), processor, SpreadLeg1.SpreadLeg1Builder.class, getSpreadLeg1());
			processor.processBasic(path.newSubPath("spreadNotationLeg2"), String.class, getSpreadNotationLeg2(), this);
			processRosetta(path.newSubPath("spreadLeg2"), processor, SpreadLeg2.SpreadLeg2Builder.class, getSpreadLeg2());
			processor.processBasic(path.newSubPath("spreadCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSpreadCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("spreadCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSpreadCurrencyLeg2(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.StrikePriceAndNotationBuilder.class, getStrikePrice());
			processRosetta(path.newSubPath("barrier"), processor, BarrierAndNotation.BarrierAndNotationBuilder.class, getBarrier());
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("dayCountConventionLeg1"), InterestComputationMethod4Code.class, getDayCountConventionLeg1(), this);
			processor.processBasic(path.newSubPath("dayCountConventionLeg2"), InterestComputationMethod4Code.class, getDayCountConventionLeg2(), this);
			processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg1"), String.class, getPaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("paymentFrequencyPeriodLeg2"), String.class, getPaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg1"), Integer.class, getPaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("paymentFrequencyPeriodMultiplierLeg2"), Integer.class, getPaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg2(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.OtherPaymentReportBuilder.class, getOtherPayment());
			processRosetta(path.newSubPath("customBasketCode"), processor, ASICCustomBasket.ASICCustomBasketBuilder.class, getCustomBasketCode());
			processRosetta(path.newSubPath("basket"), processor, Basket.BasketBuilder.class, getBasket());
			processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
			processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
			processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
			processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, getUnderlyingIdOtherSource(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateLeg2"), String.class, getIndicatorOfTheFloatingRateLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg2TimePeriod(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg2Multiplier(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PackageTransactionPrice.PackageTransactionPriceBuilder.class, getPackageTransactionPrice());
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PackageTransactionSpread.PackageTransactionSpreadBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUtiProprietary"), String.class, getPriorUtiProprietary(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("newDerivativeTradeRepository"), String.class, getNewDerivativeTradeRepository(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, getNextFloatingReferenceResetDateLeg1(), this);
			processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, getNextFloatingReferenceResetDateLeg2(), this);
			processor.processBasic(path.newSubPath("smallScaleBuySideEntityIndicator"), String.class, getSmallScaleBuySideEntityIndicator(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioCodeInitialMargin"), String.class, getCollateralPortfolioCodeInitialMargin(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioCodeVariationMargin"), String.class, getCollateralPortfolioCodeVariationMargin(), this);
			processor.processBasic(path.newSubPath("executionAgentOfCounterparty2DTCC"), String.class, getExecutionAgentOfCounterparty2DTCC(), this);
			processRosetta(path.newSubPath("nonReportable"), processor, ASICNonReportable.ASICNonReportableBuilder.class, getNonReportable());
		}
		

		ASICTransactionReport.ASICTransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of ASICTransactionReport  ***********************/
	class ASICTransactionReportImpl implements ASICTransactionReport {
		private final String uniqueTransactionIdentifier;
		private final String utiProprietaryID;
		private final String secondaryTransactionIdentifier;
		private final String uniqueProductIdentifier;
		private final String assetClass;
		private final String contractType;
		private final String reportingEntity;
		private final String counterparty1;
		private final String counterparty2;
		private final String counterparty2Name;
		private final Boolean counterparty2IdentifierTypeIndicator;
		private final ISOCountryCodeEnum countryOfTheCounterParty2;
		private final String beneficiary1;
		private final Boolean beneficiary1IdentifierTypeIndicator;
		private final String broker;
		private final String executionAgentOfCounterparty1;
		private final String direction;
		private final String direction2OfLeg1;
		private final String direction2OfLeg2;
		private final Date effectiveDate;
		private final Date expirationDate;
		private final ZonedDateTime executionTimestamp;
		private final ZonedDateTime eventTimestamp;
		private final ZonedDateTime clearingTimestamp;
		private final String cleared;
		private final String centralCounterparty;
		private final String clearingMember;
		private final String platformIdentifier;
		private final BigDecimal notionalLeg1;
		private final BigDecimal notionalLeg2;
		private final BigDecimal totalNotionalQuantityLeg1;
		private final BigDecimal totalNotionalQuantityLeg2;
		private final BigDecimal notionalQuantityLeg1;
		private final BigDecimal notionalQuantityLeg2;
		private final BigDecimal callAmount;
		private final BigDecimal putAmount;
		private final ISOCurrencyCodeEnum notionalCurrencyLeg1;
		private final ISOCurrencyCodeEnum notionalCurrencyLeg2;
		private final String quantityUnitOfMeasureLeg1;
		private final String quantityUnitOfMeasureLeg2;
		private final ISOCurrencyCodeEnum callCurrency;
		private final ISOCurrencyCodeEnum putCurrency;
		private final List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1;
		private final List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2;
		private final PriceAndNotation price;
		private final String priceUnitOfMeasure;
		private final BigDecimal fixedRateLeg1;
		private final BigDecimal fixedRateLeg2;
		private final String spreadNotationLeg1;
		private final SpreadLeg1 spreadLeg1;
		private final String spreadNotationLeg2;
		private final SpreadLeg2 spreadLeg2;
		private final ISOCurrencyCodeEnum spreadCurrencyLeg1;
		private final ISOCurrencyCodeEnum spreadCurrencyLeg2;
		private final StrikePriceAndNotation strikePrice;
		private final BarrierAndNotation barrier;
		private final BigDecimal optionPremiumAmount;
		private final ISOCurrencyCodeEnum optionPremiumCurrency;
		private final Date optionPremiumPaymentDate;
		private final BigDecimal exchangeRate;
		private final String exchangeRateBasis;
		private final InterestComputationMethod4Code dayCountConventionLeg1;
		private final InterestComputationMethod4Code dayCountConventionLeg2;
		private final String paymentFrequencyPeriodLeg1;
		private final String paymentFrequencyPeriodLeg2;
		private final Integer paymentFrequencyPeriodMultiplierLeg1;
		private final Integer paymentFrequencyPeriodMultiplierLeg2;
		private final ISOCurrencyCodeEnum settlementCurrencyLeg1;
		private final ISOCurrencyCodeEnum settlementCurrencyLeg2;
		private final List<? extends OtherPaymentReport> otherPayment;
		private final ASICCustomBasket customBasketCode;
		private final Basket basket;
		private final String underlyingIdentification;
		private final String underlyingIdentificationType;
		private final String underlyingIdOther;
		private final ProductIdTypeEnum underlyingIdOtherSource;
		private final Date maturityDateOfTheUnderlying;
		private final String indicatorOfTheFloatingRateLeg2;
		private final String floatingRateReferencePeriodOfLeg2TimePeriod;
		private final Integer floatingRateReferencePeriodOfLeg2Multiplier;
		private final BigDecimal cdSIndexAttachmentPoint;
		private final BigDecimal cdSIndexDetachmentPoint;
		private final BigDecimal indexFactor;
		private final String packageIdentifier;
		private final PackageTransactionPrice packageTransactionPrice;
		private final PackageTransactionSpread packageTransactionSpread;
		private final String priorUTI;
		private final String priorUtiProprietary;
		private final String eventIdentifier;
		private final String actionType;
		private final String eventType;
		private final ZonedDateTime reportingTimestamp;
		private final String reportSubmittingEntityID;
		private final String newDerivativeTradeRepository;
		private final ZonedDateTime valuationTimestamp;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ValuationType1Code valuationMethod;
		private final BigDecimal delta;
		private final Date nextFloatingReferenceResetDateLeg1;
		private final Date nextFloatingReferenceResetDateLeg2;
		private final String smallScaleBuySideEntityIndicator;
		private final String technicalRecordId;
		private final Boolean collateralPortfolioIndicator;
		private final String collateralPortfolioCodeInitialMargin;
		private final String collateralPortfolioCodeVariationMargin;
		private final String executionAgentOfCounterparty2DTCC;
		private final ASICNonReportable nonReportable;
		
		protected ASICTransactionReportImpl(ASICTransactionReport.ASICTransactionReportBuilder builder) {
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.utiProprietaryID = builder.getUtiProprietaryID();
			this.secondaryTransactionIdentifier = builder.getSecondaryTransactionIdentifier();
			this.uniqueProductIdentifier = builder.getUniqueProductIdentifier();
			this.assetClass = builder.getAssetClass();
			this.contractType = builder.getContractType();
			this.reportingEntity = builder.getReportingEntity();
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2Name = builder.getCounterparty2Name();
			this.counterparty2IdentifierTypeIndicator = builder.getCounterparty2IdentifierTypeIndicator();
			this.countryOfTheCounterParty2 = builder.getCountryOfTheCounterParty2();
			this.beneficiary1 = builder.getBeneficiary1();
			this.beneficiary1IdentifierTypeIndicator = builder.getBeneficiary1IdentifierTypeIndicator();
			this.broker = builder.getBroker();
			this.executionAgentOfCounterparty1 = builder.getExecutionAgentOfCounterparty1();
			this.direction = builder.getDirection();
			this.direction2OfLeg1 = builder.getDirection2OfLeg1();
			this.direction2OfLeg2 = builder.getDirection2OfLeg2();
			this.effectiveDate = builder.getEffectiveDate();
			this.expirationDate = builder.getExpirationDate();
			this.executionTimestamp = builder.getExecutionTimestamp();
			this.eventTimestamp = builder.getEventTimestamp();
			this.clearingTimestamp = builder.getClearingTimestamp();
			this.cleared = builder.getCleared();
			this.centralCounterparty = builder.getCentralCounterparty();
			this.clearingMember = builder.getClearingMember();
			this.platformIdentifier = builder.getPlatformIdentifier();
			this.notionalLeg1 = builder.getNotionalLeg1();
			this.notionalLeg2 = builder.getNotionalLeg2();
			this.totalNotionalQuantityLeg1 = builder.getTotalNotionalQuantityLeg1();
			this.totalNotionalQuantityLeg2 = builder.getTotalNotionalQuantityLeg2();
			this.notionalQuantityLeg1 = builder.getNotionalQuantityLeg1();
			this.notionalQuantityLeg2 = builder.getNotionalQuantityLeg2();
			this.callAmount = builder.getCallAmount();
			this.putAmount = builder.getPutAmount();
			this.notionalCurrencyLeg1 = builder.getNotionalCurrencyLeg1();
			this.notionalCurrencyLeg2 = builder.getNotionalCurrencyLeg2();
			this.quantityUnitOfMeasureLeg1 = builder.getQuantityUnitOfMeasureLeg1();
			this.quantityUnitOfMeasureLeg2 = builder.getQuantityUnitOfMeasureLeg2();
			this.callCurrency = builder.getCallCurrency();
			this.putCurrency = builder.getPutCurrency();
			this.notionalAmountScheduleLeg1 = ofNullable(builder.getNotionalAmountScheduleLeg1()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.notionalAmountScheduleLeg2 = ofNullable(builder.getNotionalAmountScheduleLeg2()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.price = ofNullable(builder.getPrice()).map(f->f.build()).orElse(null);
			this.priceUnitOfMeasure = builder.getPriceUnitOfMeasure();
			this.fixedRateLeg1 = builder.getFixedRateLeg1();
			this.fixedRateLeg2 = builder.getFixedRateLeg2();
			this.spreadNotationLeg1 = builder.getSpreadNotationLeg1();
			this.spreadLeg1 = ofNullable(builder.getSpreadLeg1()).map(f->f.build()).orElse(null);
			this.spreadNotationLeg2 = builder.getSpreadNotationLeg2();
			this.spreadLeg2 = ofNullable(builder.getSpreadLeg2()).map(f->f.build()).orElse(null);
			this.spreadCurrencyLeg1 = builder.getSpreadCurrencyLeg1();
			this.spreadCurrencyLeg2 = builder.getSpreadCurrencyLeg2();
			this.strikePrice = ofNullable(builder.getStrikePrice()).map(f->f.build()).orElse(null);
			this.barrier = ofNullable(builder.getBarrier()).map(f->f.build()).orElse(null);
			this.optionPremiumAmount = builder.getOptionPremiumAmount();
			this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
			this.optionPremiumPaymentDate = builder.getOptionPremiumPaymentDate();
			this.exchangeRate = builder.getExchangeRate();
			this.exchangeRateBasis = builder.getExchangeRateBasis();
			this.dayCountConventionLeg1 = builder.getDayCountConventionLeg1();
			this.dayCountConventionLeg2 = builder.getDayCountConventionLeg2();
			this.paymentFrequencyPeriodLeg1 = builder.getPaymentFrequencyPeriodLeg1();
			this.paymentFrequencyPeriodLeg2 = builder.getPaymentFrequencyPeriodLeg2();
			this.paymentFrequencyPeriodMultiplierLeg1 = builder.getPaymentFrequencyPeriodMultiplierLeg1();
			this.paymentFrequencyPeriodMultiplierLeg2 = builder.getPaymentFrequencyPeriodMultiplierLeg2();
			this.settlementCurrencyLeg1 = builder.getSettlementCurrencyLeg1();
			this.settlementCurrencyLeg2 = builder.getSettlementCurrencyLeg2();
			this.otherPayment = ofNullable(builder.getOtherPayment()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.customBasketCode = ofNullable(builder.getCustomBasketCode()).map(f->f.build()).orElse(null);
			this.basket = ofNullable(builder.getBasket()).map(f->f.build()).orElse(null);
			this.underlyingIdentification = builder.getUnderlyingIdentification();
			this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
			this.underlyingIdOther = builder.getUnderlyingIdOther();
			this.underlyingIdOtherSource = builder.getUnderlyingIdOtherSource();
			this.maturityDateOfTheUnderlying = builder.getMaturityDateOfTheUnderlying();
			this.indicatorOfTheFloatingRateLeg2 = builder.getIndicatorOfTheFloatingRateLeg2();
			this.floatingRateReferencePeriodOfLeg2TimePeriod = builder.getFloatingRateReferencePeriodOfLeg2TimePeriod();
			this.floatingRateReferencePeriodOfLeg2Multiplier = builder.getFloatingRateReferencePeriodOfLeg2Multiplier();
			this.cdSIndexAttachmentPoint = builder.getCdSIndexAttachmentPoint();
			this.cdSIndexDetachmentPoint = builder.getCdSIndexDetachmentPoint();
			this.indexFactor = builder.getIndexFactor();
			this.packageIdentifier = builder.getPackageIdentifier();
			this.packageTransactionPrice = ofNullable(builder.getPackageTransactionPrice()).map(f->f.build()).orElse(null);
			this.packageTransactionSpread = ofNullable(builder.getPackageTransactionSpread()).map(f->f.build()).orElse(null);
			this.priorUTI = builder.getPriorUTI();
			this.priorUtiProprietary = builder.getPriorUtiProprietary();
			this.eventIdentifier = builder.getEventIdentifier();
			this.actionType = builder.getActionType();
			this.eventType = builder.getEventType();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
			this.newDerivativeTradeRepository = builder.getNewDerivativeTradeRepository();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationMethod = builder.getValuationMethod();
			this.delta = builder.getDelta();
			this.nextFloatingReferenceResetDateLeg1 = builder.getNextFloatingReferenceResetDateLeg1();
			this.nextFloatingReferenceResetDateLeg2 = builder.getNextFloatingReferenceResetDateLeg2();
			this.smallScaleBuySideEntityIndicator = builder.getSmallScaleBuySideEntityIndicator();
			this.technicalRecordId = builder.getTechnicalRecordId();
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.collateralPortfolioCodeInitialMargin = builder.getCollateralPortfolioCodeInitialMargin();
			this.collateralPortfolioCodeVariationMargin = builder.getCollateralPortfolioCodeVariationMargin();
			this.executionAgentOfCounterparty2DTCC = builder.getExecutionAgentOfCounterparty2DTCC();
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("utiProprietaryID")
		@RuneAttribute("utiProprietaryID")
		public String getUtiProprietaryID() {
			return utiProprietaryID;
		}
		
		@Override
		@RosettaAttribute("secondaryTransactionIdentifier")
		@RuneAttribute("secondaryTransactionIdentifier")
		public String getSecondaryTransactionIdentifier() {
			return secondaryTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public String getUniqueProductIdentifier() {
			return uniqueProductIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute("reportingEntity")
		@RuneAttribute("reportingEntity")
		public String getReportingEntity() {
			return reportingEntity;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public String getCounterparty2Name() {
			return counterparty2Name;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		public Boolean getCounterparty2IdentifierTypeIndicator() {
			return counterparty2IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
			return countryOfTheCounterParty2;
		}
		
		@Override
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		public String getBeneficiary1() {
			return beneficiary1;
		}
		
		@Override
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		public Boolean getBeneficiary1IdentifierTypeIndicator() {
			return beneficiary1IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("broker")
		@RuneAttribute("broker")
		public String getBroker() {
			return broker;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfCounterparty1")
		@RuneAttribute("executionAgentOfCounterparty1")
		public String getExecutionAgentOfCounterparty1() {
			return executionAgentOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		public String getDirection() {
			return direction;
		}
		
		@Override
		@RosettaAttribute("direction2OfLeg1")
		@RuneAttribute("direction2OfLeg1")
		public String getDirection2OfLeg1() {
			return direction2OfLeg1;
		}
		
		@Override
		@RosettaAttribute("direction2OfLeg2")
		@RuneAttribute("direction2OfLeg2")
		public String getDirection2OfLeg2() {
			return direction2OfLeg2;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public ZonedDateTime getClearingTimestamp() {
			return clearingTimestamp;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public String getPlatformIdentifier() {
			return platformIdentifier;
		}
		
		@Override
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		public BigDecimal getNotionalLeg1() {
			return notionalLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		public BigDecimal getNotionalLeg2() {
			return notionalLeg2;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityLeg1")
		@RuneAttribute("notionalQuantityLeg1")
		public BigDecimal getNotionalQuantityLeg1() {
			return notionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityLeg2")
		@RuneAttribute("notionalQuantityLeg2")
		public BigDecimal getNotionalQuantityLeg2() {
			return notionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public BigDecimal getCallAmount() {
			return callAmount;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public BigDecimal getPutAmount() {
			return putAmount;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyLeg1")
		@RuneAttribute("notionalCurrencyLeg1")
		public ISOCurrencyCodeEnum getNotionalCurrencyLeg1() {
			return notionalCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyLeg2")
		@RuneAttribute("notionalCurrencyLeg2")
		public ISOCurrencyCodeEnum getNotionalCurrencyLeg2() {
			return notionalCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public String getQuantityUnitOfMeasureLeg1() {
			return quantityUnitOfMeasureLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public String getQuantityUnitOfMeasureLeg2() {
			return quantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public ISOCurrencyCodeEnum getCallCurrency() {
			return callCurrency;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public ISOCurrencyCodeEnum getPutCurrency() {
			return putCurrency;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1() {
			return notionalAmountScheduleLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2() {
			return notionalAmountScheduleLeg2;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public PriceAndNotation getPrice() {
			return price;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public String getPriceUnitOfMeasure() {
			return priceUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg1")
		@RuneAttribute("fixedRateLeg1")
		public BigDecimal getFixedRateLeg1() {
			return fixedRateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg2")
		@RuneAttribute("fixedRateLeg2")
		public BigDecimal getFixedRateLeg2() {
			return fixedRateLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadNotationLeg1")
		@RuneAttribute("spreadNotationLeg1")
		public String getSpreadNotationLeg1() {
			return spreadNotationLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1")
		@RuneAttribute("spreadLeg1")
		public SpreadLeg1 getSpreadLeg1() {
			return spreadLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadNotationLeg2")
		@RuneAttribute("spreadNotationLeg2")
		public String getSpreadNotationLeg2() {
			return spreadNotationLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2")
		@RuneAttribute("spreadLeg2")
		public SpreadLeg2 getSpreadLeg2() {
			return spreadLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyLeg1")
		@RuneAttribute("spreadCurrencyLeg1")
		public ISOCurrencyCodeEnum getSpreadCurrencyLeg1() {
			return spreadCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyLeg2")
		@RuneAttribute("spreadCurrencyLeg2")
		public ISOCurrencyCodeEnum getSpreadCurrencyLeg2() {
			return spreadCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public StrikePriceAndNotation getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public BarrierAndNotation getBarrier() {
			return barrier;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("dayCountConventionLeg1")
		@RuneAttribute("dayCountConventionLeg1")
		public InterestComputationMethod4Code getDayCountConventionLeg1() {
			return dayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("dayCountConventionLeg2")
		@RuneAttribute("dayCountConventionLeg2")
		public InterestComputationMethod4Code getDayCountConventionLeg2() {
			return dayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg1")
		@RuneAttribute("paymentFrequencyPeriodLeg1")
		public String getPaymentFrequencyPeriodLeg1() {
			return paymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg2")
		@RuneAttribute("paymentFrequencyPeriodLeg2")
		public String getPaymentFrequencyPeriodLeg2() {
			return paymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg1")
		public Integer getPaymentFrequencyPeriodMultiplierLeg1() {
			return paymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg2")
		public Integer getPaymentFrequencyPeriodMultiplierLeg2() {
			return paymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg1")
		@RuneAttribute("settlementCurrencyLeg1")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
			return settlementCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg2")
		@RuneAttribute("settlementCurrencyLeg2")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
			return settlementCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public ASICCustomBasket getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("basket")
		@RuneAttribute("basket")
		public Basket getBasket() {
			return basket;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public String getUnderlyingIdOther() {
			return underlyingIdOther;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public ProductIdTypeEnum getUnderlyingIdOtherSource() {
			return underlyingIdOtherSource;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateLeg2")
		public String getIndicatorOfTheFloatingRateLeg2() {
			return indicatorOfTheFloatingRateLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
			return floatingRateReferencePeriodOfLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
			return floatingRateReferencePeriodOfLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public BigDecimal getCdSIndexAttachmentPoint() {
			return cdSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public BigDecimal getCdSIndexDetachmentPoint() {
			return cdSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public PackageTransactionPrice getPackageTransactionPrice() {
			return packageTransactionPrice;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public PackageTransactionSpread getPackageTransactionSpread() {
			return packageTransactionSpread;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("priorUtiProprietary")
		@RuneAttribute("priorUtiProprietary")
		public String getPriorUtiProprietary() {
			return priorUtiProprietary;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public String getEventIdentifier() {
			return eventIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("newDerivativeTradeRepository")
		@RuneAttribute("newDerivativeTradeRepository")
		public String getNewDerivativeTradeRepository() {
			return newDerivativeTradeRepository;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		public Date getNextFloatingReferenceResetDateLeg1() {
			return nextFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		public Date getNextFloatingReferenceResetDateLeg2() {
			return nextFloatingReferenceResetDateLeg2;
		}
		
		@Override
		@RosettaAttribute("smallScaleBuySideEntityIndicator")
		@RuneAttribute("smallScaleBuySideEntityIndicator")
		public String getSmallScaleBuySideEntityIndicator() {
			return smallScaleBuySideEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCodeInitialMargin")
		@RuneAttribute("collateralPortfolioCodeInitialMargin")
		public String getCollateralPortfolioCodeInitialMargin() {
			return collateralPortfolioCodeInitialMargin;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCodeVariationMargin")
		@RuneAttribute("collateralPortfolioCodeVariationMargin")
		public String getCollateralPortfolioCodeVariationMargin() {
			return collateralPortfolioCodeVariationMargin;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfCounterparty2DTCC")
		@RuneAttribute("executionAgentOfCounterparty2DTCC")
		public String getExecutionAgentOfCounterparty2DTCC() {
			return executionAgentOfCounterparty2DTCC;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public ASICNonReportable getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public ASICTransactionReport build() {
			return this;
		}
		
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder toBuilder() {
			ASICTransactionReport.ASICTransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ASICTransactionReport.ASICTransactionReportBuilder builder) {
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getUtiProprietaryID()).ifPresent(builder::setUtiProprietaryID);
			ofNullable(getSecondaryTransactionIdentifier()).ifPresent(builder::setSecondaryTransactionIdentifier);
			ofNullable(getUniqueProductIdentifier()).ifPresent(builder::setUniqueProductIdentifier);
			ofNullable(getAssetClass()).ifPresent(builder::setAssetClass);
			ofNullable(getContractType()).ifPresent(builder::setContractType);
			ofNullable(getReportingEntity()).ifPresent(builder::setReportingEntity);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2Name()).ifPresent(builder::setCounterparty2Name);
			ofNullable(getCounterparty2IdentifierTypeIndicator()).ifPresent(builder::setCounterparty2IdentifierTypeIndicator);
			ofNullable(getCountryOfTheCounterParty2()).ifPresent(builder::setCountryOfTheCounterParty2);
			ofNullable(getBeneficiary1()).ifPresent(builder::setBeneficiary1);
			ofNullable(getBeneficiary1IdentifierTypeIndicator()).ifPresent(builder::setBeneficiary1IdentifierTypeIndicator);
			ofNullable(getBroker()).ifPresent(builder::setBroker);
			ofNullable(getExecutionAgentOfCounterparty1()).ifPresent(builder::setExecutionAgentOfCounterparty1);
			ofNullable(getDirection()).ifPresent(builder::setDirection);
			ofNullable(getDirection2OfLeg1()).ifPresent(builder::setDirection2OfLeg1);
			ofNullable(getDirection2OfLeg2()).ifPresent(builder::setDirection2OfLeg2);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getExpirationDate()).ifPresent(builder::setExpirationDate);
			ofNullable(getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
			ofNullable(getEventTimestamp()).ifPresent(builder::setEventTimestamp);
			ofNullable(getClearingTimestamp()).ifPresent(builder::setClearingTimestamp);
			ofNullable(getCleared()).ifPresent(builder::setCleared);
			ofNullable(getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
			ofNullable(getClearingMember()).ifPresent(builder::setClearingMember);
			ofNullable(getPlatformIdentifier()).ifPresent(builder::setPlatformIdentifier);
			ofNullable(getNotionalLeg1()).ifPresent(builder::setNotionalLeg1);
			ofNullable(getNotionalLeg2()).ifPresent(builder::setNotionalLeg2);
			ofNullable(getTotalNotionalQuantityLeg1()).ifPresent(builder::setTotalNotionalQuantityLeg1);
			ofNullable(getTotalNotionalQuantityLeg2()).ifPresent(builder::setTotalNotionalQuantityLeg2);
			ofNullable(getNotionalQuantityLeg1()).ifPresent(builder::setNotionalQuantityLeg1);
			ofNullable(getNotionalQuantityLeg2()).ifPresent(builder::setNotionalQuantityLeg2);
			ofNullable(getCallAmount()).ifPresent(builder::setCallAmount);
			ofNullable(getPutAmount()).ifPresent(builder::setPutAmount);
			ofNullable(getNotionalCurrencyLeg1()).ifPresent(builder::setNotionalCurrencyLeg1);
			ofNullable(getNotionalCurrencyLeg2()).ifPresent(builder::setNotionalCurrencyLeg2);
			ofNullable(getQuantityUnitOfMeasureLeg1()).ifPresent(builder::setQuantityUnitOfMeasureLeg1);
			ofNullable(getQuantityUnitOfMeasureLeg2()).ifPresent(builder::setQuantityUnitOfMeasureLeg2);
			ofNullable(getCallCurrency()).ifPresent(builder::setCallCurrency);
			ofNullable(getPutCurrency()).ifPresent(builder::setPutCurrency);
			ofNullable(getNotionalAmountScheduleLeg1()).ifPresent(builder::setNotionalAmountScheduleLeg1);
			ofNullable(getNotionalAmountScheduleLeg2()).ifPresent(builder::setNotionalAmountScheduleLeg2);
			ofNullable(getPrice()).ifPresent(builder::setPrice);
			ofNullable(getPriceUnitOfMeasure()).ifPresent(builder::setPriceUnitOfMeasure);
			ofNullable(getFixedRateLeg1()).ifPresent(builder::setFixedRateLeg1);
			ofNullable(getFixedRateLeg2()).ifPresent(builder::setFixedRateLeg2);
			ofNullable(getSpreadNotationLeg1()).ifPresent(builder::setSpreadNotationLeg1);
			ofNullable(getSpreadLeg1()).ifPresent(builder::setSpreadLeg1);
			ofNullable(getSpreadNotationLeg2()).ifPresent(builder::setSpreadNotationLeg2);
			ofNullable(getSpreadLeg2()).ifPresent(builder::setSpreadLeg2);
			ofNullable(getSpreadCurrencyLeg1()).ifPresent(builder::setSpreadCurrencyLeg1);
			ofNullable(getSpreadCurrencyLeg2()).ifPresent(builder::setSpreadCurrencyLeg2);
			ofNullable(getStrikePrice()).ifPresent(builder::setStrikePrice);
			ofNullable(getBarrier()).ifPresent(builder::setBarrier);
			ofNullable(getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
			ofNullable(getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
			ofNullable(getOptionPremiumPaymentDate()).ifPresent(builder::setOptionPremiumPaymentDate);
			ofNullable(getExchangeRate()).ifPresent(builder::setExchangeRate);
			ofNullable(getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
			ofNullable(getDayCountConventionLeg1()).ifPresent(builder::setDayCountConventionLeg1);
			ofNullable(getDayCountConventionLeg2()).ifPresent(builder::setDayCountConventionLeg2);
			ofNullable(getPaymentFrequencyPeriodLeg1()).ifPresent(builder::setPaymentFrequencyPeriodLeg1);
			ofNullable(getPaymentFrequencyPeriodLeg2()).ifPresent(builder::setPaymentFrequencyPeriodLeg2);
			ofNullable(getPaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setPaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getPaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setPaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getSettlementCurrencyLeg1()).ifPresent(builder::setSettlementCurrencyLeg1);
			ofNullable(getSettlementCurrencyLeg2()).ifPresent(builder::setSettlementCurrencyLeg2);
			ofNullable(getOtherPayment()).ifPresent(builder::setOtherPayment);
			ofNullable(getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
			ofNullable(getBasket()).ifPresent(builder::setBasket);
			ofNullable(getUnderlyingIdentification()).ifPresent(builder::setUnderlyingIdentification);
			ofNullable(getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
			ofNullable(getUnderlyingIdOther()).ifPresent(builder::setUnderlyingIdOther);
			ofNullable(getUnderlyingIdOtherSource()).ifPresent(builder::setUnderlyingIdOtherSource);
			ofNullable(getMaturityDateOfTheUnderlying()).ifPresent(builder::setMaturityDateOfTheUnderlying);
			ofNullable(getIndicatorOfTheFloatingRateLeg2()).ifPresent(builder::setIndicatorOfTheFloatingRateLeg2);
			ofNullable(getFloatingRateReferencePeriodOfLeg2TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2TimePeriod);
			ofNullable(getFloatingRateReferencePeriodOfLeg2Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2Multiplier);
			ofNullable(getCdSIndexAttachmentPoint()).ifPresent(builder::setCdSIndexAttachmentPoint);
			ofNullable(getCdSIndexDetachmentPoint()).ifPresent(builder::setCdSIndexDetachmentPoint);
			ofNullable(getIndexFactor()).ifPresent(builder::setIndexFactor);
			ofNullable(getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
			ofNullable(getPackageTransactionPrice()).ifPresent(builder::setPackageTransactionPrice);
			ofNullable(getPackageTransactionSpread()).ifPresent(builder::setPackageTransactionSpread);
			ofNullable(getPriorUTI()).ifPresent(builder::setPriorUTI);
			ofNullable(getPriorUtiProprietary()).ifPresent(builder::setPriorUtiProprietary);
			ofNullable(getEventIdentifier()).ifPresent(builder::setEventIdentifier);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getEventType()).ifPresent(builder::setEventType);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
			ofNullable(getNewDerivativeTradeRepository()).ifPresent(builder::setNewDerivativeTradeRepository);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getDelta()).ifPresent(builder::setDelta);
			ofNullable(getNextFloatingReferenceResetDateLeg1()).ifPresent(builder::setNextFloatingReferenceResetDateLeg1);
			ofNullable(getNextFloatingReferenceResetDateLeg2()).ifPresent(builder::setNextFloatingReferenceResetDateLeg2);
			ofNullable(getSmallScaleBuySideEntityIndicator()).ifPresent(builder::setSmallScaleBuySideEntityIndicator);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getCollateralPortfolioCodeInitialMargin()).ifPresent(builder::setCollateralPortfolioCodeInitialMargin);
			ofNullable(getCollateralPortfolioCodeVariationMargin()).ifPresent(builder::setCollateralPortfolioCodeVariationMargin);
			ofNullable(getExecutionAgentOfCounterparty2DTCC()).ifPresent(builder::setExecutionAgentOfCounterparty2DTCC);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(utiProprietaryID, _that.getUtiProprietaryID())) return false;
			if (!Objects.equals(secondaryTransactionIdentifier, _that.getSecondaryTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueProductIdentifier, _that.getUniqueProductIdentifier())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(reportingEntity, _that.getReportingEntity())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2Name, _that.getCounterparty2Name())) return false;
			if (!Objects.equals(counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) return false;
			if (!Objects.equals(countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) return false;
			if (!Objects.equals(beneficiary1, _that.getBeneficiary1())) return false;
			if (!Objects.equals(beneficiary1IdentifierTypeIndicator, _that.getBeneficiary1IdentifierTypeIndicator())) return false;
			if (!Objects.equals(broker, _that.getBroker())) return false;
			if (!Objects.equals(executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) return false;
			if (!Objects.equals(direction, _that.getDirection())) return false;
			if (!Objects.equals(direction2OfLeg1, _that.getDirection2OfLeg1())) return false;
			if (!Objects.equals(direction2OfLeg2, _that.getDirection2OfLeg2())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(clearingTimestamp, _that.getClearingTimestamp())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(platformIdentifier, _that.getPlatformIdentifier())) return false;
			if (!Objects.equals(notionalLeg1, _that.getNotionalLeg1())) return false;
			if (!Objects.equals(notionalLeg2, _that.getNotionalLeg2())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(notionalQuantityLeg1, _that.getNotionalQuantityLeg1())) return false;
			if (!Objects.equals(notionalQuantityLeg2, _that.getNotionalQuantityLeg2())) return false;
			if (!Objects.equals(callAmount, _that.getCallAmount())) return false;
			if (!Objects.equals(putAmount, _that.getPutAmount())) return false;
			if (!Objects.equals(notionalCurrencyLeg1, _that.getNotionalCurrencyLeg1())) return false;
			if (!Objects.equals(notionalCurrencyLeg2, _that.getNotionalCurrencyLeg2())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) return false;
			if (!Objects.equals(callCurrency, _that.getCallCurrency())) return false;
			if (!Objects.equals(putCurrency, _that.getPutCurrency())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!Objects.equals(priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) return false;
			if (!Objects.equals(fixedRateLeg1, _that.getFixedRateLeg1())) return false;
			if (!Objects.equals(fixedRateLeg2, _that.getFixedRateLeg2())) return false;
			if (!Objects.equals(spreadNotationLeg1, _that.getSpreadNotationLeg1())) return false;
			if (!Objects.equals(spreadLeg1, _that.getSpreadLeg1())) return false;
			if (!Objects.equals(spreadNotationLeg2, _that.getSpreadNotationLeg2())) return false;
			if (!Objects.equals(spreadLeg2, _that.getSpreadLeg2())) return false;
			if (!Objects.equals(spreadCurrencyLeg1, _that.getSpreadCurrencyLeg1())) return false;
			if (!Objects.equals(spreadCurrencyLeg2, _that.getSpreadCurrencyLeg2())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!Objects.equals(barrier, _that.getBarrier())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(dayCountConventionLeg1, _that.getDayCountConventionLeg1())) return false;
			if (!Objects.equals(dayCountConventionLeg2, _that.getDayCountConventionLeg2())) return false;
			if (!Objects.equals(paymentFrequencyPeriodLeg1, _that.getPaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(paymentFrequencyPeriodLeg2, _that.getPaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(paymentFrequencyPeriodMultiplierLeg1, _that.getPaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(paymentFrequencyPeriodMultiplierLeg2, _that.getPaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) return false;
			if (!Objects.equals(settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(basket, _that.getBasket())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdOther, _that.getUnderlyingIdOther())) return false;
			if (!Objects.equals(underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateLeg2, _that.getIndicatorOfTheFloatingRateLeg2())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) return false;
			if (!Objects.equals(cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(packageTransactionPrice, _that.getPackageTransactionPrice())) return false;
			if (!Objects.equals(packageTransactionSpread, _that.getPackageTransactionSpread())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(priorUtiProprietary, _that.getPriorUtiProprietary())) return false;
			if (!Objects.equals(eventIdentifier, _that.getEventIdentifier())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(newDerivativeTradeRepository, _that.getNewDerivativeTradeRepository())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) return false;
			if (!Objects.equals(smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(collateralPortfolioCodeInitialMargin, _that.getCollateralPortfolioCodeInitialMargin())) return false;
			if (!Objects.equals(collateralPortfolioCodeVariationMargin, _that.getCollateralPortfolioCodeVariationMargin())) return false;
			if (!Objects.equals(executionAgentOfCounterparty2DTCC, _that.getExecutionAgentOfCounterparty2DTCC())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (utiProprietaryID != null ? utiProprietaryID.hashCode() : 0);
			_result = 31 * _result + (secondaryTransactionIdentifier != null ? secondaryTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifier != null ? uniqueProductIdentifier.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (reportingEntity != null ? reportingEntity.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2Name != null ? counterparty2Name.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierTypeIndicator != null ? counterparty2IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (countryOfTheCounterParty2 != null ? countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (beneficiary1 != null ? beneficiary1.hashCode() : 0);
			_result = 31 * _result + (beneficiary1IdentifierTypeIndicator != null ? beneficiary1IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (broker != null ? broker.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty1 != null ? executionAgentOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (direction != null ? direction.hashCode() : 0);
			_result = 31 * _result + (direction2OfLeg1 != null ? direction2OfLeg1.hashCode() : 0);
			_result = 31 * _result + (direction2OfLeg2 != null ? direction2OfLeg2.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingTimestamp != null ? clearingTimestamp.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (platformIdentifier != null ? platformIdentifier.hashCode() : 0);
			_result = 31 * _result + (notionalLeg1 != null ? notionalLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalLeg2 != null ? notionalLeg2.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityLeg1 != null ? notionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityLeg2 != null ? notionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (callAmount != null ? callAmount.hashCode() : 0);
			_result = 31 * _result + (putAmount != null ? putAmount.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyLeg1 != null ? notionalCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyLeg2 != null ? notionalCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg1 != null ? quantityUnitOfMeasureLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg2 != null ? quantityUnitOfMeasureLeg2.hashCode() : 0);
			_result = 31 * _result + (callCurrency != null ? callCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (putCurrency != null ? putCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1 != null ? notionalAmountScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2 != null ? notionalAmountScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceUnitOfMeasure != null ? priceUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg1 != null ? fixedRateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg2 != null ? fixedRateLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadNotationLeg1 != null ? spreadNotationLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1 != null ? spreadLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadNotationLeg2 != null ? spreadNotationLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2 != null ? spreadLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyLeg1 != null ? spreadCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyLeg2 != null ? spreadCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (barrier != null ? barrier.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (dayCountConventionLeg1 != null ? dayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (dayCountConventionLeg2 != null ? dayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodLeg1 != null ? paymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodLeg2 != null ? paymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodMultiplierLeg1 != null ? paymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodMultiplierLeg2 != null ? paymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg1 != null ? settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg2 != null ? settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (basket != null ? basket.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOther != null ? underlyingIdOther.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOtherSource != null ? underlyingIdOtherSource.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateLeg2 != null ? indicatorOfTheFloatingRateLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2TimePeriod != null ? floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2Multiplier != null ? floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
			_result = 31 * _result + (cdSIndexAttachmentPoint != null ? cdSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cdSIndexDetachmentPoint != null ? cdSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPrice != null ? packageTransactionPrice.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpread != null ? packageTransactionSpread.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (priorUtiProprietary != null ? priorUtiProprietary.hashCode() : 0);
			_result = 31 * _result + (eventIdentifier != null ? eventIdentifier.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (newDerivativeTradeRepository != null ? newDerivativeTradeRepository.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg1 != null ? nextFloatingReferenceResetDateLeg1.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg2 != null ? nextFloatingReferenceResetDateLeg2.hashCode() : 0);
			_result = 31 * _result + (smallScaleBuySideEntityIndicator != null ? smallScaleBuySideEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCodeInitialMargin != null ? collateralPortfolioCodeInitialMargin.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCodeVariationMargin != null ? collateralPortfolioCodeVariationMargin.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty2DTCC != null ? executionAgentOfCounterparty2DTCC.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICTransactionReport {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"utiProprietaryID=" + this.utiProprietaryID + ", " +
				"secondaryTransactionIdentifier=" + this.secondaryTransactionIdentifier + ", " +
				"uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", " +
				"assetClass=" + this.assetClass + ", " +
				"contractType=" + this.contractType + ", " +
				"reportingEntity=" + this.reportingEntity + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2Name=" + this.counterparty2Name + ", " +
				"counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", " +
				"countryOfTheCounterParty2=" + this.countryOfTheCounterParty2 + ", " +
				"beneficiary1=" + this.beneficiary1 + ", " +
				"beneficiary1IdentifierTypeIndicator=" + this.beneficiary1IdentifierTypeIndicator + ", " +
				"broker=" + this.broker + ", " +
				"executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + ", " +
				"direction=" + this.direction + ", " +
				"direction2OfLeg1=" + this.direction2OfLeg1 + ", " +
				"direction2OfLeg2=" + this.direction2OfLeg2 + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"clearingTimestamp=" + this.clearingTimestamp + ", " +
				"cleared=" + this.cleared + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"platformIdentifier=" + this.platformIdentifier + ", " +
				"notionalLeg1=" + this.notionalLeg1 + ", " +
				"notionalLeg2=" + this.notionalLeg2 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"notionalQuantityLeg1=" + this.notionalQuantityLeg1 + ", " +
				"notionalQuantityLeg2=" + this.notionalQuantityLeg2 + ", " +
				"callAmount=" + this.callAmount + ", " +
				"putAmount=" + this.putAmount + ", " +
				"notionalCurrencyLeg1=" + this.notionalCurrencyLeg1 + ", " +
				"notionalCurrencyLeg2=" + this.notionalCurrencyLeg2 + ", " +
				"quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", " +
				"quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", " +
				"callCurrency=" + this.callCurrency + ", " +
				"putCurrency=" + this.putCurrency + ", " +
				"notionalAmountScheduleLeg1=" + this.notionalAmountScheduleLeg1 + ", " +
				"notionalAmountScheduleLeg2=" + this.notionalAmountScheduleLeg2 + ", " +
				"price=" + this.price + ", " +
				"priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", " +
				"fixedRateLeg1=" + this.fixedRateLeg1 + ", " +
				"fixedRateLeg2=" + this.fixedRateLeg2 + ", " +
				"spreadNotationLeg1=" + this.spreadNotationLeg1 + ", " +
				"spreadLeg1=" + this.spreadLeg1 + ", " +
				"spreadNotationLeg2=" + this.spreadNotationLeg2 + ", " +
				"spreadLeg2=" + this.spreadLeg2 + ", " +
				"spreadCurrencyLeg1=" + this.spreadCurrencyLeg1 + ", " +
				"spreadCurrencyLeg2=" + this.spreadCurrencyLeg2 + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"barrier=" + this.barrier + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"dayCountConventionLeg1=" + this.dayCountConventionLeg1 + ", " +
				"dayCountConventionLeg2=" + this.dayCountConventionLeg2 + ", " +
				"paymentFrequencyPeriodLeg1=" + this.paymentFrequencyPeriodLeg1 + ", " +
				"paymentFrequencyPeriodLeg2=" + this.paymentFrequencyPeriodLeg2 + ", " +
				"paymentFrequencyPeriodMultiplierLeg1=" + this.paymentFrequencyPeriodMultiplierLeg1 + ", " +
				"paymentFrequencyPeriodMultiplierLeg2=" + this.paymentFrequencyPeriodMultiplierLeg2 + ", " +
				"settlementCurrencyLeg1=" + this.settlementCurrencyLeg1 + ", " +
				"settlementCurrencyLeg2=" + this.settlementCurrencyLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"basket=" + this.basket + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdOther=" + this.underlyingIdOther + ", " +
				"underlyingIdOtherSource=" + this.underlyingIdOtherSource + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"indicatorOfTheFloatingRateLeg2=" + this.indicatorOfTheFloatingRateLeg2 + ", " +
				"floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", " +
				"cdSIndexAttachmentPoint=" + this.cdSIndexAttachmentPoint + ", " +
				"cdSIndexDetachmentPoint=" + this.cdSIndexDetachmentPoint + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"packageTransactionPrice=" + this.packageTransactionPrice + ", " +
				"packageTransactionSpread=" + this.packageTransactionSpread + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"priorUtiProprietary=" + this.priorUtiProprietary + ", " +
				"eventIdentifier=" + this.eventIdentifier + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"newDerivativeTradeRepository=" + this.newDerivativeTradeRepository + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"nextFloatingReferenceResetDateLeg1=" + this.nextFloatingReferenceResetDateLeg1 + ", " +
				"nextFloatingReferenceResetDateLeg2=" + this.nextFloatingReferenceResetDateLeg2 + ", " +
				"smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"collateralPortfolioCodeInitialMargin=" + this.collateralPortfolioCodeInitialMargin + ", " +
				"collateralPortfolioCodeVariationMargin=" + this.collateralPortfolioCodeVariationMargin + ", " +
				"executionAgentOfCounterparty2DTCC=" + this.executionAgentOfCounterparty2DTCC + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}

	/*********************** Builder Implementation of ASICTransactionReport  ***********************/
	class ASICTransactionReportBuilderImpl implements ASICTransactionReport.ASICTransactionReportBuilder {
	
		protected String uniqueTransactionIdentifier;
		protected String utiProprietaryID;
		protected String secondaryTransactionIdentifier;
		protected String uniqueProductIdentifier;
		protected String assetClass;
		protected String contractType;
		protected String reportingEntity;
		protected String counterparty1;
		protected String counterparty2;
		protected String counterparty2Name;
		protected Boolean counterparty2IdentifierTypeIndicator;
		protected ISOCountryCodeEnum countryOfTheCounterParty2;
		protected String beneficiary1;
		protected Boolean beneficiary1IdentifierTypeIndicator;
		protected String broker;
		protected String executionAgentOfCounterparty1;
		protected String direction;
		protected String direction2OfLeg1;
		protected String direction2OfLeg2;
		protected Date effectiveDate;
		protected Date expirationDate;
		protected ZonedDateTime executionTimestamp;
		protected ZonedDateTime eventTimestamp;
		protected ZonedDateTime clearingTimestamp;
		protected String cleared;
		protected String centralCounterparty;
		protected String clearingMember;
		protected String platformIdentifier;
		protected BigDecimal notionalLeg1;
		protected BigDecimal notionalLeg2;
		protected BigDecimal totalNotionalQuantityLeg1;
		protected BigDecimal totalNotionalQuantityLeg2;
		protected BigDecimal notionalQuantityLeg1;
		protected BigDecimal notionalQuantityLeg2;
		protected BigDecimal callAmount;
		protected BigDecimal putAmount;
		protected ISOCurrencyCodeEnum notionalCurrencyLeg1;
		protected ISOCurrencyCodeEnum notionalCurrencyLeg2;
		protected String quantityUnitOfMeasureLeg1;
		protected String quantityUnitOfMeasureLeg2;
		protected ISOCurrencyCodeEnum callCurrency;
		protected ISOCurrencyCodeEnum putCurrency;
		protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> notionalAmountScheduleLeg1 = new ArrayList<>();
		protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> notionalAmountScheduleLeg2 = new ArrayList<>();
		protected PriceAndNotation.PriceAndNotationBuilder price;
		protected String priceUnitOfMeasure;
		protected BigDecimal fixedRateLeg1;
		protected BigDecimal fixedRateLeg2;
		protected String spreadNotationLeg1;
		protected SpreadLeg1.SpreadLeg1Builder spreadLeg1;
		protected String spreadNotationLeg2;
		protected SpreadLeg2.SpreadLeg2Builder spreadLeg2;
		protected ISOCurrencyCodeEnum spreadCurrencyLeg1;
		protected ISOCurrencyCodeEnum spreadCurrencyLeg2;
		protected StrikePriceAndNotation.StrikePriceAndNotationBuilder strikePrice;
		protected BarrierAndNotation.BarrierAndNotationBuilder barrier;
		protected BigDecimal optionPremiumAmount;
		protected ISOCurrencyCodeEnum optionPremiumCurrency;
		protected Date optionPremiumPaymentDate;
		protected BigDecimal exchangeRate;
		protected String exchangeRateBasis;
		protected InterestComputationMethod4Code dayCountConventionLeg1;
		protected InterestComputationMethod4Code dayCountConventionLeg2;
		protected String paymentFrequencyPeriodLeg1;
		protected String paymentFrequencyPeriodLeg2;
		protected Integer paymentFrequencyPeriodMultiplierLeg1;
		protected Integer paymentFrequencyPeriodMultiplierLeg2;
		protected ISOCurrencyCodeEnum settlementCurrencyLeg1;
		protected ISOCurrencyCodeEnum settlementCurrencyLeg2;
		protected List<OtherPaymentReport.OtherPaymentReportBuilder> otherPayment = new ArrayList<>();
		protected ASICCustomBasket.ASICCustomBasketBuilder customBasketCode;
		protected Basket.BasketBuilder basket;
		protected String underlyingIdentification;
		protected String underlyingIdentificationType;
		protected String underlyingIdOther;
		protected ProductIdTypeEnum underlyingIdOtherSource;
		protected Date maturityDateOfTheUnderlying;
		protected String indicatorOfTheFloatingRateLeg2;
		protected String floatingRateReferencePeriodOfLeg2TimePeriod;
		protected Integer floatingRateReferencePeriodOfLeg2Multiplier;
		protected BigDecimal cdSIndexAttachmentPoint;
		protected BigDecimal cdSIndexDetachmentPoint;
		protected BigDecimal indexFactor;
		protected String packageIdentifier;
		protected PackageTransactionPrice.PackageTransactionPriceBuilder packageTransactionPrice;
		protected PackageTransactionSpread.PackageTransactionSpreadBuilder packageTransactionSpread;
		protected String priorUTI;
		protected String priorUtiProprietary;
		protected String eventIdentifier;
		protected String actionType;
		protected String eventType;
		protected ZonedDateTime reportingTimestamp;
		protected String reportSubmittingEntityID;
		protected String newDerivativeTradeRepository;
		protected ZonedDateTime valuationTimestamp;
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ValuationType1Code valuationMethod;
		protected BigDecimal delta;
		protected Date nextFloatingReferenceResetDateLeg1;
		protected Date nextFloatingReferenceResetDateLeg2;
		protected String smallScaleBuySideEntityIndicator;
		protected String technicalRecordId;
		protected Boolean collateralPortfolioIndicator;
		protected String collateralPortfolioCodeInitialMargin;
		protected String collateralPortfolioCodeVariationMargin;
		protected String executionAgentOfCounterparty2DTCC;
		protected ASICNonReportable.ASICNonReportableBuilder nonReportable;
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("utiProprietaryID")
		@RuneAttribute("utiProprietaryID")
		public String getUtiProprietaryID() {
			return utiProprietaryID;
		}
		
		@Override
		@RosettaAttribute("secondaryTransactionIdentifier")
		@RuneAttribute("secondaryTransactionIdentifier")
		public String getSecondaryTransactionIdentifier() {
			return secondaryTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public String getUniqueProductIdentifier() {
			return uniqueProductIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute("reportingEntity")
		@RuneAttribute("reportingEntity")
		public String getReportingEntity() {
			return reportingEntity;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public String getCounterparty2Name() {
			return counterparty2Name;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		public Boolean getCounterparty2IdentifierTypeIndicator() {
			return counterparty2IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
			return countryOfTheCounterParty2;
		}
		
		@Override
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		public String getBeneficiary1() {
			return beneficiary1;
		}
		
		@Override
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		public Boolean getBeneficiary1IdentifierTypeIndicator() {
			return beneficiary1IdentifierTypeIndicator;
		}
		
		@Override
		@RosettaAttribute("broker")
		@RuneAttribute("broker")
		public String getBroker() {
			return broker;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfCounterparty1")
		@RuneAttribute("executionAgentOfCounterparty1")
		public String getExecutionAgentOfCounterparty1() {
			return executionAgentOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		public String getDirection() {
			return direction;
		}
		
		@Override
		@RosettaAttribute("direction2OfLeg1")
		@RuneAttribute("direction2OfLeg1")
		public String getDirection2OfLeg1() {
			return direction2OfLeg1;
		}
		
		@Override
		@RosettaAttribute("direction2OfLeg2")
		@RuneAttribute("direction2OfLeg2")
		public String getDirection2OfLeg2() {
			return direction2OfLeg2;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public ZonedDateTime getClearingTimestamp() {
			return clearingTimestamp;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public String getPlatformIdentifier() {
			return platformIdentifier;
		}
		
		@Override
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		public BigDecimal getNotionalLeg1() {
			return notionalLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		public BigDecimal getNotionalLeg2() {
			return notionalLeg2;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityLeg1")
		@RuneAttribute("notionalQuantityLeg1")
		public BigDecimal getNotionalQuantityLeg1() {
			return notionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityLeg2")
		@RuneAttribute("notionalQuantityLeg2")
		public BigDecimal getNotionalQuantityLeg2() {
			return notionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public BigDecimal getCallAmount() {
			return callAmount;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public BigDecimal getPutAmount() {
			return putAmount;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyLeg1")
		@RuneAttribute("notionalCurrencyLeg1")
		public ISOCurrencyCodeEnum getNotionalCurrencyLeg1() {
			return notionalCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyLeg2")
		@RuneAttribute("notionalCurrencyLeg2")
		public ISOCurrencyCodeEnum getNotionalCurrencyLeg2() {
			return notionalCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public String getQuantityUnitOfMeasureLeg1() {
			return quantityUnitOfMeasureLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public String getQuantityUnitOfMeasureLeg2() {
			return quantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public ISOCurrencyCodeEnum getCallCurrency() {
			return callCurrency;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public ISOCurrencyCodeEnum getPutCurrency() {
			return putCurrency;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1() {
			return notionalAmountScheduleLeg1;
		}
		
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index) {
			if (notionalAmountScheduleLeg1==null) {
				this.notionalAmountScheduleLeg1 = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg1, index, () -> {
						NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder newNotionalAmountScheduleLeg1 = NotionalAmountScheduleLeg1Report.builder();
						return newNotionalAmountScheduleLeg1;
					});
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2() {
			return notionalAmountScheduleLeg2;
		}
		
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index) {
			if (notionalAmountScheduleLeg2==null) {
				this.notionalAmountScheduleLeg2 = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg2, index, () -> {
						NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder newNotionalAmountScheduleLeg2 = NotionalAmountScheduleLeg2Report.builder();
						return newNotionalAmountScheduleLeg2;
					});
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public PriceAndNotation.PriceAndNotationBuilder getPrice() {
			return price;
		}
		
		@Override
		public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice() {
			PriceAndNotation.PriceAndNotationBuilder result;
			if (price!=null) {
				result = price;
			}
			else {
				result = price = PriceAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public String getPriceUnitOfMeasure() {
			return priceUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg1")
		@RuneAttribute("fixedRateLeg1")
		public BigDecimal getFixedRateLeg1() {
			return fixedRateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg2")
		@RuneAttribute("fixedRateLeg2")
		public BigDecimal getFixedRateLeg2() {
			return fixedRateLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadNotationLeg1")
		@RuneAttribute("spreadNotationLeg1")
		public String getSpreadNotationLeg1() {
			return spreadNotationLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1")
		@RuneAttribute("spreadLeg1")
		public SpreadLeg1.SpreadLeg1Builder getSpreadLeg1() {
			return spreadLeg1;
		}
		
		@Override
		public SpreadLeg1.SpreadLeg1Builder getOrCreateSpreadLeg1() {
			SpreadLeg1.SpreadLeg1Builder result;
			if (spreadLeg1!=null) {
				result = spreadLeg1;
			}
			else {
				result = spreadLeg1 = SpreadLeg1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("spreadNotationLeg2")
		@RuneAttribute("spreadNotationLeg2")
		public String getSpreadNotationLeg2() {
			return spreadNotationLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2")
		@RuneAttribute("spreadLeg2")
		public SpreadLeg2.SpreadLeg2Builder getSpreadLeg2() {
			return spreadLeg2;
		}
		
		@Override
		public SpreadLeg2.SpreadLeg2Builder getOrCreateSpreadLeg2() {
			SpreadLeg2.SpreadLeg2Builder result;
			if (spreadLeg2!=null) {
				result = spreadLeg2;
			}
			else {
				result = spreadLeg2 = SpreadLeg2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyLeg1")
		@RuneAttribute("spreadCurrencyLeg1")
		public ISOCurrencyCodeEnum getSpreadCurrencyLeg1() {
			return spreadCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyLeg2")
		@RuneAttribute("spreadCurrencyLeg2")
		public ISOCurrencyCodeEnum getSpreadCurrencyLeg2() {
			return spreadCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice() {
			StrikePriceAndNotation.StrikePriceAndNotationBuilder result;
			if (strikePrice!=null) {
				result = strikePrice;
			}
			else {
				result = strikePrice = StrikePriceAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public BarrierAndNotation.BarrierAndNotationBuilder getBarrier() {
			return barrier;
		}
		
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder getOrCreateBarrier() {
			BarrierAndNotation.BarrierAndNotationBuilder result;
			if (barrier!=null) {
				result = barrier;
			}
			else {
				result = barrier = BarrierAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("dayCountConventionLeg1")
		@RuneAttribute("dayCountConventionLeg1")
		public InterestComputationMethod4Code getDayCountConventionLeg1() {
			return dayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("dayCountConventionLeg2")
		@RuneAttribute("dayCountConventionLeg2")
		public InterestComputationMethod4Code getDayCountConventionLeg2() {
			return dayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg1")
		@RuneAttribute("paymentFrequencyPeriodLeg1")
		public String getPaymentFrequencyPeriodLeg1() {
			return paymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodLeg2")
		@RuneAttribute("paymentFrequencyPeriodLeg2")
		public String getPaymentFrequencyPeriodLeg2() {
			return paymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg1")
		public Integer getPaymentFrequencyPeriodMultiplierLeg1() {
			return paymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg2")
		public Integer getPaymentFrequencyPeriodMultiplierLeg2() {
			return paymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg1")
		@RuneAttribute("settlementCurrencyLeg1")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
			return settlementCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg2")
		@RuneAttribute("settlementCurrencyLeg2")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
			return settlementCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index) {
			if (otherPayment==null) {
				this.otherPayment = new ArrayList<>();
			}
			return getIndex(otherPayment, index, () -> {
						OtherPaymentReport.OtherPaymentReportBuilder newOtherPayment = OtherPaymentReport.builder();
						return newOtherPayment;
					});
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public ASICCustomBasket.ASICCustomBasketBuilder getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		public ASICCustomBasket.ASICCustomBasketBuilder getOrCreateCustomBasketCode() {
			ASICCustomBasket.ASICCustomBasketBuilder result;
			if (customBasketCode!=null) {
				result = customBasketCode;
			}
			else {
				result = customBasketCode = ASICCustomBasket.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("basket")
		@RuneAttribute("basket")
		public Basket.BasketBuilder getBasket() {
			return basket;
		}
		
		@Override
		public Basket.BasketBuilder getOrCreateBasket() {
			Basket.BasketBuilder result;
			if (basket!=null) {
				result = basket;
			}
			else {
				result = basket = Basket.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public String getUnderlyingIdOther() {
			return underlyingIdOther;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public ProductIdTypeEnum getUnderlyingIdOtherSource() {
			return underlyingIdOtherSource;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateLeg2")
		public String getIndicatorOfTheFloatingRateLeg2() {
			return indicatorOfTheFloatingRateLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
			return floatingRateReferencePeriodOfLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
			return floatingRateReferencePeriodOfLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public BigDecimal getCdSIndexAttachmentPoint() {
			return cdSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public BigDecimal getCdSIndexDetachmentPoint() {
			return cdSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public PackageTransactionPrice.PackageTransactionPriceBuilder getPackageTransactionPrice() {
			return packageTransactionPrice;
		}
		
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder getOrCreatePackageTransactionPrice() {
			PackageTransactionPrice.PackageTransactionPriceBuilder result;
			if (packageTransactionPrice!=null) {
				result = packageTransactionPrice;
			}
			else {
				result = packageTransactionPrice = PackageTransactionPrice.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public PackageTransactionSpread.PackageTransactionSpreadBuilder getPackageTransactionSpread() {
			return packageTransactionSpread;
		}
		
		@Override
		public PackageTransactionSpread.PackageTransactionSpreadBuilder getOrCreatePackageTransactionSpread() {
			PackageTransactionSpread.PackageTransactionSpreadBuilder result;
			if (packageTransactionSpread!=null) {
				result = packageTransactionSpread;
			}
			else {
				result = packageTransactionSpread = PackageTransactionSpread.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("priorUtiProprietary")
		@RuneAttribute("priorUtiProprietary")
		public String getPriorUtiProprietary() {
			return priorUtiProprietary;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public String getEventIdentifier() {
			return eventIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("newDerivativeTradeRepository")
		@RuneAttribute("newDerivativeTradeRepository")
		public String getNewDerivativeTradeRepository() {
			return newDerivativeTradeRepository;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		public Date getNextFloatingReferenceResetDateLeg1() {
			return nextFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		public Date getNextFloatingReferenceResetDateLeg2() {
			return nextFloatingReferenceResetDateLeg2;
		}
		
		@Override
		@RosettaAttribute("smallScaleBuySideEntityIndicator")
		@RuneAttribute("smallScaleBuySideEntityIndicator")
		public String getSmallScaleBuySideEntityIndicator() {
			return smallScaleBuySideEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCodeInitialMargin")
		@RuneAttribute("collateralPortfolioCodeInitialMargin")
		public String getCollateralPortfolioCodeInitialMargin() {
			return collateralPortfolioCodeInitialMargin;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCodeVariationMargin")
		@RuneAttribute("collateralPortfolioCodeVariationMargin")
		public String getCollateralPortfolioCodeVariationMargin() {
			return collateralPortfolioCodeVariationMargin;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfCounterparty2DTCC")
		@RuneAttribute("executionAgentOfCounterparty2DTCC")
		public String getExecutionAgentOfCounterparty2DTCC() {
			return executionAgentOfCounterparty2DTCC;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public ASICNonReportable.ASICNonReportableBuilder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public ASICNonReportable.ASICNonReportableBuilder getOrCreateNonReportable() {
			ASICNonReportable.ASICNonReportableBuilder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = ASICNonReportable.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute("utiProprietaryID")
		@RuneAttribute("utiProprietaryID")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setUtiProprietaryID(String _utiProprietaryID) {
			this.utiProprietaryID = _utiProprietaryID == null ? null : _utiProprietaryID;
			return this;
		}
		
		@RosettaAttribute("secondaryTransactionIdentifier")
		@RuneAttribute("secondaryTransactionIdentifier")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
			this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setAssetClass(String _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setContractType(String _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@RosettaAttribute("reportingEntity")
		@RuneAttribute("reportingEntity")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setReportingEntity(String _reportingEntity) {
			this.reportingEntity = _reportingEntity == null ? null : _reportingEntity;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean _counterparty2IdentifierTypeIndicator) {
			this.counterparty2IdentifierTypeIndicator = _counterparty2IdentifierTypeIndicator == null ? null : _counterparty2IdentifierTypeIndicator;
			return this;
		}
		
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum _countryOfTheCounterParty2) {
			this.countryOfTheCounterParty2 = _countryOfTheCounterParty2 == null ? null : _countryOfTheCounterParty2;
			return this;
		}
		
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
			this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
			return this;
		}
		
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
			this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
			return this;
		}
		
		@RosettaAttribute("broker")
		@RuneAttribute("broker")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setBroker(String _broker) {
			this.broker = _broker == null ? null : _broker;
			return this;
		}
		
		@RosettaAttribute("executionAgentOfCounterparty1")
		@RuneAttribute("executionAgentOfCounterparty1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setExecutionAgentOfCounterparty1(String _executionAgentOfCounterparty1) {
			this.executionAgentOfCounterparty1 = _executionAgentOfCounterparty1 == null ? null : _executionAgentOfCounterparty1;
			return this;
		}
		
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setDirection(String _direction) {
			this.direction = _direction == null ? null : _direction;
			return this;
		}
		
		@RosettaAttribute("direction2OfLeg1")
		@RuneAttribute("direction2OfLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setDirection2OfLeg1(String _direction2OfLeg1) {
			this.direction2OfLeg1 = _direction2OfLeg1 == null ? null : _direction2OfLeg1;
			return this;
		}
		
		@RosettaAttribute("direction2OfLeg2")
		@RuneAttribute("direction2OfLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setDirection2OfLeg2(String _direction2OfLeg2) {
			this.direction2OfLeg2 = _direction2OfLeg2 == null ? null : _direction2OfLeg2;
			return this;
		}
		
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCleared(String _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNotionalLeg1(BigDecimal _notionalLeg1) {
			this.notionalLeg1 = _notionalLeg1 == null ? null : _notionalLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNotionalLeg2(BigDecimal _notionalLeg2) {
			this.notionalLeg2 = _notionalLeg2 == null ? null : _notionalLeg2;
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal _totalNotionalQuantityLeg1) {
			this.totalNotionalQuantityLeg1 = _totalNotionalQuantityLeg1 == null ? null : _totalNotionalQuantityLeg1;
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal _totalNotionalQuantityLeg2) {
			this.totalNotionalQuantityLeg2 = _totalNotionalQuantityLeg2 == null ? null : _totalNotionalQuantityLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalQuantityLeg1")
		@RuneAttribute("notionalQuantityLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNotionalQuantityLeg1(BigDecimal _notionalQuantityLeg1) {
			this.notionalQuantityLeg1 = _notionalQuantityLeg1 == null ? null : _notionalQuantityLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalQuantityLeg2")
		@RuneAttribute("notionalQuantityLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNotionalQuantityLeg2(BigDecimal _notionalQuantityLeg2) {
			this.notionalQuantityLeg2 = _notionalQuantityLeg2 == null ? null : _notionalQuantityLeg2;
			return this;
		}
		
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@RosettaAttribute("notionalCurrencyLeg1")
		@RuneAttribute("notionalCurrencyLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNotionalCurrencyLeg1(ISOCurrencyCodeEnum _notionalCurrencyLeg1) {
			this.notionalCurrencyLeg1 = _notionalCurrencyLeg1 == null ? null : _notionalCurrencyLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalCurrencyLeg2")
		@RuneAttribute("notionalCurrencyLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNotionalCurrencyLeg2(ISOCurrencyCodeEnum _notionalCurrencyLeg2) {
			this.notionalCurrencyLeg2 = _notionalCurrencyLeg2 == null ? null : _notionalCurrencyLeg2;
			return this;
		}
		
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1) {
			if (_notionalAmountScheduleLeg1 != null) {
				this.notionalAmountScheduleLeg1.add(_notionalAmountScheduleLeg1.toBuilder());
			}
			return this;
		}
		
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1, int idx) {
			getIndex(this.notionalAmountScheduleLeg1, idx, () -> _notionalAmountScheduleLeg1.toBuilder());
			return this;
		}
		
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
			if (notionalAmountScheduleLeg1s != null) {
				for (final NotionalAmountScheduleLeg1Report toAdd : notionalAmountScheduleLeg1s) {
					this.notionalAmountScheduleLeg1.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
			if (notionalAmountScheduleLeg1s == null) {
				this.notionalAmountScheduleLeg1 = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2) {
			if (_notionalAmountScheduleLeg2 != null) {
				this.notionalAmountScheduleLeg2.add(_notionalAmountScheduleLeg2.toBuilder());
			}
			return this;
		}
		
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2, int idx) {
			getIndex(this.notionalAmountScheduleLeg2, idx, () -> _notionalAmountScheduleLeg2.toBuilder());
			return this;
		}
		
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
			if (notionalAmountScheduleLeg2s != null) {
				for (final NotionalAmountScheduleLeg2Report toAdd : notionalAmountScheduleLeg2s) {
					this.notionalAmountScheduleLeg2.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
			if (notionalAmountScheduleLeg2s == null) {
				this.notionalAmountScheduleLeg2 = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("price")
		@RuneAttribute("price")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPrice(PriceAndNotation _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@RosettaAttribute("fixedRateLeg1")
		@RuneAttribute("fixedRateLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setFixedRateLeg1(BigDecimal _fixedRateLeg1) {
			this.fixedRateLeg1 = _fixedRateLeg1 == null ? null : _fixedRateLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRateLeg2")
		@RuneAttribute("fixedRateLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setFixedRateLeg2(BigDecimal _fixedRateLeg2) {
			this.fixedRateLeg2 = _fixedRateLeg2 == null ? null : _fixedRateLeg2;
			return this;
		}
		
		@RosettaAttribute("spreadNotationLeg1")
		@RuneAttribute("spreadNotationLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSpreadNotationLeg1(String _spreadNotationLeg1) {
			this.spreadNotationLeg1 = _spreadNotationLeg1 == null ? null : _spreadNotationLeg1;
			return this;
		}
		
		@RosettaAttribute("spreadLeg1")
		@RuneAttribute("spreadLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSpreadLeg1(SpreadLeg1 _spreadLeg1) {
			this.spreadLeg1 = _spreadLeg1 == null ? null : _spreadLeg1.toBuilder();
			return this;
		}
		
		@RosettaAttribute("spreadNotationLeg2")
		@RuneAttribute("spreadNotationLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSpreadNotationLeg2(String _spreadNotationLeg2) {
			this.spreadNotationLeg2 = _spreadNotationLeg2 == null ? null : _spreadNotationLeg2;
			return this;
		}
		
		@RosettaAttribute("spreadLeg2")
		@RuneAttribute("spreadLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSpreadLeg2(SpreadLeg2 _spreadLeg2) {
			this.spreadLeg2 = _spreadLeg2 == null ? null : _spreadLeg2.toBuilder();
			return this;
		}
		
		@RosettaAttribute("spreadCurrencyLeg1")
		@RuneAttribute("spreadCurrencyLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSpreadCurrencyLeg1(ISOCurrencyCodeEnum _spreadCurrencyLeg1) {
			this.spreadCurrencyLeg1 = _spreadCurrencyLeg1 == null ? null : _spreadCurrencyLeg1;
			return this;
		}
		
		@RosettaAttribute("spreadCurrencyLeg2")
		@RuneAttribute("spreadCurrencyLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSpreadCurrencyLeg2(ISOCurrencyCodeEnum _spreadCurrencyLeg2) {
			this.spreadCurrencyLeg2 = _spreadCurrencyLeg2 == null ? null : _spreadCurrencyLeg2;
			return this;
		}
		
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setStrikePrice(StrikePriceAndNotation _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setBarrier(BarrierAndNotation _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@RosettaAttribute("dayCountConventionLeg1")
		@RuneAttribute("dayCountConventionLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setDayCountConventionLeg1(InterestComputationMethod4Code _dayCountConventionLeg1) {
			this.dayCountConventionLeg1 = _dayCountConventionLeg1 == null ? null : _dayCountConventionLeg1;
			return this;
		}
		
		@RosettaAttribute("dayCountConventionLeg2")
		@RuneAttribute("dayCountConventionLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setDayCountConventionLeg2(InterestComputationMethod4Code _dayCountConventionLeg2) {
			this.dayCountConventionLeg2 = _dayCountConventionLeg2 == null ? null : _dayCountConventionLeg2;
			return this;
		}
		
		@RosettaAttribute("paymentFrequencyPeriodLeg1")
		@RuneAttribute("paymentFrequencyPeriodLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPaymentFrequencyPeriodLeg1(String _paymentFrequencyPeriodLeg1) {
			this.paymentFrequencyPeriodLeg1 = _paymentFrequencyPeriodLeg1 == null ? null : _paymentFrequencyPeriodLeg1;
			return this;
		}
		
		@RosettaAttribute("paymentFrequencyPeriodLeg2")
		@RuneAttribute("paymentFrequencyPeriodLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPaymentFrequencyPeriodLeg2(String _paymentFrequencyPeriodLeg2) {
			this.paymentFrequencyPeriodLeg2 = _paymentFrequencyPeriodLeg2 == null ? null : _paymentFrequencyPeriodLeg2;
			return this;
		}
		
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPaymentFrequencyPeriodMultiplierLeg1(Integer _paymentFrequencyPeriodMultiplierLeg1) {
			this.paymentFrequencyPeriodMultiplierLeg1 = _paymentFrequencyPeriodMultiplierLeg1 == null ? null : _paymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("paymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("paymentFrequencyPeriodMultiplierLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPaymentFrequencyPeriodMultiplierLeg2(Integer _paymentFrequencyPeriodMultiplierLeg2) {
			this.paymentFrequencyPeriodMultiplierLeg2 = _paymentFrequencyPeriodMultiplierLeg2 == null ? null : _paymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("settlementCurrencyLeg1")
		@RuneAttribute("settlementCurrencyLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum _settlementCurrencyLeg1) {
			this.settlementCurrencyLeg1 = _settlementCurrencyLeg1 == null ? null : _settlementCurrencyLeg1;
			return this;
		}
		
		@RosettaAttribute("settlementCurrencyLeg2")
		@RuneAttribute("settlementCurrencyLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum _settlementCurrencyLeg2) {
			this.settlementCurrencyLeg2 = _settlementCurrencyLeg2 == null ? null : _settlementCurrencyLeg2;
			return this;
		}
		
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment, int idx) {
			getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPaymentReport toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("otherPayment")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCustomBasketCode(ASICCustomBasket _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode.toBuilder();
			return this;
		}
		
		@RosettaAttribute("basket")
		@RuneAttribute("basket")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setBasket(Basket _basket) {
			this.basket = _basket == null ? null : _basket.toBuilder();
			return this;
		}
		
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
			this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
			this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
			return this;
		}
		
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
			this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
			return this;
		}
		
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
			this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
			return this;
		}
		
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@RosettaAttribute("indicatorOfTheFloatingRateLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setIndicatorOfTheFloatingRateLeg2(String _indicatorOfTheFloatingRateLeg2) {
			this.indicatorOfTheFloatingRateLeg2 = _indicatorOfTheFloatingRateLeg2 == null ? null : _indicatorOfTheFloatingRateLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String _floatingRateReferencePeriodOfLeg2TimePeriod) {
			this.floatingRateReferencePeriodOfLeg2TimePeriod = _floatingRateReferencePeriodOfLeg2TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg2TimePeriod;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer _floatingRateReferencePeriodOfLeg2Multiplier) {
			this.floatingRateReferencePeriodOfLeg2Multiplier = _floatingRateReferencePeriodOfLeg2Multiplier == null ? null : _floatingRateReferencePeriodOfLeg2Multiplier;
			return this;
		}
		
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPackageTransactionPrice(PackageTransactionPrice _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPackageTransactionSpread(PackageTransactionSpread _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@RosettaAttribute("priorUtiProprietary")
		@RuneAttribute("priorUtiProprietary")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setPriorUtiProprietary(String _priorUtiProprietary) {
			this.priorUtiProprietary = _priorUtiProprietary == null ? null : _priorUtiProprietary;
			return this;
		}
		
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setActionType(String _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setEventType(String _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@RosettaAttribute("newDerivativeTradeRepository")
		@RuneAttribute("newDerivativeTradeRepository")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNewDerivativeTradeRepository(String _newDerivativeTradeRepository) {
			this.newDerivativeTradeRepository = _newDerivativeTradeRepository == null ? null : _newDerivativeTradeRepository;
			return this;
		}
		
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
			this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
			return this;
		}
		
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
			this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
			return this;
		}
		
		@RosettaAttribute("smallScaleBuySideEntityIndicator")
		@RuneAttribute("smallScaleBuySideEntityIndicator")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setSmallScaleBuySideEntityIndicator(String _smallScaleBuySideEntityIndicator) {
			this.smallScaleBuySideEntityIndicator = _smallScaleBuySideEntityIndicator == null ? null : _smallScaleBuySideEntityIndicator;
			return this;
		}
		
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioCodeInitialMargin")
		@RuneAttribute("collateralPortfolioCodeInitialMargin")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCollateralPortfolioCodeInitialMargin(String _collateralPortfolioCodeInitialMargin) {
			this.collateralPortfolioCodeInitialMargin = _collateralPortfolioCodeInitialMargin == null ? null : _collateralPortfolioCodeInitialMargin;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioCodeVariationMargin")
		@RuneAttribute("collateralPortfolioCodeVariationMargin")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setCollateralPortfolioCodeVariationMargin(String _collateralPortfolioCodeVariationMargin) {
			this.collateralPortfolioCodeVariationMargin = _collateralPortfolioCodeVariationMargin == null ? null : _collateralPortfolioCodeVariationMargin;
			return this;
		}
		
		@RosettaAttribute("executionAgentOfCounterparty2DTCC")
		@RuneAttribute("executionAgentOfCounterparty2DTCC")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setExecutionAgentOfCounterparty2DTCC(String _executionAgentOfCounterparty2DTCC) {
			this.executionAgentOfCounterparty2DTCC = _executionAgentOfCounterparty2DTCC == null ? null : _executionAgentOfCounterparty2DTCC;
			return this;
		}
		
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder setNonReportable(ASICNonReportable _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@Override
		public ASICTransactionReport build() {
			return new ASICTransactionReport.ASICTransactionReportImpl(this);
		}
		
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder prune() {
			notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1.stream().filter(b->b!=null).<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2.stream().filter(b->b!=null).<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (price!=null && !price.prune().hasData()) price = null;
			if (spreadLeg1!=null && !spreadLeg1.prune().hasData()) spreadLeg1 = null;
			if (spreadLeg2!=null && !spreadLeg2.prune().hasData()) spreadLeg2 = null;
			if (strikePrice!=null && !strikePrice.prune().hasData()) strikePrice = null;
			if (barrier!=null && !barrier.prune().hasData()) barrier = null;
			otherPayment = otherPayment.stream().filter(b->b!=null).<OtherPaymentReport.OtherPaymentReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (customBasketCode!=null && !customBasketCode.prune().hasData()) customBasketCode = null;
			if (basket!=null && !basket.prune().hasData()) basket = null;
			if (packageTransactionPrice!=null && !packageTransactionPrice.prune().hasData()) packageTransactionPrice = null;
			if (packageTransactionSpread!=null && !packageTransactionSpread.prune().hasData()) packageTransactionSpread = null;
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getUtiProprietaryID()!=null) return true;
			if (getSecondaryTransactionIdentifier()!=null) return true;
			if (getUniqueProductIdentifier()!=null) return true;
			if (getAssetClass()!=null) return true;
			if (getContractType()!=null) return true;
			if (getReportingEntity()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2Name()!=null) return true;
			if (getCounterparty2IdentifierTypeIndicator()!=null) return true;
			if (getCountryOfTheCounterParty2()!=null) return true;
			if (getBeneficiary1()!=null) return true;
			if (getBeneficiary1IdentifierTypeIndicator()!=null) return true;
			if (getBroker()!=null) return true;
			if (getExecutionAgentOfCounterparty1()!=null) return true;
			if (getDirection()!=null) return true;
			if (getDirection2OfLeg1()!=null) return true;
			if (getDirection2OfLeg2()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			if (getExpirationDate()!=null) return true;
			if (getExecutionTimestamp()!=null) return true;
			if (getEventTimestamp()!=null) return true;
			if (getClearingTimestamp()!=null) return true;
			if (getCleared()!=null) return true;
			if (getCentralCounterparty()!=null) return true;
			if (getClearingMember()!=null) return true;
			if (getPlatformIdentifier()!=null) return true;
			if (getNotionalLeg1()!=null) return true;
			if (getNotionalLeg2()!=null) return true;
			if (getTotalNotionalQuantityLeg1()!=null) return true;
			if (getTotalNotionalQuantityLeg2()!=null) return true;
			if (getNotionalQuantityLeg1()!=null) return true;
			if (getNotionalQuantityLeg2()!=null) return true;
			if (getCallAmount()!=null) return true;
			if (getPutAmount()!=null) return true;
			if (getNotionalCurrencyLeg1()!=null) return true;
			if (getNotionalCurrencyLeg2()!=null) return true;
			if (getQuantityUnitOfMeasureLeg1()!=null) return true;
			if (getQuantityUnitOfMeasureLeg2()!=null) return true;
			if (getCallCurrency()!=null) return true;
			if (getPutCurrency()!=null) return true;
			if (getNotionalAmountScheduleLeg1()!=null && getNotionalAmountScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getNotionalAmountScheduleLeg2()!=null && getNotionalAmountScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getPrice()!=null && getPrice().hasData()) return true;
			if (getPriceUnitOfMeasure()!=null) return true;
			if (getFixedRateLeg1()!=null) return true;
			if (getFixedRateLeg2()!=null) return true;
			if (getSpreadNotationLeg1()!=null) return true;
			if (getSpreadLeg1()!=null && getSpreadLeg1().hasData()) return true;
			if (getSpreadNotationLeg2()!=null) return true;
			if (getSpreadLeg2()!=null && getSpreadLeg2().hasData()) return true;
			if (getSpreadCurrencyLeg1()!=null) return true;
			if (getSpreadCurrencyLeg2()!=null) return true;
			if (getStrikePrice()!=null && getStrikePrice().hasData()) return true;
			if (getBarrier()!=null && getBarrier().hasData()) return true;
			if (getOptionPremiumAmount()!=null) return true;
			if (getOptionPremiumCurrency()!=null) return true;
			if (getOptionPremiumPaymentDate()!=null) return true;
			if (getExchangeRate()!=null) return true;
			if (getExchangeRateBasis()!=null) return true;
			if (getDayCountConventionLeg1()!=null) return true;
			if (getDayCountConventionLeg2()!=null) return true;
			if (getPaymentFrequencyPeriodLeg1()!=null) return true;
			if (getPaymentFrequencyPeriodLeg2()!=null) return true;
			if (getPaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getPaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getSettlementCurrencyLeg1()!=null) return true;
			if (getSettlementCurrencyLeg2()!=null) return true;
			if (getOtherPayment()!=null && getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getCustomBasketCode()!=null && getCustomBasketCode().hasData()) return true;
			if (getBasket()!=null && getBasket().hasData()) return true;
			if (getUnderlyingIdentification()!=null) return true;
			if (getUnderlyingIdentificationType()!=null) return true;
			if (getUnderlyingIdOther()!=null) return true;
			if (getUnderlyingIdOtherSource()!=null) return true;
			if (getMaturityDateOfTheUnderlying()!=null) return true;
			if (getIndicatorOfTheFloatingRateLeg2()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg2TimePeriod()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg2Multiplier()!=null) return true;
			if (getCdSIndexAttachmentPoint()!=null) return true;
			if (getCdSIndexDetachmentPoint()!=null) return true;
			if (getIndexFactor()!=null) return true;
			if (getPackageIdentifier()!=null) return true;
			if (getPackageTransactionPrice()!=null && getPackageTransactionPrice().hasData()) return true;
			if (getPackageTransactionSpread()!=null && getPackageTransactionSpread().hasData()) return true;
			if (getPriorUTI()!=null) return true;
			if (getPriorUtiProprietary()!=null) return true;
			if (getEventIdentifier()!=null) return true;
			if (getActionType()!=null) return true;
			if (getEventType()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getReportSubmittingEntityID()!=null) return true;
			if (getNewDerivativeTradeRepository()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getDelta()!=null) return true;
			if (getNextFloatingReferenceResetDateLeg1()!=null) return true;
			if (getNextFloatingReferenceResetDateLeg2()!=null) return true;
			if (getSmallScaleBuySideEntityIndicator()!=null) return true;
			if (getTechnicalRecordId()!=null) return true;
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getCollateralPortfolioCodeInitialMargin()!=null) return true;
			if (getCollateralPortfolioCodeVariationMargin()!=null) return true;
			if (getExecutionAgentOfCounterparty2DTCC()!=null) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ASICTransactionReport.ASICTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ASICTransactionReport.ASICTransactionReportBuilder o = (ASICTransactionReport.ASICTransactionReportBuilder) other;
			
			merger.mergeRosetta(getNotionalAmountScheduleLeg1(), o.getNotionalAmountScheduleLeg1(), this::getOrCreateNotionalAmountScheduleLeg1);
			merger.mergeRosetta(getNotionalAmountScheduleLeg2(), o.getNotionalAmountScheduleLeg2(), this::getOrCreateNotionalAmountScheduleLeg2);
			merger.mergeRosetta(getPrice(), o.getPrice(), this::setPrice);
			merger.mergeRosetta(getSpreadLeg1(), o.getSpreadLeg1(), this::setSpreadLeg1);
			merger.mergeRosetta(getSpreadLeg2(), o.getSpreadLeg2(), this::setSpreadLeg2);
			merger.mergeRosetta(getStrikePrice(), o.getStrikePrice(), this::setStrikePrice);
			merger.mergeRosetta(getBarrier(), o.getBarrier(), this::setBarrier);
			merger.mergeRosetta(getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
			merger.mergeRosetta(getCustomBasketCode(), o.getCustomBasketCode(), this::setCustomBasketCode);
			merger.mergeRosetta(getBasket(), o.getBasket(), this::setBasket);
			merger.mergeRosetta(getPackageTransactionPrice(), o.getPackageTransactionPrice(), this::setPackageTransactionPrice);
			merger.mergeRosetta(getPackageTransactionSpread(), o.getPackageTransactionSpread(), this::setPackageTransactionSpread);
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getUtiProprietaryID(), o.getUtiProprietaryID(), this::setUtiProprietaryID);
			merger.mergeBasic(getSecondaryTransactionIdentifier(), o.getSecondaryTransactionIdentifier(), this::setSecondaryTransactionIdentifier);
			merger.mergeBasic(getUniqueProductIdentifier(), o.getUniqueProductIdentifier(), this::setUniqueProductIdentifier);
			merger.mergeBasic(getAssetClass(), o.getAssetClass(), this::setAssetClass);
			merger.mergeBasic(getContractType(), o.getContractType(), this::setContractType);
			merger.mergeBasic(getReportingEntity(), o.getReportingEntity(), this::setReportingEntity);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2Name(), o.getCounterparty2Name(), this::setCounterparty2Name);
			merger.mergeBasic(getCounterparty2IdentifierTypeIndicator(), o.getCounterparty2IdentifierTypeIndicator(), this::setCounterparty2IdentifierTypeIndicator);
			merger.mergeBasic(getCountryOfTheCounterParty2(), o.getCountryOfTheCounterParty2(), this::setCountryOfTheCounterParty2);
			merger.mergeBasic(getBeneficiary1(), o.getBeneficiary1(), this::setBeneficiary1);
			merger.mergeBasic(getBeneficiary1IdentifierTypeIndicator(), o.getBeneficiary1IdentifierTypeIndicator(), this::setBeneficiary1IdentifierTypeIndicator);
			merger.mergeBasic(getBroker(), o.getBroker(), this::setBroker);
			merger.mergeBasic(getExecutionAgentOfCounterparty1(), o.getExecutionAgentOfCounterparty1(), this::setExecutionAgentOfCounterparty1);
			merger.mergeBasic(getDirection(), o.getDirection(), this::setDirection);
			merger.mergeBasic(getDirection2OfLeg1(), o.getDirection2OfLeg1(), this::setDirection2OfLeg1);
			merger.mergeBasic(getDirection2OfLeg2(), o.getDirection2OfLeg2(), this::setDirection2OfLeg2);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getExpirationDate(), o.getExpirationDate(), this::setExpirationDate);
			merger.mergeBasic(getExecutionTimestamp(), o.getExecutionTimestamp(), this::setExecutionTimestamp);
			merger.mergeBasic(getEventTimestamp(), o.getEventTimestamp(), this::setEventTimestamp);
			merger.mergeBasic(getClearingTimestamp(), o.getClearingTimestamp(), this::setClearingTimestamp);
			merger.mergeBasic(getCleared(), o.getCleared(), this::setCleared);
			merger.mergeBasic(getCentralCounterparty(), o.getCentralCounterparty(), this::setCentralCounterparty);
			merger.mergeBasic(getClearingMember(), o.getClearingMember(), this::setClearingMember);
			merger.mergeBasic(getPlatformIdentifier(), o.getPlatformIdentifier(), this::setPlatformIdentifier);
			merger.mergeBasic(getNotionalLeg1(), o.getNotionalLeg1(), this::setNotionalLeg1);
			merger.mergeBasic(getNotionalLeg2(), o.getNotionalLeg2(), this::setNotionalLeg2);
			merger.mergeBasic(getTotalNotionalQuantityLeg1(), o.getTotalNotionalQuantityLeg1(), this::setTotalNotionalQuantityLeg1);
			merger.mergeBasic(getTotalNotionalQuantityLeg2(), o.getTotalNotionalQuantityLeg2(), this::setTotalNotionalQuantityLeg2);
			merger.mergeBasic(getNotionalQuantityLeg1(), o.getNotionalQuantityLeg1(), this::setNotionalQuantityLeg1);
			merger.mergeBasic(getNotionalQuantityLeg2(), o.getNotionalQuantityLeg2(), this::setNotionalQuantityLeg2);
			merger.mergeBasic(getCallAmount(), o.getCallAmount(), this::setCallAmount);
			merger.mergeBasic(getPutAmount(), o.getPutAmount(), this::setPutAmount);
			merger.mergeBasic(getNotionalCurrencyLeg1(), o.getNotionalCurrencyLeg1(), this::setNotionalCurrencyLeg1);
			merger.mergeBasic(getNotionalCurrencyLeg2(), o.getNotionalCurrencyLeg2(), this::setNotionalCurrencyLeg2);
			merger.mergeBasic(getQuantityUnitOfMeasureLeg1(), o.getQuantityUnitOfMeasureLeg1(), this::setQuantityUnitOfMeasureLeg1);
			merger.mergeBasic(getQuantityUnitOfMeasureLeg2(), o.getQuantityUnitOfMeasureLeg2(), this::setQuantityUnitOfMeasureLeg2);
			merger.mergeBasic(getCallCurrency(), o.getCallCurrency(), this::setCallCurrency);
			merger.mergeBasic(getPutCurrency(), o.getPutCurrency(), this::setPutCurrency);
			merger.mergeBasic(getPriceUnitOfMeasure(), o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure);
			merger.mergeBasic(getFixedRateLeg1(), o.getFixedRateLeg1(), this::setFixedRateLeg1);
			merger.mergeBasic(getFixedRateLeg2(), o.getFixedRateLeg2(), this::setFixedRateLeg2);
			merger.mergeBasic(getSpreadNotationLeg1(), o.getSpreadNotationLeg1(), this::setSpreadNotationLeg1);
			merger.mergeBasic(getSpreadNotationLeg2(), o.getSpreadNotationLeg2(), this::setSpreadNotationLeg2);
			merger.mergeBasic(getSpreadCurrencyLeg1(), o.getSpreadCurrencyLeg1(), this::setSpreadCurrencyLeg1);
			merger.mergeBasic(getSpreadCurrencyLeg2(), o.getSpreadCurrencyLeg2(), this::setSpreadCurrencyLeg2);
			merger.mergeBasic(getOptionPremiumAmount(), o.getOptionPremiumAmount(), this::setOptionPremiumAmount);
			merger.mergeBasic(getOptionPremiumCurrency(), o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency);
			merger.mergeBasic(getOptionPremiumPaymentDate(), o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate);
			merger.mergeBasic(getExchangeRate(), o.getExchangeRate(), this::setExchangeRate);
			merger.mergeBasic(getExchangeRateBasis(), o.getExchangeRateBasis(), this::setExchangeRateBasis);
			merger.mergeBasic(getDayCountConventionLeg1(), o.getDayCountConventionLeg1(), this::setDayCountConventionLeg1);
			merger.mergeBasic(getDayCountConventionLeg2(), o.getDayCountConventionLeg2(), this::setDayCountConventionLeg2);
			merger.mergeBasic(getPaymentFrequencyPeriodLeg1(), o.getPaymentFrequencyPeriodLeg1(), this::setPaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getPaymentFrequencyPeriodLeg2(), o.getPaymentFrequencyPeriodLeg2(), this::setPaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getPaymentFrequencyPeriodMultiplierLeg1(), o.getPaymentFrequencyPeriodMultiplierLeg1(), this::setPaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getPaymentFrequencyPeriodMultiplierLeg2(), o.getPaymentFrequencyPeriodMultiplierLeg2(), this::setPaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getSettlementCurrencyLeg1(), o.getSettlementCurrencyLeg1(), this::setSettlementCurrencyLeg1);
			merger.mergeBasic(getSettlementCurrencyLeg2(), o.getSettlementCurrencyLeg2(), this::setSettlementCurrencyLeg2);
			merger.mergeBasic(getUnderlyingIdentification(), o.getUnderlyingIdentification(), this::setUnderlyingIdentification);
			merger.mergeBasic(getUnderlyingIdentificationType(), o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType);
			merger.mergeBasic(getUnderlyingIdOther(), o.getUnderlyingIdOther(), this::setUnderlyingIdOther);
			merger.mergeBasic(getUnderlyingIdOtherSource(), o.getUnderlyingIdOtherSource(), this::setUnderlyingIdOtherSource);
			merger.mergeBasic(getMaturityDateOfTheUnderlying(), o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying);
			merger.mergeBasic(getIndicatorOfTheFloatingRateLeg2(), o.getIndicatorOfTheFloatingRateLeg2(), this::setIndicatorOfTheFloatingRateLeg2);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg2TimePeriod(), o.getFloatingRateReferencePeriodOfLeg2TimePeriod(), this::setFloatingRateReferencePeriodOfLeg2TimePeriod);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg2Multiplier(), o.getFloatingRateReferencePeriodOfLeg2Multiplier(), this::setFloatingRateReferencePeriodOfLeg2Multiplier);
			merger.mergeBasic(getCdSIndexAttachmentPoint(), o.getCdSIndexAttachmentPoint(), this::setCdSIndexAttachmentPoint);
			merger.mergeBasic(getCdSIndexDetachmentPoint(), o.getCdSIndexDetachmentPoint(), this::setCdSIndexDetachmentPoint);
			merger.mergeBasic(getIndexFactor(), o.getIndexFactor(), this::setIndexFactor);
			merger.mergeBasic(getPackageIdentifier(), o.getPackageIdentifier(), this::setPackageIdentifier);
			merger.mergeBasic(getPriorUTI(), o.getPriorUTI(), this::setPriorUTI);
			merger.mergeBasic(getPriorUtiProprietary(), o.getPriorUtiProprietary(), this::setPriorUtiProprietary);
			merger.mergeBasic(getEventIdentifier(), o.getEventIdentifier(), this::setEventIdentifier);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getEventType(), o.getEventType(), this::setEventType);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getReportSubmittingEntityID(), o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID);
			merger.mergeBasic(getNewDerivativeTradeRepository(), o.getNewDerivativeTradeRepository(), this::setNewDerivativeTradeRepository);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getDelta(), o.getDelta(), this::setDelta);
			merger.mergeBasic(getNextFloatingReferenceResetDateLeg1(), o.getNextFloatingReferenceResetDateLeg1(), this::setNextFloatingReferenceResetDateLeg1);
			merger.mergeBasic(getNextFloatingReferenceResetDateLeg2(), o.getNextFloatingReferenceResetDateLeg2(), this::setNextFloatingReferenceResetDateLeg2);
			merger.mergeBasic(getSmallScaleBuySideEntityIndicator(), o.getSmallScaleBuySideEntityIndicator(), this::setSmallScaleBuySideEntityIndicator);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getCollateralPortfolioCodeInitialMargin(), o.getCollateralPortfolioCodeInitialMargin(), this::setCollateralPortfolioCodeInitialMargin);
			merger.mergeBasic(getCollateralPortfolioCodeVariationMargin(), o.getCollateralPortfolioCodeVariationMargin(), this::setCollateralPortfolioCodeVariationMargin);
			merger.mergeBasic(getExecutionAgentOfCounterparty2DTCC(), o.getExecutionAgentOfCounterparty2DTCC(), this::setExecutionAgentOfCounterparty2DTCC);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ASICTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(utiProprietaryID, _that.getUtiProprietaryID())) return false;
			if (!Objects.equals(secondaryTransactionIdentifier, _that.getSecondaryTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueProductIdentifier, _that.getUniqueProductIdentifier())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(reportingEntity, _that.getReportingEntity())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2Name, _that.getCounterparty2Name())) return false;
			if (!Objects.equals(counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) return false;
			if (!Objects.equals(countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) return false;
			if (!Objects.equals(beneficiary1, _that.getBeneficiary1())) return false;
			if (!Objects.equals(beneficiary1IdentifierTypeIndicator, _that.getBeneficiary1IdentifierTypeIndicator())) return false;
			if (!Objects.equals(broker, _that.getBroker())) return false;
			if (!Objects.equals(executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) return false;
			if (!Objects.equals(direction, _that.getDirection())) return false;
			if (!Objects.equals(direction2OfLeg1, _that.getDirection2OfLeg1())) return false;
			if (!Objects.equals(direction2OfLeg2, _that.getDirection2OfLeg2())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(clearingTimestamp, _that.getClearingTimestamp())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(platformIdentifier, _that.getPlatformIdentifier())) return false;
			if (!Objects.equals(notionalLeg1, _that.getNotionalLeg1())) return false;
			if (!Objects.equals(notionalLeg2, _that.getNotionalLeg2())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(notionalQuantityLeg1, _that.getNotionalQuantityLeg1())) return false;
			if (!Objects.equals(notionalQuantityLeg2, _that.getNotionalQuantityLeg2())) return false;
			if (!Objects.equals(callAmount, _that.getCallAmount())) return false;
			if (!Objects.equals(putAmount, _that.getPutAmount())) return false;
			if (!Objects.equals(notionalCurrencyLeg1, _that.getNotionalCurrencyLeg1())) return false;
			if (!Objects.equals(notionalCurrencyLeg2, _that.getNotionalCurrencyLeg2())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) return false;
			if (!Objects.equals(callCurrency, _that.getCallCurrency())) return false;
			if (!Objects.equals(putCurrency, _that.getPutCurrency())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!Objects.equals(priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) return false;
			if (!Objects.equals(fixedRateLeg1, _that.getFixedRateLeg1())) return false;
			if (!Objects.equals(fixedRateLeg2, _that.getFixedRateLeg2())) return false;
			if (!Objects.equals(spreadNotationLeg1, _that.getSpreadNotationLeg1())) return false;
			if (!Objects.equals(spreadLeg1, _that.getSpreadLeg1())) return false;
			if (!Objects.equals(spreadNotationLeg2, _that.getSpreadNotationLeg2())) return false;
			if (!Objects.equals(spreadLeg2, _that.getSpreadLeg2())) return false;
			if (!Objects.equals(spreadCurrencyLeg1, _that.getSpreadCurrencyLeg1())) return false;
			if (!Objects.equals(spreadCurrencyLeg2, _that.getSpreadCurrencyLeg2())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!Objects.equals(barrier, _that.getBarrier())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(dayCountConventionLeg1, _that.getDayCountConventionLeg1())) return false;
			if (!Objects.equals(dayCountConventionLeg2, _that.getDayCountConventionLeg2())) return false;
			if (!Objects.equals(paymentFrequencyPeriodLeg1, _that.getPaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(paymentFrequencyPeriodLeg2, _that.getPaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(paymentFrequencyPeriodMultiplierLeg1, _that.getPaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(paymentFrequencyPeriodMultiplierLeg2, _that.getPaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) return false;
			if (!Objects.equals(settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(basket, _that.getBasket())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdOther, _that.getUnderlyingIdOther())) return false;
			if (!Objects.equals(underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateLeg2, _that.getIndicatorOfTheFloatingRateLeg2())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) return false;
			if (!Objects.equals(cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(packageTransactionPrice, _that.getPackageTransactionPrice())) return false;
			if (!Objects.equals(packageTransactionSpread, _that.getPackageTransactionSpread())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(priorUtiProprietary, _that.getPriorUtiProprietary())) return false;
			if (!Objects.equals(eventIdentifier, _that.getEventIdentifier())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(newDerivativeTradeRepository, _that.getNewDerivativeTradeRepository())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) return false;
			if (!Objects.equals(smallScaleBuySideEntityIndicator, _that.getSmallScaleBuySideEntityIndicator())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(collateralPortfolioCodeInitialMargin, _that.getCollateralPortfolioCodeInitialMargin())) return false;
			if (!Objects.equals(collateralPortfolioCodeVariationMargin, _that.getCollateralPortfolioCodeVariationMargin())) return false;
			if (!Objects.equals(executionAgentOfCounterparty2DTCC, _that.getExecutionAgentOfCounterparty2DTCC())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (utiProprietaryID != null ? utiProprietaryID.hashCode() : 0);
			_result = 31 * _result + (secondaryTransactionIdentifier != null ? secondaryTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifier != null ? uniqueProductIdentifier.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (reportingEntity != null ? reportingEntity.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2Name != null ? counterparty2Name.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierTypeIndicator != null ? counterparty2IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (countryOfTheCounterParty2 != null ? countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (beneficiary1 != null ? beneficiary1.hashCode() : 0);
			_result = 31 * _result + (beneficiary1IdentifierTypeIndicator != null ? beneficiary1IdentifierTypeIndicator.hashCode() : 0);
			_result = 31 * _result + (broker != null ? broker.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty1 != null ? executionAgentOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (direction != null ? direction.hashCode() : 0);
			_result = 31 * _result + (direction2OfLeg1 != null ? direction2OfLeg1.hashCode() : 0);
			_result = 31 * _result + (direction2OfLeg2 != null ? direction2OfLeg2.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingTimestamp != null ? clearingTimestamp.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (platformIdentifier != null ? platformIdentifier.hashCode() : 0);
			_result = 31 * _result + (notionalLeg1 != null ? notionalLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalLeg2 != null ? notionalLeg2.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityLeg1 != null ? notionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityLeg2 != null ? notionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (callAmount != null ? callAmount.hashCode() : 0);
			_result = 31 * _result + (putAmount != null ? putAmount.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyLeg1 != null ? notionalCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyLeg2 != null ? notionalCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg1 != null ? quantityUnitOfMeasureLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg2 != null ? quantityUnitOfMeasureLeg2.hashCode() : 0);
			_result = 31 * _result + (callCurrency != null ? callCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (putCurrency != null ? putCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1 != null ? notionalAmountScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2 != null ? notionalAmountScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceUnitOfMeasure != null ? priceUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg1 != null ? fixedRateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg2 != null ? fixedRateLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadNotationLeg1 != null ? spreadNotationLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1 != null ? spreadLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadNotationLeg2 != null ? spreadNotationLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2 != null ? spreadLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyLeg1 != null ? spreadCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyLeg2 != null ? spreadCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (barrier != null ? barrier.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (dayCountConventionLeg1 != null ? dayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (dayCountConventionLeg2 != null ? dayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodLeg1 != null ? paymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodLeg2 != null ? paymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodMultiplierLeg1 != null ? paymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (paymentFrequencyPeriodMultiplierLeg2 != null ? paymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg1 != null ? settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg2 != null ? settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (basket != null ? basket.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOther != null ? underlyingIdOther.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOtherSource != null ? underlyingIdOtherSource.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateLeg2 != null ? indicatorOfTheFloatingRateLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2TimePeriod != null ? floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2Multiplier != null ? floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
			_result = 31 * _result + (cdSIndexAttachmentPoint != null ? cdSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cdSIndexDetachmentPoint != null ? cdSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPrice != null ? packageTransactionPrice.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpread != null ? packageTransactionSpread.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (priorUtiProprietary != null ? priorUtiProprietary.hashCode() : 0);
			_result = 31 * _result + (eventIdentifier != null ? eventIdentifier.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (newDerivativeTradeRepository != null ? newDerivativeTradeRepository.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg1 != null ? nextFloatingReferenceResetDateLeg1.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg2 != null ? nextFloatingReferenceResetDateLeg2.hashCode() : 0);
			_result = 31 * _result + (smallScaleBuySideEntityIndicator != null ? smallScaleBuySideEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCodeInitialMargin != null ? collateralPortfolioCodeInitialMargin.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCodeVariationMargin != null ? collateralPortfolioCodeVariationMargin.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty2DTCC != null ? executionAgentOfCounterparty2DTCC.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ASICTransactionReportBuilder {" +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"utiProprietaryID=" + this.utiProprietaryID + ", " +
				"secondaryTransactionIdentifier=" + this.secondaryTransactionIdentifier + ", " +
				"uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", " +
				"assetClass=" + this.assetClass + ", " +
				"contractType=" + this.contractType + ", " +
				"reportingEntity=" + this.reportingEntity + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2Name=" + this.counterparty2Name + ", " +
				"counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", " +
				"countryOfTheCounterParty2=" + this.countryOfTheCounterParty2 + ", " +
				"beneficiary1=" + this.beneficiary1 + ", " +
				"beneficiary1IdentifierTypeIndicator=" + this.beneficiary1IdentifierTypeIndicator + ", " +
				"broker=" + this.broker + ", " +
				"executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + ", " +
				"direction=" + this.direction + ", " +
				"direction2OfLeg1=" + this.direction2OfLeg1 + ", " +
				"direction2OfLeg2=" + this.direction2OfLeg2 + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"clearingTimestamp=" + this.clearingTimestamp + ", " +
				"cleared=" + this.cleared + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"platformIdentifier=" + this.platformIdentifier + ", " +
				"notionalLeg1=" + this.notionalLeg1 + ", " +
				"notionalLeg2=" + this.notionalLeg2 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"notionalQuantityLeg1=" + this.notionalQuantityLeg1 + ", " +
				"notionalQuantityLeg2=" + this.notionalQuantityLeg2 + ", " +
				"callAmount=" + this.callAmount + ", " +
				"putAmount=" + this.putAmount + ", " +
				"notionalCurrencyLeg1=" + this.notionalCurrencyLeg1 + ", " +
				"notionalCurrencyLeg2=" + this.notionalCurrencyLeg2 + ", " +
				"quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", " +
				"quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", " +
				"callCurrency=" + this.callCurrency + ", " +
				"putCurrency=" + this.putCurrency + ", " +
				"notionalAmountScheduleLeg1=" + this.notionalAmountScheduleLeg1 + ", " +
				"notionalAmountScheduleLeg2=" + this.notionalAmountScheduleLeg2 + ", " +
				"price=" + this.price + ", " +
				"priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", " +
				"fixedRateLeg1=" + this.fixedRateLeg1 + ", " +
				"fixedRateLeg2=" + this.fixedRateLeg2 + ", " +
				"spreadNotationLeg1=" + this.spreadNotationLeg1 + ", " +
				"spreadLeg1=" + this.spreadLeg1 + ", " +
				"spreadNotationLeg2=" + this.spreadNotationLeg2 + ", " +
				"spreadLeg2=" + this.spreadLeg2 + ", " +
				"spreadCurrencyLeg1=" + this.spreadCurrencyLeg1 + ", " +
				"spreadCurrencyLeg2=" + this.spreadCurrencyLeg2 + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"barrier=" + this.barrier + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"dayCountConventionLeg1=" + this.dayCountConventionLeg1 + ", " +
				"dayCountConventionLeg2=" + this.dayCountConventionLeg2 + ", " +
				"paymentFrequencyPeriodLeg1=" + this.paymentFrequencyPeriodLeg1 + ", " +
				"paymentFrequencyPeriodLeg2=" + this.paymentFrequencyPeriodLeg2 + ", " +
				"paymentFrequencyPeriodMultiplierLeg1=" + this.paymentFrequencyPeriodMultiplierLeg1 + ", " +
				"paymentFrequencyPeriodMultiplierLeg2=" + this.paymentFrequencyPeriodMultiplierLeg2 + ", " +
				"settlementCurrencyLeg1=" + this.settlementCurrencyLeg1 + ", " +
				"settlementCurrencyLeg2=" + this.settlementCurrencyLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"basket=" + this.basket + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdOther=" + this.underlyingIdOther + ", " +
				"underlyingIdOtherSource=" + this.underlyingIdOtherSource + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"indicatorOfTheFloatingRateLeg2=" + this.indicatorOfTheFloatingRateLeg2 + ", " +
				"floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", " +
				"cdSIndexAttachmentPoint=" + this.cdSIndexAttachmentPoint + ", " +
				"cdSIndexDetachmentPoint=" + this.cdSIndexDetachmentPoint + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"packageTransactionPrice=" + this.packageTransactionPrice + ", " +
				"packageTransactionSpread=" + this.packageTransactionSpread + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"priorUtiProprietary=" + this.priorUtiProprietary + ", " +
				"eventIdentifier=" + this.eventIdentifier + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"newDerivativeTradeRepository=" + this.newDerivativeTradeRepository + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"nextFloatingReferenceResetDateLeg1=" + this.nextFloatingReferenceResetDateLeg1 + ", " +
				"nextFloatingReferenceResetDateLeg2=" + this.nextFloatingReferenceResetDateLeg2 + ", " +
				"smallScaleBuySideEntityIndicator=" + this.smallScaleBuySideEntityIndicator + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"collateralPortfolioCodeInitialMargin=" + this.collateralPortfolioCodeInitialMargin + ", " +
				"collateralPortfolioCodeVariationMargin=" + this.collateralPortfolioCodeVariationMargin + ", " +
				"executionAgentOfCounterparty2DTCC=" + this.executionAgentOfCounterparty2DTCC + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}
}
