package drr.regulation.asic.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.asic.rewrite.trade.meta.BarrierAndNotationMeta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="BarrierAndNotation", builder=BarrierAndNotation.BarrierAndNotationBuilderImpl.class, version="5.53.0")
@RuneDataType(value="BarrierAndNotation", model="drr", builder=BarrierAndNotation.BarrierAndNotationBuilderImpl.class, version="5.53.0")
public interface BarrierAndNotation extends RosettaModelObject {

	BarrierAndNotationMeta metaData = new BarrierAndNotationMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getSingleBarrierPriceMonetary();
	BigDecimal getSingleBarrierPriceDecimal();
	BigDecimal getLowerBarrierPriceMonetary();
	BigDecimal getLowerBarrierPriceDecimal();
	BigDecimal getUpperBarrierPriceMonetary();
	BigDecimal getUpperBarrierPriceDecimal();
	PriceNotationEnum getSingleBarrierPriceNotation();
	PriceNotationEnum getLowerBarrierPriceNotation();
	PriceNotationEnum getUpperBarrierPriceNotation();
	ISOCurrencyCodeEnum getSingleBarrierPriceCurrency();
	ISOCurrencyCodeEnum getLowerBarrierPriceCurrency();
	ISOCurrencyCodeEnum getUpperBarrierPriceCurrency();

	/*********************** Build Methods  ***********************/
	BarrierAndNotation build();
	
	BarrierAndNotation.BarrierAndNotationBuilder toBuilder();
	
	static BarrierAndNotation.BarrierAndNotationBuilder builder() {
		return new BarrierAndNotation.BarrierAndNotationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends BarrierAndNotation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends BarrierAndNotation> getType() {
		return BarrierAndNotation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("singleBarrierPriceMonetary"), BigDecimal.class, getSingleBarrierPriceMonetary(), this);
		processor.processBasic(path.newSubPath("singleBarrierPriceDecimal"), BigDecimal.class, getSingleBarrierPriceDecimal(), this);
		processor.processBasic(path.newSubPath("lowerBarrierPriceMonetary"), BigDecimal.class, getLowerBarrierPriceMonetary(), this);
		processor.processBasic(path.newSubPath("lowerBarrierPriceDecimal"), BigDecimal.class, getLowerBarrierPriceDecimal(), this);
		processor.processBasic(path.newSubPath("upperBarrierPriceMonetary"), BigDecimal.class, getUpperBarrierPriceMonetary(), this);
		processor.processBasic(path.newSubPath("upperBarrierPriceDecimal"), BigDecimal.class, getUpperBarrierPriceDecimal(), this);
		processor.processBasic(path.newSubPath("singleBarrierPriceNotation"), PriceNotationEnum.class, getSingleBarrierPriceNotation(), this);
		processor.processBasic(path.newSubPath("lowerBarrierPriceNotation"), PriceNotationEnum.class, getLowerBarrierPriceNotation(), this);
		processor.processBasic(path.newSubPath("upperBarrierPriceNotation"), PriceNotationEnum.class, getUpperBarrierPriceNotation(), this);
		processor.processBasic(path.newSubPath("singleBarrierPriceCurrency"), ISOCurrencyCodeEnum.class, getSingleBarrierPriceCurrency(), this);
		processor.processBasic(path.newSubPath("lowerBarrierPriceCurrency"), ISOCurrencyCodeEnum.class, getLowerBarrierPriceCurrency(), this);
		processor.processBasic(path.newSubPath("upperBarrierPriceCurrency"), ISOCurrencyCodeEnum.class, getUpperBarrierPriceCurrency(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface BarrierAndNotationBuilder extends BarrierAndNotation, RosettaModelObjectBuilder {
		BarrierAndNotation.BarrierAndNotationBuilder setSingleBarrierPriceMonetary(BigDecimal singleBarrierPriceMonetary);
		BarrierAndNotation.BarrierAndNotationBuilder setSingleBarrierPriceDecimal(BigDecimal singleBarrierPriceDecimal);
		BarrierAndNotation.BarrierAndNotationBuilder setLowerBarrierPriceMonetary(BigDecimal lowerBarrierPriceMonetary);
		BarrierAndNotation.BarrierAndNotationBuilder setLowerBarrierPriceDecimal(BigDecimal lowerBarrierPriceDecimal);
		BarrierAndNotation.BarrierAndNotationBuilder setUpperBarrierPriceMonetary(BigDecimal upperBarrierPriceMonetary);
		BarrierAndNotation.BarrierAndNotationBuilder setUpperBarrierPriceDecimal(BigDecimal upperBarrierPriceDecimal);
		BarrierAndNotation.BarrierAndNotationBuilder setSingleBarrierPriceNotation(PriceNotationEnum singleBarrierPriceNotation);
		BarrierAndNotation.BarrierAndNotationBuilder setLowerBarrierPriceNotation(PriceNotationEnum lowerBarrierPriceNotation);
		BarrierAndNotation.BarrierAndNotationBuilder setUpperBarrierPriceNotation(PriceNotationEnum upperBarrierPriceNotation);
		BarrierAndNotation.BarrierAndNotationBuilder setSingleBarrierPriceCurrency(ISOCurrencyCodeEnum singleBarrierPriceCurrency);
		BarrierAndNotation.BarrierAndNotationBuilder setLowerBarrierPriceCurrency(ISOCurrencyCodeEnum lowerBarrierPriceCurrency);
		BarrierAndNotation.BarrierAndNotationBuilder setUpperBarrierPriceCurrency(ISOCurrencyCodeEnum upperBarrierPriceCurrency);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("singleBarrierPriceMonetary"), BigDecimal.class, getSingleBarrierPriceMonetary(), this);
			processor.processBasic(path.newSubPath("singleBarrierPriceDecimal"), BigDecimal.class, getSingleBarrierPriceDecimal(), this);
			processor.processBasic(path.newSubPath("lowerBarrierPriceMonetary"), BigDecimal.class, getLowerBarrierPriceMonetary(), this);
			processor.processBasic(path.newSubPath("lowerBarrierPriceDecimal"), BigDecimal.class, getLowerBarrierPriceDecimal(), this);
			processor.processBasic(path.newSubPath("upperBarrierPriceMonetary"), BigDecimal.class, getUpperBarrierPriceMonetary(), this);
			processor.processBasic(path.newSubPath("upperBarrierPriceDecimal"), BigDecimal.class, getUpperBarrierPriceDecimal(), this);
			processor.processBasic(path.newSubPath("singleBarrierPriceNotation"), PriceNotationEnum.class, getSingleBarrierPriceNotation(), this);
			processor.processBasic(path.newSubPath("lowerBarrierPriceNotation"), PriceNotationEnum.class, getLowerBarrierPriceNotation(), this);
			processor.processBasic(path.newSubPath("upperBarrierPriceNotation"), PriceNotationEnum.class, getUpperBarrierPriceNotation(), this);
			processor.processBasic(path.newSubPath("singleBarrierPriceCurrency"), ISOCurrencyCodeEnum.class, getSingleBarrierPriceCurrency(), this);
			processor.processBasic(path.newSubPath("lowerBarrierPriceCurrency"), ISOCurrencyCodeEnum.class, getLowerBarrierPriceCurrency(), this);
			processor.processBasic(path.newSubPath("upperBarrierPriceCurrency"), ISOCurrencyCodeEnum.class, getUpperBarrierPriceCurrency(), this);
		}
		

		BarrierAndNotation.BarrierAndNotationBuilder prune();
	}

	/*********************** Immutable Implementation of BarrierAndNotation  ***********************/
	class BarrierAndNotationImpl implements BarrierAndNotation {
		private final BigDecimal singleBarrierPriceMonetary;
		private final BigDecimal singleBarrierPriceDecimal;
		private final BigDecimal lowerBarrierPriceMonetary;
		private final BigDecimal lowerBarrierPriceDecimal;
		private final BigDecimal upperBarrierPriceMonetary;
		private final BigDecimal upperBarrierPriceDecimal;
		private final PriceNotationEnum singleBarrierPriceNotation;
		private final PriceNotationEnum lowerBarrierPriceNotation;
		private final PriceNotationEnum upperBarrierPriceNotation;
		private final ISOCurrencyCodeEnum singleBarrierPriceCurrency;
		private final ISOCurrencyCodeEnum lowerBarrierPriceCurrency;
		private final ISOCurrencyCodeEnum upperBarrierPriceCurrency;
		
		protected BarrierAndNotationImpl(BarrierAndNotation.BarrierAndNotationBuilder builder) {
			this.singleBarrierPriceMonetary = builder.getSingleBarrierPriceMonetary();
			this.singleBarrierPriceDecimal = builder.getSingleBarrierPriceDecimal();
			this.lowerBarrierPriceMonetary = builder.getLowerBarrierPriceMonetary();
			this.lowerBarrierPriceDecimal = builder.getLowerBarrierPriceDecimal();
			this.upperBarrierPriceMonetary = builder.getUpperBarrierPriceMonetary();
			this.upperBarrierPriceDecimal = builder.getUpperBarrierPriceDecimal();
			this.singleBarrierPriceNotation = builder.getSingleBarrierPriceNotation();
			this.lowerBarrierPriceNotation = builder.getLowerBarrierPriceNotation();
			this.upperBarrierPriceNotation = builder.getUpperBarrierPriceNotation();
			this.singleBarrierPriceCurrency = builder.getSingleBarrierPriceCurrency();
			this.lowerBarrierPriceCurrency = builder.getLowerBarrierPriceCurrency();
			this.upperBarrierPriceCurrency = builder.getUpperBarrierPriceCurrency();
		}
		
		@Override
		@RosettaAttribute("singleBarrierPriceMonetary")
		@RuneAttribute("singleBarrierPriceMonetary")
		public BigDecimal getSingleBarrierPriceMonetary() {
			return singleBarrierPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("singleBarrierPriceDecimal")
		@RuneAttribute("singleBarrierPriceDecimal")
		public BigDecimal getSingleBarrierPriceDecimal() {
			return singleBarrierPriceDecimal;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierPriceMonetary")
		@RuneAttribute("lowerBarrierPriceMonetary")
		public BigDecimal getLowerBarrierPriceMonetary() {
			return lowerBarrierPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierPriceDecimal")
		@RuneAttribute("lowerBarrierPriceDecimal")
		public BigDecimal getLowerBarrierPriceDecimal() {
			return lowerBarrierPriceDecimal;
		}
		
		@Override
		@RosettaAttribute("upperBarrierPriceMonetary")
		@RuneAttribute("upperBarrierPriceMonetary")
		public BigDecimal getUpperBarrierPriceMonetary() {
			return upperBarrierPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("upperBarrierPriceDecimal")
		@RuneAttribute("upperBarrierPriceDecimal")
		public BigDecimal getUpperBarrierPriceDecimal() {
			return upperBarrierPriceDecimal;
		}
		
		@Override
		@RosettaAttribute("singleBarrierPriceNotation")
		@RuneAttribute("singleBarrierPriceNotation")
		public PriceNotationEnum getSingleBarrierPriceNotation() {
			return singleBarrierPriceNotation;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierPriceNotation")
		@RuneAttribute("lowerBarrierPriceNotation")
		public PriceNotationEnum getLowerBarrierPriceNotation() {
			return lowerBarrierPriceNotation;
		}
		
		@Override
		@RosettaAttribute("upperBarrierPriceNotation")
		@RuneAttribute("upperBarrierPriceNotation")
		public PriceNotationEnum getUpperBarrierPriceNotation() {
			return upperBarrierPriceNotation;
		}
		
		@Override
		@RosettaAttribute("singleBarrierPriceCurrency")
		@RuneAttribute("singleBarrierPriceCurrency")
		public ISOCurrencyCodeEnum getSingleBarrierPriceCurrency() {
			return singleBarrierPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierPriceCurrency")
		@RuneAttribute("lowerBarrierPriceCurrency")
		public ISOCurrencyCodeEnum getLowerBarrierPriceCurrency() {
			return lowerBarrierPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("upperBarrierPriceCurrency")
		@RuneAttribute("upperBarrierPriceCurrency")
		public ISOCurrencyCodeEnum getUpperBarrierPriceCurrency() {
			return upperBarrierPriceCurrency;
		}
		
		@Override
		public BarrierAndNotation build() {
			return this;
		}
		
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder toBuilder() {
			BarrierAndNotation.BarrierAndNotationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(BarrierAndNotation.BarrierAndNotationBuilder builder) {
			ofNullable(getSingleBarrierPriceMonetary()).ifPresent(builder::setSingleBarrierPriceMonetary);
			ofNullable(getSingleBarrierPriceDecimal()).ifPresent(builder::setSingleBarrierPriceDecimal);
			ofNullable(getLowerBarrierPriceMonetary()).ifPresent(builder::setLowerBarrierPriceMonetary);
			ofNullable(getLowerBarrierPriceDecimal()).ifPresent(builder::setLowerBarrierPriceDecimal);
			ofNullable(getUpperBarrierPriceMonetary()).ifPresent(builder::setUpperBarrierPriceMonetary);
			ofNullable(getUpperBarrierPriceDecimal()).ifPresent(builder::setUpperBarrierPriceDecimal);
			ofNullable(getSingleBarrierPriceNotation()).ifPresent(builder::setSingleBarrierPriceNotation);
			ofNullable(getLowerBarrierPriceNotation()).ifPresent(builder::setLowerBarrierPriceNotation);
			ofNullable(getUpperBarrierPriceNotation()).ifPresent(builder::setUpperBarrierPriceNotation);
			ofNullable(getSingleBarrierPriceCurrency()).ifPresent(builder::setSingleBarrierPriceCurrency);
			ofNullable(getLowerBarrierPriceCurrency()).ifPresent(builder::setLowerBarrierPriceCurrency);
			ofNullable(getUpperBarrierPriceCurrency()).ifPresent(builder::setUpperBarrierPriceCurrency);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			BarrierAndNotation _that = getType().cast(o);
		
			if (!Objects.equals(singleBarrierPriceMonetary, _that.getSingleBarrierPriceMonetary())) return false;
			if (!Objects.equals(singleBarrierPriceDecimal, _that.getSingleBarrierPriceDecimal())) return false;
			if (!Objects.equals(lowerBarrierPriceMonetary, _that.getLowerBarrierPriceMonetary())) return false;
			if (!Objects.equals(lowerBarrierPriceDecimal, _that.getLowerBarrierPriceDecimal())) return false;
			if (!Objects.equals(upperBarrierPriceMonetary, _that.getUpperBarrierPriceMonetary())) return false;
			if (!Objects.equals(upperBarrierPriceDecimal, _that.getUpperBarrierPriceDecimal())) return false;
			if (!Objects.equals(singleBarrierPriceNotation, _that.getSingleBarrierPriceNotation())) return false;
			if (!Objects.equals(lowerBarrierPriceNotation, _that.getLowerBarrierPriceNotation())) return false;
			if (!Objects.equals(upperBarrierPriceNotation, _that.getUpperBarrierPriceNotation())) return false;
			if (!Objects.equals(singleBarrierPriceCurrency, _that.getSingleBarrierPriceCurrency())) return false;
			if (!Objects.equals(lowerBarrierPriceCurrency, _that.getLowerBarrierPriceCurrency())) return false;
			if (!Objects.equals(upperBarrierPriceCurrency, _that.getUpperBarrierPriceCurrency())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (singleBarrierPriceMonetary != null ? singleBarrierPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (singleBarrierPriceDecimal != null ? singleBarrierPriceDecimal.hashCode() : 0);
			_result = 31 * _result + (lowerBarrierPriceMonetary != null ? lowerBarrierPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (lowerBarrierPriceDecimal != null ? lowerBarrierPriceDecimal.hashCode() : 0);
			_result = 31 * _result + (upperBarrierPriceMonetary != null ? upperBarrierPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (upperBarrierPriceDecimal != null ? upperBarrierPriceDecimal.hashCode() : 0);
			_result = 31 * _result + (singleBarrierPriceNotation != null ? singleBarrierPriceNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (lowerBarrierPriceNotation != null ? lowerBarrierPriceNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (upperBarrierPriceNotation != null ? upperBarrierPriceNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (singleBarrierPriceCurrency != null ? singleBarrierPriceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (lowerBarrierPriceCurrency != null ? lowerBarrierPriceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (upperBarrierPriceCurrency != null ? upperBarrierPriceCurrency.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "BarrierAndNotation {" +
				"singleBarrierPriceMonetary=" + this.singleBarrierPriceMonetary + ", " +
				"singleBarrierPriceDecimal=" + this.singleBarrierPriceDecimal + ", " +
				"lowerBarrierPriceMonetary=" + this.lowerBarrierPriceMonetary + ", " +
				"lowerBarrierPriceDecimal=" + this.lowerBarrierPriceDecimal + ", " +
				"upperBarrierPriceMonetary=" + this.upperBarrierPriceMonetary + ", " +
				"upperBarrierPriceDecimal=" + this.upperBarrierPriceDecimal + ", " +
				"singleBarrierPriceNotation=" + this.singleBarrierPriceNotation + ", " +
				"lowerBarrierPriceNotation=" + this.lowerBarrierPriceNotation + ", " +
				"upperBarrierPriceNotation=" + this.upperBarrierPriceNotation + ", " +
				"singleBarrierPriceCurrency=" + this.singleBarrierPriceCurrency + ", " +
				"lowerBarrierPriceCurrency=" + this.lowerBarrierPriceCurrency + ", " +
				"upperBarrierPriceCurrency=" + this.upperBarrierPriceCurrency +
			'}';
		}
	}

	/*********************** Builder Implementation of BarrierAndNotation  ***********************/
	class BarrierAndNotationBuilderImpl implements BarrierAndNotation.BarrierAndNotationBuilder {
	
		protected BigDecimal singleBarrierPriceMonetary;
		protected BigDecimal singleBarrierPriceDecimal;
		protected BigDecimal lowerBarrierPriceMonetary;
		protected BigDecimal lowerBarrierPriceDecimal;
		protected BigDecimal upperBarrierPriceMonetary;
		protected BigDecimal upperBarrierPriceDecimal;
		protected PriceNotationEnum singleBarrierPriceNotation;
		protected PriceNotationEnum lowerBarrierPriceNotation;
		protected PriceNotationEnum upperBarrierPriceNotation;
		protected ISOCurrencyCodeEnum singleBarrierPriceCurrency;
		protected ISOCurrencyCodeEnum lowerBarrierPriceCurrency;
		protected ISOCurrencyCodeEnum upperBarrierPriceCurrency;
		
		@Override
		@RosettaAttribute("singleBarrierPriceMonetary")
		@RuneAttribute("singleBarrierPriceMonetary")
		public BigDecimal getSingleBarrierPriceMonetary() {
			return singleBarrierPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("singleBarrierPriceDecimal")
		@RuneAttribute("singleBarrierPriceDecimal")
		public BigDecimal getSingleBarrierPriceDecimal() {
			return singleBarrierPriceDecimal;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierPriceMonetary")
		@RuneAttribute("lowerBarrierPriceMonetary")
		public BigDecimal getLowerBarrierPriceMonetary() {
			return lowerBarrierPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierPriceDecimal")
		@RuneAttribute("lowerBarrierPriceDecimal")
		public BigDecimal getLowerBarrierPriceDecimal() {
			return lowerBarrierPriceDecimal;
		}
		
		@Override
		@RosettaAttribute("upperBarrierPriceMonetary")
		@RuneAttribute("upperBarrierPriceMonetary")
		public BigDecimal getUpperBarrierPriceMonetary() {
			return upperBarrierPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("upperBarrierPriceDecimal")
		@RuneAttribute("upperBarrierPriceDecimal")
		public BigDecimal getUpperBarrierPriceDecimal() {
			return upperBarrierPriceDecimal;
		}
		
		@Override
		@RosettaAttribute("singleBarrierPriceNotation")
		@RuneAttribute("singleBarrierPriceNotation")
		public PriceNotationEnum getSingleBarrierPriceNotation() {
			return singleBarrierPriceNotation;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierPriceNotation")
		@RuneAttribute("lowerBarrierPriceNotation")
		public PriceNotationEnum getLowerBarrierPriceNotation() {
			return lowerBarrierPriceNotation;
		}
		
		@Override
		@RosettaAttribute("upperBarrierPriceNotation")
		@RuneAttribute("upperBarrierPriceNotation")
		public PriceNotationEnum getUpperBarrierPriceNotation() {
			return upperBarrierPriceNotation;
		}
		
		@Override
		@RosettaAttribute("singleBarrierPriceCurrency")
		@RuneAttribute("singleBarrierPriceCurrency")
		public ISOCurrencyCodeEnum getSingleBarrierPriceCurrency() {
			return singleBarrierPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("lowerBarrierPriceCurrency")
		@RuneAttribute("lowerBarrierPriceCurrency")
		public ISOCurrencyCodeEnum getLowerBarrierPriceCurrency() {
			return lowerBarrierPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("upperBarrierPriceCurrency")
		@RuneAttribute("upperBarrierPriceCurrency")
		public ISOCurrencyCodeEnum getUpperBarrierPriceCurrency() {
			return upperBarrierPriceCurrency;
		}
		
		@RosettaAttribute("singleBarrierPriceMonetary")
		@RuneAttribute("singleBarrierPriceMonetary")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setSingleBarrierPriceMonetary(BigDecimal _singleBarrierPriceMonetary) {
			this.singleBarrierPriceMonetary = _singleBarrierPriceMonetary == null ? null : _singleBarrierPriceMonetary;
			return this;
		}
		
		@RosettaAttribute("singleBarrierPriceDecimal")
		@RuneAttribute("singleBarrierPriceDecimal")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setSingleBarrierPriceDecimal(BigDecimal _singleBarrierPriceDecimal) {
			this.singleBarrierPriceDecimal = _singleBarrierPriceDecimal == null ? null : _singleBarrierPriceDecimal;
			return this;
		}
		
		@RosettaAttribute("lowerBarrierPriceMonetary")
		@RuneAttribute("lowerBarrierPriceMonetary")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setLowerBarrierPriceMonetary(BigDecimal _lowerBarrierPriceMonetary) {
			this.lowerBarrierPriceMonetary = _lowerBarrierPriceMonetary == null ? null : _lowerBarrierPriceMonetary;
			return this;
		}
		
		@RosettaAttribute("lowerBarrierPriceDecimal")
		@RuneAttribute("lowerBarrierPriceDecimal")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setLowerBarrierPriceDecimal(BigDecimal _lowerBarrierPriceDecimal) {
			this.lowerBarrierPriceDecimal = _lowerBarrierPriceDecimal == null ? null : _lowerBarrierPriceDecimal;
			return this;
		}
		
		@RosettaAttribute("upperBarrierPriceMonetary")
		@RuneAttribute("upperBarrierPriceMonetary")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setUpperBarrierPriceMonetary(BigDecimal _upperBarrierPriceMonetary) {
			this.upperBarrierPriceMonetary = _upperBarrierPriceMonetary == null ? null : _upperBarrierPriceMonetary;
			return this;
		}
		
		@RosettaAttribute("upperBarrierPriceDecimal")
		@RuneAttribute("upperBarrierPriceDecimal")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setUpperBarrierPriceDecimal(BigDecimal _upperBarrierPriceDecimal) {
			this.upperBarrierPriceDecimal = _upperBarrierPriceDecimal == null ? null : _upperBarrierPriceDecimal;
			return this;
		}
		
		@RosettaAttribute("singleBarrierPriceNotation")
		@RuneAttribute("singleBarrierPriceNotation")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setSingleBarrierPriceNotation(PriceNotationEnum _singleBarrierPriceNotation) {
			this.singleBarrierPriceNotation = _singleBarrierPriceNotation == null ? null : _singleBarrierPriceNotation;
			return this;
		}
		
		@RosettaAttribute("lowerBarrierPriceNotation")
		@RuneAttribute("lowerBarrierPriceNotation")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setLowerBarrierPriceNotation(PriceNotationEnum _lowerBarrierPriceNotation) {
			this.lowerBarrierPriceNotation = _lowerBarrierPriceNotation == null ? null : _lowerBarrierPriceNotation;
			return this;
		}
		
		@RosettaAttribute("upperBarrierPriceNotation")
		@RuneAttribute("upperBarrierPriceNotation")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setUpperBarrierPriceNotation(PriceNotationEnum _upperBarrierPriceNotation) {
			this.upperBarrierPriceNotation = _upperBarrierPriceNotation == null ? null : _upperBarrierPriceNotation;
			return this;
		}
		
		@RosettaAttribute("singleBarrierPriceCurrency")
		@RuneAttribute("singleBarrierPriceCurrency")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setSingleBarrierPriceCurrency(ISOCurrencyCodeEnum _singleBarrierPriceCurrency) {
			this.singleBarrierPriceCurrency = _singleBarrierPriceCurrency == null ? null : _singleBarrierPriceCurrency;
			return this;
		}
		
		@RosettaAttribute("lowerBarrierPriceCurrency")
		@RuneAttribute("lowerBarrierPriceCurrency")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setLowerBarrierPriceCurrency(ISOCurrencyCodeEnum _lowerBarrierPriceCurrency) {
			this.lowerBarrierPriceCurrency = _lowerBarrierPriceCurrency == null ? null : _lowerBarrierPriceCurrency;
			return this;
		}
		
		@RosettaAttribute("upperBarrierPriceCurrency")
		@RuneAttribute("upperBarrierPriceCurrency")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder setUpperBarrierPriceCurrency(ISOCurrencyCodeEnum _upperBarrierPriceCurrency) {
			this.upperBarrierPriceCurrency = _upperBarrierPriceCurrency == null ? null : _upperBarrierPriceCurrency;
			return this;
		}
		
		@Override
		public BarrierAndNotation build() {
			return new BarrierAndNotation.BarrierAndNotationImpl(this);
		}
		
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getSingleBarrierPriceMonetary()!=null) return true;
			if (getSingleBarrierPriceDecimal()!=null) return true;
			if (getLowerBarrierPriceMonetary()!=null) return true;
			if (getLowerBarrierPriceDecimal()!=null) return true;
			if (getUpperBarrierPriceMonetary()!=null) return true;
			if (getUpperBarrierPriceDecimal()!=null) return true;
			if (getSingleBarrierPriceNotation()!=null) return true;
			if (getLowerBarrierPriceNotation()!=null) return true;
			if (getUpperBarrierPriceNotation()!=null) return true;
			if (getSingleBarrierPriceCurrency()!=null) return true;
			if (getLowerBarrierPriceCurrency()!=null) return true;
			if (getUpperBarrierPriceCurrency()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public BarrierAndNotation.BarrierAndNotationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			BarrierAndNotation.BarrierAndNotationBuilder o = (BarrierAndNotation.BarrierAndNotationBuilder) other;
			
			
			merger.mergeBasic(getSingleBarrierPriceMonetary(), o.getSingleBarrierPriceMonetary(), this::setSingleBarrierPriceMonetary);
			merger.mergeBasic(getSingleBarrierPriceDecimal(), o.getSingleBarrierPriceDecimal(), this::setSingleBarrierPriceDecimal);
			merger.mergeBasic(getLowerBarrierPriceMonetary(), o.getLowerBarrierPriceMonetary(), this::setLowerBarrierPriceMonetary);
			merger.mergeBasic(getLowerBarrierPriceDecimal(), o.getLowerBarrierPriceDecimal(), this::setLowerBarrierPriceDecimal);
			merger.mergeBasic(getUpperBarrierPriceMonetary(), o.getUpperBarrierPriceMonetary(), this::setUpperBarrierPriceMonetary);
			merger.mergeBasic(getUpperBarrierPriceDecimal(), o.getUpperBarrierPriceDecimal(), this::setUpperBarrierPriceDecimal);
			merger.mergeBasic(getSingleBarrierPriceNotation(), o.getSingleBarrierPriceNotation(), this::setSingleBarrierPriceNotation);
			merger.mergeBasic(getLowerBarrierPriceNotation(), o.getLowerBarrierPriceNotation(), this::setLowerBarrierPriceNotation);
			merger.mergeBasic(getUpperBarrierPriceNotation(), o.getUpperBarrierPriceNotation(), this::setUpperBarrierPriceNotation);
			merger.mergeBasic(getSingleBarrierPriceCurrency(), o.getSingleBarrierPriceCurrency(), this::setSingleBarrierPriceCurrency);
			merger.mergeBasic(getLowerBarrierPriceCurrency(), o.getLowerBarrierPriceCurrency(), this::setLowerBarrierPriceCurrency);
			merger.mergeBasic(getUpperBarrierPriceCurrency(), o.getUpperBarrierPriceCurrency(), this::setUpperBarrierPriceCurrency);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			BarrierAndNotation _that = getType().cast(o);
		
			if (!Objects.equals(singleBarrierPriceMonetary, _that.getSingleBarrierPriceMonetary())) return false;
			if (!Objects.equals(singleBarrierPriceDecimal, _that.getSingleBarrierPriceDecimal())) return false;
			if (!Objects.equals(lowerBarrierPriceMonetary, _that.getLowerBarrierPriceMonetary())) return false;
			if (!Objects.equals(lowerBarrierPriceDecimal, _that.getLowerBarrierPriceDecimal())) return false;
			if (!Objects.equals(upperBarrierPriceMonetary, _that.getUpperBarrierPriceMonetary())) return false;
			if (!Objects.equals(upperBarrierPriceDecimal, _that.getUpperBarrierPriceDecimal())) return false;
			if (!Objects.equals(singleBarrierPriceNotation, _that.getSingleBarrierPriceNotation())) return false;
			if (!Objects.equals(lowerBarrierPriceNotation, _that.getLowerBarrierPriceNotation())) return false;
			if (!Objects.equals(upperBarrierPriceNotation, _that.getUpperBarrierPriceNotation())) return false;
			if (!Objects.equals(singleBarrierPriceCurrency, _that.getSingleBarrierPriceCurrency())) return false;
			if (!Objects.equals(lowerBarrierPriceCurrency, _that.getLowerBarrierPriceCurrency())) return false;
			if (!Objects.equals(upperBarrierPriceCurrency, _that.getUpperBarrierPriceCurrency())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (singleBarrierPriceMonetary != null ? singleBarrierPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (singleBarrierPriceDecimal != null ? singleBarrierPriceDecimal.hashCode() : 0);
			_result = 31 * _result + (lowerBarrierPriceMonetary != null ? lowerBarrierPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (lowerBarrierPriceDecimal != null ? lowerBarrierPriceDecimal.hashCode() : 0);
			_result = 31 * _result + (upperBarrierPriceMonetary != null ? upperBarrierPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (upperBarrierPriceDecimal != null ? upperBarrierPriceDecimal.hashCode() : 0);
			_result = 31 * _result + (singleBarrierPriceNotation != null ? singleBarrierPriceNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (lowerBarrierPriceNotation != null ? lowerBarrierPriceNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (upperBarrierPriceNotation != null ? upperBarrierPriceNotation.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (singleBarrierPriceCurrency != null ? singleBarrierPriceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (lowerBarrierPriceCurrency != null ? lowerBarrierPriceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (upperBarrierPriceCurrency != null ? upperBarrierPriceCurrency.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "BarrierAndNotationBuilder {" +
				"singleBarrierPriceMonetary=" + this.singleBarrierPriceMonetary + ", " +
				"singleBarrierPriceDecimal=" + this.singleBarrierPriceDecimal + ", " +
				"lowerBarrierPriceMonetary=" + this.lowerBarrierPriceMonetary + ", " +
				"lowerBarrierPriceDecimal=" + this.lowerBarrierPriceDecimal + ", " +
				"upperBarrierPriceMonetary=" + this.upperBarrierPriceMonetary + ", " +
				"upperBarrierPriceDecimal=" + this.upperBarrierPriceDecimal + ", " +
				"singleBarrierPriceNotation=" + this.singleBarrierPriceNotation + ", " +
				"lowerBarrierPriceNotation=" + this.lowerBarrierPriceNotation + ", " +
				"upperBarrierPriceNotation=" + this.upperBarrierPriceNotation + ", " +
				"singleBarrierPriceCurrency=" + this.singleBarrierPriceCurrency + ", " +
				"lowerBarrierPriceCurrency=" + this.lowerBarrierPriceCurrency + ", " +
				"upperBarrierPriceCurrency=" + this.upperBarrierPriceCurrency +
			'}';
		}
	}
}
