package drr.regulation.asic.rewrite.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import drr.regulation.asic.rewrite.trade.validation.SpreadLeg2TypeFormatValidator;
import drr.regulation.asic.rewrite.trade.validation.SpreadLeg2Validator;
import drr.regulation.asic.rewrite.trade.validation.datarule.SpreadLeg2MonetaryOrDecimalOrBasis;
import drr.regulation.asic.rewrite.trade.validation.exists.SpreadLeg2OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.53.0
 */
@RosettaMeta(model=SpreadLeg2.class)
public class SpreadLeg2Meta implements RosettaMetaData<SpreadLeg2> {

	@Override
	public List<Validator<? super SpreadLeg2>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<SpreadLeg2>create(SpreadLeg2MonetaryOrDecimalOrBasis.class)
		);
	}
	
	@Override
	public List<Function<? super SpreadLeg2, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super SpreadLeg2> validator(ValidatorFactory factory) {
		return factory.<SpreadLeg2>create(SpreadLeg2Validator.class);
	}

	@Override
	public Validator<? super SpreadLeg2> typeFormatValidator(ValidatorFactory factory) {
		return factory.<SpreadLeg2>create(SpreadLeg2TypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super SpreadLeg2> validator() {
		return new SpreadLeg2Validator();
	}

	@Deprecated
	@Override
	public Validator<? super SpreadLeg2> typeFormatValidator() {
		return new SpreadLeg2TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super SpreadLeg2, Set<String>> onlyExistsValidator() {
		return new SpreadLeg2OnlyExistsValidator();
	}
}
