package drr.regulation.asic.rewrite.trade.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.standards.iosco.cde.reports.CDEInterestRateFixedRateRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(FixedRateLeg2Rule.FixedRateLeg2RuleDefault.class)
public abstract class FixedRateLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEInterestRateFixedRateRule cDEInterestRateFixedRateRule;
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class FixedRateLeg2RuleDefault extends FixedRateLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			output = thenArg2
				.mapSingleToItem(item -> MapperS.of(cDEInterestRateFixedRateRule.evaluate(interestRateLeg2.evaluate(item.get())))).get();
			
			return output;
		}
	}
}
