package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICNonReportable;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ASICNonReportableTypeFormatValidator implements Validator<ASICNonReportable> {

	private List<ComparisonResult> getComparisonResults(ASICNonReportable o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICNonReportable o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ASICNonReportable", ValidationResult.ValidationType.TYPE_FORMAT, "ASICNonReportable", path, "", res.getError());
				}
				return success("ASICNonReportable", ValidationResult.ValidationType.TYPE_FORMAT, "ASICNonReportable", path, "");
			})
			.collect(toList());
	}

}
