package drr.regulation.asic.rewrite.trade.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.PackageTransactionPrice;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class PackageTransactionPriceValidator implements Validator<PackageTransactionPrice> {

	private List<ComparisonResult> getComparisonResults(PackageTransactionPrice o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("packageTransactionPriceMonetary", (BigDecimal) o.getPackageTransactionPriceMonetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPriceDecimal", (BigDecimal) o.getPackageTransactionPriceDecimal() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPriceNotation", (PriceNotationEnum) o.getPackageTransactionPriceNotation() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPriceCurrency", (ISOCurrencyCodeEnum) o.getPackageTransactionPriceCurrency() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionPrice o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PackageTransactionPrice", ValidationResult.ValidationType.CARDINALITY, "PackageTransactionPrice", path, "", res.getError());
				}
				return success("PackageTransactionPrice", ValidationResult.ValidationType.CARDINALITY, "PackageTransactionPrice", path, "");
			})
			.collect(toList());
	}

}
