package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class SpreadLeg2Validator implements Validator<SpreadLeg2> {

	private List<ComparisonResult> getComparisonResults(SpreadLeg2 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("spreadLeg2Monetary", (BigDecimal) o.getSpreadLeg2Monetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg2Decimal", (BigDecimal) o.getSpreadLeg2Decimal() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg2Basis", (BigDecimal) o.getSpreadLeg2Basis() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg2Notation", (PriceNotationEnum) o.getSpreadLeg2Notation() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadLeg2 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SpreadLeg2", ValidationResult.ValidationType.CARDINALITY, "SpreadLeg2", path, "", res.getError());
				}
				return success("SpreadLeg2", ValidationResult.ValidationType.CARDINALITY, "SpreadLeg2", path, "");
			})
			.collect(toList());
	}

}
