package drr.regulation.asic.rewrite.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.ASICCustomBasket;
import drr.regulation.asic.rewrite.trade.ASICNonReportable;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.BarrierAndNotation;
import drr.regulation.asic.rewrite.trade.Basket;
import drr.regulation.asic.rewrite.trade.NotionalAmountScheduleLeg1Report;
import drr.regulation.asic.rewrite.trade.NotionalAmountScheduleLeg2Report;
import drr.regulation.asic.rewrite.trade.OtherPaymentReport;
import drr.regulation.asic.rewrite.trade.PackageTransactionPrice;
import drr.regulation.asic.rewrite.trade.PackageTransactionSpread;
import drr.regulation.asic.rewrite.trade.PriceAndNotation;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import drr.regulation.asic.rewrite.trade.SpreadLeg2;
import drr.regulation.asic.rewrite.trade.StrikePriceAndNotation;
import iso20022.auth030.asic.InterestComputationMethod4Code;
import iso20022.auth030.asic.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ASICTransactionReportOnlyExistsValidator implements ValidatorWithArg<ASICTransactionReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ASICTransactionReport> ValidationResult<ASICTransactionReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("uniqueTransactionIdentifier", ExistenceChecker.isSet((String) o.getUniqueTransactionIdentifier()))
				.put("utiProprietaryID", ExistenceChecker.isSet((String) o.getUtiProprietaryID()))
				.put("secondaryTransactionIdentifier", ExistenceChecker.isSet((String) o.getSecondaryTransactionIdentifier()))
				.put("uniqueProductIdentifier", ExistenceChecker.isSet((String) o.getUniqueProductIdentifier()))
				.put("assetClass", ExistenceChecker.isSet((String) o.getAssetClass()))
				.put("contractType", ExistenceChecker.isSet((String) o.getContractType()))
				.put("reportingEntity", ExistenceChecker.isSet((String) o.getReportingEntity()))
				.put("counterparty1", ExistenceChecker.isSet((String) o.getCounterparty1()))
				.put("counterparty2", ExistenceChecker.isSet((String) o.getCounterparty2()))
				.put("counterparty2Name", ExistenceChecker.isSet((String) o.getCounterparty2Name()))
				.put("counterparty2IdentifierTypeIndicator", ExistenceChecker.isSet((Boolean) o.getCounterparty2IdentifierTypeIndicator()))
				.put("countryOfTheCounterParty2", ExistenceChecker.isSet((ISOCountryCodeEnum) o.getCountryOfTheCounterParty2()))
				.put("beneficiary1", ExistenceChecker.isSet((String) o.getBeneficiary1()))
				.put("beneficiary1IdentifierTypeIndicator", ExistenceChecker.isSet((Boolean) o.getBeneficiary1IdentifierTypeIndicator()))
				.put("broker", ExistenceChecker.isSet((String) o.getBroker()))
				.put("executionAgentOfCounterparty1", ExistenceChecker.isSet((String) o.getExecutionAgentOfCounterparty1()))
				.put("direction", ExistenceChecker.isSet((String) o.getDirection()))
				.put("direction2OfLeg1", ExistenceChecker.isSet((String) o.getDirection2OfLeg1()))
				.put("direction2OfLeg2", ExistenceChecker.isSet((String) o.getDirection2OfLeg2()))
				.put("effectiveDate", ExistenceChecker.isSet((Date) o.getEffectiveDate()))
				.put("expirationDate", ExistenceChecker.isSet((Date) o.getExpirationDate()))
				.put("executionTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getExecutionTimestamp()))
				.put("eventTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getEventTimestamp()))
				.put("clearingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getClearingTimestamp()))
				.put("cleared", ExistenceChecker.isSet((String) o.getCleared()))
				.put("centralCounterparty", ExistenceChecker.isSet((String) o.getCentralCounterparty()))
				.put("clearingMember", ExistenceChecker.isSet((String) o.getClearingMember()))
				.put("platformIdentifier", ExistenceChecker.isSet((String) o.getPlatformIdentifier()))
				.put("notionalLeg1", ExistenceChecker.isSet((BigDecimal) o.getNotionalLeg1()))
				.put("notionalLeg2", ExistenceChecker.isSet((BigDecimal) o.getNotionalLeg2()))
				.put("totalNotionalQuantityLeg1", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityLeg1()))
				.put("totalNotionalQuantityLeg2", ExistenceChecker.isSet((BigDecimal) o.getTotalNotionalQuantityLeg2()))
				.put("notionalQuantityLeg1", ExistenceChecker.isSet((BigDecimal) o.getNotionalQuantityLeg1()))
				.put("notionalQuantityLeg2", ExistenceChecker.isSet((BigDecimal) o.getNotionalQuantityLeg2()))
				.put("callAmount", ExistenceChecker.isSet((BigDecimal) o.getCallAmount()))
				.put("putAmount", ExistenceChecker.isSet((BigDecimal) o.getPutAmount()))
				.put("notionalCurrencyLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg1()))
				.put("notionalCurrencyLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getNotionalCurrencyLeg2()))
				.put("quantityUnitOfMeasureLeg1", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureLeg1()))
				.put("quantityUnitOfMeasureLeg2", ExistenceChecker.isSet((String) o.getQuantityUnitOfMeasureLeg2()))
				.put("callCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCallCurrency()))
				.put("putCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPutCurrency()))
				.put("notionalAmountScheduleLeg1", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg1Report>) o.getNotionalAmountScheduleLeg1()))
				.put("notionalAmountScheduleLeg2", ExistenceChecker.isSet((List<? extends NotionalAmountScheduleLeg2Report>) o.getNotionalAmountScheduleLeg2()))
				.put("price", ExistenceChecker.isSet((PriceAndNotation) o.getPrice()))
				.put("priceUnitOfMeasure", ExistenceChecker.isSet((String) o.getPriceUnitOfMeasure()))
				.put("fixedRateLeg1", ExistenceChecker.isSet((BigDecimal) o.getFixedRateLeg1()))
				.put("fixedRateLeg2", ExistenceChecker.isSet((BigDecimal) o.getFixedRateLeg2()))
				.put("spreadNotationLeg1", ExistenceChecker.isSet((String) o.getSpreadNotationLeg1()))
				.put("spreadLeg1", ExistenceChecker.isSet((SpreadLeg1) o.getSpreadLeg1()))
				.put("spreadNotationLeg2", ExistenceChecker.isSet((String) o.getSpreadNotationLeg2()))
				.put("spreadLeg2", ExistenceChecker.isSet((SpreadLeg2) o.getSpreadLeg2()))
				.put("spreadCurrencyLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg1()))
				.put("spreadCurrencyLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSpreadCurrencyLeg2()))
				.put("strikePrice", ExistenceChecker.isSet((StrikePriceAndNotation) o.getStrikePrice()))
				.put("barrier", ExistenceChecker.isSet((BarrierAndNotation) o.getBarrier()))
				.put("optionPremiumAmount", ExistenceChecker.isSet((BigDecimal) o.getOptionPremiumAmount()))
				.put("optionPremiumCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getOptionPremiumCurrency()))
				.put("optionPremiumPaymentDate", ExistenceChecker.isSet((Date) o.getOptionPremiumPaymentDate()))
				.put("exchangeRate", ExistenceChecker.isSet((BigDecimal) o.getExchangeRate()))
				.put("exchangeRateBasis", ExistenceChecker.isSet((String) o.getExchangeRateBasis()))
				.put("dayCountConventionLeg1", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getDayCountConventionLeg1()))
				.put("dayCountConventionLeg2", ExistenceChecker.isSet((InterestComputationMethod4Code) o.getDayCountConventionLeg2()))
				.put("paymentFrequencyPeriodLeg1", ExistenceChecker.isSet((String) o.getPaymentFrequencyPeriodLeg1()))
				.put("paymentFrequencyPeriodLeg2", ExistenceChecker.isSet((String) o.getPaymentFrequencyPeriodLeg2()))
				.put("paymentFrequencyPeriodMultiplierLeg1", ExistenceChecker.isSet((Integer) o.getPaymentFrequencyPeriodMultiplierLeg1()))
				.put("paymentFrequencyPeriodMultiplierLeg2", ExistenceChecker.isSet((Integer) o.getPaymentFrequencyPeriodMultiplierLeg2()))
				.put("settlementCurrencyLeg1", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg1()))
				.put("settlementCurrencyLeg2", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getSettlementCurrencyLeg2()))
				.put("otherPayment", ExistenceChecker.isSet((List<? extends OtherPaymentReport>) o.getOtherPayment()))
				.put("customBasketCode", ExistenceChecker.isSet((ASICCustomBasket) o.getCustomBasketCode()))
				.put("basket", ExistenceChecker.isSet((Basket) o.getBasket()))
				.put("underlyingIdentification", ExistenceChecker.isSet((String) o.getUnderlyingIdentification()))
				.put("underlyingIdentificationType", ExistenceChecker.isSet((String) o.getUnderlyingIdentificationType()))
				.put("underlyingIdOther", ExistenceChecker.isSet((String) o.getUnderlyingIdOther()))
				.put("underlyingIdOtherSource", ExistenceChecker.isSet((ProductIdTypeEnum) o.getUnderlyingIdOtherSource()))
				.put("maturityDateOfTheUnderlying", ExistenceChecker.isSet((Date) o.getMaturityDateOfTheUnderlying()))
				.put("indicatorOfTheFloatingRateLeg2", ExistenceChecker.isSet((String) o.getIndicatorOfTheFloatingRateLeg2()))
				.put("floatingRateReferencePeriodOfLeg2TimePeriod", ExistenceChecker.isSet((String) o.getFloatingRateReferencePeriodOfLeg2TimePeriod()))
				.put("floatingRateReferencePeriodOfLeg2Multiplier", ExistenceChecker.isSet((Integer) o.getFloatingRateReferencePeriodOfLeg2Multiplier()))
				.put("cdSIndexAttachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCdSIndexAttachmentPoint()))
				.put("cdSIndexDetachmentPoint", ExistenceChecker.isSet((BigDecimal) o.getCdSIndexDetachmentPoint()))
				.put("indexFactor", ExistenceChecker.isSet((BigDecimal) o.getIndexFactor()))
				.put("packageIdentifier", ExistenceChecker.isSet((String) o.getPackageIdentifier()))
				.put("packageTransactionPrice", ExistenceChecker.isSet((PackageTransactionPrice) o.getPackageTransactionPrice()))
				.put("packageTransactionSpread", ExistenceChecker.isSet((PackageTransactionSpread) o.getPackageTransactionSpread()))
				.put("priorUTI", ExistenceChecker.isSet((String) o.getPriorUTI()))
				.put("priorUtiProprietary", ExistenceChecker.isSet((String) o.getPriorUtiProprietary()))
				.put("eventIdentifier", ExistenceChecker.isSet((String) o.getEventIdentifier()))
				.put("actionType", ExistenceChecker.isSet((String) o.getActionType()))
				.put("eventType", ExistenceChecker.isSet((String) o.getEventType()))
				.put("reportingTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getReportingTimestamp()))
				.put("reportSubmittingEntityID", ExistenceChecker.isSet((String) o.getReportSubmittingEntityID()))
				.put("newDerivativeTradeRepository", ExistenceChecker.isSet((String) o.getNewDerivativeTradeRepository()))
				.put("valuationTimestamp", ExistenceChecker.isSet((ZonedDateTime) o.getValuationTimestamp()))
				.put("valuationAmount", ExistenceChecker.isSet((BigDecimal) o.getValuationAmount()))
				.put("valuationCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getValuationCurrency()))
				.put("valuationMethod", ExistenceChecker.isSet((ValuationType1Code) o.getValuationMethod()))
				.put("delta", ExistenceChecker.isSet((BigDecimal) o.getDelta()))
				.put("nextFloatingReferenceResetDateLeg1", ExistenceChecker.isSet((Date) o.getNextFloatingReferenceResetDateLeg1()))
				.put("nextFloatingReferenceResetDateLeg2", ExistenceChecker.isSet((Date) o.getNextFloatingReferenceResetDateLeg2()))
				.put("smallScaleBuySideEntityIndicator", ExistenceChecker.isSet((String) o.getSmallScaleBuySideEntityIndicator()))
				.put("technicalRecordId", ExistenceChecker.isSet((String) o.getTechnicalRecordId()))
				.put("collateralPortfolioIndicator", ExistenceChecker.isSet((Boolean) o.getCollateralPortfolioIndicator()))
				.put("collateralPortfolioCodeInitialMargin", ExistenceChecker.isSet((String) o.getCollateralPortfolioCodeInitialMargin()))
				.put("collateralPortfolioCodeVariationMargin", ExistenceChecker.isSet((String) o.getCollateralPortfolioCodeVariationMargin()))
				.put("executionAgentOfCounterparty2DTCC", ExistenceChecker.isSet((String) o.getExecutionAgentOfCounterparty2DTCC()))
				.put("nonReportable", ExistenceChecker.isSet((ASICNonReportable) o.getNonReportable()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ASICTransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "ASICTransactionReport", path, "");
		}
		return failure("ASICTransactionReport", ValidationResult.ValidationType.ONLY_EXISTS, "ASICTransactionReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
