package drr.regulation.asic.rewrite.trade.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class SpreadLeg1OnlyExistsValidator implements ValidatorWithArg<SpreadLeg1, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends SpreadLeg1> ValidationResult<SpreadLeg1> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("spreadLeg1Monetary", ExistenceChecker.isSet((BigDecimal) o.getSpreadLeg1Monetary()))
				.put("spreadLeg1Decimal", ExistenceChecker.isSet((BigDecimal) o.getSpreadLeg1Decimal()))
				.put("spreadLeg1Basis", ExistenceChecker.isSet((BigDecimal) o.getSpreadLeg1Basis()))
				.put("spreadLeg1Notation", ExistenceChecker.isSet((PriceNotationEnum) o.getSpreadLeg1Notation()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("SpreadLeg1", ValidationResult.ValidationType.ONLY_EXISTS, "SpreadLeg1", path, "");
		}
		return failure("SpreadLeg1", ValidationResult.ValidationType.ONLY_EXISTS, "SpreadLeg1", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
