package drr.regulation.asic.rewrite.trade.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.StrikePriceAndNotation;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class StrikePriceAndNotationOnlyExistsValidator implements ValidatorWithArg<StrikePriceAndNotation, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends StrikePriceAndNotation> ValidationResult<StrikePriceAndNotation> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("strikePriceMonetary", ExistenceChecker.isSet((BigDecimal) o.getStrikePriceMonetary()))
				.put("strikePriceDecimal", ExistenceChecker.isSet((BigDecimal) o.getStrikePriceDecimal()))
				.put("strikePriceNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getStrikePriceNotation()))
				.put("strikePriceCurrency", ExistenceChecker.isSet((String) o.getStrikePriceCurrency()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("StrikePriceAndNotation", ValidationResult.ValidationType.ONLY_EXISTS, "StrikePriceAndNotation", path, "");
		}
		return failure("StrikePriceAndNotation", ValidationResult.ValidationType.ONLY_EXISTS, "StrikePriceAndNotation", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
