package drr.regulation.cftc.rewrite;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.cftc.rewrite.meta.CFTCGuidebookPart45Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="CFTCGuidebookPart45", builder=CFTCGuidebookPart45.CFTCGuidebookPart45BuilderImpl.class, version="5.53.0")
@RuneDataType(value="CFTCGuidebookPart45", model="drr", builder=CFTCGuidebookPart45.CFTCGuidebookPart45BuilderImpl.class, version="5.53.0")
public interface CFTCGuidebookPart45 extends RosettaModelObject {

	CFTCGuidebookPart45Meta metaData = new CFTCGuidebookPart45Meta();

	/*********************** Getter Methods  ***********************/
	String getOptionType();
	String getOptionStyle();
	String getAssetClass();
	Boolean getMandatoryClearingIndicator();
	Date getMaturityDateOfTheUnderlier();
	Boolean getLargeNotionalOffFacilitySwapElectionIndicator();
	Boolean getSefOrDcmIndicator();
	Boolean getSefOrDcmAnonymousExecutionIndicator();
	String getMessageType();
	String getSettlementType();
	Boolean getSdMspIndicatorParty1();
	Boolean getSdMspIndicatorParty2();
	Boolean getPhysicalCommodityIndicator();

	/*********************** Build Methods  ***********************/
	CFTCGuidebookPart45 build();
	
	CFTCGuidebookPart45.CFTCGuidebookPart45Builder toBuilder();
	
	static CFTCGuidebookPart45.CFTCGuidebookPart45Builder builder() {
		return new CFTCGuidebookPart45.CFTCGuidebookPart45BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CFTCGuidebookPart45> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CFTCGuidebookPart45> getType() {
		return CFTCGuidebookPart45.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("mandatoryClearingIndicator"), Boolean.class, getMandatoryClearingIndicator(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlier"), Date.class, getMaturityDateOfTheUnderlier(), this);
		processor.processBasic(path.newSubPath("largeNotionalOffFacilitySwapElectionIndicator"), Boolean.class, getLargeNotionalOffFacilitySwapElectionIndicator(), this);
		processor.processBasic(path.newSubPath("sefOrDcmIndicator"), Boolean.class, getSefOrDcmIndicator(), this);
		processor.processBasic(path.newSubPath("sefOrDcmAnonymousExecutionIndicator"), Boolean.class, getSefOrDcmAnonymousExecutionIndicator(), this);
		processor.processBasic(path.newSubPath("messageType"), String.class, getMessageType(), this);
		processor.processBasic(path.newSubPath("settlementType"), String.class, getSettlementType(), this);
		processor.processBasic(path.newSubPath("sdMspIndicatorParty1"), Boolean.class, getSdMspIndicatorParty1(), this);
		processor.processBasic(path.newSubPath("sdMspIndicatorParty2"), Boolean.class, getSdMspIndicatorParty2(), this);
		processor.processBasic(path.newSubPath("physicalCommodityIndicator"), Boolean.class, getPhysicalCommodityIndicator(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CFTCGuidebookPart45Builder extends CFTCGuidebookPart45, RosettaModelObjectBuilder {
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setOptionType(String optionType);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setOptionStyle(String optionStyle);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setAssetClass(String assetClass);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setMandatoryClearingIndicator(Boolean mandatoryClearingIndicator);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setMaturityDateOfTheUnderlier(Date maturityDateOfTheUnderlier);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setLargeNotionalOffFacilitySwapElectionIndicator(Boolean largeNotionalOffFacilitySwapElectionIndicator);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSefOrDcmIndicator(Boolean sefOrDcmIndicator);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSefOrDcmAnonymousExecutionIndicator(Boolean sefOrDcmAnonymousExecutionIndicator);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setMessageType(String messageType);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSettlementType(String settlementType);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSdMspIndicatorParty1(Boolean sdMspIndicatorParty1);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSdMspIndicatorParty2(Boolean sdMspIndicatorParty2);
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder setPhysicalCommodityIndicator(Boolean physicalCommodityIndicator);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("mandatoryClearingIndicator"), Boolean.class, getMandatoryClearingIndicator(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlier"), Date.class, getMaturityDateOfTheUnderlier(), this);
			processor.processBasic(path.newSubPath("largeNotionalOffFacilitySwapElectionIndicator"), Boolean.class, getLargeNotionalOffFacilitySwapElectionIndicator(), this);
			processor.processBasic(path.newSubPath("sefOrDcmIndicator"), Boolean.class, getSefOrDcmIndicator(), this);
			processor.processBasic(path.newSubPath("sefOrDcmAnonymousExecutionIndicator"), Boolean.class, getSefOrDcmAnonymousExecutionIndicator(), this);
			processor.processBasic(path.newSubPath("messageType"), String.class, getMessageType(), this);
			processor.processBasic(path.newSubPath("settlementType"), String.class, getSettlementType(), this);
			processor.processBasic(path.newSubPath("sdMspIndicatorParty1"), Boolean.class, getSdMspIndicatorParty1(), this);
			processor.processBasic(path.newSubPath("sdMspIndicatorParty2"), Boolean.class, getSdMspIndicatorParty2(), this);
			processor.processBasic(path.newSubPath("physicalCommodityIndicator"), Boolean.class, getPhysicalCommodityIndicator(), this);
		}
		

		CFTCGuidebookPart45.CFTCGuidebookPart45Builder prune();
	}

	/*********************** Immutable Implementation of CFTCGuidebookPart45  ***********************/
	class CFTCGuidebookPart45Impl implements CFTCGuidebookPart45 {
		private final String optionType;
		private final String optionStyle;
		private final String assetClass;
		private final Boolean mandatoryClearingIndicator;
		private final Date maturityDateOfTheUnderlier;
		private final Boolean largeNotionalOffFacilitySwapElectionIndicator;
		private final Boolean sefOrDcmIndicator;
		private final Boolean sefOrDcmAnonymousExecutionIndicator;
		private final String messageType;
		private final String settlementType;
		private final Boolean sdMspIndicatorParty1;
		private final Boolean sdMspIndicatorParty2;
		private final Boolean physicalCommodityIndicator;
		
		protected CFTCGuidebookPart45Impl(CFTCGuidebookPart45.CFTCGuidebookPart45Builder builder) {
			this.optionType = builder.getOptionType();
			this.optionStyle = builder.getOptionStyle();
			this.assetClass = builder.getAssetClass();
			this.mandatoryClearingIndicator = builder.getMandatoryClearingIndicator();
			this.maturityDateOfTheUnderlier = builder.getMaturityDateOfTheUnderlier();
			this.largeNotionalOffFacilitySwapElectionIndicator = builder.getLargeNotionalOffFacilitySwapElectionIndicator();
			this.sefOrDcmIndicator = builder.getSefOrDcmIndicator();
			this.sefOrDcmAnonymousExecutionIndicator = builder.getSefOrDcmAnonymousExecutionIndicator();
			this.messageType = builder.getMessageType();
			this.settlementType = builder.getSettlementType();
			this.sdMspIndicatorParty1 = builder.getSdMspIndicatorParty1();
			this.sdMspIndicatorParty2 = builder.getSdMspIndicatorParty2();
			this.physicalCommodityIndicator = builder.getPhysicalCommodityIndicator();
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="mandatoryClearingIndicator", isRequired=true)
		@RuneAttribute(value="mandatoryClearingIndicator", isRequired=true)
		public Boolean getMandatoryClearingIndicator() {
			return mandatoryClearingIndicator;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlier")
		@RuneAttribute("maturityDateOfTheUnderlier")
		public Date getMaturityDateOfTheUnderlier() {
			return maturityDateOfTheUnderlier;
		}
		
		@Override
		@RosettaAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		@RuneAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		public Boolean getLargeNotionalOffFacilitySwapElectionIndicator() {
			return largeNotionalOffFacilitySwapElectionIndicator;
		}
		
		@Override
		@RosettaAttribute(value="sefOrDcmIndicator", isRequired=true)
		@RuneAttribute(value="sefOrDcmIndicator", isRequired=true)
		public Boolean getSefOrDcmIndicator() {
			return sefOrDcmIndicator;
		}
		
		@Override
		@RosettaAttribute("sefOrDcmAnonymousExecutionIndicator")
		@RuneAttribute("sefOrDcmAnonymousExecutionIndicator")
		public Boolean getSefOrDcmAnonymousExecutionIndicator() {
			return sefOrDcmAnonymousExecutionIndicator;
		}
		
		@Override
		@RosettaAttribute(value="messageType", isRequired=true)
		@RuneAttribute(value="messageType", isRequired=true)
		public String getMessageType() {
			return messageType;
		}
		
		@Override
		@RosettaAttribute("settlementType")
		@RuneAttribute("settlementType")
		public String getSettlementType() {
			return settlementType;
		}
		
		@Override
		@RosettaAttribute(value="sdMspIndicatorParty1", isRequired=true)
		@RuneAttribute(value="sdMspIndicatorParty1", isRequired=true)
		public Boolean getSdMspIndicatorParty1() {
			return sdMspIndicatorParty1;
		}
		
		@Override
		@RosettaAttribute(value="sdMspIndicatorParty2", isRequired=true)
		@RuneAttribute(value="sdMspIndicatorParty2", isRequired=true)
		public Boolean getSdMspIndicatorParty2() {
			return sdMspIndicatorParty2;
		}
		
		@Override
		@RosettaAttribute("physicalCommodityIndicator")
		@RuneAttribute("physicalCommodityIndicator")
		public Boolean getPhysicalCommodityIndicator() {
			return physicalCommodityIndicator;
		}
		
		@Override
		public CFTCGuidebookPart45 build() {
			return this;
		}
		
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder toBuilder() {
			CFTCGuidebookPart45.CFTCGuidebookPart45Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CFTCGuidebookPart45.CFTCGuidebookPart45Builder builder) {
			ofNullable(getOptionType()).ifPresent(builder::setOptionType);
			ofNullable(getOptionStyle()).ifPresent(builder::setOptionStyle);
			ofNullable(getAssetClass()).ifPresent(builder::setAssetClass);
			ofNullable(getMandatoryClearingIndicator()).ifPresent(builder::setMandatoryClearingIndicator);
			ofNullable(getMaturityDateOfTheUnderlier()).ifPresent(builder::setMaturityDateOfTheUnderlier);
			ofNullable(getLargeNotionalOffFacilitySwapElectionIndicator()).ifPresent(builder::setLargeNotionalOffFacilitySwapElectionIndicator);
			ofNullable(getSefOrDcmIndicator()).ifPresent(builder::setSefOrDcmIndicator);
			ofNullable(getSefOrDcmAnonymousExecutionIndicator()).ifPresent(builder::setSefOrDcmAnonymousExecutionIndicator);
			ofNullable(getMessageType()).ifPresent(builder::setMessageType);
			ofNullable(getSettlementType()).ifPresent(builder::setSettlementType);
			ofNullable(getSdMspIndicatorParty1()).ifPresent(builder::setSdMspIndicatorParty1);
			ofNullable(getSdMspIndicatorParty2()).ifPresent(builder::setSdMspIndicatorParty2);
			ofNullable(getPhysicalCommodityIndicator()).ifPresent(builder::setPhysicalCommodityIndicator);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CFTCGuidebookPart45 _that = getType().cast(o);
		
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(mandatoryClearingIndicator, _that.getMandatoryClearingIndicator())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlier, _that.getMaturityDateOfTheUnderlier())) return false;
			if (!Objects.equals(largeNotionalOffFacilitySwapElectionIndicator, _that.getLargeNotionalOffFacilitySwapElectionIndicator())) return false;
			if (!Objects.equals(sefOrDcmIndicator, _that.getSefOrDcmIndicator())) return false;
			if (!Objects.equals(sefOrDcmAnonymousExecutionIndicator, _that.getSefOrDcmAnonymousExecutionIndicator())) return false;
			if (!Objects.equals(messageType, _that.getMessageType())) return false;
			if (!Objects.equals(settlementType, _that.getSettlementType())) return false;
			if (!Objects.equals(sdMspIndicatorParty1, _that.getSdMspIndicatorParty1())) return false;
			if (!Objects.equals(sdMspIndicatorParty2, _that.getSdMspIndicatorParty2())) return false;
			if (!Objects.equals(physicalCommodityIndicator, _that.getPhysicalCommodityIndicator())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (mandatoryClearingIndicator != null ? mandatoryClearingIndicator.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlier != null ? maturityDateOfTheUnderlier.hashCode() : 0);
			_result = 31 * _result + (largeNotionalOffFacilitySwapElectionIndicator != null ? largeNotionalOffFacilitySwapElectionIndicator.hashCode() : 0);
			_result = 31 * _result + (sefOrDcmIndicator != null ? sefOrDcmIndicator.hashCode() : 0);
			_result = 31 * _result + (sefOrDcmAnonymousExecutionIndicator != null ? sefOrDcmAnonymousExecutionIndicator.hashCode() : 0);
			_result = 31 * _result + (messageType != null ? messageType.hashCode() : 0);
			_result = 31 * _result + (settlementType != null ? settlementType.hashCode() : 0);
			_result = 31 * _result + (sdMspIndicatorParty1 != null ? sdMspIndicatorParty1.hashCode() : 0);
			_result = 31 * _result + (sdMspIndicatorParty2 != null ? sdMspIndicatorParty2.hashCode() : 0);
			_result = 31 * _result + (physicalCommodityIndicator != null ? physicalCommodityIndicator.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCGuidebookPart45 {" +
				"optionType=" + this.optionType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"assetClass=" + this.assetClass + ", " +
				"mandatoryClearingIndicator=" + this.mandatoryClearingIndicator + ", " +
				"maturityDateOfTheUnderlier=" + this.maturityDateOfTheUnderlier + ", " +
				"largeNotionalOffFacilitySwapElectionIndicator=" + this.largeNotionalOffFacilitySwapElectionIndicator + ", " +
				"sefOrDcmIndicator=" + this.sefOrDcmIndicator + ", " +
				"sefOrDcmAnonymousExecutionIndicator=" + this.sefOrDcmAnonymousExecutionIndicator + ", " +
				"messageType=" + this.messageType + ", " +
				"settlementType=" + this.settlementType + ", " +
				"sdMspIndicatorParty1=" + this.sdMspIndicatorParty1 + ", " +
				"sdMspIndicatorParty2=" + this.sdMspIndicatorParty2 + ", " +
				"physicalCommodityIndicator=" + this.physicalCommodityIndicator +
			'}';
		}
	}

	/*********************** Builder Implementation of CFTCGuidebookPart45  ***********************/
	class CFTCGuidebookPart45BuilderImpl implements CFTCGuidebookPart45.CFTCGuidebookPart45Builder {
	
		protected String optionType;
		protected String optionStyle;
		protected String assetClass;
		protected Boolean mandatoryClearingIndicator;
		protected Date maturityDateOfTheUnderlier;
		protected Boolean largeNotionalOffFacilitySwapElectionIndicator;
		protected Boolean sefOrDcmIndicator;
		protected Boolean sefOrDcmAnonymousExecutionIndicator;
		protected String messageType;
		protected String settlementType;
		protected Boolean sdMspIndicatorParty1;
		protected Boolean sdMspIndicatorParty2;
		protected Boolean physicalCommodityIndicator;
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="mandatoryClearingIndicator", isRequired=true)
		@RuneAttribute(value="mandatoryClearingIndicator", isRequired=true)
		public Boolean getMandatoryClearingIndicator() {
			return mandatoryClearingIndicator;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlier")
		@RuneAttribute("maturityDateOfTheUnderlier")
		public Date getMaturityDateOfTheUnderlier() {
			return maturityDateOfTheUnderlier;
		}
		
		@Override
		@RosettaAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		@RuneAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		public Boolean getLargeNotionalOffFacilitySwapElectionIndicator() {
			return largeNotionalOffFacilitySwapElectionIndicator;
		}
		
		@Override
		@RosettaAttribute(value="sefOrDcmIndicator", isRequired=true)
		@RuneAttribute(value="sefOrDcmIndicator", isRequired=true)
		public Boolean getSefOrDcmIndicator() {
			return sefOrDcmIndicator;
		}
		
		@Override
		@RosettaAttribute("sefOrDcmAnonymousExecutionIndicator")
		@RuneAttribute("sefOrDcmAnonymousExecutionIndicator")
		public Boolean getSefOrDcmAnonymousExecutionIndicator() {
			return sefOrDcmAnonymousExecutionIndicator;
		}
		
		@Override
		@RosettaAttribute(value="messageType", isRequired=true)
		@RuneAttribute(value="messageType", isRequired=true)
		public String getMessageType() {
			return messageType;
		}
		
		@Override
		@RosettaAttribute("settlementType")
		@RuneAttribute("settlementType")
		public String getSettlementType() {
			return settlementType;
		}
		
		@Override
		@RosettaAttribute(value="sdMspIndicatorParty1", isRequired=true)
		@RuneAttribute(value="sdMspIndicatorParty1", isRequired=true)
		public Boolean getSdMspIndicatorParty1() {
			return sdMspIndicatorParty1;
		}
		
		@Override
		@RosettaAttribute(value="sdMspIndicatorParty2", isRequired=true)
		@RuneAttribute(value="sdMspIndicatorParty2", isRequired=true)
		public Boolean getSdMspIndicatorParty2() {
			return sdMspIndicatorParty2;
		}
		
		@Override
		@RosettaAttribute("physicalCommodityIndicator")
		@RuneAttribute("physicalCommodityIndicator")
		public Boolean getPhysicalCommodityIndicator() {
			return physicalCommodityIndicator;
		}
		
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setOptionType(String _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setOptionStyle(String _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setAssetClass(String _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@RosettaAttribute(value="mandatoryClearingIndicator", isRequired=true)
		@RuneAttribute(value="mandatoryClearingIndicator", isRequired=true)
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setMandatoryClearingIndicator(Boolean _mandatoryClearingIndicator) {
			this.mandatoryClearingIndicator = _mandatoryClearingIndicator == null ? null : _mandatoryClearingIndicator;
			return this;
		}
		
		@RosettaAttribute("maturityDateOfTheUnderlier")
		@RuneAttribute("maturityDateOfTheUnderlier")
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setMaturityDateOfTheUnderlier(Date _maturityDateOfTheUnderlier) {
			this.maturityDateOfTheUnderlier = _maturityDateOfTheUnderlier == null ? null : _maturityDateOfTheUnderlier;
			return this;
		}
		
		@RosettaAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		@RuneAttribute("largeNotionalOffFacilitySwapElectionIndicator")
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setLargeNotionalOffFacilitySwapElectionIndicator(Boolean _largeNotionalOffFacilitySwapElectionIndicator) {
			this.largeNotionalOffFacilitySwapElectionIndicator = _largeNotionalOffFacilitySwapElectionIndicator == null ? null : _largeNotionalOffFacilitySwapElectionIndicator;
			return this;
		}
		
		@RosettaAttribute(value="sefOrDcmIndicator", isRequired=true)
		@RuneAttribute(value="sefOrDcmIndicator", isRequired=true)
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSefOrDcmIndicator(Boolean _sefOrDcmIndicator) {
			this.sefOrDcmIndicator = _sefOrDcmIndicator == null ? null : _sefOrDcmIndicator;
			return this;
		}
		
		@RosettaAttribute("sefOrDcmAnonymousExecutionIndicator")
		@RuneAttribute("sefOrDcmAnonymousExecutionIndicator")
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSefOrDcmAnonymousExecutionIndicator(Boolean _sefOrDcmAnonymousExecutionIndicator) {
			this.sefOrDcmAnonymousExecutionIndicator = _sefOrDcmAnonymousExecutionIndicator == null ? null : _sefOrDcmAnonymousExecutionIndicator;
			return this;
		}
		
		@RosettaAttribute(value="messageType", isRequired=true)
		@RuneAttribute(value="messageType", isRequired=true)
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setMessageType(String _messageType) {
			this.messageType = _messageType == null ? null : _messageType;
			return this;
		}
		
		@RosettaAttribute("settlementType")
		@RuneAttribute("settlementType")
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSettlementType(String _settlementType) {
			this.settlementType = _settlementType == null ? null : _settlementType;
			return this;
		}
		
		@RosettaAttribute(value="sdMspIndicatorParty1", isRequired=true)
		@RuneAttribute(value="sdMspIndicatorParty1", isRequired=true)
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSdMspIndicatorParty1(Boolean _sdMspIndicatorParty1) {
			this.sdMspIndicatorParty1 = _sdMspIndicatorParty1 == null ? null : _sdMspIndicatorParty1;
			return this;
		}
		
		@RosettaAttribute(value="sdMspIndicatorParty2", isRequired=true)
		@RuneAttribute(value="sdMspIndicatorParty2", isRequired=true)
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setSdMspIndicatorParty2(Boolean _sdMspIndicatorParty2) {
			this.sdMspIndicatorParty2 = _sdMspIndicatorParty2 == null ? null : _sdMspIndicatorParty2;
			return this;
		}
		
		@RosettaAttribute("physicalCommodityIndicator")
		@RuneAttribute("physicalCommodityIndicator")
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder setPhysicalCommodityIndicator(Boolean _physicalCommodityIndicator) {
			this.physicalCommodityIndicator = _physicalCommodityIndicator == null ? null : _physicalCommodityIndicator;
			return this;
		}
		
		@Override
		public CFTCGuidebookPart45 build() {
			return new CFTCGuidebookPart45.CFTCGuidebookPart45Impl(this);
		}
		
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getOptionType()!=null) return true;
			if (getOptionStyle()!=null) return true;
			if (getAssetClass()!=null) return true;
			if (getMandatoryClearingIndicator()!=null) return true;
			if (getMaturityDateOfTheUnderlier()!=null) return true;
			if (getLargeNotionalOffFacilitySwapElectionIndicator()!=null) return true;
			if (getSefOrDcmIndicator()!=null) return true;
			if (getSefOrDcmAnonymousExecutionIndicator()!=null) return true;
			if (getMessageType()!=null) return true;
			if (getSettlementType()!=null) return true;
			if (getSdMspIndicatorParty1()!=null) return true;
			if (getSdMspIndicatorParty2()!=null) return true;
			if (getPhysicalCommodityIndicator()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CFTCGuidebookPart45.CFTCGuidebookPart45Builder o = (CFTCGuidebookPart45.CFTCGuidebookPart45Builder) other;
			
			
			merger.mergeBasic(getOptionType(), o.getOptionType(), this::setOptionType);
			merger.mergeBasic(getOptionStyle(), o.getOptionStyle(), this::setOptionStyle);
			merger.mergeBasic(getAssetClass(), o.getAssetClass(), this::setAssetClass);
			merger.mergeBasic(getMandatoryClearingIndicator(), o.getMandatoryClearingIndicator(), this::setMandatoryClearingIndicator);
			merger.mergeBasic(getMaturityDateOfTheUnderlier(), o.getMaturityDateOfTheUnderlier(), this::setMaturityDateOfTheUnderlier);
			merger.mergeBasic(getLargeNotionalOffFacilitySwapElectionIndicator(), o.getLargeNotionalOffFacilitySwapElectionIndicator(), this::setLargeNotionalOffFacilitySwapElectionIndicator);
			merger.mergeBasic(getSefOrDcmIndicator(), o.getSefOrDcmIndicator(), this::setSefOrDcmIndicator);
			merger.mergeBasic(getSefOrDcmAnonymousExecutionIndicator(), o.getSefOrDcmAnonymousExecutionIndicator(), this::setSefOrDcmAnonymousExecutionIndicator);
			merger.mergeBasic(getMessageType(), o.getMessageType(), this::setMessageType);
			merger.mergeBasic(getSettlementType(), o.getSettlementType(), this::setSettlementType);
			merger.mergeBasic(getSdMspIndicatorParty1(), o.getSdMspIndicatorParty1(), this::setSdMspIndicatorParty1);
			merger.mergeBasic(getSdMspIndicatorParty2(), o.getSdMspIndicatorParty2(), this::setSdMspIndicatorParty2);
			merger.mergeBasic(getPhysicalCommodityIndicator(), o.getPhysicalCommodityIndicator(), this::setPhysicalCommodityIndicator);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CFTCGuidebookPart45 _that = getType().cast(o);
		
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(mandatoryClearingIndicator, _that.getMandatoryClearingIndicator())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlier, _that.getMaturityDateOfTheUnderlier())) return false;
			if (!Objects.equals(largeNotionalOffFacilitySwapElectionIndicator, _that.getLargeNotionalOffFacilitySwapElectionIndicator())) return false;
			if (!Objects.equals(sefOrDcmIndicator, _that.getSefOrDcmIndicator())) return false;
			if (!Objects.equals(sefOrDcmAnonymousExecutionIndicator, _that.getSefOrDcmAnonymousExecutionIndicator())) return false;
			if (!Objects.equals(messageType, _that.getMessageType())) return false;
			if (!Objects.equals(settlementType, _that.getSettlementType())) return false;
			if (!Objects.equals(sdMspIndicatorParty1, _that.getSdMspIndicatorParty1())) return false;
			if (!Objects.equals(sdMspIndicatorParty2, _that.getSdMspIndicatorParty2())) return false;
			if (!Objects.equals(physicalCommodityIndicator, _that.getPhysicalCommodityIndicator())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (mandatoryClearingIndicator != null ? mandatoryClearingIndicator.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlier != null ? maturityDateOfTheUnderlier.hashCode() : 0);
			_result = 31 * _result + (largeNotionalOffFacilitySwapElectionIndicator != null ? largeNotionalOffFacilitySwapElectionIndicator.hashCode() : 0);
			_result = 31 * _result + (sefOrDcmIndicator != null ? sefOrDcmIndicator.hashCode() : 0);
			_result = 31 * _result + (sefOrDcmAnonymousExecutionIndicator != null ? sefOrDcmAnonymousExecutionIndicator.hashCode() : 0);
			_result = 31 * _result + (messageType != null ? messageType.hashCode() : 0);
			_result = 31 * _result + (settlementType != null ? settlementType.hashCode() : 0);
			_result = 31 * _result + (sdMspIndicatorParty1 != null ? sdMspIndicatorParty1.hashCode() : 0);
			_result = 31 * _result + (sdMspIndicatorParty2 != null ? sdMspIndicatorParty2.hashCode() : 0);
			_result = 31 * _result + (physicalCommodityIndicator != null ? physicalCommodityIndicator.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCGuidebookPart45Builder {" +
				"optionType=" + this.optionType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"assetClass=" + this.assetClass + ", " +
				"mandatoryClearingIndicator=" + this.mandatoryClearingIndicator + ", " +
				"maturityDateOfTheUnderlier=" + this.maturityDateOfTheUnderlier + ", " +
				"largeNotionalOffFacilitySwapElectionIndicator=" + this.largeNotionalOffFacilitySwapElectionIndicator + ", " +
				"sefOrDcmIndicator=" + this.sefOrDcmIndicator + ", " +
				"sefOrDcmAnonymousExecutionIndicator=" + this.sefOrDcmAnonymousExecutionIndicator + ", " +
				"messageType=" + this.messageType + ", " +
				"settlementType=" + this.settlementType + ", " +
				"sdMspIndicatorParty1=" + this.sdMspIndicatorParty1 + ", " +
				"sdMspIndicatorParty2=" + this.sdMspIndicatorParty2 + ", " +
				"physicalCommodityIndicator=" + this.physicalCommodityIndicator +
			'}';
		}
	}
}
