package drr.regulation.cftc.rewrite;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.cftc.rewrite.meta.CFTCPart45TransactionReportMeta;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 5.53.0
 */
@RosettaDataType(value="CFTCPart45TransactionReport", builder=CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilderImpl.class, version="5.53.0")
@RuneDataType(value="CFTCPart45TransactionReport", model="drr", builder=CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilderImpl.class, version="5.53.0")
public interface CFTCPart45TransactionReport extends RosettaModelObject {

	CFTCPart45TransactionReportMeta metaData = new CFTCPart45TransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	String getCleared();
	String getCentralCounterparty();
	String getClearingAccountOrigin();
	String getClearingMember();
	List<? extends ClearingSwapUSIsReport> getClearingSwapUSIs();
	List<? extends ClearingSwapUTIsReport> getClearingSwapUTIs();
	String getOriginalSwapUSI();
	String getOriginalSwapUTI();
	String getOriginalSwapSDRIdentifier();
	ZonedDateTime getClearingReceiptTimestamp();
	List<? extends ClearingExceptionsAndExemptionsCounterparty1Report> getClearingExceptionsAndExemptionsCounterparty1();
	List<? extends ClearingExceptionsAndExemptionsCounterparty2Report> getClearingExceptionsAndExemptionsCounterparty2();
	String getCounterparty1();
	String getCounterparty2();
	String getCounterparty2IdentifierSource();
	Boolean getCounterparty1FinancialEntityIndicator();
	Boolean getCounterparty2FinancialEntityIndicator();
	String getBuyerIdentifier();
	String getSellerIdentifier();
	String getPayerIdentifierLeg1();
	String getPayerIdentifierLeg2();
	String getReceiverIdentifierLeg1();
	String getReceiverIdentifierLeg2();
	String getSubmitterIdentifier();
	Boolean getCounterparty1FederalEntityIndicator();
	Boolean getCounterparty2FederalEntityIndicator();
	Boolean getCustomBasketIndicator();
	String getActionType();
	String getEventType();
	Boolean getAmendmentIndicator();
	String getEventIdentifier();
	ZonedDateTime getEventTimestamp();
	BigDecimal getNotionalAmountLeg1();
	BigDecimal getNotionalAmountLeg2();
	ISOCurrencyCodeEnum getNotionalCurrencyLeg1();
	ISOCurrencyCodeEnum getNotionalCurrencyLeg2();
	List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1();
	List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2();
	BigDecimal getCallAmount();
	ISOCurrencyCodeEnum getCallCurrency();
	BigDecimal getPutAmount();
	ISOCurrencyCodeEnum getPutCurrency();
	BigDecimal getNotionalQuantityLeg1();
	BigDecimal getNotionalQuantityLeg2();
	String getQuantityFrequencyLeg1();
	String getQuantityFrequencyLeg2();
	Integer getQuantityFrequencyMultiplierLeg1();
	Integer getQuantityFrequencyMultiplierLeg2();
	String getQuantityUnitOfMeasureLeg1();
	String getQuantityUnitOfMeasureLeg2();
	BigDecimal getTotalNotionalQuantityLeg1();
	BigDecimal getTotalNotionalQuantityLeg2();
	Boolean getPackageIndicator();
	String getPackageIdentifier();
	BigDecimal getPackageTransactionPrice();
	ISOCurrencyCodeEnum getPackageTransactionPriceCurrency();
	String getPackageTransactionPriceNotation();
	BigDecimal getPackageTransactionSpread();
	ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency();
	String getPackageTransactionSpreadNotation();
	InterestComputationMethod4Code getFixedRateDayCountConventionLeg1();
	InterestComputationMethod4Code getFixedRateDayCountConventionLeg2();
	InterestComputationMethod4Code getFloatingRateDayCountConventionLeg1();
	InterestComputationMethod4Code getFloatingRateDayCountConventionLeg2();
	Date getFixingDateLeg1();
	Date getFixingDateLeg2();
	String getFloatingRateResetFrequencyPeriodLeg1();
	String getFloatingRateResetFrequencyPeriodLeg2();
	Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1();
	Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2();
	List<? extends OtherPaymentReport> getOtherPayment();
	String getFixedRatePaymentFrequencyPeriodLeg1();
	String getFixedRatePaymentFrequencyPeriodLeg2();
	String getFloatingRatePaymentFrequencyPeriodLeg1();
	String getFloatingRatePaymentFrequencyPeriodLeg2();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg1();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg2();
	BigDecimal getExchangeRateLeg1();
	String getExchangeRateBasis();
	BigDecimal getFixedRateLeg1();
	BigDecimal getFixedRateLeg2();
	Boolean getPostPricedSwapIndicator();
	BigDecimal getPrice();
	ISOCurrencyCodeEnum getPriceCurrency();
	String getPriceNotation();
	String getPriceUnitOfMeasure();
	BigDecimal getSpreadLeg1();
	BigDecimal getSpreadLeg2();
	ISOCurrencyCodeEnum getSpreadCurrencyLeg1();
	ISOCurrencyCodeEnum getSpreadCurrencyLeg2();
	String getSpreadNotationLeg1();
	String getSpreadNotationLeg2();
	BigDecimal getStrikePrice();
	String getStrikePriceCurrency();
	String getStrikePriceNotation();
	BigDecimal getOptionPremiumAmount();
	ISOCurrencyCodeEnum getOptionPremiumCurrency();
	Date getOptionPremiumPaymentDate();
	Date getFirstExerciseDate();
	BigDecimal getCDSIndexAttachmentPoint();
	BigDecimal getCDSIndexDetachmentPoint();
	BigDecimal getIndexFactor();
	String getEmbeddedOptionType();
	String getUniqueProductIdentifier();
	Date getFinalContractualSettlementDate();
	ISOCurrencyCodeEnum getSettlementCurrencyLeg1();
	ISOCurrencyCodeEnum getSettlementCurrencyLeg2();
	String getSettlementLocationLeg1();
	String getSettlementLocationLeg2();
	String getAllocationIndicator();
	Boolean getNonStandardizedTermIndicator();
	Boolean getBlockTradeElectionIndicator();
	Date getEffectiveDate();
	Date getExpirationDate();
	ZonedDateTime getExecutionTimestamp();
	ZonedDateTime getReportingTimestamp();
	String getPlatformIdentifier();
	Boolean getPrimeBrokerageTransactionIndicator();
	String getPriorUSI();
	String getPriorUTI();
	String getUniqueSwapIdentifier();
	String getUniqueTransactionIdentifier();
	String getJurisdiction();
	String getNewSDRIdentifier();
	String getInitialMarginCollateralPortfolioCode();
	String getVariationMarginCollateralPortfolioCode();
	CFTCGuidebookPart45 getCftcGuidebook();
	CFTCNonReportablePart45 getNonReportable();

	/*********************** Build Methods  ***********************/
	CFTCPart45TransactionReport build();
	
	CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder toBuilder();
	
	static CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder builder() {
		return new CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CFTCPart45TransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CFTCPart45TransactionReport> getType() {
		return CFTCPart45TransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingAccountOrigin"), String.class, getClearingAccountOrigin(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processRosetta(path.newSubPath("clearingSwapUSIs"), processor, ClearingSwapUSIsReport.class, getClearingSwapUSIs());
		processRosetta(path.newSubPath("clearingSwapUTIs"), processor, ClearingSwapUTIsReport.class, getClearingSwapUTIs());
		processor.processBasic(path.newSubPath("originalSwapUSI"), String.class, getOriginalSwapUSI(), this);
		processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
		processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
		processRosetta(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), processor, ClearingExceptionsAndExemptionsCounterparty1Report.class, getClearingExceptionsAndExemptionsCounterparty1());
		processRosetta(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), processor, ClearingExceptionsAndExemptionsCounterparty2Report.class, getClearingExceptionsAndExemptionsCounterparty2());
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, getCounterparty2IdentifierSource(), this);
		processor.processBasic(path.newSubPath("counterparty1FinancialEntityIndicator"), Boolean.class, getCounterparty1FinancialEntityIndicator(), this);
		processor.processBasic(path.newSubPath("counterparty2FinancialEntityIndicator"), Boolean.class, getCounterparty2FinancialEntityIndicator(), this);
		processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, getBuyerIdentifier(), this);
		processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, getSellerIdentifier(), this);
		processor.processBasic(path.newSubPath("payerIdentifierLeg1"), String.class, getPayerIdentifierLeg1(), this);
		processor.processBasic(path.newSubPath("payerIdentifierLeg2"), String.class, getPayerIdentifierLeg2(), this);
		processor.processBasic(path.newSubPath("receiverIdentifierLeg1"), String.class, getReceiverIdentifierLeg1(), this);
		processor.processBasic(path.newSubPath("receiverIdentifierLeg2"), String.class, getReceiverIdentifierLeg2(), this);
		processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
		processor.processBasic(path.newSubPath("counterparty1FederalEntityIndicator"), Boolean.class, getCounterparty1FederalEntityIndicator(), this);
		processor.processBasic(path.newSubPath("counterparty2FederalEntityIndicator"), Boolean.class, getCounterparty2FederalEntityIndicator(), this);
		processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
		processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
		processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("notionalAmountLeg1"), BigDecimal.class, getNotionalAmountLeg1(), this);
		processor.processBasic(path.newSubPath("notionalAmountLeg2"), BigDecimal.class, getNotionalAmountLeg2(), this);
		processor.processBasic(path.newSubPath("notionalCurrencyLeg1"), ISOCurrencyCodeEnum.class, getNotionalCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("notionalCurrencyLeg2"), ISOCurrencyCodeEnum.class, getNotionalCurrencyLeg2(), this);
		processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.class, getNotionalAmountScheduleLeg1());
		processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.class, getNotionalAmountScheduleLeg2());
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processor.processBasic(path.newSubPath("notionalQuantityLeg1"), BigDecimal.class, getNotionalQuantityLeg1(), this);
		processor.processBasic(path.newSubPath("notionalQuantityLeg2"), BigDecimal.class, getNotionalQuantityLeg2(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyLeg1"), String.class, getQuantityFrequencyLeg1(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyLeg2"), String.class, getQuantityFrequencyLeg2(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyMultiplierLeg1"), Integer.class, getQuantityFrequencyMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyMultiplierLeg2"), Integer.class, getQuantityFrequencyMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
		processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processor.processBasic(path.newSubPath("packageTransactionPrice"), BigDecimal.class, getPackageTransactionPrice(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), String.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpread"), BigDecimal.class, getPackageTransactionSpread(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), String.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionLeg2(), this);
		processor.processBasic(path.newSubPath("fixingDateLeg1"), Date.class, getFixingDateLeg1(), this);
		processor.processBasic(path.newSubPath("fixingDateLeg2"), Date.class, getFixingDateLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodLeg1"), String.class, getFloatingRateResetFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodLeg2"), String.class, getFloatingRateResetFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.class, getOtherPayment());
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, getFixedRatePaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, getFixedRatePaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg1"), String.class, getFloatingRatePaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg2"), String.class, getFloatingRatePaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("exchangeRateLeg1"), BigDecimal.class, getExchangeRateLeg1(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, getFixedRateLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, getFixedRateLeg2(), this);
		processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, getPostPricedSwapIndicator(), this);
		processor.processBasic(path.newSubPath("price"), BigDecimal.class, getPrice(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceNotation"), String.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("spreadLeg1"), BigDecimal.class, getSpreadLeg1(), this);
		processor.processBasic(path.newSubPath("spreadLeg2"), BigDecimal.class, getSpreadLeg2(), this);
		processor.processBasic(path.newSubPath("spreadCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSpreadCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("spreadCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSpreadCurrencyLeg2(), this);
		processor.processBasic(path.newSubPath("spreadNotationLeg1"), String.class, getSpreadNotationLeg1(), this);
		processor.processBasic(path.newSubPath("spreadNotationLeg2"), String.class, getSpreadNotationLeg2(), this);
		processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, getStrikePrice(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("strikePriceNotation"), String.class, getStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("cDSIndexAttachmentPoint"), BigDecimal.class, getCDSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cDSIndexDetachmentPoint"), BigDecimal.class, getCDSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), String.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg1(), this);
		processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg2(), this);
		processor.processBasic(path.newSubPath("settlementLocationLeg1"), String.class, getSettlementLocationLeg1(), this);
		processor.processBasic(path.newSubPath("settlementLocationLeg2"), String.class, getSettlementLocationLeg2(), this);
		processor.processBasic(path.newSubPath("allocationIndicator"), String.class, getAllocationIndicator(), this);
		processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
		processor.processBasic(path.newSubPath("blockTradeElectionIndicator"), Boolean.class, getBlockTradeElectionIndicator(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("primeBrokerageTransactionIndicator"), Boolean.class, getPrimeBrokerageTransactionIndicator(), this);
		processor.processBasic(path.newSubPath("priorUSI"), String.class, getPriorUSI(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, getUniqueSwapIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("jurisdiction"), String.class, getJurisdiction(), this);
		processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processRosetta(path.newSubPath("cftcGuidebook"), processor, CFTCGuidebookPart45.class, getCftcGuidebook());
		processRosetta(path.newSubPath("nonReportable"), processor, CFTCNonReportablePart45.class, getNonReportable());
	}
	

	/*********************** Builder Interface  ***********************/
	interface CFTCPart45TransactionReportBuilder extends CFTCPart45TransactionReport, RosettaModelObjectBuilder {
		ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder getOrCreateClearingSwapUSIs(int index);
		@Override
		List<? extends ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder> getClearingSwapUSIs();
		ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder getOrCreateClearingSwapUTIs(int index);
		@Override
		List<? extends ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder> getClearingSwapUTIs();
		ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder getOrCreateClearingExceptionsAndExemptionsCounterparty1(int index);
		@Override
		List<? extends ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder> getClearingExceptionsAndExemptionsCounterparty1();
		ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder getOrCreateClearingExceptionsAndExemptionsCounterparty2(int index);
		@Override
		List<? extends ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder> getClearingExceptionsAndExemptionsCounterparty2();
		NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1();
		NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2();
		OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index);
		@Override
		List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment();
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder getOrCreateCftcGuidebook();
		@Override
		CFTCGuidebookPart45.CFTCGuidebookPart45Builder getCftcGuidebook();
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder getOrCreateNonReportable();
		@Override
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder getNonReportable();
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCleared(String cleared);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingAccountOrigin(String clearingAccountOrigin);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingMember(String clearingMember);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(ClearingSwapUSIsReport clearingSwapUSIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(ClearingSwapUSIsReport clearingSwapUSIs, int idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(List<? extends ClearingSwapUSIsReport> clearingSwapUSIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingSwapUSIs(List<? extends ClearingSwapUSIsReport> clearingSwapUSIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(ClearingSwapUTIsReport clearingSwapUTIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(ClearingSwapUTIsReport clearingSwapUTIs, int idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(List<? extends ClearingSwapUTIsReport> clearingSwapUTIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingSwapUTIs(List<? extends ClearingSwapUTIsReport> clearingSwapUTIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapUSI(String originalSwapUSI);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapUTI(String originalSwapUTI);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapSDRIdentifier(String originalSwapSDRIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime clearingReceiptTimestamp);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsCounterparty1Report clearingExceptionsAndExemptionsCounterparty1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsCounterparty1Report clearingExceptionsAndExemptionsCounterparty1, int idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<? extends ClearingExceptionsAndExemptionsCounterparty1Report> clearingExceptionsAndExemptionsCounterparty1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<? extends ClearingExceptionsAndExemptionsCounterparty1Report> clearingExceptionsAndExemptionsCounterparty1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsCounterparty2Report clearingExceptionsAndExemptionsCounterparty2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsCounterparty2Report clearingExceptionsAndExemptionsCounterparty2, int idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<? extends ClearingExceptionsAndExemptionsCounterparty2Report> clearingExceptionsAndExemptionsCounterparty2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<? extends ClearingExceptionsAndExemptionsCounterparty2Report> clearingExceptionsAndExemptionsCounterparty2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1(String counterparty1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2(String counterparty2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2IdentifierSource(String counterparty2IdentifierSource);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1FinancialEntityIndicator(Boolean counterparty1FinancialEntityIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2FinancialEntityIndicator(Boolean counterparty2FinancialEntityIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBuyerIdentifier(String buyerIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSellerIdentifier(String sellerIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPayerIdentifierLeg1(String payerIdentifierLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPayerIdentifierLeg2(String payerIdentifierLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReceiverIdentifierLeg1(String receiverIdentifierLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReceiverIdentifierLeg2(String receiverIdentifierLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSubmitterIdentifier(String submitterIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1FederalEntityIndicator(Boolean counterparty1FederalEntityIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2FederalEntityIndicator(Boolean counterparty2FederalEntityIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCustomBasketIndicator(Boolean customBasketIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setActionType(String actionType);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventType(String eventType);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAmendmentIndicator(Boolean amendmentIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventIdentifier(String eventIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalAmountLeg1(BigDecimal notionalAmountLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalAmountLeg2(BigDecimal notionalAmountLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalCurrencyLeg1(ISOCurrencyCodeEnum notionalCurrencyLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalCurrencyLeg2(ISOCurrencyCodeEnum notionalCurrencyLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1, int idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2, int idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCallAmount(BigDecimal callAmount);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPutAmount(BigDecimal putAmount);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalQuantityLeg1(BigDecimal notionalQuantityLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalQuantityLeg2(BigDecimal notionalQuantityLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityFrequencyLeg1(String quantityFrequencyLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityFrequencyLeg2(String quantityFrequencyLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityFrequencyMultiplierLeg1(Integer quantityFrequencyMultiplierLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityFrequencyMultiplierLeg2(Integer quantityFrequencyMultiplierLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal totalNotionalQuantityLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal totalNotionalQuantityLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageIndicator(Boolean packageIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPrice(BigDecimal packageTransactionPrice);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPriceNotation(String packageTransactionPriceNotation);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpread(BigDecimal packageTransactionSpread);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpreadNotation(String packageTransactionSpreadNotation);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code fixedRateDayCountConventionLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code fixedRateDayCountConventionLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateDayCountConventionLeg1(InterestComputationMethod4Code floatingRateDayCountConventionLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateDayCountConventionLeg2(InterestComputationMethod4Code floatingRateDayCountConventionLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixingDateLeg1(Date fixingDateLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixingDateLeg2(Date fixingDateLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateResetFrequencyPeriodLeg1(String floatingRateResetFrequencyPeriodLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateResetFrequencyPeriodLeg2(String floatingRateResetFrequencyPeriodLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer floatingRateResetFrequencyPeriodMultiplierLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer floatingRateResetFrequencyPeriodMultiplierLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment, int idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String fixedRatePaymentFrequencyPeriodLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String fixedRatePaymentFrequencyPeriodLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg1(String floatingRatePaymentFrequencyPeriodLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg2(String floatingRatePaymentFrequencyPeriodLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg1(Integer floatingRatePaymentFrequencyPeriodMultiplierLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg2(Integer floatingRatePaymentFrequencyPeriodMultiplierLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExchangeRateLeg1(BigDecimal exchangeRateLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRateLeg1(BigDecimal fixedRateLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRateLeg2(BigDecimal fixedRateLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPostPricedSwapIndicator(Boolean postPricedSwapIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPrice(BigDecimal price);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceNotation(String priceNotation);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadLeg1(BigDecimal spreadLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadLeg2(BigDecimal spreadLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadCurrencyLeg1(ISOCurrencyCodeEnum spreadCurrencyLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadCurrencyLeg2(ISOCurrencyCodeEnum spreadCurrencyLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadNotationLeg1(String spreadNotationLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadNotationLeg2(String spreadNotationLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePrice(BigDecimal strikePrice);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceCurrency(String strikePriceCurrency);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceNotation(String strikePriceNotation);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCDSIndexAttachmentPoint(BigDecimal cDSIndexAttachmentPoint);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCDSIndexDetachmentPoint(BigDecimal cDSIndexDetachmentPoint);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEmbeddedOptionType(String embeddedOptionType);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum settlementCurrencyLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum settlementCurrencyLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementLocationLeg1(String settlementLocationLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementLocationLeg2(String settlementLocationLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAllocationIndicator(String allocationIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNonStandardizedTermIndicator(Boolean nonStandardizedTermIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBlockTradeElectionIndicator(Boolean blockTradeElectionIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEffectiveDate(Date effectiveDate);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExpirationDate(Date expirationDate);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPrimeBrokerageTransactionIndicator(Boolean primeBrokerageTransactionIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUSI(String priorUSI);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUTI(String priorUTI);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueSwapIdentifier(String uniqueSwapIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setJurisdiction(String jurisdiction);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNewSDRIdentifier(String newSDRIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCftcGuidebook(CFTCGuidebookPart45 cftcGuidebook);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNonReportable(CFTCNonReportablePart45 nonReportable);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingAccountOrigin"), String.class, getClearingAccountOrigin(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processRosetta(path.newSubPath("clearingSwapUSIs"), processor, ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder.class, getClearingSwapUSIs());
			processRosetta(path.newSubPath("clearingSwapUTIs"), processor, ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder.class, getClearingSwapUTIs());
			processor.processBasic(path.newSubPath("originalSwapUSI"), String.class, getOriginalSwapUSI(), this);
			processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
			processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
			processRosetta(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), processor, ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder.class, getClearingExceptionsAndExemptionsCounterparty1());
			processRosetta(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), processor, ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder.class, getClearingExceptionsAndExemptionsCounterparty2());
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, getCounterparty2IdentifierSource(), this);
			processor.processBasic(path.newSubPath("counterparty1FinancialEntityIndicator"), Boolean.class, getCounterparty1FinancialEntityIndicator(), this);
			processor.processBasic(path.newSubPath("counterparty2FinancialEntityIndicator"), Boolean.class, getCounterparty2FinancialEntityIndicator(), this);
			processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, getBuyerIdentifier(), this);
			processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, getSellerIdentifier(), this);
			processor.processBasic(path.newSubPath("payerIdentifierLeg1"), String.class, getPayerIdentifierLeg1(), this);
			processor.processBasic(path.newSubPath("payerIdentifierLeg2"), String.class, getPayerIdentifierLeg2(), this);
			processor.processBasic(path.newSubPath("receiverIdentifierLeg1"), String.class, getReceiverIdentifierLeg1(), this);
			processor.processBasic(path.newSubPath("receiverIdentifierLeg2"), String.class, getReceiverIdentifierLeg2(), this);
			processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
			processor.processBasic(path.newSubPath("counterparty1FederalEntityIndicator"), Boolean.class, getCounterparty1FederalEntityIndicator(), this);
			processor.processBasic(path.newSubPath("counterparty2FederalEntityIndicator"), Boolean.class, getCounterparty2FederalEntityIndicator(), this);
			processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
			processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
			processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("notionalAmountLeg1"), BigDecimal.class, getNotionalAmountLeg1(), this);
			processor.processBasic(path.newSubPath("notionalAmountLeg2"), BigDecimal.class, getNotionalAmountLeg2(), this);
			processor.processBasic(path.newSubPath("notionalCurrencyLeg1"), ISOCurrencyCodeEnum.class, getNotionalCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("notionalCurrencyLeg2"), ISOCurrencyCodeEnum.class, getNotionalCurrencyLeg2(), this);
			processRosetta(path.newSubPath("notionalAmountScheduleLeg1"), processor, NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder.class, getNotionalAmountScheduleLeg1());
			processRosetta(path.newSubPath("notionalAmountScheduleLeg2"), processor, NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder.class, getNotionalAmountScheduleLeg2());
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processor.processBasic(path.newSubPath("notionalQuantityLeg1"), BigDecimal.class, getNotionalQuantityLeg1(), this);
			processor.processBasic(path.newSubPath("notionalQuantityLeg2"), BigDecimal.class, getNotionalQuantityLeg2(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyLeg1"), String.class, getQuantityFrequencyLeg1(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyLeg2"), String.class, getQuantityFrequencyLeg2(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyMultiplierLeg1"), Integer.class, getQuantityFrequencyMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyMultiplierLeg2"), Integer.class, getQuantityFrequencyMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
			processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processor.processBasic(path.newSubPath("packageTransactionPrice"), BigDecimal.class, getPackageTransactionPrice(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), String.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpread"), BigDecimal.class, getPackageTransactionSpread(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), String.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionLeg2(), this);
			processor.processBasic(path.newSubPath("fixingDateLeg1"), Date.class, getFixingDateLeg1(), this);
			processor.processBasic(path.newSubPath("fixingDateLeg2"), Date.class, getFixingDateLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodLeg1"), String.class, getFloatingRateResetFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodLeg2"), String.class, getFloatingRateResetFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.OtherPaymentReportBuilder.class, getOtherPayment());
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, getFixedRatePaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, getFixedRatePaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg1"), String.class, getFloatingRatePaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodLeg2"), String.class, getFloatingRatePaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("exchangeRateLeg1"), BigDecimal.class, getExchangeRateLeg1(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("fixedRateLeg1"), BigDecimal.class, getFixedRateLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRateLeg2"), BigDecimal.class, getFixedRateLeg2(), this);
			processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, getPostPricedSwapIndicator(), this);
			processor.processBasic(path.newSubPath("price"), BigDecimal.class, getPrice(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceNotation"), String.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("spreadLeg1"), BigDecimal.class, getSpreadLeg1(), this);
			processor.processBasic(path.newSubPath("spreadLeg2"), BigDecimal.class, getSpreadLeg2(), this);
			processor.processBasic(path.newSubPath("spreadCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSpreadCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("spreadCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSpreadCurrencyLeg2(), this);
			processor.processBasic(path.newSubPath("spreadNotationLeg1"), String.class, getSpreadNotationLeg1(), this);
			processor.processBasic(path.newSubPath("spreadNotationLeg2"), String.class, getSpreadNotationLeg2(), this);
			processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, getStrikePrice(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("strikePriceNotation"), String.class, getStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("cDSIndexAttachmentPoint"), BigDecimal.class, getCDSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cDSIndexDetachmentPoint"), BigDecimal.class, getCDSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), String.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processor.processBasic(path.newSubPath("settlementCurrencyLeg1"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg1(), this);
			processor.processBasic(path.newSubPath("settlementCurrencyLeg2"), ISOCurrencyCodeEnum.class, getSettlementCurrencyLeg2(), this);
			processor.processBasic(path.newSubPath("settlementLocationLeg1"), String.class, getSettlementLocationLeg1(), this);
			processor.processBasic(path.newSubPath("settlementLocationLeg2"), String.class, getSettlementLocationLeg2(), this);
			processor.processBasic(path.newSubPath("allocationIndicator"), String.class, getAllocationIndicator(), this);
			processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
			processor.processBasic(path.newSubPath("blockTradeElectionIndicator"), Boolean.class, getBlockTradeElectionIndicator(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("primeBrokerageTransactionIndicator"), Boolean.class, getPrimeBrokerageTransactionIndicator(), this);
			processor.processBasic(path.newSubPath("priorUSI"), String.class, getPriorUSI(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, getUniqueSwapIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("jurisdiction"), String.class, getJurisdiction(), this);
			processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processRosetta(path.newSubPath("cftcGuidebook"), processor, CFTCGuidebookPart45.CFTCGuidebookPart45Builder.class, getCftcGuidebook());
			processRosetta(path.newSubPath("nonReportable"), processor, CFTCNonReportablePart45.CFTCNonReportablePart45Builder.class, getNonReportable());
		}
		

		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of CFTCPart45TransactionReport  ***********************/
	class CFTCPart45TransactionReportImpl implements CFTCPart45TransactionReport {
		private final String cleared;
		private final String centralCounterparty;
		private final String clearingAccountOrigin;
		private final String clearingMember;
		private final List<? extends ClearingSwapUSIsReport> clearingSwapUSIs;
		private final List<? extends ClearingSwapUTIsReport> clearingSwapUTIs;
		private final String originalSwapUSI;
		private final String originalSwapUTI;
		private final String originalSwapSDRIdentifier;
		private final ZonedDateTime clearingReceiptTimestamp;
		private final List<? extends ClearingExceptionsAndExemptionsCounterparty1Report> clearingExceptionsAndExemptionsCounterparty1;
		private final List<? extends ClearingExceptionsAndExemptionsCounterparty2Report> clearingExceptionsAndExemptionsCounterparty2;
		private final String counterparty1;
		private final String counterparty2;
		private final String counterparty2IdentifierSource;
		private final Boolean counterparty1FinancialEntityIndicator;
		private final Boolean counterparty2FinancialEntityIndicator;
		private final String buyerIdentifier;
		private final String sellerIdentifier;
		private final String payerIdentifierLeg1;
		private final String payerIdentifierLeg2;
		private final String receiverIdentifierLeg1;
		private final String receiverIdentifierLeg2;
		private final String submitterIdentifier;
		private final Boolean counterparty1FederalEntityIndicator;
		private final Boolean counterparty2FederalEntityIndicator;
		private final Boolean customBasketIndicator;
		private final String actionType;
		private final String eventType;
		private final Boolean amendmentIndicator;
		private final String eventIdentifier;
		private final ZonedDateTime eventTimestamp;
		private final BigDecimal notionalAmountLeg1;
		private final BigDecimal notionalAmountLeg2;
		private final ISOCurrencyCodeEnum notionalCurrencyLeg1;
		private final ISOCurrencyCodeEnum notionalCurrencyLeg2;
		private final List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1;
		private final List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2;
		private final BigDecimal callAmount;
		private final ISOCurrencyCodeEnum callCurrency;
		private final BigDecimal putAmount;
		private final ISOCurrencyCodeEnum putCurrency;
		private final BigDecimal notionalQuantityLeg1;
		private final BigDecimal notionalQuantityLeg2;
		private final String quantityFrequencyLeg1;
		private final String quantityFrequencyLeg2;
		private final Integer quantityFrequencyMultiplierLeg1;
		private final Integer quantityFrequencyMultiplierLeg2;
		private final String quantityUnitOfMeasureLeg1;
		private final String quantityUnitOfMeasureLeg2;
		private final BigDecimal totalNotionalQuantityLeg1;
		private final BigDecimal totalNotionalQuantityLeg2;
		private final Boolean packageIndicator;
		private final String packageIdentifier;
		private final BigDecimal packageTransactionPrice;
		private final ISOCurrencyCodeEnum packageTransactionPriceCurrency;
		private final String packageTransactionPriceNotation;
		private final BigDecimal packageTransactionSpread;
		private final ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
		private final String packageTransactionSpreadNotation;
		private final InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
		private final InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
		private final InterestComputationMethod4Code floatingRateDayCountConventionLeg1;
		private final InterestComputationMethod4Code floatingRateDayCountConventionLeg2;
		private final Date fixingDateLeg1;
		private final Date fixingDateLeg2;
		private final String floatingRateResetFrequencyPeriodLeg1;
		private final String floatingRateResetFrequencyPeriodLeg2;
		private final Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
		private final Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
		private final List<? extends OtherPaymentReport> otherPayment;
		private final String fixedRatePaymentFrequencyPeriodLeg1;
		private final String fixedRatePaymentFrequencyPeriodLeg2;
		private final String floatingRatePaymentFrequencyPeriodLeg1;
		private final String floatingRatePaymentFrequencyPeriodLeg2;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierLeg1;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierLeg2;
		private final BigDecimal exchangeRateLeg1;
		private final String exchangeRateBasis;
		private final BigDecimal fixedRateLeg1;
		private final BigDecimal fixedRateLeg2;
		private final Boolean postPricedSwapIndicator;
		private final BigDecimal price;
		private final ISOCurrencyCodeEnum priceCurrency;
		private final String priceNotation;
		private final String priceUnitOfMeasure;
		private final BigDecimal spreadLeg1;
		private final BigDecimal spreadLeg2;
		private final ISOCurrencyCodeEnum spreadCurrencyLeg1;
		private final ISOCurrencyCodeEnum spreadCurrencyLeg2;
		private final String spreadNotationLeg1;
		private final String spreadNotationLeg2;
		private final BigDecimal strikePrice;
		private final String strikePriceCurrency;
		private final String strikePriceNotation;
		private final BigDecimal optionPremiumAmount;
		private final ISOCurrencyCodeEnum optionPremiumCurrency;
		private final Date optionPremiumPaymentDate;
		private final Date firstExerciseDate;
		private final BigDecimal cDSIndexAttachmentPoint;
		private final BigDecimal cDSIndexDetachmentPoint;
		private final BigDecimal indexFactor;
		private final String embeddedOptionType;
		private final String uniqueProductIdentifier;
		private final Date finalContractualSettlementDate;
		private final ISOCurrencyCodeEnum settlementCurrencyLeg1;
		private final ISOCurrencyCodeEnum settlementCurrencyLeg2;
		private final String settlementLocationLeg1;
		private final String settlementLocationLeg2;
		private final String allocationIndicator;
		private final Boolean nonStandardizedTermIndicator;
		private final Boolean blockTradeElectionIndicator;
		private final Date effectiveDate;
		private final Date expirationDate;
		private final ZonedDateTime executionTimestamp;
		private final ZonedDateTime reportingTimestamp;
		private final String platformIdentifier;
		private final Boolean primeBrokerageTransactionIndicator;
		private final String priorUSI;
		private final String priorUTI;
		private final String uniqueSwapIdentifier;
		private final String uniqueTransactionIdentifier;
		private final String jurisdiction;
		private final String newSDRIdentifier;
		private final String initialMarginCollateralPortfolioCode;
		private final String variationMarginCollateralPortfolioCode;
		private final CFTCGuidebookPart45 cftcGuidebook;
		private final CFTCNonReportablePart45 nonReportable;
		
		protected CFTCPart45TransactionReportImpl(CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder builder) {
			this.cleared = builder.getCleared();
			this.centralCounterparty = builder.getCentralCounterparty();
			this.clearingAccountOrigin = builder.getClearingAccountOrigin();
			this.clearingMember = builder.getClearingMember();
			this.clearingSwapUSIs = ofNullable(builder.getClearingSwapUSIs()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.clearingSwapUTIs = ofNullable(builder.getClearingSwapUTIs()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.originalSwapUSI = builder.getOriginalSwapUSI();
			this.originalSwapUTI = builder.getOriginalSwapUTI();
			this.originalSwapSDRIdentifier = builder.getOriginalSwapSDRIdentifier();
			this.clearingReceiptTimestamp = builder.getClearingReceiptTimestamp();
			this.clearingExceptionsAndExemptionsCounterparty1 = ofNullable(builder.getClearingExceptionsAndExemptionsCounterparty1()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.clearingExceptionsAndExemptionsCounterparty2 = ofNullable(builder.getClearingExceptionsAndExemptionsCounterparty2()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
			this.counterparty1FinancialEntityIndicator = builder.getCounterparty1FinancialEntityIndicator();
			this.counterparty2FinancialEntityIndicator = builder.getCounterparty2FinancialEntityIndicator();
			this.buyerIdentifier = builder.getBuyerIdentifier();
			this.sellerIdentifier = builder.getSellerIdentifier();
			this.payerIdentifierLeg1 = builder.getPayerIdentifierLeg1();
			this.payerIdentifierLeg2 = builder.getPayerIdentifierLeg2();
			this.receiverIdentifierLeg1 = builder.getReceiverIdentifierLeg1();
			this.receiverIdentifierLeg2 = builder.getReceiverIdentifierLeg2();
			this.submitterIdentifier = builder.getSubmitterIdentifier();
			this.counterparty1FederalEntityIndicator = builder.getCounterparty1FederalEntityIndicator();
			this.counterparty2FederalEntityIndicator = builder.getCounterparty2FederalEntityIndicator();
			this.customBasketIndicator = builder.getCustomBasketIndicator();
			this.actionType = builder.getActionType();
			this.eventType = builder.getEventType();
			this.amendmentIndicator = builder.getAmendmentIndicator();
			this.eventIdentifier = builder.getEventIdentifier();
			this.eventTimestamp = builder.getEventTimestamp();
			this.notionalAmountLeg1 = builder.getNotionalAmountLeg1();
			this.notionalAmountLeg2 = builder.getNotionalAmountLeg2();
			this.notionalCurrencyLeg1 = builder.getNotionalCurrencyLeg1();
			this.notionalCurrencyLeg2 = builder.getNotionalCurrencyLeg2();
			this.notionalAmountScheduleLeg1 = ofNullable(builder.getNotionalAmountScheduleLeg1()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.notionalAmountScheduleLeg2 = ofNullable(builder.getNotionalAmountScheduleLeg2()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.callAmount = builder.getCallAmount();
			this.callCurrency = builder.getCallCurrency();
			this.putAmount = builder.getPutAmount();
			this.putCurrency = builder.getPutCurrency();
			this.notionalQuantityLeg1 = builder.getNotionalQuantityLeg1();
			this.notionalQuantityLeg2 = builder.getNotionalQuantityLeg2();
			this.quantityFrequencyLeg1 = builder.getQuantityFrequencyLeg1();
			this.quantityFrequencyLeg2 = builder.getQuantityFrequencyLeg2();
			this.quantityFrequencyMultiplierLeg1 = builder.getQuantityFrequencyMultiplierLeg1();
			this.quantityFrequencyMultiplierLeg2 = builder.getQuantityFrequencyMultiplierLeg2();
			this.quantityUnitOfMeasureLeg1 = builder.getQuantityUnitOfMeasureLeg1();
			this.quantityUnitOfMeasureLeg2 = builder.getQuantityUnitOfMeasureLeg2();
			this.totalNotionalQuantityLeg1 = builder.getTotalNotionalQuantityLeg1();
			this.totalNotionalQuantityLeg2 = builder.getTotalNotionalQuantityLeg2();
			this.packageIndicator = builder.getPackageIndicator();
			this.packageIdentifier = builder.getPackageIdentifier();
			this.packageTransactionPrice = builder.getPackageTransactionPrice();
			this.packageTransactionPriceCurrency = builder.getPackageTransactionPriceCurrency();
			this.packageTransactionPriceNotation = builder.getPackageTransactionPriceNotation();
			this.packageTransactionSpread = builder.getPackageTransactionSpread();
			this.packageTransactionSpreadCurrency = builder.getPackageTransactionSpreadCurrency();
			this.packageTransactionSpreadNotation = builder.getPackageTransactionSpreadNotation();
			this.fixedRateDayCountConventionLeg1 = builder.getFixedRateDayCountConventionLeg1();
			this.fixedRateDayCountConventionLeg2 = builder.getFixedRateDayCountConventionLeg2();
			this.floatingRateDayCountConventionLeg1 = builder.getFloatingRateDayCountConventionLeg1();
			this.floatingRateDayCountConventionLeg2 = builder.getFloatingRateDayCountConventionLeg2();
			this.fixingDateLeg1 = builder.getFixingDateLeg1();
			this.fixingDateLeg2 = builder.getFixingDateLeg2();
			this.floatingRateResetFrequencyPeriodLeg1 = builder.getFloatingRateResetFrequencyPeriodLeg1();
			this.floatingRateResetFrequencyPeriodLeg2 = builder.getFloatingRateResetFrequencyPeriodLeg2();
			this.floatingRateResetFrequencyPeriodMultiplierLeg1 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg1();
			this.floatingRateResetFrequencyPeriodMultiplierLeg2 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg2();
			this.otherPayment = ofNullable(builder.getOtherPayment()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.fixedRatePaymentFrequencyPeriodLeg1 = builder.getFixedRatePaymentFrequencyPeriodLeg1();
			this.fixedRatePaymentFrequencyPeriodLeg2 = builder.getFixedRatePaymentFrequencyPeriodLeg2();
			this.floatingRatePaymentFrequencyPeriodLeg1 = builder.getFloatingRatePaymentFrequencyPeriodLeg1();
			this.floatingRatePaymentFrequencyPeriodLeg2 = builder.getFloatingRatePaymentFrequencyPeriodLeg2();
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg1();
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg2();
			this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1();
			this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2();
			this.exchangeRateLeg1 = builder.getExchangeRateLeg1();
			this.exchangeRateBasis = builder.getExchangeRateBasis();
			this.fixedRateLeg1 = builder.getFixedRateLeg1();
			this.fixedRateLeg2 = builder.getFixedRateLeg2();
			this.postPricedSwapIndicator = builder.getPostPricedSwapIndicator();
			this.price = builder.getPrice();
			this.priceCurrency = builder.getPriceCurrency();
			this.priceNotation = builder.getPriceNotation();
			this.priceUnitOfMeasure = builder.getPriceUnitOfMeasure();
			this.spreadLeg1 = builder.getSpreadLeg1();
			this.spreadLeg2 = builder.getSpreadLeg2();
			this.spreadCurrencyLeg1 = builder.getSpreadCurrencyLeg1();
			this.spreadCurrencyLeg2 = builder.getSpreadCurrencyLeg2();
			this.spreadNotationLeg1 = builder.getSpreadNotationLeg1();
			this.spreadNotationLeg2 = builder.getSpreadNotationLeg2();
			this.strikePrice = builder.getStrikePrice();
			this.strikePriceCurrency = builder.getStrikePriceCurrency();
			this.strikePriceNotation = builder.getStrikePriceNotation();
			this.optionPremiumAmount = builder.getOptionPremiumAmount();
			this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
			this.optionPremiumPaymentDate = builder.getOptionPremiumPaymentDate();
			this.firstExerciseDate = builder.getFirstExerciseDate();
			this.cDSIndexAttachmentPoint = builder.getCDSIndexAttachmentPoint();
			this.cDSIndexDetachmentPoint = builder.getCDSIndexDetachmentPoint();
			this.indexFactor = builder.getIndexFactor();
			this.embeddedOptionType = builder.getEmbeddedOptionType();
			this.uniqueProductIdentifier = builder.getUniqueProductIdentifier();
			this.finalContractualSettlementDate = builder.getFinalContractualSettlementDate();
			this.settlementCurrencyLeg1 = builder.getSettlementCurrencyLeg1();
			this.settlementCurrencyLeg2 = builder.getSettlementCurrencyLeg2();
			this.settlementLocationLeg1 = builder.getSettlementLocationLeg1();
			this.settlementLocationLeg2 = builder.getSettlementLocationLeg2();
			this.allocationIndicator = builder.getAllocationIndicator();
			this.nonStandardizedTermIndicator = builder.getNonStandardizedTermIndicator();
			this.blockTradeElectionIndicator = builder.getBlockTradeElectionIndicator();
			this.effectiveDate = builder.getEffectiveDate();
			this.expirationDate = builder.getExpirationDate();
			this.executionTimestamp = builder.getExecutionTimestamp();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.platformIdentifier = builder.getPlatformIdentifier();
			this.primeBrokerageTransactionIndicator = builder.getPrimeBrokerageTransactionIndicator();
			this.priorUSI = builder.getPriorUSI();
			this.priorUTI = builder.getPriorUTI();
			this.uniqueSwapIdentifier = builder.getUniqueSwapIdentifier();
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.jurisdiction = builder.getJurisdiction();
			this.newSDRIdentifier = builder.getNewSDRIdentifier();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.cftcGuidebook = ofNullable(builder.getCftcGuidebook()).map(f->f.build()).orElse(null);
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public String getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUSIs")
		@RuneAttribute("clearingSwapUSIs")
		public List<? extends ClearingSwapUSIsReport> getClearingSwapUSIs() {
			return clearingSwapUSIs;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUTIs")
		@RuneAttribute("clearingSwapUTIs")
		public List<? extends ClearingSwapUTIsReport> getClearingSwapUTIs() {
			return clearingSwapUTIs;
		}
		
		@Override
		@RosettaAttribute("originalSwapUSI")
		@RuneAttribute("originalSwapUSI")
		public String getOriginalSwapUSI() {
			return originalSwapUSI;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public String getOriginalSwapUTI() {
			return originalSwapUTI;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public String getOriginalSwapSDRIdentifier() {
			return originalSwapSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public List<? extends ClearingExceptionsAndExemptionsCounterparty1Report> getClearingExceptionsAndExemptionsCounterparty1() {
			return clearingExceptionsAndExemptionsCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public List<? extends ClearingExceptionsAndExemptionsCounterparty2Report> getClearingExceptionsAndExemptionsCounterparty2() {
			return clearingExceptionsAndExemptionsCounterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
		public String getCounterparty2IdentifierSource() {
			return counterparty2IdentifierSource;
		}
		
		@Override
		@RosettaAttribute("counterparty1FinancialEntityIndicator")
		@RuneAttribute("counterparty1FinancialEntityIndicator")
		public Boolean getCounterparty1FinancialEntityIndicator() {
			return counterparty1FinancialEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
		public Boolean getCounterparty2FinancialEntityIndicator() {
			return counterparty2FinancialEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		public String getBuyerIdentifier() {
			return buyerIdentifier;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		public String getSellerIdentifier() {
			return sellerIdentifier;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1")
		@RuneAttribute("payerIdentifierLeg1")
		public String getPayerIdentifierLeg1() {
			return payerIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2")
		@RuneAttribute("payerIdentifierLeg2")
		public String getPayerIdentifierLeg2() {
			return payerIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1")
		@RuneAttribute("receiverIdentifierLeg1")
		public String getReceiverIdentifierLeg1() {
			return receiverIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2")
		@RuneAttribute("receiverIdentifierLeg2")
		public String getReceiverIdentifierLeg2() {
			return receiverIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1FederalEntityIndicator", isRequired=true)
		@RuneAttribute(value="counterparty1FederalEntityIndicator", isRequired=true)
		public Boolean getCounterparty1FederalEntityIndicator() {
			return counterparty1FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2FederalEntityIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2FederalEntityIndicator", isRequired=true)
		public Boolean getCounterparty2FederalEntityIndicator() {
			return counterparty2FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="customBasketIndicator", isRequired=true)
		@RuneAttribute(value="customBasketIndicator", isRequired=true)
		public Boolean getCustomBasketIndicator() {
			return customBasketIndicator;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public Boolean getAmendmentIndicator() {
			return amendmentIndicator;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public String getEventIdentifier() {
			return eventIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("notionalAmountLeg1")
		@RuneAttribute("notionalAmountLeg1")
		public BigDecimal getNotionalAmountLeg1() {
			return notionalAmountLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalAmountLeg2")
		@RuneAttribute("notionalAmountLeg2")
		public BigDecimal getNotionalAmountLeg2() {
			return notionalAmountLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyLeg1")
		@RuneAttribute("notionalCurrencyLeg1")
		public ISOCurrencyCodeEnum getNotionalCurrencyLeg1() {
			return notionalCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyLeg2")
		@RuneAttribute("notionalCurrencyLeg2")
		public ISOCurrencyCodeEnum getNotionalCurrencyLeg2() {
			return notionalCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1() {
			return notionalAmountScheduleLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2() {
			return notionalAmountScheduleLeg2;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public BigDecimal getCallAmount() {
			return callAmount;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public ISOCurrencyCodeEnum getCallCurrency() {
			return callCurrency;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public BigDecimal getPutAmount() {
			return putAmount;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public ISOCurrencyCodeEnum getPutCurrency() {
			return putCurrency;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityLeg1")
		@RuneAttribute("notionalQuantityLeg1")
		public BigDecimal getNotionalQuantityLeg1() {
			return notionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityLeg2")
		@RuneAttribute("notionalQuantityLeg2")
		public BigDecimal getNotionalQuantityLeg2() {
			return notionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyLeg1")
		@RuneAttribute("quantityFrequencyLeg1")
		public String getQuantityFrequencyLeg1() {
			return quantityFrequencyLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyLeg2")
		@RuneAttribute("quantityFrequencyLeg2")
		public String getQuantityFrequencyLeg2() {
			return quantityFrequencyLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg1")
		@RuneAttribute("quantityFrequencyMultiplierLeg1")
		public Integer getQuantityFrequencyMultiplierLeg1() {
			return quantityFrequencyMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg2")
		@RuneAttribute("quantityFrequencyMultiplierLeg2")
		public Integer getQuantityFrequencyMultiplierLeg2() {
			return quantityFrequencyMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public String getQuantityUnitOfMeasureLeg1() {
			return quantityUnitOfMeasureLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public String getQuantityUnitOfMeasureLeg2() {
			return quantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute(value="packageIndicator", isRequired=true)
		@RuneAttribute(value="packageIndicator", isRequired=true)
		public Boolean getPackageIndicator() {
			return packageIndicator;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public BigDecimal getPackageTransactionPrice() {
			return packageTransactionPrice;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
			return packageTransactionPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public String getPackageTransactionPriceNotation() {
			return packageTransactionPriceNotation;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public BigDecimal getPackageTransactionSpread() {
			return packageTransactionSpread;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
			return packageTransactionSpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public String getPackageTransactionSpreadNotation() {
			return packageTransactionSpreadNotation;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
			return fixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
			return fixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionLeg1")
		@RuneAttribute("floatingRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionLeg1() {
			return floatingRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionLeg2")
		@RuneAttribute("floatingRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionLeg2() {
			return floatingRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg1")
		@RuneAttribute("fixingDateLeg1")
		public Date getFixingDateLeg1() {
			return fixingDateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg2")
		@RuneAttribute("fixingDateLeg2")
		public Date getFixingDateLeg2() {
			return fixingDateLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodLeg1")
		public String getFloatingRateResetFrequencyPeriodLeg1() {
			return floatingRateResetFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodLeg2")
		public String getFloatingRateResetFrequencyPeriodLeg2() {
			return floatingRateResetFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		public String getFixedRatePaymentFrequencyPeriodLeg1() {
			return fixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		public String getFixedRatePaymentFrequencyPeriodLeg2() {
			return fixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		public String getFloatingRatePaymentFrequencyPeriodLeg1() {
			return floatingRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		public String getFloatingRatePaymentFrequencyPeriodLeg2() {
			return floatingRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("exchangeRateLeg1")
		@RuneAttribute("exchangeRateLeg1")
		public BigDecimal getExchangeRateLeg1() {
			return exchangeRateLeg1;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg1")
		@RuneAttribute("fixedRateLeg1")
		public BigDecimal getFixedRateLeg1() {
			return fixedRateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg2")
		@RuneAttribute("fixedRateLeg2")
		public BigDecimal getFixedRateLeg2() {
			return fixedRateLeg2;
		}
		
		@Override
		@RosettaAttribute(value="postPricedSwapIndicator", isRequired=true)
		@RuneAttribute(value="postPricedSwapIndicator", isRequired=true)
		public Boolean getPostPricedSwapIndicator() {
			return postPricedSwapIndicator;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public BigDecimal getPrice() {
			return price;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public ISOCurrencyCodeEnum getPriceCurrency() {
			return priceCurrency;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public String getPriceNotation() {
			return priceNotation;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public String getPriceUnitOfMeasure() {
			return priceUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1")
		@RuneAttribute("spreadLeg1")
		public BigDecimal getSpreadLeg1() {
			return spreadLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2")
		@RuneAttribute("spreadLeg2")
		public BigDecimal getSpreadLeg2() {
			return spreadLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyLeg1")
		@RuneAttribute("spreadCurrencyLeg1")
		public ISOCurrencyCodeEnum getSpreadCurrencyLeg1() {
			return spreadCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyLeg2")
		@RuneAttribute("spreadCurrencyLeg2")
		public ISOCurrencyCodeEnum getSpreadCurrencyLeg2() {
			return spreadCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadNotationLeg1")
		@RuneAttribute("spreadNotationLeg1")
		public String getSpreadNotationLeg1() {
			return spreadNotationLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadNotationLeg2")
		@RuneAttribute("spreadNotationLeg2")
		public String getSpreadNotationLeg2() {
			return spreadNotationLeg2;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public BigDecimal getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public String getStrikePriceCurrency() {
			return strikePriceCurrency;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public String getStrikePriceNotation() {
			return strikePriceNotation;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public Date getFirstExerciseDate() {
			return firstExerciseDate;
		}
		
		@Override
		@RosettaAttribute("cDSIndexAttachmentPoint")
		@RuneAttribute("cDSIndexAttachmentPoint")
		public BigDecimal getCDSIndexAttachmentPoint() {
			return cDSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cDSIndexDetachmentPoint")
		@RuneAttribute("cDSIndexDetachmentPoint")
		public BigDecimal getCDSIndexDetachmentPoint() {
			return cDSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public String getEmbeddedOptionType() {
			return embeddedOptionType;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public String getUniqueProductIdentifier() {
			return uniqueProductIdentifier;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg1")
		@RuneAttribute("settlementCurrencyLeg1")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
			return settlementCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg2")
		@RuneAttribute("settlementCurrencyLeg2")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
			return settlementCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg1")
		@RuneAttribute("settlementLocationLeg1")
		public String getSettlementLocationLeg1() {
			return settlementLocationLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg2")
		@RuneAttribute("settlementLocationLeg2")
		public String getSettlementLocationLeg2() {
			return settlementLocationLeg2;
		}
		
		@Override
		@RosettaAttribute(value="allocationIndicator", isRequired=true)
		@RuneAttribute(value="allocationIndicator", isRequired=true)
		public String getAllocationIndicator() {
			return allocationIndicator;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public Boolean getNonStandardizedTermIndicator() {
			return nonStandardizedTermIndicator;
		}
		
		@Override
		@RosettaAttribute(value="blockTradeElectionIndicator", isRequired=true)
		@RuneAttribute(value="blockTradeElectionIndicator", isRequired=true)
		public Boolean getBlockTradeElectionIndicator() {
			return blockTradeElectionIndicator;
		}
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public String getPlatformIdentifier() {
			return platformIdentifier;
		}
		
		@Override
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		public Boolean getPrimeBrokerageTransactionIndicator() {
			return primeBrokerageTransactionIndicator;
		}
		
		@Override
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		public String getPriorUSI() {
			return priorUSI;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("uniqueSwapIdentifier")
		@RuneAttribute("uniqueSwapIdentifier")
		public String getUniqueSwapIdentifier() {
			return uniqueSwapIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="jurisdiction", isRequired=true)
		@RuneAttribute(value="jurisdiction", isRequired=true)
		public String getJurisdiction() {
			return jurisdiction;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="cftcGuidebook", isRequired=true)
		@RuneAttribute(value="cftcGuidebook", isRequired=true)
		public CFTCGuidebookPart45 getCftcGuidebook() {
			return cftcGuidebook;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public CFTCNonReportablePart45 getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public CFTCPart45TransactionReport build() {
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder toBuilder() {
			CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder builder) {
			ofNullable(getCleared()).ifPresent(builder::setCleared);
			ofNullable(getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
			ofNullable(getClearingAccountOrigin()).ifPresent(builder::setClearingAccountOrigin);
			ofNullable(getClearingMember()).ifPresent(builder::setClearingMember);
			ofNullable(getClearingSwapUSIs()).ifPresent(builder::setClearingSwapUSIs);
			ofNullable(getClearingSwapUTIs()).ifPresent(builder::setClearingSwapUTIs);
			ofNullable(getOriginalSwapUSI()).ifPresent(builder::setOriginalSwapUSI);
			ofNullable(getOriginalSwapUTI()).ifPresent(builder::setOriginalSwapUTI);
			ofNullable(getOriginalSwapSDRIdentifier()).ifPresent(builder::setOriginalSwapSDRIdentifier);
			ofNullable(getClearingReceiptTimestamp()).ifPresent(builder::setClearingReceiptTimestamp);
			ofNullable(getClearingExceptionsAndExemptionsCounterparty1()).ifPresent(builder::setClearingExceptionsAndExemptionsCounterparty1);
			ofNullable(getClearingExceptionsAndExemptionsCounterparty2()).ifPresent(builder::setClearingExceptionsAndExemptionsCounterparty2);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSource);
			ofNullable(getCounterparty1FinancialEntityIndicator()).ifPresent(builder::setCounterparty1FinancialEntityIndicator);
			ofNullable(getCounterparty2FinancialEntityIndicator()).ifPresent(builder::setCounterparty2FinancialEntityIndicator);
			ofNullable(getBuyerIdentifier()).ifPresent(builder::setBuyerIdentifier);
			ofNullable(getSellerIdentifier()).ifPresent(builder::setSellerIdentifier);
			ofNullable(getPayerIdentifierLeg1()).ifPresent(builder::setPayerIdentifierLeg1);
			ofNullable(getPayerIdentifierLeg2()).ifPresent(builder::setPayerIdentifierLeg2);
			ofNullable(getReceiverIdentifierLeg1()).ifPresent(builder::setReceiverIdentifierLeg1);
			ofNullable(getReceiverIdentifierLeg2()).ifPresent(builder::setReceiverIdentifierLeg2);
			ofNullable(getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
			ofNullable(getCounterparty1FederalEntityIndicator()).ifPresent(builder::setCounterparty1FederalEntityIndicator);
			ofNullable(getCounterparty2FederalEntityIndicator()).ifPresent(builder::setCounterparty2FederalEntityIndicator);
			ofNullable(getCustomBasketIndicator()).ifPresent(builder::setCustomBasketIndicator);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getEventType()).ifPresent(builder::setEventType);
			ofNullable(getAmendmentIndicator()).ifPresent(builder::setAmendmentIndicator);
			ofNullable(getEventIdentifier()).ifPresent(builder::setEventIdentifier);
			ofNullable(getEventTimestamp()).ifPresent(builder::setEventTimestamp);
			ofNullable(getNotionalAmountLeg1()).ifPresent(builder::setNotionalAmountLeg1);
			ofNullable(getNotionalAmountLeg2()).ifPresent(builder::setNotionalAmountLeg2);
			ofNullable(getNotionalCurrencyLeg1()).ifPresent(builder::setNotionalCurrencyLeg1);
			ofNullable(getNotionalCurrencyLeg2()).ifPresent(builder::setNotionalCurrencyLeg2);
			ofNullable(getNotionalAmountScheduleLeg1()).ifPresent(builder::setNotionalAmountScheduleLeg1);
			ofNullable(getNotionalAmountScheduleLeg2()).ifPresent(builder::setNotionalAmountScheduleLeg2);
			ofNullable(getCallAmount()).ifPresent(builder::setCallAmount);
			ofNullable(getCallCurrency()).ifPresent(builder::setCallCurrency);
			ofNullable(getPutAmount()).ifPresent(builder::setPutAmount);
			ofNullable(getPutCurrency()).ifPresent(builder::setPutCurrency);
			ofNullable(getNotionalQuantityLeg1()).ifPresent(builder::setNotionalQuantityLeg1);
			ofNullable(getNotionalQuantityLeg2()).ifPresent(builder::setNotionalQuantityLeg2);
			ofNullable(getQuantityFrequencyLeg1()).ifPresent(builder::setQuantityFrequencyLeg1);
			ofNullable(getQuantityFrequencyLeg2()).ifPresent(builder::setQuantityFrequencyLeg2);
			ofNullable(getQuantityFrequencyMultiplierLeg1()).ifPresent(builder::setQuantityFrequencyMultiplierLeg1);
			ofNullable(getQuantityFrequencyMultiplierLeg2()).ifPresent(builder::setQuantityFrequencyMultiplierLeg2);
			ofNullable(getQuantityUnitOfMeasureLeg1()).ifPresent(builder::setQuantityUnitOfMeasureLeg1);
			ofNullable(getQuantityUnitOfMeasureLeg2()).ifPresent(builder::setQuantityUnitOfMeasureLeg2);
			ofNullable(getTotalNotionalQuantityLeg1()).ifPresent(builder::setTotalNotionalQuantityLeg1);
			ofNullable(getTotalNotionalQuantityLeg2()).ifPresent(builder::setTotalNotionalQuantityLeg2);
			ofNullable(getPackageIndicator()).ifPresent(builder::setPackageIndicator);
			ofNullable(getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
			ofNullable(getPackageTransactionPrice()).ifPresent(builder::setPackageTransactionPrice);
			ofNullable(getPackageTransactionPriceCurrency()).ifPresent(builder::setPackageTransactionPriceCurrency);
			ofNullable(getPackageTransactionPriceNotation()).ifPresent(builder::setPackageTransactionPriceNotation);
			ofNullable(getPackageTransactionSpread()).ifPresent(builder::setPackageTransactionSpread);
			ofNullable(getPackageTransactionSpreadCurrency()).ifPresent(builder::setPackageTransactionSpreadCurrency);
			ofNullable(getPackageTransactionSpreadNotation()).ifPresent(builder::setPackageTransactionSpreadNotation);
			ofNullable(getFixedRateDayCountConventionLeg1()).ifPresent(builder::setFixedRateDayCountConventionLeg1);
			ofNullable(getFixedRateDayCountConventionLeg2()).ifPresent(builder::setFixedRateDayCountConventionLeg2);
			ofNullable(getFloatingRateDayCountConventionLeg1()).ifPresent(builder::setFloatingRateDayCountConventionLeg1);
			ofNullable(getFloatingRateDayCountConventionLeg2()).ifPresent(builder::setFloatingRateDayCountConventionLeg2);
			ofNullable(getFixingDateLeg1()).ifPresent(builder::setFixingDateLeg1);
			ofNullable(getFixingDateLeg2()).ifPresent(builder::setFixingDateLeg2);
			ofNullable(getFloatingRateResetFrequencyPeriodLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodLeg1);
			ofNullable(getFloatingRateResetFrequencyPeriodLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodLeg2);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg1);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg2);
			ofNullable(getOtherPayment()).ifPresent(builder::setOtherPayment);
			ofNullable(getFixedRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodLeg2);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getExchangeRateLeg1()).ifPresent(builder::setExchangeRateLeg1);
			ofNullable(getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
			ofNullable(getFixedRateLeg1()).ifPresent(builder::setFixedRateLeg1);
			ofNullable(getFixedRateLeg2()).ifPresent(builder::setFixedRateLeg2);
			ofNullable(getPostPricedSwapIndicator()).ifPresent(builder::setPostPricedSwapIndicator);
			ofNullable(getPrice()).ifPresent(builder::setPrice);
			ofNullable(getPriceCurrency()).ifPresent(builder::setPriceCurrency);
			ofNullable(getPriceNotation()).ifPresent(builder::setPriceNotation);
			ofNullable(getPriceUnitOfMeasure()).ifPresent(builder::setPriceUnitOfMeasure);
			ofNullable(getSpreadLeg1()).ifPresent(builder::setSpreadLeg1);
			ofNullable(getSpreadLeg2()).ifPresent(builder::setSpreadLeg2);
			ofNullable(getSpreadCurrencyLeg1()).ifPresent(builder::setSpreadCurrencyLeg1);
			ofNullable(getSpreadCurrencyLeg2()).ifPresent(builder::setSpreadCurrencyLeg2);
			ofNullable(getSpreadNotationLeg1()).ifPresent(builder::setSpreadNotationLeg1);
			ofNullable(getSpreadNotationLeg2()).ifPresent(builder::setSpreadNotationLeg2);
			ofNullable(getStrikePrice()).ifPresent(builder::setStrikePrice);
			ofNullable(getStrikePriceCurrency()).ifPresent(builder::setStrikePriceCurrency);
			ofNullable(getStrikePriceNotation()).ifPresent(builder::setStrikePriceNotation);
			ofNullable(getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
			ofNullable(getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
			ofNullable(getOptionPremiumPaymentDate()).ifPresent(builder::setOptionPremiumPaymentDate);
			ofNullable(getFirstExerciseDate()).ifPresent(builder::setFirstExerciseDate);
			ofNullable(getCDSIndexAttachmentPoint()).ifPresent(builder::setCDSIndexAttachmentPoint);
			ofNullable(getCDSIndexDetachmentPoint()).ifPresent(builder::setCDSIndexDetachmentPoint);
			ofNullable(getIndexFactor()).ifPresent(builder::setIndexFactor);
			ofNullable(getEmbeddedOptionType()).ifPresent(builder::setEmbeddedOptionType);
			ofNullable(getUniqueProductIdentifier()).ifPresent(builder::setUniqueProductIdentifier);
			ofNullable(getFinalContractualSettlementDate()).ifPresent(builder::setFinalContractualSettlementDate);
			ofNullable(getSettlementCurrencyLeg1()).ifPresent(builder::setSettlementCurrencyLeg1);
			ofNullable(getSettlementCurrencyLeg2()).ifPresent(builder::setSettlementCurrencyLeg2);
			ofNullable(getSettlementLocationLeg1()).ifPresent(builder::setSettlementLocationLeg1);
			ofNullable(getSettlementLocationLeg2()).ifPresent(builder::setSettlementLocationLeg2);
			ofNullable(getAllocationIndicator()).ifPresent(builder::setAllocationIndicator);
			ofNullable(getNonStandardizedTermIndicator()).ifPresent(builder::setNonStandardizedTermIndicator);
			ofNullable(getBlockTradeElectionIndicator()).ifPresent(builder::setBlockTradeElectionIndicator);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getExpirationDate()).ifPresent(builder::setExpirationDate);
			ofNullable(getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getPlatformIdentifier()).ifPresent(builder::setPlatformIdentifier);
			ofNullable(getPrimeBrokerageTransactionIndicator()).ifPresent(builder::setPrimeBrokerageTransactionIndicator);
			ofNullable(getPriorUSI()).ifPresent(builder::setPriorUSI);
			ofNullable(getPriorUTI()).ifPresent(builder::setPriorUTI);
			ofNullable(getUniqueSwapIdentifier()).ifPresent(builder::setUniqueSwapIdentifier);
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getJurisdiction()).ifPresent(builder::setJurisdiction);
			ofNullable(getNewSDRIdentifier()).ifPresent(builder::setNewSDRIdentifier);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getCftcGuidebook()).ifPresent(builder::setCftcGuidebook);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CFTCPart45TransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!ListEquals.listEquals(clearingSwapUSIs, _that.getClearingSwapUSIs())) return false;
			if (!ListEquals.listEquals(clearingSwapUTIs, _that.getClearingSwapUTIs())) return false;
			if (!Objects.equals(originalSwapUSI, _that.getOriginalSwapUSI())) return false;
			if (!Objects.equals(originalSwapUTI, _that.getOriginalSwapUTI())) return false;
			if (!Objects.equals(originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty1, _that.getClearingExceptionsAndExemptionsCounterparty1())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty2, _that.getClearingExceptionsAndExemptionsCounterparty2())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) return false;
			if (!Objects.equals(counterparty1FinancialEntityIndicator, _that.getCounterparty1FinancialEntityIndicator())) return false;
			if (!Objects.equals(counterparty2FinancialEntityIndicator, _that.getCounterparty2FinancialEntityIndicator())) return false;
			if (!Objects.equals(buyerIdentifier, _that.getBuyerIdentifier())) return false;
			if (!Objects.equals(sellerIdentifier, _that.getSellerIdentifier())) return false;
			if (!Objects.equals(payerIdentifierLeg1, _that.getPayerIdentifierLeg1())) return false;
			if (!Objects.equals(payerIdentifierLeg2, _that.getPayerIdentifierLeg2())) return false;
			if (!Objects.equals(receiverIdentifierLeg1, _that.getReceiverIdentifierLeg1())) return false;
			if (!Objects.equals(receiverIdentifierLeg2, _that.getReceiverIdentifierLeg2())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(counterparty1FederalEntityIndicator, _that.getCounterparty1FederalEntityIndicator())) return false;
			if (!Objects.equals(counterparty2FederalEntityIndicator, _that.getCounterparty2FederalEntityIndicator())) return false;
			if (!Objects.equals(customBasketIndicator, _that.getCustomBasketIndicator())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(amendmentIndicator, _that.getAmendmentIndicator())) return false;
			if (!Objects.equals(eventIdentifier, _that.getEventIdentifier())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(notionalAmountLeg1, _that.getNotionalAmountLeg1())) return false;
			if (!Objects.equals(notionalAmountLeg2, _that.getNotionalAmountLeg2())) return false;
			if (!Objects.equals(notionalCurrencyLeg1, _that.getNotionalCurrencyLeg1())) return false;
			if (!Objects.equals(notionalCurrencyLeg2, _that.getNotionalCurrencyLeg2())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) return false;
			if (!Objects.equals(callAmount, _that.getCallAmount())) return false;
			if (!Objects.equals(callCurrency, _that.getCallCurrency())) return false;
			if (!Objects.equals(putAmount, _that.getPutAmount())) return false;
			if (!Objects.equals(putCurrency, _that.getPutCurrency())) return false;
			if (!Objects.equals(notionalQuantityLeg1, _that.getNotionalQuantityLeg1())) return false;
			if (!Objects.equals(notionalQuantityLeg2, _that.getNotionalQuantityLeg2())) return false;
			if (!Objects.equals(quantityFrequencyLeg1, _that.getQuantityFrequencyLeg1())) return false;
			if (!Objects.equals(quantityFrequencyLeg2, _that.getQuantityFrequencyLeg2())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierLeg1, _that.getQuantityFrequencyMultiplierLeg1())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierLeg2, _that.getQuantityFrequencyMultiplierLeg2())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(packageIndicator, _that.getPackageIndicator())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(packageTransactionPrice, _that.getPackageTransactionPrice())) return false;
			if (!Objects.equals(packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) return false;
			if (!Objects.equals(packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) return false;
			if (!Objects.equals(packageTransactionSpread, _that.getPackageTransactionSpread())) return false;
			if (!Objects.equals(packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) return false;
			if (!Objects.equals(packageTransactionSpreadNotation, _that.getPackageTransactionSpreadNotation())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionLeg1, _that.getFloatingRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionLeg2, _that.getFloatingRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(fixingDateLeg1, _that.getFixingDateLeg1())) return false;
			if (!Objects.equals(fixingDateLeg2, _that.getFixingDateLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodLeg1, _that.getFloatingRateResetFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodLeg2, _that.getFloatingRateResetFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodLeg1, _that.getFloatingRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodLeg2, _that.getFloatingRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(exchangeRateLeg1, _that.getExchangeRateLeg1())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(fixedRateLeg1, _that.getFixedRateLeg1())) return false;
			if (!Objects.equals(fixedRateLeg2, _that.getFixedRateLeg2())) return false;
			if (!Objects.equals(postPricedSwapIndicator, _that.getPostPricedSwapIndicator())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!Objects.equals(priceCurrency, _that.getPriceCurrency())) return false;
			if (!Objects.equals(priceNotation, _that.getPriceNotation())) return false;
			if (!Objects.equals(priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) return false;
			if (!Objects.equals(spreadLeg1, _that.getSpreadLeg1())) return false;
			if (!Objects.equals(spreadLeg2, _that.getSpreadLeg2())) return false;
			if (!Objects.equals(spreadCurrencyLeg1, _that.getSpreadCurrencyLeg1())) return false;
			if (!Objects.equals(spreadCurrencyLeg2, _that.getSpreadCurrencyLeg2())) return false;
			if (!Objects.equals(spreadNotationLeg1, _that.getSpreadNotationLeg1())) return false;
			if (!Objects.equals(spreadNotationLeg2, _that.getSpreadNotationLeg2())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!Objects.equals(strikePriceCurrency, _that.getStrikePriceCurrency())) return false;
			if (!Objects.equals(strikePriceNotation, _that.getStrikePriceNotation())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(firstExerciseDate, _that.getFirstExerciseDate())) return false;
			if (!Objects.equals(cDSIndexAttachmentPoint, _that.getCDSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cDSIndexDetachmentPoint, _that.getCDSIndexDetachmentPoint())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(embeddedOptionType, _that.getEmbeddedOptionType())) return false;
			if (!Objects.equals(uniqueProductIdentifier, _that.getUniqueProductIdentifier())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) return false;
			if (!Objects.equals(settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) return false;
			if (!Objects.equals(settlementLocationLeg1, _that.getSettlementLocationLeg1())) return false;
			if (!Objects.equals(settlementLocationLeg2, _that.getSettlementLocationLeg2())) return false;
			if (!Objects.equals(allocationIndicator, _that.getAllocationIndicator())) return false;
			if (!Objects.equals(nonStandardizedTermIndicator, _that.getNonStandardizedTermIndicator())) return false;
			if (!Objects.equals(blockTradeElectionIndicator, _that.getBlockTradeElectionIndicator())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(platformIdentifier, _that.getPlatformIdentifier())) return false;
			if (!Objects.equals(primeBrokerageTransactionIndicator, _that.getPrimeBrokerageTransactionIndicator())) return false;
			if (!Objects.equals(priorUSI, _that.getPriorUSI())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(jurisdiction, _that.getJurisdiction())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(cftcGuidebook, _that.getCftcGuidebook())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (clearingSwapUSIs != null ? clearingSwapUSIs.hashCode() : 0);
			_result = 31 * _result + (clearingSwapUTIs != null ? clearingSwapUTIs.hashCode() : 0);
			_result = 31 * _result + (originalSwapUSI != null ? originalSwapUSI.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTI != null ? originalSwapUTI.hashCode() : 0);
			_result = 31 * _result + (originalSwapSDRIdentifier != null ? originalSwapSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty1 != null ? clearingExceptionsAndExemptionsCounterparty1.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty2 != null ? clearingExceptionsAndExemptionsCounterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierSource != null ? counterparty2IdentifierSource.hashCode() : 0);
			_result = 31 * _result + (counterparty1FinancialEntityIndicator != null ? counterparty1FinancialEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2FinancialEntityIndicator != null ? counterparty2FinancialEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (buyerIdentifier != null ? buyerIdentifier.hashCode() : 0);
			_result = 31 * _result + (sellerIdentifier != null ? sellerIdentifier.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg1 != null ? payerIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg2 != null ? payerIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg1 != null ? receiverIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg2 != null ? receiverIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (counterparty1FederalEntityIndicator != null ? counterparty1FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2FederalEntityIndicator != null ? counterparty2FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (customBasketIndicator != null ? customBasketIndicator.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (amendmentIndicator != null ? amendmentIndicator.hashCode() : 0);
			_result = 31 * _result + (eventIdentifier != null ? eventIdentifier.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (notionalAmountLeg1 != null ? notionalAmountLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalAmountLeg2 != null ? notionalAmountLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyLeg1 != null ? notionalCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyLeg2 != null ? notionalCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1 != null ? notionalAmountScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2 != null ? notionalAmountScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (callAmount != null ? callAmount.hashCode() : 0);
			_result = 31 * _result + (callCurrency != null ? callCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (putAmount != null ? putAmount.hashCode() : 0);
			_result = 31 * _result + (putCurrency != null ? putCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalQuantityLeg1 != null ? notionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityLeg2 != null ? notionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyLeg1 != null ? quantityFrequencyLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyLeg2 != null ? quantityFrequencyLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierLeg1 != null ? quantityFrequencyMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierLeg2 != null ? quantityFrequencyMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg1 != null ? quantityUnitOfMeasureLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg2 != null ? quantityUnitOfMeasureLeg2.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (packageIndicator != null ? packageIndicator.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPrice != null ? packageTransactionPrice.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceCurrency != null ? packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceNotation != null ? packageTransactionPriceNotation.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpread != null ? packageTransactionSpread.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadCurrency != null ? packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadNotation != null ? packageTransactionSpreadNotation.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg1 != null ? fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg2 != null ? fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionLeg1 != null ? floatingRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionLeg2 != null ? floatingRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg1 != null ? fixingDateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg2 != null ? fixingDateLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodLeg1 != null ? floatingRateResetFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodLeg2 != null ? floatingRateResetFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg1 != null ? fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg2 != null ? fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodLeg1 != null ? floatingRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodLeg2 != null ? floatingRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (exchangeRateLeg1 != null ? exchangeRateLeg1.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg1 != null ? fixedRateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg2 != null ? fixedRateLeg2.hashCode() : 0);
			_result = 31 * _result + (postPricedSwapIndicator != null ? postPricedSwapIndicator.hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceCurrency != null ? priceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (priceNotation != null ? priceNotation.hashCode() : 0);
			_result = 31 * _result + (priceUnitOfMeasure != null ? priceUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1 != null ? spreadLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2 != null ? spreadLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyLeg1 != null ? spreadCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyLeg2 != null ? spreadCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadNotationLeg1 != null ? spreadNotationLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadNotationLeg2 != null ? spreadNotationLeg2.hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceCurrency != null ? strikePriceCurrency.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotation != null ? strikePriceNotation.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (firstExerciseDate != null ? firstExerciseDate.hashCode() : 0);
			_result = 31 * _result + (cDSIndexAttachmentPoint != null ? cDSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cDSIndexDetachmentPoint != null ? cDSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (embeddedOptionType != null ? embeddedOptionType.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifier != null ? uniqueProductIdentifier.hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg1 != null ? settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg2 != null ? settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementLocationLeg1 != null ? settlementLocationLeg1.hashCode() : 0);
			_result = 31 * _result + (settlementLocationLeg2 != null ? settlementLocationLeg2.hashCode() : 0);
			_result = 31 * _result + (allocationIndicator != null ? allocationIndicator.hashCode() : 0);
			_result = 31 * _result + (nonStandardizedTermIndicator != null ? nonStandardizedTermIndicator.hashCode() : 0);
			_result = 31 * _result + (blockTradeElectionIndicator != null ? blockTradeElectionIndicator.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (platformIdentifier != null ? platformIdentifier.hashCode() : 0);
			_result = 31 * _result + (primeBrokerageTransactionIndicator != null ? primeBrokerageTransactionIndicator.hashCode() : 0);
			_result = 31 * _result + (priorUSI != null ? priorUSI.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (uniqueSwapIdentifier != null ? uniqueSwapIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (jurisdiction != null ? jurisdiction.hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (cftcGuidebook != null ? cftcGuidebook.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCPart45TransactionReport {" +
				"cleared=" + this.cleared + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"clearingSwapUSIs=" + this.clearingSwapUSIs + ", " +
				"clearingSwapUTIs=" + this.clearingSwapUTIs + ", " +
				"originalSwapUSI=" + this.originalSwapUSI + ", " +
				"originalSwapUTI=" + this.originalSwapUTI + ", " +
				"originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"clearingExceptionsAndExemptionsCounterparty1=" + this.clearingExceptionsAndExemptionsCounterparty1 + ", " +
				"clearingExceptionsAndExemptionsCounterparty2=" + this.clearingExceptionsAndExemptionsCounterparty2 + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", " +
				"counterparty1FinancialEntityIndicator=" + this.counterparty1FinancialEntityIndicator + ", " +
				"counterparty2FinancialEntityIndicator=" + this.counterparty2FinancialEntityIndicator + ", " +
				"buyerIdentifier=" + this.buyerIdentifier + ", " +
				"sellerIdentifier=" + this.sellerIdentifier + ", " +
				"payerIdentifierLeg1=" + this.payerIdentifierLeg1 + ", " +
				"payerIdentifierLeg2=" + this.payerIdentifierLeg2 + ", " +
				"receiverIdentifierLeg1=" + this.receiverIdentifierLeg1 + ", " +
				"receiverIdentifierLeg2=" + this.receiverIdentifierLeg2 + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"counterparty1FederalEntityIndicator=" + this.counterparty1FederalEntityIndicator + ", " +
				"counterparty2FederalEntityIndicator=" + this.counterparty2FederalEntityIndicator + ", " +
				"customBasketIndicator=" + this.customBasketIndicator + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"amendmentIndicator=" + this.amendmentIndicator + ", " +
				"eventIdentifier=" + this.eventIdentifier + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"notionalAmountLeg1=" + this.notionalAmountLeg1 + ", " +
				"notionalAmountLeg2=" + this.notionalAmountLeg2 + ", " +
				"notionalCurrencyLeg1=" + this.notionalCurrencyLeg1 + ", " +
				"notionalCurrencyLeg2=" + this.notionalCurrencyLeg2 + ", " +
				"notionalAmountScheduleLeg1=" + this.notionalAmountScheduleLeg1 + ", " +
				"notionalAmountScheduleLeg2=" + this.notionalAmountScheduleLeg2 + ", " +
				"callAmount=" + this.callAmount + ", " +
				"callCurrency=" + this.callCurrency + ", " +
				"putAmount=" + this.putAmount + ", " +
				"putCurrency=" + this.putCurrency + ", " +
				"notionalQuantityLeg1=" + this.notionalQuantityLeg1 + ", " +
				"notionalQuantityLeg2=" + this.notionalQuantityLeg2 + ", " +
				"quantityFrequencyLeg1=" + this.quantityFrequencyLeg1 + ", " +
				"quantityFrequencyLeg2=" + this.quantityFrequencyLeg2 + ", " +
				"quantityFrequencyMultiplierLeg1=" + this.quantityFrequencyMultiplierLeg1 + ", " +
				"quantityFrequencyMultiplierLeg2=" + this.quantityFrequencyMultiplierLeg2 + ", " +
				"quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", " +
				"quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"packageIndicator=" + this.packageIndicator + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"packageTransactionPrice=" + this.packageTransactionPrice + ", " +
				"packageTransactionPriceCurrency=" + this.packageTransactionPriceCurrency + ", " +
				"packageTransactionPriceNotation=" + this.packageTransactionPriceNotation + ", " +
				"packageTransactionSpread=" + this.packageTransactionSpread + ", " +
				"packageTransactionSpreadCurrency=" + this.packageTransactionSpreadCurrency + ", " +
				"packageTransactionSpreadNotation=" + this.packageTransactionSpreadNotation + ", " +
				"fixedRateDayCountConventionLeg1=" + this.fixedRateDayCountConventionLeg1 + ", " +
				"fixedRateDayCountConventionLeg2=" + this.fixedRateDayCountConventionLeg2 + ", " +
				"floatingRateDayCountConventionLeg1=" + this.floatingRateDayCountConventionLeg1 + ", " +
				"floatingRateDayCountConventionLeg2=" + this.floatingRateDayCountConventionLeg2 + ", " +
				"fixingDateLeg1=" + this.fixingDateLeg1 + ", " +
				"fixingDateLeg2=" + this.fixingDateLeg2 + ", " +
				"floatingRateResetFrequencyPeriodLeg1=" + this.floatingRateResetFrequencyPeriodLeg1 + ", " +
				"floatingRateResetFrequencyPeriodLeg2=" + this.floatingRateResetFrequencyPeriodLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodLeg1=" + this.floatingRatePaymentFrequencyPeriodLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodLeg2=" + this.floatingRatePaymentFrequencyPeriodLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"exchangeRateLeg1=" + this.exchangeRateLeg1 + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"fixedRateLeg1=" + this.fixedRateLeg1 + ", " +
				"fixedRateLeg2=" + this.fixedRateLeg2 + ", " +
				"postPricedSwapIndicator=" + this.postPricedSwapIndicator + ", " +
				"price=" + this.price + ", " +
				"priceCurrency=" + this.priceCurrency + ", " +
				"priceNotation=" + this.priceNotation + ", " +
				"priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", " +
				"spreadLeg1=" + this.spreadLeg1 + ", " +
				"spreadLeg2=" + this.spreadLeg2 + ", " +
				"spreadCurrencyLeg1=" + this.spreadCurrencyLeg1 + ", " +
				"spreadCurrencyLeg2=" + this.spreadCurrencyLeg2 + ", " +
				"spreadNotationLeg1=" + this.spreadNotationLeg1 + ", " +
				"spreadNotationLeg2=" + this.spreadNotationLeg2 + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"strikePriceCurrency=" + this.strikePriceCurrency + ", " +
				"strikePriceNotation=" + this.strikePriceNotation + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"firstExerciseDate=" + this.firstExerciseDate + ", " +
				"cDSIndexAttachmentPoint=" + this.cDSIndexAttachmentPoint + ", " +
				"cDSIndexDetachmentPoint=" + this.cDSIndexDetachmentPoint + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"embeddedOptionType=" + this.embeddedOptionType + ", " +
				"uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"settlementCurrencyLeg1=" + this.settlementCurrencyLeg1 + ", " +
				"settlementCurrencyLeg2=" + this.settlementCurrencyLeg2 + ", " +
				"settlementLocationLeg1=" + this.settlementLocationLeg1 + ", " +
				"settlementLocationLeg2=" + this.settlementLocationLeg2 + ", " +
				"allocationIndicator=" + this.allocationIndicator + ", " +
				"nonStandardizedTermIndicator=" + this.nonStandardizedTermIndicator + ", " +
				"blockTradeElectionIndicator=" + this.blockTradeElectionIndicator + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"platformIdentifier=" + this.platformIdentifier + ", " +
				"primeBrokerageTransactionIndicator=" + this.primeBrokerageTransactionIndicator + ", " +
				"priorUSI=" + this.priorUSI + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"jurisdiction=" + this.jurisdiction + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"cftcGuidebook=" + this.cftcGuidebook + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}

	/*********************** Builder Implementation of CFTCPart45TransactionReport  ***********************/
	class CFTCPart45TransactionReportBuilderImpl implements CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder {
	
		protected String cleared;
		protected String centralCounterparty;
		protected String clearingAccountOrigin;
		protected String clearingMember;
		protected List<ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder> clearingSwapUSIs = new ArrayList<>();
		protected List<ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder> clearingSwapUTIs = new ArrayList<>();
		protected String originalSwapUSI;
		protected String originalSwapUTI;
		protected String originalSwapSDRIdentifier;
		protected ZonedDateTime clearingReceiptTimestamp;
		protected List<ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder> clearingExceptionsAndExemptionsCounterparty1 = new ArrayList<>();
		protected List<ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder> clearingExceptionsAndExemptionsCounterparty2 = new ArrayList<>();
		protected String counterparty1;
		protected String counterparty2;
		protected String counterparty2IdentifierSource;
		protected Boolean counterparty1FinancialEntityIndicator;
		protected Boolean counterparty2FinancialEntityIndicator;
		protected String buyerIdentifier;
		protected String sellerIdentifier;
		protected String payerIdentifierLeg1;
		protected String payerIdentifierLeg2;
		protected String receiverIdentifierLeg1;
		protected String receiverIdentifierLeg2;
		protected String submitterIdentifier;
		protected Boolean counterparty1FederalEntityIndicator;
		protected Boolean counterparty2FederalEntityIndicator;
		protected Boolean customBasketIndicator;
		protected String actionType;
		protected String eventType;
		protected Boolean amendmentIndicator;
		protected String eventIdentifier;
		protected ZonedDateTime eventTimestamp;
		protected BigDecimal notionalAmountLeg1;
		protected BigDecimal notionalAmountLeg2;
		protected ISOCurrencyCodeEnum notionalCurrencyLeg1;
		protected ISOCurrencyCodeEnum notionalCurrencyLeg2;
		protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> notionalAmountScheduleLeg1 = new ArrayList<>();
		protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> notionalAmountScheduleLeg2 = new ArrayList<>();
		protected BigDecimal callAmount;
		protected ISOCurrencyCodeEnum callCurrency;
		protected BigDecimal putAmount;
		protected ISOCurrencyCodeEnum putCurrency;
		protected BigDecimal notionalQuantityLeg1;
		protected BigDecimal notionalQuantityLeg2;
		protected String quantityFrequencyLeg1;
		protected String quantityFrequencyLeg2;
		protected Integer quantityFrequencyMultiplierLeg1;
		protected Integer quantityFrequencyMultiplierLeg2;
		protected String quantityUnitOfMeasureLeg1;
		protected String quantityUnitOfMeasureLeg2;
		protected BigDecimal totalNotionalQuantityLeg1;
		protected BigDecimal totalNotionalQuantityLeg2;
		protected Boolean packageIndicator;
		protected String packageIdentifier;
		protected BigDecimal packageTransactionPrice;
		protected ISOCurrencyCodeEnum packageTransactionPriceCurrency;
		protected String packageTransactionPriceNotation;
		protected BigDecimal packageTransactionSpread;
		protected ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
		protected String packageTransactionSpreadNotation;
		protected InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
		protected InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
		protected InterestComputationMethod4Code floatingRateDayCountConventionLeg1;
		protected InterestComputationMethod4Code floatingRateDayCountConventionLeg2;
		protected Date fixingDateLeg1;
		protected Date fixingDateLeg2;
		protected String floatingRateResetFrequencyPeriodLeg1;
		protected String floatingRateResetFrequencyPeriodLeg2;
		protected Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
		protected Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
		protected List<OtherPaymentReport.OtherPaymentReportBuilder> otherPayment = new ArrayList<>();
		protected String fixedRatePaymentFrequencyPeriodLeg1;
		protected String fixedRatePaymentFrequencyPeriodLeg2;
		protected String floatingRatePaymentFrequencyPeriodLeg1;
		protected String floatingRatePaymentFrequencyPeriodLeg2;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierLeg1;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierLeg2;
		protected BigDecimal exchangeRateLeg1;
		protected String exchangeRateBasis;
		protected BigDecimal fixedRateLeg1;
		protected BigDecimal fixedRateLeg2;
		protected Boolean postPricedSwapIndicator;
		protected BigDecimal price;
		protected ISOCurrencyCodeEnum priceCurrency;
		protected String priceNotation;
		protected String priceUnitOfMeasure;
		protected BigDecimal spreadLeg1;
		protected BigDecimal spreadLeg2;
		protected ISOCurrencyCodeEnum spreadCurrencyLeg1;
		protected ISOCurrencyCodeEnum spreadCurrencyLeg2;
		protected String spreadNotationLeg1;
		protected String spreadNotationLeg2;
		protected BigDecimal strikePrice;
		protected String strikePriceCurrency;
		protected String strikePriceNotation;
		protected BigDecimal optionPremiumAmount;
		protected ISOCurrencyCodeEnum optionPremiumCurrency;
		protected Date optionPremiumPaymentDate;
		protected Date firstExerciseDate;
		protected BigDecimal cDSIndexAttachmentPoint;
		protected BigDecimal cDSIndexDetachmentPoint;
		protected BigDecimal indexFactor;
		protected String embeddedOptionType;
		protected String uniqueProductIdentifier;
		protected Date finalContractualSettlementDate;
		protected ISOCurrencyCodeEnum settlementCurrencyLeg1;
		protected ISOCurrencyCodeEnum settlementCurrencyLeg2;
		protected String settlementLocationLeg1;
		protected String settlementLocationLeg2;
		protected String allocationIndicator;
		protected Boolean nonStandardizedTermIndicator;
		protected Boolean blockTradeElectionIndicator;
		protected Date effectiveDate;
		protected Date expirationDate;
		protected ZonedDateTime executionTimestamp;
		protected ZonedDateTime reportingTimestamp;
		protected String platformIdentifier;
		protected Boolean primeBrokerageTransactionIndicator;
		protected String priorUSI;
		protected String priorUTI;
		protected String uniqueSwapIdentifier;
		protected String uniqueTransactionIdentifier;
		protected String jurisdiction;
		protected String newSDRIdentifier;
		protected String initialMarginCollateralPortfolioCode;
		protected String variationMarginCollateralPortfolioCode;
		protected CFTCGuidebookPart45.CFTCGuidebookPart45Builder cftcGuidebook;
		protected CFTCNonReportablePart45.CFTCNonReportablePart45Builder nonReportable;
		
		@Override
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public String getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUSIs")
		@RuneAttribute("clearingSwapUSIs")
		public List<? extends ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder> getClearingSwapUSIs() {
			return clearingSwapUSIs;
		}
		
		@Override
		public ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder getOrCreateClearingSwapUSIs(int index) {
			if (clearingSwapUSIs==null) {
				this.clearingSwapUSIs = new ArrayList<>();
			}
			return getIndex(clearingSwapUSIs, index, () -> {
						ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder newClearingSwapUSIs = ClearingSwapUSIsReport.builder();
						return newClearingSwapUSIs;
					});
		}
		
		@Override
		@RosettaAttribute("clearingSwapUTIs")
		@RuneAttribute("clearingSwapUTIs")
		public List<? extends ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder> getClearingSwapUTIs() {
			return clearingSwapUTIs;
		}
		
		@Override
		public ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder getOrCreateClearingSwapUTIs(int index) {
			if (clearingSwapUTIs==null) {
				this.clearingSwapUTIs = new ArrayList<>();
			}
			return getIndex(clearingSwapUTIs, index, () -> {
						ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder newClearingSwapUTIs = ClearingSwapUTIsReport.builder();
						return newClearingSwapUTIs;
					});
		}
		
		@Override
		@RosettaAttribute("originalSwapUSI")
		@RuneAttribute("originalSwapUSI")
		public String getOriginalSwapUSI() {
			return originalSwapUSI;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public String getOriginalSwapUTI() {
			return originalSwapUTI;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public String getOriginalSwapSDRIdentifier() {
			return originalSwapSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public List<? extends ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder> getClearingExceptionsAndExemptionsCounterparty1() {
			return clearingExceptionsAndExemptionsCounterparty1;
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder getOrCreateClearingExceptionsAndExemptionsCounterparty1(int index) {
			if (clearingExceptionsAndExemptionsCounterparty1==null) {
				this.clearingExceptionsAndExemptionsCounterparty1 = new ArrayList<>();
			}
			return getIndex(clearingExceptionsAndExemptionsCounterparty1, index, () -> {
						ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder newClearingExceptionsAndExemptionsCounterparty1 = ClearingExceptionsAndExemptionsCounterparty1Report.builder();
						return newClearingExceptionsAndExemptionsCounterparty1;
					});
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public List<? extends ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder> getClearingExceptionsAndExemptionsCounterparty2() {
			return clearingExceptionsAndExemptionsCounterparty2;
		}
		
		@Override
		public ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder getOrCreateClearingExceptionsAndExemptionsCounterparty2(int index) {
			if (clearingExceptionsAndExemptionsCounterparty2==null) {
				this.clearingExceptionsAndExemptionsCounterparty2 = new ArrayList<>();
			}
			return getIndex(clearingExceptionsAndExemptionsCounterparty2, index, () -> {
						ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder newClearingExceptionsAndExemptionsCounterparty2 = ClearingExceptionsAndExemptionsCounterparty2Report.builder();
						return newClearingExceptionsAndExemptionsCounterparty2;
					});
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
		public String getCounterparty2IdentifierSource() {
			return counterparty2IdentifierSource;
		}
		
		@Override
		@RosettaAttribute("counterparty1FinancialEntityIndicator")
		@RuneAttribute("counterparty1FinancialEntityIndicator")
		public Boolean getCounterparty1FinancialEntityIndicator() {
			return counterparty1FinancialEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
		public Boolean getCounterparty2FinancialEntityIndicator() {
			return counterparty2FinancialEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		public String getBuyerIdentifier() {
			return buyerIdentifier;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		public String getSellerIdentifier() {
			return sellerIdentifier;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1")
		@RuneAttribute("payerIdentifierLeg1")
		public String getPayerIdentifierLeg1() {
			return payerIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2")
		@RuneAttribute("payerIdentifierLeg2")
		public String getPayerIdentifierLeg2() {
			return payerIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1")
		@RuneAttribute("receiverIdentifierLeg1")
		public String getReceiverIdentifierLeg1() {
			return receiverIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2")
		@RuneAttribute("receiverIdentifierLeg2")
		public String getReceiverIdentifierLeg2() {
			return receiverIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1FederalEntityIndicator", isRequired=true)
		@RuneAttribute(value="counterparty1FederalEntityIndicator", isRequired=true)
		public Boolean getCounterparty1FederalEntityIndicator() {
			return counterparty1FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2FederalEntityIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2FederalEntityIndicator", isRequired=true)
		public Boolean getCounterparty2FederalEntityIndicator() {
			return counterparty2FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute(value="customBasketIndicator", isRequired=true)
		@RuneAttribute(value="customBasketIndicator", isRequired=true)
		public Boolean getCustomBasketIndicator() {
			return customBasketIndicator;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public Boolean getAmendmentIndicator() {
			return amendmentIndicator;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public String getEventIdentifier() {
			return eventIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		public ZonedDateTime getEventTimestamp() {
			return eventTimestamp;
		}
		
		@Override
		@RosettaAttribute("notionalAmountLeg1")
		@RuneAttribute("notionalAmountLeg1")
		public BigDecimal getNotionalAmountLeg1() {
			return notionalAmountLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalAmountLeg2")
		@RuneAttribute("notionalAmountLeg2")
		public BigDecimal getNotionalAmountLeg2() {
			return notionalAmountLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyLeg1")
		@RuneAttribute("notionalCurrencyLeg1")
		public ISOCurrencyCodeEnum getNotionalCurrencyLeg1() {
			return notionalCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyLeg2")
		@RuneAttribute("notionalCurrencyLeg2")
		public ISOCurrencyCodeEnum getNotionalCurrencyLeg2() {
			return notionalCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1() {
			return notionalAmountScheduleLeg1;
		}
		
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1(int index) {
			if (notionalAmountScheduleLeg1==null) {
				this.notionalAmountScheduleLeg1 = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg1, index, () -> {
						NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder newNotionalAmountScheduleLeg1 = NotionalAmountScheduleLeg1Report.builder();
						return newNotionalAmountScheduleLeg1;
					});
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2() {
			return notionalAmountScheduleLeg2;
		}
		
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2(int index) {
			if (notionalAmountScheduleLeg2==null) {
				this.notionalAmountScheduleLeg2 = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg2, index, () -> {
						NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder newNotionalAmountScheduleLeg2 = NotionalAmountScheduleLeg2Report.builder();
						return newNotionalAmountScheduleLeg2;
					});
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public BigDecimal getCallAmount() {
			return callAmount;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public ISOCurrencyCodeEnum getCallCurrency() {
			return callCurrency;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public BigDecimal getPutAmount() {
			return putAmount;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public ISOCurrencyCodeEnum getPutCurrency() {
			return putCurrency;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityLeg1")
		@RuneAttribute("notionalQuantityLeg1")
		public BigDecimal getNotionalQuantityLeg1() {
			return notionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityLeg2")
		@RuneAttribute("notionalQuantityLeg2")
		public BigDecimal getNotionalQuantityLeg2() {
			return notionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyLeg1")
		@RuneAttribute("quantityFrequencyLeg1")
		public String getQuantityFrequencyLeg1() {
			return quantityFrequencyLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyLeg2")
		@RuneAttribute("quantityFrequencyLeg2")
		public String getQuantityFrequencyLeg2() {
			return quantityFrequencyLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg1")
		@RuneAttribute("quantityFrequencyMultiplierLeg1")
		public Integer getQuantityFrequencyMultiplierLeg1() {
			return quantityFrequencyMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierLeg2")
		@RuneAttribute("quantityFrequencyMultiplierLeg2")
		public Integer getQuantityFrequencyMultiplierLeg2() {
			return quantityFrequencyMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public String getQuantityUnitOfMeasureLeg1() {
			return quantityUnitOfMeasureLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public String getQuantityUnitOfMeasureLeg2() {
			return quantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute(value="packageIndicator", isRequired=true)
		@RuneAttribute(value="packageIndicator", isRequired=true)
		public Boolean getPackageIndicator() {
			return packageIndicator;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public BigDecimal getPackageTransactionPrice() {
			return packageTransactionPrice;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
			return packageTransactionPriceCurrency;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public String getPackageTransactionPriceNotation() {
			return packageTransactionPriceNotation;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public BigDecimal getPackageTransactionSpread() {
			return packageTransactionSpread;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
			return packageTransactionSpreadCurrency;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public String getPackageTransactionSpreadNotation() {
			return packageTransactionSpreadNotation;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
			return fixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
			return fixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionLeg1")
		@RuneAttribute("floatingRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionLeg1() {
			return floatingRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionLeg2")
		@RuneAttribute("floatingRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionLeg2() {
			return floatingRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg1")
		@RuneAttribute("fixingDateLeg1")
		public Date getFixingDateLeg1() {
			return fixingDateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixingDateLeg2")
		@RuneAttribute("fixingDateLeg2")
		public Date getFixingDateLeg2() {
			return fixingDateLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodLeg1")
		public String getFloatingRateResetFrequencyPeriodLeg1() {
			return floatingRateResetFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodLeg2")
		public String getFloatingRateResetFrequencyPeriodLeg2() {
			return floatingRateResetFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index) {
			if (otherPayment==null) {
				this.otherPayment = new ArrayList<>();
			}
			return getIndex(otherPayment, index, () -> {
						OtherPaymentReport.OtherPaymentReportBuilder newOtherPayment = OtherPaymentReport.builder();
						return newOtherPayment;
					});
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		public String getFixedRatePaymentFrequencyPeriodLeg1() {
			return fixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		public String getFixedRatePaymentFrequencyPeriodLeg2() {
			return fixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		public String getFloatingRatePaymentFrequencyPeriodLeg1() {
			return floatingRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		public String getFloatingRatePaymentFrequencyPeriodLeg2() {
			return floatingRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("exchangeRateLeg1")
		@RuneAttribute("exchangeRateLeg1")
		public BigDecimal getExchangeRateLeg1() {
			return exchangeRateLeg1;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg1")
		@RuneAttribute("fixedRateLeg1")
		public BigDecimal getFixedRateLeg1() {
			return fixedRateLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateLeg2")
		@RuneAttribute("fixedRateLeg2")
		public BigDecimal getFixedRateLeg2() {
			return fixedRateLeg2;
		}
		
		@Override
		@RosettaAttribute(value="postPricedSwapIndicator", isRequired=true)
		@RuneAttribute(value="postPricedSwapIndicator", isRequired=true)
		public Boolean getPostPricedSwapIndicator() {
			return postPricedSwapIndicator;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public BigDecimal getPrice() {
			return price;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public ISOCurrencyCodeEnum getPriceCurrency() {
			return priceCurrency;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public String getPriceNotation() {
			return priceNotation;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public String getPriceUnitOfMeasure() {
			return priceUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("spreadLeg1")
		@RuneAttribute("spreadLeg1")
		public BigDecimal getSpreadLeg1() {
			return spreadLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadLeg2")
		@RuneAttribute("spreadLeg2")
		public BigDecimal getSpreadLeg2() {
			return spreadLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyLeg1")
		@RuneAttribute("spreadCurrencyLeg1")
		public ISOCurrencyCodeEnum getSpreadCurrencyLeg1() {
			return spreadCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadCurrencyLeg2")
		@RuneAttribute("spreadCurrencyLeg2")
		public ISOCurrencyCodeEnum getSpreadCurrencyLeg2() {
			return spreadCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadNotationLeg1")
		@RuneAttribute("spreadNotationLeg1")
		public String getSpreadNotationLeg1() {
			return spreadNotationLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadNotationLeg2")
		@RuneAttribute("spreadNotationLeg2")
		public String getSpreadNotationLeg2() {
			return spreadNotationLeg2;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public BigDecimal getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public String getStrikePriceCurrency() {
			return strikePriceCurrency;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public String getStrikePriceNotation() {
			return strikePriceNotation;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public Date getFirstExerciseDate() {
			return firstExerciseDate;
		}
		
		@Override
		@RosettaAttribute("cDSIndexAttachmentPoint")
		@RuneAttribute("cDSIndexAttachmentPoint")
		public BigDecimal getCDSIndexAttachmentPoint() {
			return cDSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cDSIndexDetachmentPoint")
		@RuneAttribute("cDSIndexDetachmentPoint")
		public BigDecimal getCDSIndexDetachmentPoint() {
			return cDSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public String getEmbeddedOptionType() {
			return embeddedOptionType;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public String getUniqueProductIdentifier() {
			return uniqueProductIdentifier;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg1")
		@RuneAttribute("settlementCurrencyLeg1")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg1() {
			return settlementCurrencyLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrencyLeg2")
		@RuneAttribute("settlementCurrencyLeg2")
		public ISOCurrencyCodeEnum getSettlementCurrencyLeg2() {
			return settlementCurrencyLeg2;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg1")
		@RuneAttribute("settlementLocationLeg1")
		public String getSettlementLocationLeg1() {
			return settlementLocationLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg2")
		@RuneAttribute("settlementLocationLeg2")
		public String getSettlementLocationLeg2() {
			return settlementLocationLeg2;
		}
		
		@Override
		@RosettaAttribute(value="allocationIndicator", isRequired=true)
		@RuneAttribute(value="allocationIndicator", isRequired=true)
		public String getAllocationIndicator() {
			return allocationIndicator;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public Boolean getNonStandardizedTermIndicator() {
			return nonStandardizedTermIndicator;
		}
		
		@Override
		@RosettaAttribute(value="blockTradeElectionIndicator", isRequired=true)
		@RuneAttribute(value="blockTradeElectionIndicator", isRequired=true)
		public Boolean getBlockTradeElectionIndicator() {
			return blockTradeElectionIndicator;
		}
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public String getPlatformIdentifier() {
			return platformIdentifier;
		}
		
		@Override
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		public Boolean getPrimeBrokerageTransactionIndicator() {
			return primeBrokerageTransactionIndicator;
		}
		
		@Override
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		public String getPriorUSI() {
			return priorUSI;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("uniqueSwapIdentifier")
		@RuneAttribute("uniqueSwapIdentifier")
		public String getUniqueSwapIdentifier() {
			return uniqueSwapIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute(value="jurisdiction", isRequired=true)
		@RuneAttribute(value="jurisdiction", isRequired=true)
		public String getJurisdiction() {
			return jurisdiction;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="cftcGuidebook", isRequired=true)
		@RuneAttribute(value="cftcGuidebook", isRequired=true)
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder getCftcGuidebook() {
			return cftcGuidebook;
		}
		
		@Override
		public CFTCGuidebookPart45.CFTCGuidebookPart45Builder getOrCreateCftcGuidebook() {
			CFTCGuidebookPart45.CFTCGuidebookPart45Builder result;
			if (cftcGuidebook!=null) {
				result = cftcGuidebook;
			}
			else {
				result = cftcGuidebook = CFTCGuidebookPart45.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder getOrCreateNonReportable() {
			CFTCNonReportablePart45.CFTCNonReportablePart45Builder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = CFTCNonReportablePart45.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCleared(String _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingAccountOrigin(String _clearingAccountOrigin) {
			this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
			return this;
		}
		
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@RosettaAttribute("clearingSwapUSIs")
		@RuneAttribute("clearingSwapUSIs")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(ClearingSwapUSIsReport _clearingSwapUSIs) {
			if (_clearingSwapUSIs != null) {
				this.clearingSwapUSIs.add(_clearingSwapUSIs.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(ClearingSwapUSIsReport _clearingSwapUSIs, int idx) {
			getIndex(this.clearingSwapUSIs, idx, () -> _clearingSwapUSIs.toBuilder());
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(List<? extends ClearingSwapUSIsReport> clearingSwapUSIss) {
			if (clearingSwapUSIss != null) {
				for (final ClearingSwapUSIsReport toAdd : clearingSwapUSIss) {
					this.clearingSwapUSIs.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("clearingSwapUSIs")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingSwapUSIs(List<? extends ClearingSwapUSIsReport> clearingSwapUSIss) {
			if (clearingSwapUSIss == null) {
				this.clearingSwapUSIs = new ArrayList<>();
			} else {
				this.clearingSwapUSIs = clearingSwapUSIss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("clearingSwapUTIs")
		@RuneAttribute("clearingSwapUTIs")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(ClearingSwapUTIsReport _clearingSwapUTIs) {
			if (_clearingSwapUTIs != null) {
				this.clearingSwapUTIs.add(_clearingSwapUTIs.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(ClearingSwapUTIsReport _clearingSwapUTIs, int idx) {
			getIndex(this.clearingSwapUTIs, idx, () -> _clearingSwapUTIs.toBuilder());
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(List<? extends ClearingSwapUTIsReport> clearingSwapUTIss) {
			if (clearingSwapUTIss != null) {
				for (final ClearingSwapUTIsReport toAdd : clearingSwapUTIss) {
					this.clearingSwapUTIs.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("clearingSwapUTIs")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingSwapUTIs(List<? extends ClearingSwapUTIsReport> clearingSwapUTIss) {
			if (clearingSwapUTIss == null) {
				this.clearingSwapUTIs = new ArrayList<>();
			} else {
				this.clearingSwapUTIs = clearingSwapUTIss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("originalSwapUSI")
		@RuneAttribute("originalSwapUSI")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapUSI(String _originalSwapUSI) {
			this.originalSwapUSI = _originalSwapUSI == null ? null : _originalSwapUSI;
			return this;
		}
		
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
			this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
			return this;
		}
		
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
			this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
			return this;
		}
		
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
			this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
			return this;
		}
		
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsCounterparty1Report _clearingExceptionsAndExemptionsCounterparty1) {
			if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
				this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsCounterparty1Report _clearingExceptionsAndExemptionsCounterparty1, int idx) {
			getIndex(this.clearingExceptionsAndExemptionsCounterparty1, idx, () -> _clearingExceptionsAndExemptionsCounterparty1.toBuilder());
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<? extends ClearingExceptionsAndExemptionsCounterparty1Report> clearingExceptionsAndExemptionsCounterparty1s) {
			if (clearingExceptionsAndExemptionsCounterparty1s != null) {
				for (final ClearingExceptionsAndExemptionsCounterparty1Report toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
					this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<? extends ClearingExceptionsAndExemptionsCounterparty1Report> clearingExceptionsAndExemptionsCounterparty1s) {
			if (clearingExceptionsAndExemptionsCounterparty1s == null) {
				this.clearingExceptionsAndExemptionsCounterparty1 = new ArrayList<>();
			} else {
				this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsCounterparty2Report _clearingExceptionsAndExemptionsCounterparty2) {
			if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
				this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsCounterparty2Report _clearingExceptionsAndExemptionsCounterparty2, int idx) {
			getIndex(this.clearingExceptionsAndExemptionsCounterparty2, idx, () -> _clearingExceptionsAndExemptionsCounterparty2.toBuilder());
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<? extends ClearingExceptionsAndExemptionsCounterparty2Report> clearingExceptionsAndExemptionsCounterparty2s) {
			if (clearingExceptionsAndExemptionsCounterparty2s != null) {
				for (final ClearingExceptionsAndExemptionsCounterparty2Report toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
					this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<? extends ClearingExceptionsAndExemptionsCounterparty2Report> clearingExceptionsAndExemptionsCounterparty2s) {
			if (clearingExceptionsAndExemptionsCounterparty2s == null) {
				this.clearingExceptionsAndExemptionsCounterparty2 = new ArrayList<>();
			} else {
				this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
			this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
			return this;
		}
		
		@RosettaAttribute("counterparty1FinancialEntityIndicator")
		@RuneAttribute("counterparty1FinancialEntityIndicator")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1FinancialEntityIndicator(Boolean _counterparty1FinancialEntityIndicator) {
			this.counterparty1FinancialEntityIndicator = _counterparty1FinancialEntityIndicator == null ? null : _counterparty1FinancialEntityIndicator;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2FinancialEntityIndicator", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2FinancialEntityIndicator(Boolean _counterparty2FinancialEntityIndicator) {
			this.counterparty2FinancialEntityIndicator = _counterparty2FinancialEntityIndicator == null ? null : _counterparty2FinancialEntityIndicator;
			return this;
		}
		
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
			this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
			return this;
		}
		
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
			this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
			return this;
		}
		
		@RosettaAttribute("payerIdentifierLeg1")
		@RuneAttribute("payerIdentifierLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPayerIdentifierLeg1(String _payerIdentifierLeg1) {
			this.payerIdentifierLeg1 = _payerIdentifierLeg1 == null ? null : _payerIdentifierLeg1;
			return this;
		}
		
		@RosettaAttribute("payerIdentifierLeg2")
		@RuneAttribute("payerIdentifierLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPayerIdentifierLeg2(String _payerIdentifierLeg2) {
			this.payerIdentifierLeg2 = _payerIdentifierLeg2 == null ? null : _payerIdentifierLeg2;
			return this;
		}
		
		@RosettaAttribute("receiverIdentifierLeg1")
		@RuneAttribute("receiverIdentifierLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReceiverIdentifierLeg1(String _receiverIdentifierLeg1) {
			this.receiverIdentifierLeg1 = _receiverIdentifierLeg1 == null ? null : _receiverIdentifierLeg1;
			return this;
		}
		
		@RosettaAttribute("receiverIdentifierLeg2")
		@RuneAttribute("receiverIdentifierLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReceiverIdentifierLeg2(String _receiverIdentifierLeg2) {
			this.receiverIdentifierLeg2 = _receiverIdentifierLeg2 == null ? null : _receiverIdentifierLeg2;
			return this;
		}
		
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
			this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1FederalEntityIndicator", isRequired=true)
		@RuneAttribute(value="counterparty1FederalEntityIndicator", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1FederalEntityIndicator(Boolean _counterparty1FederalEntityIndicator) {
			this.counterparty1FederalEntityIndicator = _counterparty1FederalEntityIndicator == null ? null : _counterparty1FederalEntityIndicator;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2FederalEntityIndicator", isRequired=true)
		@RuneAttribute(value="counterparty2FederalEntityIndicator", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2FederalEntityIndicator(Boolean _counterparty2FederalEntityIndicator) {
			this.counterparty2FederalEntityIndicator = _counterparty2FederalEntityIndicator == null ? null : _counterparty2FederalEntityIndicator;
			return this;
		}
		
		@RosettaAttribute(value="customBasketIndicator", isRequired=true)
		@RuneAttribute(value="customBasketIndicator", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
			this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setActionType(String _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventType(String _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
			this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
			return this;
		}
		
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@RosettaAttribute(value="eventTimestamp", isRequired=true)
		@RuneAttribute(value="eventTimestamp", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@RosettaAttribute("notionalAmountLeg1")
		@RuneAttribute("notionalAmountLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalAmountLeg1(BigDecimal _notionalAmountLeg1) {
			this.notionalAmountLeg1 = _notionalAmountLeg1 == null ? null : _notionalAmountLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalAmountLeg2")
		@RuneAttribute("notionalAmountLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalAmountLeg2(BigDecimal _notionalAmountLeg2) {
			this.notionalAmountLeg2 = _notionalAmountLeg2 == null ? null : _notionalAmountLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalCurrencyLeg1")
		@RuneAttribute("notionalCurrencyLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalCurrencyLeg1(ISOCurrencyCodeEnum _notionalCurrencyLeg1) {
			this.notionalCurrencyLeg1 = _notionalCurrencyLeg1 == null ? null : _notionalCurrencyLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalCurrencyLeg2")
		@RuneAttribute("notionalCurrencyLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalCurrencyLeg2(ISOCurrencyCodeEnum _notionalCurrencyLeg2) {
			this.notionalCurrencyLeg2 = _notionalCurrencyLeg2 == null ? null : _notionalCurrencyLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg1")
		@RuneAttribute("notionalAmountScheduleLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1) {
			if (_notionalAmountScheduleLeg1 != null) {
				this.notionalAmountScheduleLeg1.add(_notionalAmountScheduleLeg1.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg1(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1, int idx) {
			getIndex(this.notionalAmountScheduleLeg1, idx, () -> _notionalAmountScheduleLeg1.toBuilder());
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
			if (notionalAmountScheduleLeg1s != null) {
				for (final NotionalAmountScheduleLeg1Report toAdd : notionalAmountScheduleLeg1s) {
					this.notionalAmountScheduleLeg1.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalAmountScheduleLeg1(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1s) {
			if (notionalAmountScheduleLeg1s == null) {
				this.notionalAmountScheduleLeg1 = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg2")
		@RuneAttribute("notionalAmountScheduleLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2) {
			if (_notionalAmountScheduleLeg2 != null) {
				this.notionalAmountScheduleLeg2.add(_notionalAmountScheduleLeg2.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg2(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2, int idx) {
			getIndex(this.notionalAmountScheduleLeg2, idx, () -> _notionalAmountScheduleLeg2.toBuilder());
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
			if (notionalAmountScheduleLeg2s != null) {
				for (final NotionalAmountScheduleLeg2Report toAdd : notionalAmountScheduleLeg2s) {
					this.notionalAmountScheduleLeg2.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalAmountScheduleLeg2(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2s) {
			if (notionalAmountScheduleLeg2s == null) {
				this.notionalAmountScheduleLeg2 = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2s.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@RosettaAttribute("notionalQuantityLeg1")
		@RuneAttribute("notionalQuantityLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalQuantityLeg1(BigDecimal _notionalQuantityLeg1) {
			this.notionalQuantityLeg1 = _notionalQuantityLeg1 == null ? null : _notionalQuantityLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalQuantityLeg2")
		@RuneAttribute("notionalQuantityLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNotionalQuantityLeg2(BigDecimal _notionalQuantityLeg2) {
			this.notionalQuantityLeg2 = _notionalQuantityLeg2 == null ? null : _notionalQuantityLeg2;
			return this;
		}
		
		@RosettaAttribute("quantityFrequencyLeg1")
		@RuneAttribute("quantityFrequencyLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityFrequencyLeg1(String _quantityFrequencyLeg1) {
			this.quantityFrequencyLeg1 = _quantityFrequencyLeg1 == null ? null : _quantityFrequencyLeg1;
			return this;
		}
		
		@RosettaAttribute("quantityFrequencyLeg2")
		@RuneAttribute("quantityFrequencyLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityFrequencyLeg2(String _quantityFrequencyLeg2) {
			this.quantityFrequencyLeg2 = _quantityFrequencyLeg2 == null ? null : _quantityFrequencyLeg2;
			return this;
		}
		
		@RosettaAttribute("quantityFrequencyMultiplierLeg1")
		@RuneAttribute("quantityFrequencyMultiplierLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityFrequencyMultiplierLeg1(Integer _quantityFrequencyMultiplierLeg1) {
			this.quantityFrequencyMultiplierLeg1 = _quantityFrequencyMultiplierLeg1 == null ? null : _quantityFrequencyMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("quantityFrequencyMultiplierLeg2")
		@RuneAttribute("quantityFrequencyMultiplierLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityFrequencyMultiplierLeg2(Integer _quantityFrequencyMultiplierLeg2) {
			this.quantityFrequencyMultiplierLeg2 = _quantityFrequencyMultiplierLeg2 == null ? null : _quantityFrequencyMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal _totalNotionalQuantityLeg1) {
			this.totalNotionalQuantityLeg1 = _totalNotionalQuantityLeg1 == null ? null : _totalNotionalQuantityLeg1;
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal _totalNotionalQuantityLeg2) {
			this.totalNotionalQuantityLeg2 = _totalNotionalQuantityLeg2 == null ? null : _totalNotionalQuantityLeg2;
			return this;
		}
		
		@RosettaAttribute(value="packageIndicator", isRequired=true)
		@RuneAttribute(value="packageIndicator", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
			this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
			return this;
		}
		
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPrice(BigDecimal _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPriceNotation(String _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpread(BigDecimal _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpreadNotation(String _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code _fixedRateDayCountConventionLeg1) {
			this.fixedRateDayCountConventionLeg1 = _fixedRateDayCountConventionLeg1 == null ? null : _fixedRateDayCountConventionLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code _fixedRateDayCountConventionLeg2) {
			this.fixedRateDayCountConventionLeg2 = _fixedRateDayCountConventionLeg2 == null ? null : _fixedRateDayCountConventionLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionLeg1")
		@RuneAttribute("floatingRateDayCountConventionLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateDayCountConventionLeg1(InterestComputationMethod4Code _floatingRateDayCountConventionLeg1) {
			this.floatingRateDayCountConventionLeg1 = _floatingRateDayCountConventionLeg1 == null ? null : _floatingRateDayCountConventionLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionLeg2")
		@RuneAttribute("floatingRateDayCountConventionLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateDayCountConventionLeg2(InterestComputationMethod4Code _floatingRateDayCountConventionLeg2) {
			this.floatingRateDayCountConventionLeg2 = _floatingRateDayCountConventionLeg2 == null ? null : _floatingRateDayCountConventionLeg2;
			return this;
		}
		
		@RosettaAttribute("fixingDateLeg1")
		@RuneAttribute("fixingDateLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixingDateLeg1(Date _fixingDateLeg1) {
			this.fixingDateLeg1 = _fixingDateLeg1 == null ? null : _fixingDateLeg1;
			return this;
		}
		
		@RosettaAttribute("fixingDateLeg2")
		@RuneAttribute("fixingDateLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixingDateLeg2(Date _fixingDateLeg2) {
			this.fixingDateLeg2 = _fixingDateLeg2 == null ? null : _fixingDateLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateResetFrequencyPeriodLeg1(String _floatingRateResetFrequencyPeriodLeg1) {
			this.floatingRateResetFrequencyPeriodLeg1 = _floatingRateResetFrequencyPeriodLeg1 == null ? null : _floatingRateResetFrequencyPeriodLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateResetFrequencyPeriodLeg2(String _floatingRateResetFrequencyPeriodLeg2) {
			this.floatingRateResetFrequencyPeriodLeg2 = _floatingRateResetFrequencyPeriodLeg2 == null ? null : _floatingRateResetFrequencyPeriodLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer _floatingRateResetFrequencyPeriodMultiplierLeg1) {
			this.floatingRateResetFrequencyPeriodMultiplierLeg1 = _floatingRateResetFrequencyPeriodMultiplierLeg1 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer _floatingRateResetFrequencyPeriodMultiplierLeg2) {
			this.floatingRateResetFrequencyPeriodMultiplierLeg2 = _floatingRateResetFrequencyPeriodMultiplierLeg2 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment, int idx) {
			getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPaymentReport toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("otherPayment")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String _fixedRatePaymentFrequencyPeriodLeg1) {
			this.fixedRatePaymentFrequencyPeriodLeg1 = _fixedRatePaymentFrequencyPeriodLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String _fixedRatePaymentFrequencyPeriodLeg2) {
			this.fixedRatePaymentFrequencyPeriodLeg2 = _fixedRatePaymentFrequencyPeriodLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg1(String _floatingRatePaymentFrequencyPeriodLeg1) {
			this.floatingRatePaymentFrequencyPeriodLeg1 = _floatingRatePaymentFrequencyPeriodLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRatePaymentFrequencyPeriodLeg2(String _floatingRatePaymentFrequencyPeriodLeg2) {
			this.floatingRatePaymentFrequencyPeriodLeg2 = _floatingRatePaymentFrequencyPeriodLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg1) {
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = _fixedRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg2) {
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = _fixedRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg1(Integer _floatingRatePaymentFrequencyPeriodMultiplierLeg1) {
			this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 = _floatingRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierLeg2(Integer _floatingRatePaymentFrequencyPeriodMultiplierLeg2) {
			this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 = _floatingRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("exchangeRateLeg1")
		@RuneAttribute("exchangeRateLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExchangeRateLeg1(BigDecimal _exchangeRateLeg1) {
			this.exchangeRateLeg1 = _exchangeRateLeg1 == null ? null : _exchangeRateLeg1;
			return this;
		}
		
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@RosettaAttribute("fixedRateLeg1")
		@RuneAttribute("fixedRateLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRateLeg1(BigDecimal _fixedRateLeg1) {
			this.fixedRateLeg1 = _fixedRateLeg1 == null ? null : _fixedRateLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRateLeg2")
		@RuneAttribute("fixedRateLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFixedRateLeg2(BigDecimal _fixedRateLeg2) {
			this.fixedRateLeg2 = _fixedRateLeg2 == null ? null : _fixedRateLeg2;
			return this;
		}
		
		@RosettaAttribute(value="postPricedSwapIndicator", isRequired=true)
		@RuneAttribute(value="postPricedSwapIndicator", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPostPricedSwapIndicator(Boolean _postPricedSwapIndicator) {
			this.postPricedSwapIndicator = _postPricedSwapIndicator == null ? null : _postPricedSwapIndicator;
			return this;
		}
		
		@RosettaAttribute("price")
		@RuneAttribute("price")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPrice(BigDecimal _price) {
			this.price = _price == null ? null : _price;
			return this;
		}
		
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceNotation(String _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@RosettaAttribute("spreadLeg1")
		@RuneAttribute("spreadLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadLeg1(BigDecimal _spreadLeg1) {
			this.spreadLeg1 = _spreadLeg1 == null ? null : _spreadLeg1;
			return this;
		}
		
		@RosettaAttribute("spreadLeg2")
		@RuneAttribute("spreadLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadLeg2(BigDecimal _spreadLeg2) {
			this.spreadLeg2 = _spreadLeg2 == null ? null : _spreadLeg2;
			return this;
		}
		
		@RosettaAttribute("spreadCurrencyLeg1")
		@RuneAttribute("spreadCurrencyLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadCurrencyLeg1(ISOCurrencyCodeEnum _spreadCurrencyLeg1) {
			this.spreadCurrencyLeg1 = _spreadCurrencyLeg1 == null ? null : _spreadCurrencyLeg1;
			return this;
		}
		
		@RosettaAttribute("spreadCurrencyLeg2")
		@RuneAttribute("spreadCurrencyLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadCurrencyLeg2(ISOCurrencyCodeEnum _spreadCurrencyLeg2) {
			this.spreadCurrencyLeg2 = _spreadCurrencyLeg2 == null ? null : _spreadCurrencyLeg2;
			return this;
		}
		
		@RosettaAttribute("spreadNotationLeg1")
		@RuneAttribute("spreadNotationLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadNotationLeg1(String _spreadNotationLeg1) {
			this.spreadNotationLeg1 = _spreadNotationLeg1 == null ? null : _spreadNotationLeg1;
			return this;
		}
		
		@RosettaAttribute("spreadNotationLeg2")
		@RuneAttribute("spreadNotationLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSpreadNotationLeg2(String _spreadNotationLeg2) {
			this.spreadNotationLeg2 = _spreadNotationLeg2 == null ? null : _spreadNotationLeg2;
			return this;
		}
		
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePrice(BigDecimal _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice;
			return this;
		}
		
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceNotation(String _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@RosettaAttribute("cDSIndexAttachmentPoint")
		@RuneAttribute("cDSIndexAttachmentPoint")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCDSIndexAttachmentPoint(BigDecimal _cDSIndexAttachmentPoint) {
			this.cDSIndexAttachmentPoint = _cDSIndexAttachmentPoint == null ? null : _cDSIndexAttachmentPoint;
			return this;
		}
		
		@RosettaAttribute("cDSIndexDetachmentPoint")
		@RuneAttribute("cDSIndexDetachmentPoint")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCDSIndexDetachmentPoint(BigDecimal _cDSIndexDetachmentPoint) {
			this.cDSIndexDetachmentPoint = _cDSIndexDetachmentPoint == null ? null : _cDSIndexDetachmentPoint;
			return this;
		}
		
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEmbeddedOptionType(String _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@RosettaAttribute("settlementCurrencyLeg1")
		@RuneAttribute("settlementCurrencyLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementCurrencyLeg1(ISOCurrencyCodeEnum _settlementCurrencyLeg1) {
			this.settlementCurrencyLeg1 = _settlementCurrencyLeg1 == null ? null : _settlementCurrencyLeg1;
			return this;
		}
		
		@RosettaAttribute("settlementCurrencyLeg2")
		@RuneAttribute("settlementCurrencyLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementCurrencyLeg2(ISOCurrencyCodeEnum _settlementCurrencyLeg2) {
			this.settlementCurrencyLeg2 = _settlementCurrencyLeg2 == null ? null : _settlementCurrencyLeg2;
			return this;
		}
		
		@RosettaAttribute("settlementLocationLeg1")
		@RuneAttribute("settlementLocationLeg1")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementLocationLeg1(String _settlementLocationLeg1) {
			this.settlementLocationLeg1 = _settlementLocationLeg1 == null ? null : _settlementLocationLeg1;
			return this;
		}
		
		@RosettaAttribute("settlementLocationLeg2")
		@RuneAttribute("settlementLocationLeg2")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementLocationLeg2(String _settlementLocationLeg2) {
			this.settlementLocationLeg2 = _settlementLocationLeg2 == null ? null : _settlementLocationLeg2;
			return this;
		}
		
		@RosettaAttribute(value="allocationIndicator", isRequired=true)
		@RuneAttribute(value="allocationIndicator", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAllocationIndicator(String _allocationIndicator) {
			this.allocationIndicator = _allocationIndicator == null ? null : _allocationIndicator;
			return this;
		}
		
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
			this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
			return this;
		}
		
		@RosettaAttribute(value="blockTradeElectionIndicator", isRequired=true)
		@RuneAttribute(value="blockTradeElectionIndicator", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBlockTradeElectionIndicator(Boolean _blockTradeElectionIndicator) {
			this.blockTradeElectionIndicator = _blockTradeElectionIndicator == null ? null : _blockTradeElectionIndicator;
			return this;
		}
		
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPrimeBrokerageTransactionIndicator(Boolean _primeBrokerageTransactionIndicator) {
			this.primeBrokerageTransactionIndicator = _primeBrokerageTransactionIndicator == null ? null : _primeBrokerageTransactionIndicator;
			return this;
		}
		
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUSI(String _priorUSI) {
			this.priorUSI = _priorUSI == null ? null : _priorUSI;
			return this;
		}
		
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@RosettaAttribute("uniqueSwapIdentifier")
		@RuneAttribute("uniqueSwapIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueSwapIdentifier(String _uniqueSwapIdentifier) {
			this.uniqueSwapIdentifier = _uniqueSwapIdentifier == null ? null : _uniqueSwapIdentifier;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute(value="jurisdiction", isRequired=true)
		@RuneAttribute(value="jurisdiction", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setJurisdiction(String _jurisdiction) {
			this.jurisdiction = _jurisdiction == null ? null : _jurisdiction;
			return this;
		}
		
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
			this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute(value="cftcGuidebook", isRequired=true)
		@RuneAttribute(value="cftcGuidebook", isRequired=true)
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCftcGuidebook(CFTCGuidebookPart45 _cftcGuidebook) {
			this.cftcGuidebook = _cftcGuidebook == null ? null : _cftcGuidebook.toBuilder();
			return this;
		}
		
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNonReportable(CFTCNonReportablePart45 _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport build() {
			return new CFTCPart45TransactionReport.CFTCPart45TransactionReportImpl(this);
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder prune() {
			clearingSwapUSIs = clearingSwapUSIs.stream().filter(b->b!=null).<ClearingSwapUSIsReport.ClearingSwapUSIsReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			clearingSwapUTIs = clearingSwapUTIs.stream().filter(b->b!=null).<ClearingSwapUTIsReport.ClearingSwapUTIsReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1.stream().filter(b->b!=null).<ClearingExceptionsAndExemptionsCounterparty1Report.ClearingExceptionsAndExemptionsCounterparty1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2.stream().filter(b->b!=null).<ClearingExceptionsAndExemptionsCounterparty2Report.ClearingExceptionsAndExemptionsCounterparty2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalAmountScheduleLeg1 = notionalAmountScheduleLeg1.stream().filter(b->b!=null).<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalAmountScheduleLeg2 = notionalAmountScheduleLeg2.stream().filter(b->b!=null).<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			otherPayment = otherPayment.stream().filter(b->b!=null).<OtherPaymentReport.OtherPaymentReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (cftcGuidebook!=null && !cftcGuidebook.prune().hasData()) cftcGuidebook = null;
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCleared()!=null) return true;
			if (getCentralCounterparty()!=null) return true;
			if (getClearingAccountOrigin()!=null) return true;
			if (getClearingMember()!=null) return true;
			if (getClearingSwapUSIs()!=null && getClearingSwapUSIs().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getClearingSwapUTIs()!=null && getClearingSwapUTIs().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getOriginalSwapUSI()!=null) return true;
			if (getOriginalSwapUTI()!=null) return true;
			if (getOriginalSwapSDRIdentifier()!=null) return true;
			if (getClearingReceiptTimestamp()!=null) return true;
			if (getClearingExceptionsAndExemptionsCounterparty1()!=null && getClearingExceptionsAndExemptionsCounterparty1().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getClearingExceptionsAndExemptionsCounterparty2()!=null && getClearingExceptionsAndExemptionsCounterparty2().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2IdentifierSource()!=null) return true;
			if (getCounterparty1FinancialEntityIndicator()!=null) return true;
			if (getCounterparty2FinancialEntityIndicator()!=null) return true;
			if (getBuyerIdentifier()!=null) return true;
			if (getSellerIdentifier()!=null) return true;
			if (getPayerIdentifierLeg1()!=null) return true;
			if (getPayerIdentifierLeg2()!=null) return true;
			if (getReceiverIdentifierLeg1()!=null) return true;
			if (getReceiverIdentifierLeg2()!=null) return true;
			if (getSubmitterIdentifier()!=null) return true;
			if (getCounterparty1FederalEntityIndicator()!=null) return true;
			if (getCounterparty2FederalEntityIndicator()!=null) return true;
			if (getCustomBasketIndicator()!=null) return true;
			if (getActionType()!=null) return true;
			if (getEventType()!=null) return true;
			if (getAmendmentIndicator()!=null) return true;
			if (getEventIdentifier()!=null) return true;
			if (getEventTimestamp()!=null) return true;
			if (getNotionalAmountLeg1()!=null) return true;
			if (getNotionalAmountLeg2()!=null) return true;
			if (getNotionalCurrencyLeg1()!=null) return true;
			if (getNotionalCurrencyLeg2()!=null) return true;
			if (getNotionalAmountScheduleLeg1()!=null && getNotionalAmountScheduleLeg1().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getNotionalAmountScheduleLeg2()!=null && getNotionalAmountScheduleLeg2().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getCallAmount()!=null) return true;
			if (getCallCurrency()!=null) return true;
			if (getPutAmount()!=null) return true;
			if (getPutCurrency()!=null) return true;
			if (getNotionalQuantityLeg1()!=null) return true;
			if (getNotionalQuantityLeg2()!=null) return true;
			if (getQuantityFrequencyLeg1()!=null) return true;
			if (getQuantityFrequencyLeg2()!=null) return true;
			if (getQuantityFrequencyMultiplierLeg1()!=null) return true;
			if (getQuantityFrequencyMultiplierLeg2()!=null) return true;
			if (getQuantityUnitOfMeasureLeg1()!=null) return true;
			if (getQuantityUnitOfMeasureLeg2()!=null) return true;
			if (getTotalNotionalQuantityLeg1()!=null) return true;
			if (getTotalNotionalQuantityLeg2()!=null) return true;
			if (getPackageIndicator()!=null) return true;
			if (getPackageIdentifier()!=null) return true;
			if (getPackageTransactionPrice()!=null) return true;
			if (getPackageTransactionPriceCurrency()!=null) return true;
			if (getPackageTransactionPriceNotation()!=null) return true;
			if (getPackageTransactionSpread()!=null) return true;
			if (getPackageTransactionSpreadCurrency()!=null) return true;
			if (getPackageTransactionSpreadNotation()!=null) return true;
			if (getFixedRateDayCountConventionLeg1()!=null) return true;
			if (getFixedRateDayCountConventionLeg2()!=null) return true;
			if (getFloatingRateDayCountConventionLeg1()!=null) return true;
			if (getFloatingRateDayCountConventionLeg2()!=null) return true;
			if (getFixingDateLeg1()!=null) return true;
			if (getFixingDateLeg2()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodLeg1()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodLeg2()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getOtherPayment()!=null && getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getFixedRatePaymentFrequencyPeriodLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodLeg2()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getExchangeRateLeg1()!=null) return true;
			if (getExchangeRateBasis()!=null) return true;
			if (getFixedRateLeg1()!=null) return true;
			if (getFixedRateLeg2()!=null) return true;
			if (getPostPricedSwapIndicator()!=null) return true;
			if (getPrice()!=null) return true;
			if (getPriceCurrency()!=null) return true;
			if (getPriceNotation()!=null) return true;
			if (getPriceUnitOfMeasure()!=null) return true;
			if (getSpreadLeg1()!=null) return true;
			if (getSpreadLeg2()!=null) return true;
			if (getSpreadCurrencyLeg1()!=null) return true;
			if (getSpreadCurrencyLeg2()!=null) return true;
			if (getSpreadNotationLeg1()!=null) return true;
			if (getSpreadNotationLeg2()!=null) return true;
			if (getStrikePrice()!=null) return true;
			if (getStrikePriceCurrency()!=null) return true;
			if (getStrikePriceNotation()!=null) return true;
			if (getOptionPremiumAmount()!=null) return true;
			if (getOptionPremiumCurrency()!=null) return true;
			if (getOptionPremiumPaymentDate()!=null) return true;
			if (getFirstExerciseDate()!=null) return true;
			if (getCDSIndexAttachmentPoint()!=null) return true;
			if (getCDSIndexDetachmentPoint()!=null) return true;
			if (getIndexFactor()!=null) return true;
			if (getEmbeddedOptionType()!=null) return true;
			if (getUniqueProductIdentifier()!=null) return true;
			if (getFinalContractualSettlementDate()!=null) return true;
			if (getSettlementCurrencyLeg1()!=null) return true;
			if (getSettlementCurrencyLeg2()!=null) return true;
			if (getSettlementLocationLeg1()!=null) return true;
			if (getSettlementLocationLeg2()!=null) return true;
			if (getAllocationIndicator()!=null) return true;
			if (getNonStandardizedTermIndicator()!=null) return true;
			if (getBlockTradeElectionIndicator()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			if (getExpirationDate()!=null) return true;
			if (getExecutionTimestamp()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getPlatformIdentifier()!=null) return true;
			if (getPrimeBrokerageTransactionIndicator()!=null) return true;
			if (getPriorUSI()!=null) return true;
			if (getPriorUTI()!=null) return true;
			if (getUniqueSwapIdentifier()!=null) return true;
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getJurisdiction()!=null) return true;
			if (getNewSDRIdentifier()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getCftcGuidebook()!=null && getCftcGuidebook().hasData()) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder o = (CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder) other;
			
			merger.mergeRosetta(getClearingSwapUSIs(), o.getClearingSwapUSIs(), this::getOrCreateClearingSwapUSIs);
			merger.mergeRosetta(getClearingSwapUTIs(), o.getClearingSwapUTIs(), this::getOrCreateClearingSwapUTIs);
			merger.mergeRosetta(getClearingExceptionsAndExemptionsCounterparty1(), o.getClearingExceptionsAndExemptionsCounterparty1(), this::getOrCreateClearingExceptionsAndExemptionsCounterparty1);
			merger.mergeRosetta(getClearingExceptionsAndExemptionsCounterparty2(), o.getClearingExceptionsAndExemptionsCounterparty2(), this::getOrCreateClearingExceptionsAndExemptionsCounterparty2);
			merger.mergeRosetta(getNotionalAmountScheduleLeg1(), o.getNotionalAmountScheduleLeg1(), this::getOrCreateNotionalAmountScheduleLeg1);
			merger.mergeRosetta(getNotionalAmountScheduleLeg2(), o.getNotionalAmountScheduleLeg2(), this::getOrCreateNotionalAmountScheduleLeg2);
			merger.mergeRosetta(getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
			merger.mergeRosetta(getCftcGuidebook(), o.getCftcGuidebook(), this::setCftcGuidebook);
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			
			merger.mergeBasic(getCleared(), o.getCleared(), this::setCleared);
			merger.mergeBasic(getCentralCounterparty(), o.getCentralCounterparty(), this::setCentralCounterparty);
			merger.mergeBasic(getClearingAccountOrigin(), o.getClearingAccountOrigin(), this::setClearingAccountOrigin);
			merger.mergeBasic(getClearingMember(), o.getClearingMember(), this::setClearingMember);
			merger.mergeBasic(getOriginalSwapUSI(), o.getOriginalSwapUSI(), this::setOriginalSwapUSI);
			merger.mergeBasic(getOriginalSwapUTI(), o.getOriginalSwapUTI(), this::setOriginalSwapUTI);
			merger.mergeBasic(getOriginalSwapSDRIdentifier(), o.getOriginalSwapSDRIdentifier(), this::setOriginalSwapSDRIdentifier);
			merger.mergeBasic(getClearingReceiptTimestamp(), o.getClearingReceiptTimestamp(), this::setClearingReceiptTimestamp);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierSource(), o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSource);
			merger.mergeBasic(getCounterparty1FinancialEntityIndicator(), o.getCounterparty1FinancialEntityIndicator(), this::setCounterparty1FinancialEntityIndicator);
			merger.mergeBasic(getCounterparty2FinancialEntityIndicator(), o.getCounterparty2FinancialEntityIndicator(), this::setCounterparty2FinancialEntityIndicator);
			merger.mergeBasic(getBuyerIdentifier(), o.getBuyerIdentifier(), this::setBuyerIdentifier);
			merger.mergeBasic(getSellerIdentifier(), o.getSellerIdentifier(), this::setSellerIdentifier);
			merger.mergeBasic(getPayerIdentifierLeg1(), o.getPayerIdentifierLeg1(), this::setPayerIdentifierLeg1);
			merger.mergeBasic(getPayerIdentifierLeg2(), o.getPayerIdentifierLeg2(), this::setPayerIdentifierLeg2);
			merger.mergeBasic(getReceiverIdentifierLeg1(), o.getReceiverIdentifierLeg1(), this::setReceiverIdentifierLeg1);
			merger.mergeBasic(getReceiverIdentifierLeg2(), o.getReceiverIdentifierLeg2(), this::setReceiverIdentifierLeg2);
			merger.mergeBasic(getSubmitterIdentifier(), o.getSubmitterIdentifier(), this::setSubmitterIdentifier);
			merger.mergeBasic(getCounterparty1FederalEntityIndicator(), o.getCounterparty1FederalEntityIndicator(), this::setCounterparty1FederalEntityIndicator);
			merger.mergeBasic(getCounterparty2FederalEntityIndicator(), o.getCounterparty2FederalEntityIndicator(), this::setCounterparty2FederalEntityIndicator);
			merger.mergeBasic(getCustomBasketIndicator(), o.getCustomBasketIndicator(), this::setCustomBasketIndicator);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getEventType(), o.getEventType(), this::setEventType);
			merger.mergeBasic(getAmendmentIndicator(), o.getAmendmentIndicator(), this::setAmendmentIndicator);
			merger.mergeBasic(getEventIdentifier(), o.getEventIdentifier(), this::setEventIdentifier);
			merger.mergeBasic(getEventTimestamp(), o.getEventTimestamp(), this::setEventTimestamp);
			merger.mergeBasic(getNotionalAmountLeg1(), o.getNotionalAmountLeg1(), this::setNotionalAmountLeg1);
			merger.mergeBasic(getNotionalAmountLeg2(), o.getNotionalAmountLeg2(), this::setNotionalAmountLeg2);
			merger.mergeBasic(getNotionalCurrencyLeg1(), o.getNotionalCurrencyLeg1(), this::setNotionalCurrencyLeg1);
			merger.mergeBasic(getNotionalCurrencyLeg2(), o.getNotionalCurrencyLeg2(), this::setNotionalCurrencyLeg2);
			merger.mergeBasic(getCallAmount(), o.getCallAmount(), this::setCallAmount);
			merger.mergeBasic(getCallCurrency(), o.getCallCurrency(), this::setCallCurrency);
			merger.mergeBasic(getPutAmount(), o.getPutAmount(), this::setPutAmount);
			merger.mergeBasic(getPutCurrency(), o.getPutCurrency(), this::setPutCurrency);
			merger.mergeBasic(getNotionalQuantityLeg1(), o.getNotionalQuantityLeg1(), this::setNotionalQuantityLeg1);
			merger.mergeBasic(getNotionalQuantityLeg2(), o.getNotionalQuantityLeg2(), this::setNotionalQuantityLeg2);
			merger.mergeBasic(getQuantityFrequencyLeg1(), o.getQuantityFrequencyLeg1(), this::setQuantityFrequencyLeg1);
			merger.mergeBasic(getQuantityFrequencyLeg2(), o.getQuantityFrequencyLeg2(), this::setQuantityFrequencyLeg2);
			merger.mergeBasic(getQuantityFrequencyMultiplierLeg1(), o.getQuantityFrequencyMultiplierLeg1(), this::setQuantityFrequencyMultiplierLeg1);
			merger.mergeBasic(getQuantityFrequencyMultiplierLeg2(), o.getQuantityFrequencyMultiplierLeg2(), this::setQuantityFrequencyMultiplierLeg2);
			merger.mergeBasic(getQuantityUnitOfMeasureLeg1(), o.getQuantityUnitOfMeasureLeg1(), this::setQuantityUnitOfMeasureLeg1);
			merger.mergeBasic(getQuantityUnitOfMeasureLeg2(), o.getQuantityUnitOfMeasureLeg2(), this::setQuantityUnitOfMeasureLeg2);
			merger.mergeBasic(getTotalNotionalQuantityLeg1(), o.getTotalNotionalQuantityLeg1(), this::setTotalNotionalQuantityLeg1);
			merger.mergeBasic(getTotalNotionalQuantityLeg2(), o.getTotalNotionalQuantityLeg2(), this::setTotalNotionalQuantityLeg2);
			merger.mergeBasic(getPackageIndicator(), o.getPackageIndicator(), this::setPackageIndicator);
			merger.mergeBasic(getPackageIdentifier(), o.getPackageIdentifier(), this::setPackageIdentifier);
			merger.mergeBasic(getPackageTransactionPrice(), o.getPackageTransactionPrice(), this::setPackageTransactionPrice);
			merger.mergeBasic(getPackageTransactionPriceCurrency(), o.getPackageTransactionPriceCurrency(), this::setPackageTransactionPriceCurrency);
			merger.mergeBasic(getPackageTransactionPriceNotation(), o.getPackageTransactionPriceNotation(), this::setPackageTransactionPriceNotation);
			merger.mergeBasic(getPackageTransactionSpread(), o.getPackageTransactionSpread(), this::setPackageTransactionSpread);
			merger.mergeBasic(getPackageTransactionSpreadCurrency(), o.getPackageTransactionSpreadCurrency(), this::setPackageTransactionSpreadCurrency);
			merger.mergeBasic(getPackageTransactionSpreadNotation(), o.getPackageTransactionSpreadNotation(), this::setPackageTransactionSpreadNotation);
			merger.mergeBasic(getFixedRateDayCountConventionLeg1(), o.getFixedRateDayCountConventionLeg1(), this::setFixedRateDayCountConventionLeg1);
			merger.mergeBasic(getFixedRateDayCountConventionLeg2(), o.getFixedRateDayCountConventionLeg2(), this::setFixedRateDayCountConventionLeg2);
			merger.mergeBasic(getFloatingRateDayCountConventionLeg1(), o.getFloatingRateDayCountConventionLeg1(), this::setFloatingRateDayCountConventionLeg1);
			merger.mergeBasic(getFloatingRateDayCountConventionLeg2(), o.getFloatingRateDayCountConventionLeg2(), this::setFloatingRateDayCountConventionLeg2);
			merger.mergeBasic(getFixingDateLeg1(), o.getFixingDateLeg1(), this::setFixingDateLeg1);
			merger.mergeBasic(getFixingDateLeg2(), o.getFixingDateLeg2(), this::setFixingDateLeg2);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodLeg1(), o.getFloatingRateResetFrequencyPeriodLeg1(), this::setFloatingRateResetFrequencyPeriodLeg1);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodLeg2(), o.getFloatingRateResetFrequencyPeriodLeg2(), this::setFloatingRateResetFrequencyPeriodLeg2);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierLeg1(), o.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierLeg2(), o.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodLeg1(), o.getFixedRatePaymentFrequencyPeriodLeg1(), this::setFixedRatePaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodLeg2(), o.getFixedRatePaymentFrequencyPeriodLeg2(), this::setFixedRatePaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodLeg1(), o.getFloatingRatePaymentFrequencyPeriodLeg1(), this::setFloatingRatePaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodLeg2(), o.getFloatingRatePaymentFrequencyPeriodLeg2(), this::setFloatingRatePaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1(), this::setFloatingRatePaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), o.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2(), this::setFloatingRatePaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getExchangeRateLeg1(), o.getExchangeRateLeg1(), this::setExchangeRateLeg1);
			merger.mergeBasic(getExchangeRateBasis(), o.getExchangeRateBasis(), this::setExchangeRateBasis);
			merger.mergeBasic(getFixedRateLeg1(), o.getFixedRateLeg1(), this::setFixedRateLeg1);
			merger.mergeBasic(getFixedRateLeg2(), o.getFixedRateLeg2(), this::setFixedRateLeg2);
			merger.mergeBasic(getPostPricedSwapIndicator(), o.getPostPricedSwapIndicator(), this::setPostPricedSwapIndicator);
			merger.mergeBasic(getPrice(), o.getPrice(), this::setPrice);
			merger.mergeBasic(getPriceCurrency(), o.getPriceCurrency(), this::setPriceCurrency);
			merger.mergeBasic(getPriceNotation(), o.getPriceNotation(), this::setPriceNotation);
			merger.mergeBasic(getPriceUnitOfMeasure(), o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure);
			merger.mergeBasic(getSpreadLeg1(), o.getSpreadLeg1(), this::setSpreadLeg1);
			merger.mergeBasic(getSpreadLeg2(), o.getSpreadLeg2(), this::setSpreadLeg2);
			merger.mergeBasic(getSpreadCurrencyLeg1(), o.getSpreadCurrencyLeg1(), this::setSpreadCurrencyLeg1);
			merger.mergeBasic(getSpreadCurrencyLeg2(), o.getSpreadCurrencyLeg2(), this::setSpreadCurrencyLeg2);
			merger.mergeBasic(getSpreadNotationLeg1(), o.getSpreadNotationLeg1(), this::setSpreadNotationLeg1);
			merger.mergeBasic(getSpreadNotationLeg2(), o.getSpreadNotationLeg2(), this::setSpreadNotationLeg2);
			merger.mergeBasic(getStrikePrice(), o.getStrikePrice(), this::setStrikePrice);
			merger.mergeBasic(getStrikePriceCurrency(), o.getStrikePriceCurrency(), this::setStrikePriceCurrency);
			merger.mergeBasic(getStrikePriceNotation(), o.getStrikePriceNotation(), this::setStrikePriceNotation);
			merger.mergeBasic(getOptionPremiumAmount(), o.getOptionPremiumAmount(), this::setOptionPremiumAmount);
			merger.mergeBasic(getOptionPremiumCurrency(), o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency);
			merger.mergeBasic(getOptionPremiumPaymentDate(), o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate);
			merger.mergeBasic(getFirstExerciseDate(), o.getFirstExerciseDate(), this::setFirstExerciseDate);
			merger.mergeBasic(getCDSIndexAttachmentPoint(), o.getCDSIndexAttachmentPoint(), this::setCDSIndexAttachmentPoint);
			merger.mergeBasic(getCDSIndexDetachmentPoint(), o.getCDSIndexDetachmentPoint(), this::setCDSIndexDetachmentPoint);
			merger.mergeBasic(getIndexFactor(), o.getIndexFactor(), this::setIndexFactor);
			merger.mergeBasic(getEmbeddedOptionType(), o.getEmbeddedOptionType(), this::setEmbeddedOptionType);
			merger.mergeBasic(getUniqueProductIdentifier(), o.getUniqueProductIdentifier(), this::setUniqueProductIdentifier);
			merger.mergeBasic(getFinalContractualSettlementDate(), o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate);
			merger.mergeBasic(getSettlementCurrencyLeg1(), o.getSettlementCurrencyLeg1(), this::setSettlementCurrencyLeg1);
			merger.mergeBasic(getSettlementCurrencyLeg2(), o.getSettlementCurrencyLeg2(), this::setSettlementCurrencyLeg2);
			merger.mergeBasic(getSettlementLocationLeg1(), o.getSettlementLocationLeg1(), this::setSettlementLocationLeg1);
			merger.mergeBasic(getSettlementLocationLeg2(), o.getSettlementLocationLeg2(), this::setSettlementLocationLeg2);
			merger.mergeBasic(getAllocationIndicator(), o.getAllocationIndicator(), this::setAllocationIndicator);
			merger.mergeBasic(getNonStandardizedTermIndicator(), o.getNonStandardizedTermIndicator(), this::setNonStandardizedTermIndicator);
			merger.mergeBasic(getBlockTradeElectionIndicator(), o.getBlockTradeElectionIndicator(), this::setBlockTradeElectionIndicator);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getExpirationDate(), o.getExpirationDate(), this::setExpirationDate);
			merger.mergeBasic(getExecutionTimestamp(), o.getExecutionTimestamp(), this::setExecutionTimestamp);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getPlatformIdentifier(), o.getPlatformIdentifier(), this::setPlatformIdentifier);
			merger.mergeBasic(getPrimeBrokerageTransactionIndicator(), o.getPrimeBrokerageTransactionIndicator(), this::setPrimeBrokerageTransactionIndicator);
			merger.mergeBasic(getPriorUSI(), o.getPriorUSI(), this::setPriorUSI);
			merger.mergeBasic(getPriorUTI(), o.getPriorUTI(), this::setPriorUTI);
			merger.mergeBasic(getUniqueSwapIdentifier(), o.getUniqueSwapIdentifier(), this::setUniqueSwapIdentifier);
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getJurisdiction(), o.getJurisdiction(), this::setJurisdiction);
			merger.mergeBasic(getNewSDRIdentifier(), o.getNewSDRIdentifier(), this::setNewSDRIdentifier);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CFTCPart45TransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!ListEquals.listEquals(clearingSwapUSIs, _that.getClearingSwapUSIs())) return false;
			if (!ListEquals.listEquals(clearingSwapUTIs, _that.getClearingSwapUTIs())) return false;
			if (!Objects.equals(originalSwapUSI, _that.getOriginalSwapUSI())) return false;
			if (!Objects.equals(originalSwapUTI, _that.getOriginalSwapUTI())) return false;
			if (!Objects.equals(originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty1, _that.getClearingExceptionsAndExemptionsCounterparty1())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty2, _that.getClearingExceptionsAndExemptionsCounterparty2())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) return false;
			if (!Objects.equals(counterparty1FinancialEntityIndicator, _that.getCounterparty1FinancialEntityIndicator())) return false;
			if (!Objects.equals(counterparty2FinancialEntityIndicator, _that.getCounterparty2FinancialEntityIndicator())) return false;
			if (!Objects.equals(buyerIdentifier, _that.getBuyerIdentifier())) return false;
			if (!Objects.equals(sellerIdentifier, _that.getSellerIdentifier())) return false;
			if (!Objects.equals(payerIdentifierLeg1, _that.getPayerIdentifierLeg1())) return false;
			if (!Objects.equals(payerIdentifierLeg2, _that.getPayerIdentifierLeg2())) return false;
			if (!Objects.equals(receiverIdentifierLeg1, _that.getReceiverIdentifierLeg1())) return false;
			if (!Objects.equals(receiverIdentifierLeg2, _that.getReceiverIdentifierLeg2())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(counterparty1FederalEntityIndicator, _that.getCounterparty1FederalEntityIndicator())) return false;
			if (!Objects.equals(counterparty2FederalEntityIndicator, _that.getCounterparty2FederalEntityIndicator())) return false;
			if (!Objects.equals(customBasketIndicator, _that.getCustomBasketIndicator())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(amendmentIndicator, _that.getAmendmentIndicator())) return false;
			if (!Objects.equals(eventIdentifier, _that.getEventIdentifier())) return false;
			if (!Objects.equals(eventTimestamp, _that.getEventTimestamp())) return false;
			if (!Objects.equals(notionalAmountLeg1, _that.getNotionalAmountLeg1())) return false;
			if (!Objects.equals(notionalAmountLeg2, _that.getNotionalAmountLeg2())) return false;
			if (!Objects.equals(notionalCurrencyLeg1, _that.getNotionalCurrencyLeg1())) return false;
			if (!Objects.equals(notionalCurrencyLeg2, _that.getNotionalCurrencyLeg2())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1, _that.getNotionalAmountScheduleLeg1())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2, _that.getNotionalAmountScheduleLeg2())) return false;
			if (!Objects.equals(callAmount, _that.getCallAmount())) return false;
			if (!Objects.equals(callCurrency, _that.getCallCurrency())) return false;
			if (!Objects.equals(putAmount, _that.getPutAmount())) return false;
			if (!Objects.equals(putCurrency, _that.getPutCurrency())) return false;
			if (!Objects.equals(notionalQuantityLeg1, _that.getNotionalQuantityLeg1())) return false;
			if (!Objects.equals(notionalQuantityLeg2, _that.getNotionalQuantityLeg2())) return false;
			if (!Objects.equals(quantityFrequencyLeg1, _that.getQuantityFrequencyLeg1())) return false;
			if (!Objects.equals(quantityFrequencyLeg2, _that.getQuantityFrequencyLeg2())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierLeg1, _that.getQuantityFrequencyMultiplierLeg1())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierLeg2, _that.getQuantityFrequencyMultiplierLeg2())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg1, _that.getQuantityUnitOfMeasureLeg1())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(packageIndicator, _that.getPackageIndicator())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(packageTransactionPrice, _that.getPackageTransactionPrice())) return false;
			if (!Objects.equals(packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) return false;
			if (!Objects.equals(packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) return false;
			if (!Objects.equals(packageTransactionSpread, _that.getPackageTransactionSpread())) return false;
			if (!Objects.equals(packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) return false;
			if (!Objects.equals(packageTransactionSpreadNotation, _that.getPackageTransactionSpreadNotation())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionLeg1, _that.getFloatingRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionLeg2, _that.getFloatingRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(fixingDateLeg1, _that.getFixingDateLeg1())) return false;
			if (!Objects.equals(fixingDateLeg2, _that.getFixingDateLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodLeg1, _that.getFloatingRateResetFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodLeg2, _that.getFloatingRateResetFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodLeg1, _that.getFloatingRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodLeg2, _that.getFloatingRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(exchangeRateLeg1, _that.getExchangeRateLeg1())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(fixedRateLeg1, _that.getFixedRateLeg1())) return false;
			if (!Objects.equals(fixedRateLeg2, _that.getFixedRateLeg2())) return false;
			if (!Objects.equals(postPricedSwapIndicator, _that.getPostPricedSwapIndicator())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!Objects.equals(priceCurrency, _that.getPriceCurrency())) return false;
			if (!Objects.equals(priceNotation, _that.getPriceNotation())) return false;
			if (!Objects.equals(priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) return false;
			if (!Objects.equals(spreadLeg1, _that.getSpreadLeg1())) return false;
			if (!Objects.equals(spreadLeg2, _that.getSpreadLeg2())) return false;
			if (!Objects.equals(spreadCurrencyLeg1, _that.getSpreadCurrencyLeg1())) return false;
			if (!Objects.equals(spreadCurrencyLeg2, _that.getSpreadCurrencyLeg2())) return false;
			if (!Objects.equals(spreadNotationLeg1, _that.getSpreadNotationLeg1())) return false;
			if (!Objects.equals(spreadNotationLeg2, _that.getSpreadNotationLeg2())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!Objects.equals(strikePriceCurrency, _that.getStrikePriceCurrency())) return false;
			if (!Objects.equals(strikePriceNotation, _that.getStrikePriceNotation())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(firstExerciseDate, _that.getFirstExerciseDate())) return false;
			if (!Objects.equals(cDSIndexAttachmentPoint, _that.getCDSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cDSIndexDetachmentPoint, _that.getCDSIndexDetachmentPoint())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(embeddedOptionType, _that.getEmbeddedOptionType())) return false;
			if (!Objects.equals(uniqueProductIdentifier, _that.getUniqueProductIdentifier())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(settlementCurrencyLeg1, _that.getSettlementCurrencyLeg1())) return false;
			if (!Objects.equals(settlementCurrencyLeg2, _that.getSettlementCurrencyLeg2())) return false;
			if (!Objects.equals(settlementLocationLeg1, _that.getSettlementLocationLeg1())) return false;
			if (!Objects.equals(settlementLocationLeg2, _that.getSettlementLocationLeg2())) return false;
			if (!Objects.equals(allocationIndicator, _that.getAllocationIndicator())) return false;
			if (!Objects.equals(nonStandardizedTermIndicator, _that.getNonStandardizedTermIndicator())) return false;
			if (!Objects.equals(blockTradeElectionIndicator, _that.getBlockTradeElectionIndicator())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(platformIdentifier, _that.getPlatformIdentifier())) return false;
			if (!Objects.equals(primeBrokerageTransactionIndicator, _that.getPrimeBrokerageTransactionIndicator())) return false;
			if (!Objects.equals(priorUSI, _that.getPriorUSI())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(jurisdiction, _that.getJurisdiction())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(cftcGuidebook, _that.getCftcGuidebook())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (clearingSwapUSIs != null ? clearingSwapUSIs.hashCode() : 0);
			_result = 31 * _result + (clearingSwapUTIs != null ? clearingSwapUTIs.hashCode() : 0);
			_result = 31 * _result + (originalSwapUSI != null ? originalSwapUSI.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTI != null ? originalSwapUTI.hashCode() : 0);
			_result = 31 * _result + (originalSwapSDRIdentifier != null ? originalSwapSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty1 != null ? clearingExceptionsAndExemptionsCounterparty1.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty2 != null ? clearingExceptionsAndExemptionsCounterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierSource != null ? counterparty2IdentifierSource.hashCode() : 0);
			_result = 31 * _result + (counterparty1FinancialEntityIndicator != null ? counterparty1FinancialEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2FinancialEntityIndicator != null ? counterparty2FinancialEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (buyerIdentifier != null ? buyerIdentifier.hashCode() : 0);
			_result = 31 * _result + (sellerIdentifier != null ? sellerIdentifier.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg1 != null ? payerIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg2 != null ? payerIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg1 != null ? receiverIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg2 != null ? receiverIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (counterparty1FederalEntityIndicator != null ? counterparty1FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2FederalEntityIndicator != null ? counterparty2FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (customBasketIndicator != null ? customBasketIndicator.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (amendmentIndicator != null ? amendmentIndicator.hashCode() : 0);
			_result = 31 * _result + (eventIdentifier != null ? eventIdentifier.hashCode() : 0);
			_result = 31 * _result + (eventTimestamp != null ? eventTimestamp.hashCode() : 0);
			_result = 31 * _result + (notionalAmountLeg1 != null ? notionalAmountLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalAmountLeg2 != null ? notionalAmountLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyLeg1 != null ? notionalCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyLeg2 != null ? notionalCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1 != null ? notionalAmountScheduleLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2 != null ? notionalAmountScheduleLeg2.hashCode() : 0);
			_result = 31 * _result + (callAmount != null ? callAmount.hashCode() : 0);
			_result = 31 * _result + (callCurrency != null ? callCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (putAmount != null ? putAmount.hashCode() : 0);
			_result = 31 * _result + (putCurrency != null ? putCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalQuantityLeg1 != null ? notionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityLeg2 != null ? notionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyLeg1 != null ? quantityFrequencyLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyLeg2 != null ? quantityFrequencyLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierLeg1 != null ? quantityFrequencyMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierLeg2 != null ? quantityFrequencyMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg1 != null ? quantityUnitOfMeasureLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg2 != null ? quantityUnitOfMeasureLeg2.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (packageIndicator != null ? packageIndicator.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPrice != null ? packageTransactionPrice.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceCurrency != null ? packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceNotation != null ? packageTransactionPriceNotation.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpread != null ? packageTransactionSpread.hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadCurrency != null ? packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (packageTransactionSpreadNotation != null ? packageTransactionSpreadNotation.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg1 != null ? fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg2 != null ? fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionLeg1 != null ? floatingRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionLeg2 != null ? floatingRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg1 != null ? fixingDateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixingDateLeg2 != null ? fixingDateLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodLeg1 != null ? floatingRateResetFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodLeg2 != null ? floatingRateResetFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg1 != null ? fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg2 != null ? fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodLeg1 != null ? floatingRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodLeg2 != null ? floatingRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (exchangeRateLeg1 != null ? exchangeRateLeg1.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg1 != null ? fixedRateLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateLeg2 != null ? fixedRateLeg2.hashCode() : 0);
			_result = 31 * _result + (postPricedSwapIndicator != null ? postPricedSwapIndicator.hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceCurrency != null ? priceCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (priceNotation != null ? priceNotation.hashCode() : 0);
			_result = 31 * _result + (priceUnitOfMeasure != null ? priceUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (spreadLeg1 != null ? spreadLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadLeg2 != null ? spreadLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyLeg1 != null ? spreadCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadCurrencyLeg2 != null ? spreadCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (spreadNotationLeg1 != null ? spreadNotationLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadNotationLeg2 != null ? spreadNotationLeg2.hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceCurrency != null ? strikePriceCurrency.hashCode() : 0);
			_result = 31 * _result + (strikePriceNotation != null ? strikePriceNotation.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (firstExerciseDate != null ? firstExerciseDate.hashCode() : 0);
			_result = 31 * _result + (cDSIndexAttachmentPoint != null ? cDSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cDSIndexDetachmentPoint != null ? cDSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (embeddedOptionType != null ? embeddedOptionType.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifier != null ? uniqueProductIdentifier.hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg1 != null ? settlementCurrencyLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrencyLeg2 != null ? settlementCurrencyLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementLocationLeg1 != null ? settlementLocationLeg1.hashCode() : 0);
			_result = 31 * _result + (settlementLocationLeg2 != null ? settlementLocationLeg2.hashCode() : 0);
			_result = 31 * _result + (allocationIndicator != null ? allocationIndicator.hashCode() : 0);
			_result = 31 * _result + (nonStandardizedTermIndicator != null ? nonStandardizedTermIndicator.hashCode() : 0);
			_result = 31 * _result + (blockTradeElectionIndicator != null ? blockTradeElectionIndicator.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (platformIdentifier != null ? platformIdentifier.hashCode() : 0);
			_result = 31 * _result + (primeBrokerageTransactionIndicator != null ? primeBrokerageTransactionIndicator.hashCode() : 0);
			_result = 31 * _result + (priorUSI != null ? priorUSI.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (uniqueSwapIdentifier != null ? uniqueSwapIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (jurisdiction != null ? jurisdiction.hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (cftcGuidebook != null ? cftcGuidebook.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCPart45TransactionReportBuilder {" +
				"cleared=" + this.cleared + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"clearingSwapUSIs=" + this.clearingSwapUSIs + ", " +
				"clearingSwapUTIs=" + this.clearingSwapUTIs + ", " +
				"originalSwapUSI=" + this.originalSwapUSI + ", " +
				"originalSwapUTI=" + this.originalSwapUTI + ", " +
				"originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"clearingExceptionsAndExemptionsCounterparty1=" + this.clearingExceptionsAndExemptionsCounterparty1 + ", " +
				"clearingExceptionsAndExemptionsCounterparty2=" + this.clearingExceptionsAndExemptionsCounterparty2 + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", " +
				"counterparty1FinancialEntityIndicator=" + this.counterparty1FinancialEntityIndicator + ", " +
				"counterparty2FinancialEntityIndicator=" + this.counterparty2FinancialEntityIndicator + ", " +
				"buyerIdentifier=" + this.buyerIdentifier + ", " +
				"sellerIdentifier=" + this.sellerIdentifier + ", " +
				"payerIdentifierLeg1=" + this.payerIdentifierLeg1 + ", " +
				"payerIdentifierLeg2=" + this.payerIdentifierLeg2 + ", " +
				"receiverIdentifierLeg1=" + this.receiverIdentifierLeg1 + ", " +
				"receiverIdentifierLeg2=" + this.receiverIdentifierLeg2 + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"counterparty1FederalEntityIndicator=" + this.counterparty1FederalEntityIndicator + ", " +
				"counterparty2FederalEntityIndicator=" + this.counterparty2FederalEntityIndicator + ", " +
				"customBasketIndicator=" + this.customBasketIndicator + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"amendmentIndicator=" + this.amendmentIndicator + ", " +
				"eventIdentifier=" + this.eventIdentifier + ", " +
				"eventTimestamp=" + this.eventTimestamp + ", " +
				"notionalAmountLeg1=" + this.notionalAmountLeg1 + ", " +
				"notionalAmountLeg2=" + this.notionalAmountLeg2 + ", " +
				"notionalCurrencyLeg1=" + this.notionalCurrencyLeg1 + ", " +
				"notionalCurrencyLeg2=" + this.notionalCurrencyLeg2 + ", " +
				"notionalAmountScheduleLeg1=" + this.notionalAmountScheduleLeg1 + ", " +
				"notionalAmountScheduleLeg2=" + this.notionalAmountScheduleLeg2 + ", " +
				"callAmount=" + this.callAmount + ", " +
				"callCurrency=" + this.callCurrency + ", " +
				"putAmount=" + this.putAmount + ", " +
				"putCurrency=" + this.putCurrency + ", " +
				"notionalQuantityLeg1=" + this.notionalQuantityLeg1 + ", " +
				"notionalQuantityLeg2=" + this.notionalQuantityLeg2 + ", " +
				"quantityFrequencyLeg1=" + this.quantityFrequencyLeg1 + ", " +
				"quantityFrequencyLeg2=" + this.quantityFrequencyLeg2 + ", " +
				"quantityFrequencyMultiplierLeg1=" + this.quantityFrequencyMultiplierLeg1 + ", " +
				"quantityFrequencyMultiplierLeg2=" + this.quantityFrequencyMultiplierLeg2 + ", " +
				"quantityUnitOfMeasureLeg1=" + this.quantityUnitOfMeasureLeg1 + ", " +
				"quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"packageIndicator=" + this.packageIndicator + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"packageTransactionPrice=" + this.packageTransactionPrice + ", " +
				"packageTransactionPriceCurrency=" + this.packageTransactionPriceCurrency + ", " +
				"packageTransactionPriceNotation=" + this.packageTransactionPriceNotation + ", " +
				"packageTransactionSpread=" + this.packageTransactionSpread + ", " +
				"packageTransactionSpreadCurrency=" + this.packageTransactionSpreadCurrency + ", " +
				"packageTransactionSpreadNotation=" + this.packageTransactionSpreadNotation + ", " +
				"fixedRateDayCountConventionLeg1=" + this.fixedRateDayCountConventionLeg1 + ", " +
				"fixedRateDayCountConventionLeg2=" + this.fixedRateDayCountConventionLeg2 + ", " +
				"floatingRateDayCountConventionLeg1=" + this.floatingRateDayCountConventionLeg1 + ", " +
				"floatingRateDayCountConventionLeg2=" + this.floatingRateDayCountConventionLeg2 + ", " +
				"fixingDateLeg1=" + this.fixingDateLeg1 + ", " +
				"fixingDateLeg2=" + this.fixingDateLeg2 + ", " +
				"floatingRateResetFrequencyPeriodLeg1=" + this.floatingRateResetFrequencyPeriodLeg1 + ", " +
				"floatingRateResetFrequencyPeriodLeg2=" + this.floatingRateResetFrequencyPeriodLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodLeg1=" + this.floatingRatePaymentFrequencyPeriodLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodLeg2=" + this.floatingRatePaymentFrequencyPeriodLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"exchangeRateLeg1=" + this.exchangeRateLeg1 + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"fixedRateLeg1=" + this.fixedRateLeg1 + ", " +
				"fixedRateLeg2=" + this.fixedRateLeg2 + ", " +
				"postPricedSwapIndicator=" + this.postPricedSwapIndicator + ", " +
				"price=" + this.price + ", " +
				"priceCurrency=" + this.priceCurrency + ", " +
				"priceNotation=" + this.priceNotation + ", " +
				"priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", " +
				"spreadLeg1=" + this.spreadLeg1 + ", " +
				"spreadLeg2=" + this.spreadLeg2 + ", " +
				"spreadCurrencyLeg1=" + this.spreadCurrencyLeg1 + ", " +
				"spreadCurrencyLeg2=" + this.spreadCurrencyLeg2 + ", " +
				"spreadNotationLeg1=" + this.spreadNotationLeg1 + ", " +
				"spreadNotationLeg2=" + this.spreadNotationLeg2 + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"strikePriceCurrency=" + this.strikePriceCurrency + ", " +
				"strikePriceNotation=" + this.strikePriceNotation + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"firstExerciseDate=" + this.firstExerciseDate + ", " +
				"cDSIndexAttachmentPoint=" + this.cDSIndexAttachmentPoint + ", " +
				"cDSIndexDetachmentPoint=" + this.cDSIndexDetachmentPoint + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"embeddedOptionType=" + this.embeddedOptionType + ", " +
				"uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"settlementCurrencyLeg1=" + this.settlementCurrencyLeg1 + ", " +
				"settlementCurrencyLeg2=" + this.settlementCurrencyLeg2 + ", " +
				"settlementLocationLeg1=" + this.settlementLocationLeg1 + ", " +
				"settlementLocationLeg2=" + this.settlementLocationLeg2 + ", " +
				"allocationIndicator=" + this.allocationIndicator + ", " +
				"nonStandardizedTermIndicator=" + this.nonStandardizedTermIndicator + ", " +
				"blockTradeElectionIndicator=" + this.blockTradeElectionIndicator + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"platformIdentifier=" + this.platformIdentifier + ", " +
				"primeBrokerageTransactionIndicator=" + this.primeBrokerageTransactionIndicator + ", " +
				"priorUSI=" + this.priorUSI + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"jurisdiction=" + this.jurisdiction + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"cftcGuidebook=" + this.cftcGuidebook + ", " +
				"nonReportable=" + this.nonReportable +
			'}';
		}
	}
}
