package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.qualification.functions.Qualify_InterestRate_CapFloor;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.FXLeg1;
import drr.regulation.common.functions.FXSwapLeg1;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.IsCommoditySwapFixedFloat;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import drr.regulation.common.functions.IsEquitySwap;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXSwap;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradableProductForEvent;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PayerPartyLeg1.PayerPartyLeg1Default.class)
public abstract class PayerPartyLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected ExtractCounterpartyByRole extractCounterpartyByRole;
	@Inject protected FXLeg1 fXLeg1;
	@Inject protected FXSwapLeg1 fXSwapLeg1;
	@Inject protected FixedPriceLeg1 fixedPriceLeg1;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;
	@Inject protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
	@Inject protected IsEquitySwap isEquitySwap;
	@Inject protected IsFXForward isFXForward;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_InterestRate_CapFloor qualify_InterestRate_CapFloor;
	@Inject protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
	@Inject protected TradableProductForEvent tradableProductForEvent;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param reportableEvent 
	* @return party 
	*/
	public Party evaluate(ReportableEvent reportableEvent) {
		Party.PartyBuilder partyBuilder = doEvaluate(reportableEvent);
		
		final Party party;
		if (partyBuilder == null) {
			party = null;
		} else {
			party = partyBuilder.build();
			objectValidator.validate(Party.class, party);
		}
		
		return party;
	}

	protected abstract Party.PartyBuilder doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<CounterpartyRoleEnum> counterpartyRole(ReportableEvent reportableEvent);

	public static class PayerPartyLeg1Default extends PayerPartyLeg1 {
		@Override
		protected Party.PartyBuilder doEvaluate(ReportableEvent reportableEvent) {
			Party.PartyBuilder party = Party.builder();
			return assignOutput(party, reportableEvent);
		}
		
		protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, ReportableEvent reportableEvent) {
			final ReferenceWithMetaParty referenceWithMetaParty = MapperS.of(extractCounterpartyByRole.evaluate(MapperS.of(tradeForEvent.evaluate(reportableEvent)).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Counterparty>mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), counterpartyRole(reportableEvent).get())).<ReferenceWithMetaParty>map("getPartyReference", counterparty -> counterparty.getPartyReference()).get();
			if (referenceWithMetaParty == null) {
				party = null;
			} else {
				party = toBuilder(referenceWithMetaParty.getValue());
			}
			
			return Optional.ofNullable(party)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<CounterpartyRoleEnum> counterpartyRole(ReportableEvent reportableEvent) {
			final Boolean boolean0 = isCommoditySwapFloatFloat.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)));
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(commodityLeg1.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)))).<PayerReceiver>map("getPayerReceiver", commodityPayout -> commodityPayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			if (ComparisonResult.of(MapperS.of(isCommoditySwapFixedFloat.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))))).and(exists(MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<FixedPricePayout>mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()))).getOrDefault(false)) {
				return MapperS.of(fixedPriceLeg1.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)))).<PayerReceiver>map("getPayerReceiver", fixedPricePayout -> fixedPricePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			final Boolean boolean1 = isFXForward.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)));
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(fXLeg1.evaluate(productForEvent.evaluate(reportableEvent))).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			final Boolean boolean2 = isFXSwap.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)));
			if ((boolean2 == null ? false : boolean2)) {
				return MapperS.of(fXSwapLeg1.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)))).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			final Boolean boolean3 = isEquitySwap.evaluate(tradableProductForEvent.evaluate(reportableEvent));
			if ((boolean3 == null ? false : boolean3)) {
				return MapperS.of(MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<PayerReceiver>map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			if (areEqual(MapperS.of(qualify_InterestRate_Option_Swaption.evaluate(MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All).and(areEqual(MapperS.of(qualify_InterestRate_CapFloor.evaluate(MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())), MapperS.of(false), CardinalityOperator.All)).and(notExists(MapperS.of(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent))).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CreditDefaultPayout>map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()))).getOrDefault(false)) {
				return MapperS.of(interestRateLeg1.evaluate(productForTrade.evaluate(tradeForEvent.evaluate(reportableEvent)))).<PayerReceiver>map("getPayerReceiver", interestRatePayout -> interestRatePayout.getPayerReceiver()).<CounterpartyRoleEnum>map("getPayer", payerReceiver -> payerReceiver.getPayer());
			}
			return MapperS.<CounterpartyRoleEnum>ofNull();
		}
	}
}
