package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.RelatedParty;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.CFTCPartyInformation;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.functions.ExtractPartyFromRelatedPartyByRole;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PrimeBrokerageTransactionIndicatorFunc.PrimeBrokerageTransactionIndicatorFuncDefault.class)
public abstract class PrimeBrokerageTransactionIndicatorFunc implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;

	/**
	* @param reportableEvent 
	* @return indicator 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean indicator = doEvaluate(reportableEvent);
		
		return indicator;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> primeBrokerExists(ReportableEvent reportableEvent);

	protected abstract MapperC<? extends PartyInformation> executingBrokerPartyInfo(ReportableEvent reportableEvent);

	protected abstract MapperS<Boolean> executingBrokerIsUSPerson(ReportableEvent reportableEvent);

	public static class PrimeBrokerageTransactionIndicatorFuncDefault extends PrimeBrokerageTransactionIndicatorFunc {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean indicator = null;
			return assignOutput(indicator, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean indicator, ReportableEvent reportableEvent) {
			indicator = ComparisonResult.of(primeBrokerExists(reportableEvent)).and(ComparisonResult.of(executingBrokerIsUSPerson(reportableEvent))).get();
			
			return indicator;
		}
		
		@Override
		protected MapperS<Boolean> primeBrokerExists(ReportableEvent reportableEvent) {
			return exists(MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.PRIME_BROKER))).asMapper();
		}
		
		@Override
		protected MapperC<? extends PartyInformation> executingBrokerPartyInfo(ReportableEvent reportableEvent) {
			return MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation())
				.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(item.<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.EXECUTING_BROKER)), CardinalityOperator.All).get());
		}
		
		@Override
		protected MapperS<Boolean> executingBrokerIsUSPerson(ReportableEvent reportableEvent) {
			return MapperS.of(executingBrokerPartyInfo(reportableEvent).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<CFTCPartyInformation>map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).<Boolean>map("getIsUSPerson", cFTCPartyInformation -> cFTCPartyInformation.getIsUSPerson())
				.first().getOrDefault(false));
		}
	}
}
