package drr.regulation.cftc.rewrite.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.validation.CFTCGuidebookPart43TypeFormatValidator;
import drr.regulation.cftc.rewrite.validation.CFTCGuidebookPart43Validator;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCGuidebookPart43LargeNotionalOffFacilitySwapElectionIndicator;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCGuidebookPart43PhysicalCommodityIndicator;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCGuidebookPart43SefOrDcmAnonymousIndicator;
import drr.regulation.cftc.rewrite.validation.exists.CFTCGuidebookPart43OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.53.0
 */
@RosettaMeta(model=CFTCGuidebookPart43.class)
public class CFTCGuidebookPart43Meta implements RosettaMetaData<CFTCGuidebookPart43> {

	@Override
	public List<Validator<? super CFTCGuidebookPart43>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<CFTCGuidebookPart43>create(CFTCGuidebookPart43LargeNotionalOffFacilitySwapElectionIndicator.class),
			factory.<CFTCGuidebookPart43>create(CFTCGuidebookPart43SefOrDcmAnonymousIndicator.class),
			factory.<CFTCGuidebookPart43>create(CFTCGuidebookPart43PhysicalCommodityIndicator.class)
		);
	}
	
	@Override
	public List<Function<? super CFTCGuidebookPart43, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super CFTCGuidebookPart43> validator(ValidatorFactory factory) {
		return factory.<CFTCGuidebookPart43>create(CFTCGuidebookPart43Validator.class);
	}

	@Override
	public Validator<? super CFTCGuidebookPart43> typeFormatValidator(ValidatorFactory factory) {
		return factory.<CFTCGuidebookPart43>create(CFTCGuidebookPart43TypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super CFTCGuidebookPart43> validator() {
		return new CFTCGuidebookPart43Validator();
	}

	@Deprecated
	@Override
	public Validator<? super CFTCGuidebookPart43> typeFormatValidator() {
		return new CFTCGuidebookPart43TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super CFTCGuidebookPart43, Set<String>> onlyExistsValidator() {
		return new CFTCGuidebookPart43OnlyExistsValidator();
	}
}
