package drr.regulation.cftc.rewrite.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.validation.CFTCPart45TransactionReportTypeFormatValidator;
import drr.regulation.cftc.rewrite.validation.CFTCPart45TransactionReportValidator;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportAmendmentIndicatorCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportBuyerIdentifier;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportBuyerIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportCDSIndexAttachmentPointCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportCDSIndexDetachmentPointCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportCallAmountCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportCallCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportCentralCounterpartyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportClearerMemberCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportClearingAcountOriginCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportClearingExceptionsAndExemptions1Condition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportClearingExceptionsAndExemptions2Condition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportClearingReceiptTimestampCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportClearingSwapUSICondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportClearingSwapUTICondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportCounterparty1;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportCounterparty1FinancialEntityIndicatorCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportCounterparty2;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportDayCountConventionCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportEventIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportEventTimestampCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportEventTypeCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportExchangeRateBasisCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportExchangeRateCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportExpirationDateCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportFinalContractualSettlementDateCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportFirstExerciseDateCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportFixedRateCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportFixingDateCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportFloatingRateResetFrequencyPeriodCond;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportFloatingRateResetFrequencyPeriodMultiplierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportIndexFactorCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportNewSDRIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportNonStandardizedTermIndicatorCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportNotionalAmountCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportNotionalAmountScheduleCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportNotionalCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportNotionalQuantityCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportOptionPremiumAmountCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportOptionPremiumCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportOptionPremiumPaymentDateCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportOriginalSwapSDRidentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportOriginalSwapUSICondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportOriginalSwapUTICondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportOtherPartyPaymentPayerIdentifierFormat;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportOtherPartyPaymentReceiverIdentifierFormat;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportOtherPaymentTypeCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPackageIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPackageTransactionPriceCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPackageTransactionPriceCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPackageTransactionSpreadCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPackageTransactionSpreadCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPayerIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPayerIdentifierLeg1;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPayerIdentifierLeg2;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPaymentFrequencyPeriodCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPaymentFrequencyPeriodMultiplierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPlatformIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPriceCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPriceCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPriceNotationCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPriceUnitOfMesureCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPrimeBrokerageTransactionIndicatorCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPriorUSICondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPriorUTICondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPutAmountCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportPutCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportQuantityFrequencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportQuantityFrequencyMultiplierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportQuantityUnitOfMeasureCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportReceiverIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportReceiverIdentifierLeg1;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportReceiverIdentifierLeg2;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportReportingTimestampCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportSellerIdentifier;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportSellerIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportSettlementCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportSpreadCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportSpreadCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportSpreadNotationCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportStrikePriceCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportStrikePriceCurrencyCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportStrikePriceNotationCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportTotalNotionalQuantityCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportUniqueSwapIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.datarule.CFTCPart45TransactionReportUniqueTransactionIdentifierCondition;
import drr.regulation.cftc.rewrite.validation.exists.CFTCPart45TransactionReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.53.0
 */
@RosettaMeta(model=CFTCPart45TransactionReport.class)
public class CFTCPart45TransactionReportMeta implements RosettaMetaData<CFTCPart45TransactionReport> {

	@Override
	public List<Validator<? super CFTCPart45TransactionReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportCounterparty1.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportCounterparty2.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportBuyerIdentifier.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportSellerIdentifier.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPayerIdentifierLeg1.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPayerIdentifierLeg2.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportReceiverIdentifierLeg1.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportReceiverIdentifierLeg2.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportOtherPartyPaymentPayerIdentifierFormat.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportOtherPartyPaymentReceiverIdentifierFormat.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportCentralCounterpartyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportClearingAcountOriginCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportClearerMemberCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportClearingSwapUSICondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportClearingSwapUTICondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportOriginalSwapUSICondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportOriginalSwapUTICondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportOriginalSwapSDRidentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportClearingReceiptTimestampCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportClearingExceptionsAndExemptions1Condition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportClearingExceptionsAndExemptions2Condition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportCounterparty1FinancialEntityIndicatorCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportBuyerIdentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportSellerIdentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPayerIdentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportReceiverIdentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportEventTypeCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportAmendmentIndicatorCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportEventIdentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportEventTimestampCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportNotionalAmountCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportNotionalCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportNotionalAmountScheduleCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportCallAmountCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportCallCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPutAmountCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPutCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportNotionalQuantityCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportQuantityFrequencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportQuantityFrequencyMultiplierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportQuantityUnitOfMeasureCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportTotalNotionalQuantityCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPackageIdentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPackageTransactionPriceCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPackageTransactionPriceCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPackageTransactionSpreadCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPackageTransactionSpreadCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportDayCountConventionCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportFixingDateCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportFloatingRateResetFrequencyPeriodCond.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportFloatingRateResetFrequencyPeriodMultiplierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportOtherPaymentTypeCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPaymentFrequencyPeriodCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPaymentFrequencyPeriodMultiplierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportExchangeRateCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportExchangeRateBasisCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportFixedRateCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPriceCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPriceCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPriceNotationCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPriceUnitOfMesureCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportSpreadCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportSpreadCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportSpreadNotationCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportStrikePriceCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportStrikePriceCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportStrikePriceNotationCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportOptionPremiumAmountCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportOptionPremiumCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportOptionPremiumPaymentDateCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportFirstExerciseDateCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportCDSIndexAttachmentPointCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportCDSIndexDetachmentPointCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportIndexFactorCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportFinalContractualSettlementDateCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportSettlementCurrencyCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportNonStandardizedTermIndicatorCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportExpirationDateCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportReportingTimestampCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPlatformIdentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPrimeBrokerageTransactionIndicatorCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPriorUSICondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportPriorUTICondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportUniqueSwapIdentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportUniqueTransactionIdentifierCondition.class),
			factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportNewSDRIdentifierCondition.class)
		);
	}
	
	@Override
	public List<Function<? super CFTCPart45TransactionReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super CFTCPart45TransactionReport> validator(ValidatorFactory factory) {
		return factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportValidator.class);
	}

	@Override
	public Validator<? super CFTCPart45TransactionReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<CFTCPart45TransactionReport>create(CFTCPart45TransactionReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super CFTCPart45TransactionReport> validator() {
		return new CFTCPart45TransactionReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super CFTCPart45TransactionReport> typeFormatValidator() {
		return new CFTCPart45TransactionReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super CFTCPart45TransactionReport, Set<String>> onlyExistsValidator() {
		return new CFTCPart45TransactionReportOnlyExistsValidator();
	}
}
